// media/mojo/mojom/media_types.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/media_types.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var exported_shared_image$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/exported_shared_image.mojom', '../../../gpu/ipc/common/exported_shared_image.mojom.js');
  }
  var mailbox$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/mailbox.mojom', '../../../gpu/ipc/common/mailbox.mojom.js');
  }
  var sync_token$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/sync_token.mojom', '../../../gpu/ipc/common/sync_token.mojom.js');
  }
  var vulkan_ycbcr_info$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/vulkan_ycbcr_info.mojom', '../../../gpu/ipc/common/vulkan_ycbcr_info.mojom.js');
  }
  var audio_data$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_data.mojom', 'audio_data.mojom.js');
  }
  var encryption_pattern$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/encryption_pattern.mojom', 'encryption_pattern.mojom.js');
  }
  var byte_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_string.mojom', '../../../mojo/public/mojom/base/byte_string.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../mojo/public/mojom/base/values.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var buffer_types$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/buffer_types.mojom', '../../../ui/gfx/mojom/buffer_types.mojom.js');
  }
  var color_space$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/color_space.mojom', '../../../ui/gfx/mojom/color_space.mojom.js');
  }
  var hdr_metadata$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/hdr_metadata.mojom', '../../../ui/gfx/mojom/hdr_metadata.mojom.js');
  }


  var AudioCodec = {};

  AudioCodec.isKnownEnumValue = function(value) {
    return false;
  };

  AudioCodec.toKnownEnumValue = function(value) {
    return value;
  };

  AudioCodec.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AudioCodecProfile = {};

  AudioCodecProfile.isKnownEnumValue = function(value) {
    return false;
  };

  AudioCodecProfile.toKnownEnumValue = function(value) {
    return value;
  };

  AudioCodecProfile.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var BufferingState = {};

  BufferingState.isKnownEnumValue = function(value) {
    return false;
  };

  BufferingState.toKnownEnumValue = function(value) {
    return value;
  };

  BufferingState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var BufferingStateChangeReason = {};

  BufferingStateChangeReason.isKnownEnumValue = function(value) {
    return false;
  };

  BufferingStateChangeReason.toKnownEnumValue = function(value) {
    return value;
  };

  BufferingStateChangeReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ChannelLayout = {};

  ChannelLayout.isKnownEnumValue = function(value) {
    return false;
  };

  ChannelLayout.toKnownEnumValue = function(value) {
    return value;
  };

  ChannelLayout.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaContentType = {};

  MediaContentType.isKnownEnumValue = function(value) {
    return false;
  };

  MediaContentType.toKnownEnumValue = function(value) {
    return value;
  };

  MediaContentType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var OutputDeviceStatus = {};

  OutputDeviceStatus.isKnownEnumValue = function(value) {
    return false;
  };

  OutputDeviceStatus.toKnownEnumValue = function(value) {
    return value;
  };

  OutputDeviceStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SampleFormat = {};

  SampleFormat.isKnownEnumValue = function(value) {
    return false;
  };

  SampleFormat.toKnownEnumValue = function(value) {
    return value;
  };

  SampleFormat.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoCodec = {};

  VideoCodec.isKnownEnumValue = function(value) {
    return false;
  };

  VideoCodec.toKnownEnumValue = function(value) {
    return value;
  };

  VideoCodec.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoCodecProfile = {};

  VideoCodecProfile.isKnownEnumValue = function(value) {
    return false;
  };

  VideoCodecProfile.toKnownEnumValue = function(value) {
    return value;
  };

  VideoCodecProfile.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoPixelFormat = {};

  VideoPixelFormat.isKnownEnumValue = function(value) {
    return false;
  };

  VideoPixelFormat.toKnownEnumValue = function(value) {
    return value;
  };

  VideoPixelFormat.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoDecoderType = {};

  VideoDecoderType.isKnownEnumValue = function(value) {
    return false;
  };

  VideoDecoderType.toKnownEnumValue = function(value) {
    return value;
  };

  VideoDecoderType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AudioDecoderType = {};

  AudioDecoderType.isKnownEnumValue = function(value) {
    return false;
  };

  AudioDecoderType.toKnownEnumValue = function(value) {
    return value;
  };

  AudioDecoderType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var VideoRotation = {};
  VideoRotation.kVideoRotation0 = 0;
  VideoRotation.kVideoRotation90 = 1;
  VideoRotation.kVideoRotation180 = 2;
  VideoRotation.kVideoRotation270 = 3;
  VideoRotation.MIN_VALUE = 0;
  VideoRotation.MAX_VALUE = 3;

  VideoRotation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  VideoRotation.toKnownEnumValue = function(value) {
    return value;
  };

  VideoRotation.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FullscreenVideoStatus = {};

  FullscreenVideoStatus.isKnownEnumValue = function(value) {
    return false;
  };

  FullscreenVideoStatus.toKnownEnumValue = function(value) {
    return value;
  };

  FullscreenVideoStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WaitingReason = {};

  WaitingReason.isKnownEnumValue = function(value) {
    return false;
  };

  WaitingReason.toKnownEnumValue = function(value) {
    return value;
  };

  WaitingReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WatchTimeKey = {};

  WatchTimeKey.isKnownEnumValue = function(value) {
    return false;
  };

  WatchTimeKey.toKnownEnumValue = function(value) {
    return value;
  };

  WatchTimeKey.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaContainerName = {};

  MediaContainerName.isKnownEnumValue = function(value) {
    return false;
  };

  MediaContainerName.toKnownEnumValue = function(value) {
    return value;
  };

  MediaContainerName.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaStatusState = {};

  MediaStatusState.isKnownEnumValue = function(value) {
    return false;
  };

  MediaStatusState.toKnownEnumValue = function(value) {
    return value;
  };

  MediaStatusState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EncryptionScheme = {};

  EncryptionScheme.isKnownEnumValue = function(value) {
    return false;
  };

  EncryptionScheme.toKnownEnumValue = function(value) {
    return value;
  };

  EncryptionScheme.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EncryptionType = {};
  EncryptionType.kNone = 0;
  EncryptionType.kClear = 1;
  EncryptionType.kEncrypted = 2;
  EncryptionType.kEncryptedWithClearLead = 3;
  EncryptionType.MIN_VALUE = 0;
  EncryptionType.MAX_VALUE = 3;

  EncryptionType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  EncryptionType.toKnownEnumValue = function(value) {
    return value;
  };

  EncryptionType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SVCScalabilityMode = {};
  SVCScalabilityMode.kL1T1 = 0;
  SVCScalabilityMode.kL1T2 = 1;
  SVCScalabilityMode.kL1T3 = 2;
  SVCScalabilityMode.kL2T1 = 3;
  SVCScalabilityMode.kL2T2 = 4;
  SVCScalabilityMode.kL2T3 = 5;
  SVCScalabilityMode.kL3T1 = 6;
  SVCScalabilityMode.kL3T2 = 7;
  SVCScalabilityMode.kL3T3 = 8;
  SVCScalabilityMode.kL2T1h = 9;
  SVCScalabilityMode.kL2T2h = 10;
  SVCScalabilityMode.kL2T3h = 11;
  SVCScalabilityMode.kS2T1 = 12;
  SVCScalabilityMode.kS2T2 = 13;
  SVCScalabilityMode.kS2T3 = 14;
  SVCScalabilityMode.kS2T1h = 15;
  SVCScalabilityMode.kS2T2h = 16;
  SVCScalabilityMode.kS2T3h = 17;
  SVCScalabilityMode.kS3T1 = 18;
  SVCScalabilityMode.kS3T2 = 19;
  SVCScalabilityMode.kS3T3 = 20;
  SVCScalabilityMode.kS3T1h = 21;
  SVCScalabilityMode.kS3T2h = 22;
  SVCScalabilityMode.kS3T3h = 23;
  SVCScalabilityMode.kL2T1Key = 24;
  SVCScalabilityMode.kL2T2Key = 25;
  SVCScalabilityMode.kL2T2KeyShift = 26;
  SVCScalabilityMode.kL2T3Key = 27;
  SVCScalabilityMode.kL2T3KeyShift = 28;
  SVCScalabilityMode.kL3T1Key = 29;
  SVCScalabilityMode.kL3T2Key = 30;
  SVCScalabilityMode.kL3T2KeyShift = 31;
  SVCScalabilityMode.kL3T3Key = 32;
  SVCScalabilityMode.kL3T3KeyShift = 33;
  SVCScalabilityMode.kL3T1h = 34;
  SVCScalabilityMode.kL3T2h = 35;
  SVCScalabilityMode.kL3T3h = 36;
  SVCScalabilityMode.MIN_VALUE = 0;
  SVCScalabilityMode.MAX_VALUE = 36;

  SVCScalabilityMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
      return true;
    }
    return false;
  };

  SVCScalabilityMode.toKnownEnumValue = function(value) {
    return value;
  };

  SVCScalabilityMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SVCInterLayerPredMode = {};
  SVCInterLayerPredMode.kOff = 0;
  SVCInterLayerPredMode.kOn = 1;
  SVCInterLayerPredMode.kOnKeyPic = 2;
  SVCInterLayerPredMode.MIN_VALUE = 0;
  SVCInterLayerPredMode.MAX_VALUE = 2;

  SVCInterLayerPredMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SVCInterLayerPredMode.toKnownEnumValue = function(value) {
    return value;
  };

  SVCInterLayerPredMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CdmSessionClosedReason = {};
  CdmSessionClosedReason.kInternalError = 0;
  CdmSessionClosedReason.kClose = 1;
  CdmSessionClosedReason.kReleaseAcknowledged = 2;
  CdmSessionClosedReason.kHardwareContextReset = 3;
  CdmSessionClosedReason.kResourceEvicted = 4;
  CdmSessionClosedReason.MIN_VALUE = 0;
  CdmSessionClosedReason.MAX_VALUE = 4;

  CdmSessionClosedReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  CdmSessionClosedReason.toKnownEnumValue = function(value) {
    return value;
  };

  CdmSessionClosedReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EffectState = {};
  EffectState.kUnknown = 0;
  EffectState.kDisabled = 1;
  EffectState.kEnabled = 2;
  EffectState.MIN_VALUE = 0;
  EffectState.MAX_VALUE = 2;

  EffectState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  EffectState.toKnownEnumValue = function(value) {
    return value;
  };

  EffectState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaStreamType = {};
  MediaStreamType.kLocalElementCapture = 0;
  MediaStreamType.kLocalDeviceCapture = 1;
  MediaStreamType.kLocalTabCapture = 2;
  MediaStreamType.kLocalDesktopCapture = 3;
  MediaStreamType.kLocalDisplayCapture = 4;
  MediaStreamType.kRemote = 5;
  MediaStreamType.kNone = 6;
  MediaStreamType.MIN_VALUE = 0;
  MediaStreamType.MAX_VALUE = 6;

  MediaStreamType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  MediaStreamType.toKnownEnumValue = function(value) {
    return value;
  };

  MediaStreamType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var InputStreamErrorCode = {};
  InputStreamErrorCode.kUnknown = 0;
  InputStreamErrorCode.kSystemPermissions = 1;
  InputStreamErrorCode.kDeviceInUse = 2;
  InputStreamErrorCode.MIN_VALUE = 0;
  InputStreamErrorCode.MAX_VALUE = 2;

  InputStreamErrorCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  InputStreamErrorCode.toKnownEnumValue = function(value) {
    return value;
  };

  InputStreamErrorCode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var RendererType = {};
  RendererType.kRendererImpl = 0;
  RendererType.kMojo = 1;
  RendererType.kCourier = 3;
  RendererType.kFlinging = 4;
  RendererType.kCast = 5;
  RendererType.kMediaFoundation = 6;
  RendererType.kRemoting = 8;
  RendererType.kCastStreaming = 9;
  RendererType.kContentEmbedderDefined = 10;
  RendererType.kTest = 11;
  RendererType.MIN_VALUE = 0;
  RendererType.MAX_VALUE = 11;

  RendererType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 3:
    case 4:
    case 5:
    case 6:
    case 8:
    case 9:
    case 10:
    case 11:
      return true;
    }
    return false;
  };

  RendererType.toKnownEnumValue = function(value) {
    return value;
  };

  RendererType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DemuxerType = {};
  DemuxerType.kUnknownDemuxer = 0;
  DemuxerType.kMockDemuxer = 1;
  DemuxerType.kFFmpegDemuxer = 2;
  DemuxerType.kChunkDemuxer = 3;
  DemuxerType.kFrameInjectingDemuxer = 5;
  DemuxerType.kStreamProviderDemuxer = 6;
  DemuxerType.kManifestDemuxer = 7;
  DemuxerType.MIN_VALUE = 0;
  DemuxerType.MAX_VALUE = 7;

  DemuxerType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  DemuxerType.toKnownEnumValue = function(value) {
    return value;
  };

  DemuxerType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CreateCdmStatus = {};
  CreateCdmStatus.kSuccess = 0;
  CreateCdmStatus.kUnknownError = 1;
  CreateCdmStatus.kCdmCreationAborted = 2;
  CreateCdmStatus.kCreateCdmFuncNotAvailable = 4;
  CreateCdmStatus.kCdmHelperCreationFailed = 5;
  CreateCdmStatus.kGetCdmPrefDataFailed = 6;
  CreateCdmStatus.kGetCdmOriginIdFailed = 7;
  CreateCdmStatus.kInitCdmFailed = 8;
  CreateCdmStatus.kCdmFactoryCreationFailed = 9;
  CreateCdmStatus.kCdmNotSupported = 10;
  CreateCdmStatus.kInvalidCdmConfig = 11;
  CreateCdmStatus.kUnsupportedKeySystem = 12;
  CreateCdmStatus.kDisconnectionError = 13;
  CreateCdmStatus.kNotAllowedOnUniqueOrigin = 14;
  CreateCdmStatus.kMediaCryptoNotAvailable = 16;
  CreateCdmStatus.kNoMoreInstances = 17;
  CreateCdmStatus.kInsufficientGpuResources = 18;
  CreateCdmStatus.kCrOsVerifiedAccessDisabled = 19;
  CreateCdmStatus.kCrOsRemoteFactoryCreationFailed = 20;
  CreateCdmStatus.kAndroidMediaDrmIllegalArgument = 21;
  CreateCdmStatus.kAndroidMediaDrmIllegalState = 22;
  CreateCdmStatus.kAndroidFailedL1SecurityLevel = 23;
  CreateCdmStatus.kAndroidFailedL3SecurityLevel = 24;
  CreateCdmStatus.kAndroidFailedSecurityOrigin = 25;
  CreateCdmStatus.kAndroidFailedMediaCryptoSession = 26;
  CreateCdmStatus.kAndroidFailedToStartProvisioning = 27;
  CreateCdmStatus.kAndroidFailedMediaCryptoCreate = 28;
  CreateCdmStatus.kAndroidUnsupportedMediaCryptoScheme = 29;
  CreateCdmStatus.MIN_VALUE = 0;
  CreateCdmStatus.MAX_VALUE = 29;

  CreateCdmStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
      return true;
    }
    return false;
  };

  CreateCdmStatus.toKnownEnumValue = function(value) {
    return value;
  };

  CreateCdmStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AutoPipReason = {};
  AutoPipReason.kUnknown = 0;
  AutoPipReason.kVideoConferencing = 1;
  AutoPipReason.kMediaPlayback = 2;
  AutoPipReason.kBrowserInitiated = 3;
  AutoPipReason.MIN_VALUE = 0;
  AutoPipReason.MAX_VALUE = 3;

  AutoPipReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AutoPipReason.toKnownEnumValue = function(value) {
    return value;
  };

  AutoPipReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function MediaLogRecord(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaLogRecord.prototype.initDefaults_ = function() {
  };
  MediaLogRecord.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaLogRecord.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaLogRecord.encodedSize = codec.kStructHeaderSize + 0;

  MediaLogRecord.decode = function(decoder) {
    var packed;
    var val = new MediaLogRecord();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaLogRecord.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaLogRecord.encodedSize);
    encoder.writeUint32(0);
  };
  function VideoTransformation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoTransformation.prototype.initDefaults_ = function() {
    this.rotation = 0;
    this.mirrored = false;
  };
  VideoTransformation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoTransformation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoTransformation.rotation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, VideoRotation);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoTransformation.encodedSize = codec.kStructHeaderSize + 8;

  VideoTransformation.decode = function(decoder) {
    var packed;
    var val = new VideoTransformation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rotation =
        decoder.decodeStruct(new codec.Enum(VideoRotation));
    packed = decoder.readUint8();
    val.mirrored = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoTransformation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoTransformation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.rotation);
    packed = 0;
    packed |= (val.mirrored & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoAspectRatio(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  VideoAspectRatio.Type = {};
  VideoAspectRatio.Type.kDisplay = 0;
  VideoAspectRatio.Type.kPixel = 1;
  VideoAspectRatio.Type.MIN_VALUE = 0;
  VideoAspectRatio.Type.MAX_VALUE = 1;

  VideoAspectRatio.Type.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  VideoAspectRatio.Type.toKnownEnumValue = function(value) {
    return value;
  };

  VideoAspectRatio.Type.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  VideoAspectRatio.prototype.initDefaults_ = function() {
    this.type = 0;
    this.value = 0;
  };
  VideoAspectRatio.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoAspectRatio.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoAspectRatio.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, VideoAspectRatio.Type);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoAspectRatio.encodedSize = codec.kStructHeaderSize + 16;

  VideoAspectRatio.decode = function(decoder) {
    var packed;
    var val = new VideoAspectRatio();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(VideoAspectRatio.Type));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.value =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  VideoAspectRatio.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoAspectRatio.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.value);
  };
  function VideoColorSpace(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  VideoColorSpace.PrimaryID = {};

  VideoColorSpace.PrimaryID.isKnownEnumValue = function(value) {
    return false;
  };

  VideoColorSpace.PrimaryID.toKnownEnumValue = function(value) {
    return value;
  };

  VideoColorSpace.PrimaryID.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  VideoColorSpace.TransferID = {};

  VideoColorSpace.TransferID.isKnownEnumValue = function(value) {
    return false;
  };

  VideoColorSpace.TransferID.toKnownEnumValue = function(value) {
    return value;
  };

  VideoColorSpace.TransferID.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  VideoColorSpace.MatrixID = {};

  VideoColorSpace.MatrixID.isKnownEnumValue = function(value) {
    return false;
  };

  VideoColorSpace.MatrixID.toKnownEnumValue = function(value) {
    return value;
  };

  VideoColorSpace.MatrixID.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  VideoColorSpace.RangeID = {};

  VideoColorSpace.RangeID.isKnownEnumValue = function(value) {
    return false;
  };

  VideoColorSpace.RangeID.toKnownEnumValue = function(value) {
    return value;
  };

  VideoColorSpace.RangeID.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  VideoColorSpace.prototype.initDefaults_ = function() {
    this.primaries = 0;
    this.transfer = 0;
    this.matrix = 0;
    this.range = 0;
  };
  VideoColorSpace.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoColorSpace.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoColorSpace.primaries
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, VideoColorSpace.PrimaryID);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoColorSpace.transfer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, VideoColorSpace.TransferID);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoColorSpace.matrix
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, VideoColorSpace.MatrixID);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoColorSpace.range
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, VideoColorSpace.RangeID);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoColorSpace.encodedSize = codec.kStructHeaderSize + 16;

  VideoColorSpace.decode = function(decoder) {
    var packed;
    var val = new VideoColorSpace();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.primaries =
        decoder.decodeStruct(new codec.Enum(VideoColorSpace.PrimaryID));
    val.transfer =
        decoder.decodeStruct(new codec.Enum(VideoColorSpace.TransferID));
    val.matrix =
        decoder.decodeStruct(new codec.Enum(VideoColorSpace.MatrixID));
    val.range =
        decoder.decodeStruct(new codec.Enum(VideoColorSpace.RangeID));
    return val;
  };

  VideoColorSpace.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoColorSpace.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.primaries);
    encoder.encodeStruct(codec.Int32, val.transfer);
    encoder.encodeStruct(codec.Int32, val.matrix);
    encoder.encodeStruct(codec.Int32, val.range);
  };
  function AudioDecoderConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioDecoderConfig.prototype.initDefaults_ = function() {
    this.codec = 0;
    this.sampleFormat = 0;
    this.channelLayout = 0;
    this.samplesPerSecond = 0;
    this.extraData = null;
    this.encryptionScheme = 0;
    this.codecDelay = 0;
    this.seekPreroll = null;
    this.profile = 0;
    this.targetOutputChannelLayout = 0;
    this.targetOutputSampleFormat = 0;
    this.shouldDiscardDecoderDelay = false;
  };
  AudioDecoderConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioDecoderConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioDecoderConfig.codec
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AudioCodec);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioDecoderConfig.sampleFormat
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, SampleFormat);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioDecoderConfig.channelLayout
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ChannelLayout);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AudioDecoderConfig.extraData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioDecoderConfig.encryptionScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, EncryptionScheme);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioDecoderConfig.seekPreroll
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AudioDecoderConfig.profile
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, AudioCodecProfile);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioDecoderConfig.targetOutputChannelLayout
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 44, ChannelLayout);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioDecoderConfig.targetOutputSampleFormat
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, SampleFormat);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AudioDecoderConfig.encodedSize = codec.kStructHeaderSize + 56;

  AudioDecoderConfig.decode = function(decoder) {
    var packed;
    var val = new AudioDecoderConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.codec =
        decoder.decodeStruct(new codec.Enum(AudioCodec));
    val.sampleFormat =
        decoder.decodeStruct(new codec.Enum(SampleFormat));
    val.channelLayout =
        decoder.decodeStruct(new codec.Enum(ChannelLayout));
    val.samplesPerSecond =
        decoder.decodeStruct(codec.Int32);
    val.extraData =
        decoder.decodeArrayPointer(codec.Uint8);
    val.encryptionScheme =
        decoder.decodeStruct(new codec.Enum(EncryptionScheme));
    val.codecDelay =
        decoder.decodeStruct(codec.Int32);
    val.seekPreroll =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.profile =
        decoder.decodeStruct(new codec.Enum(AudioCodecProfile));
    val.targetOutputChannelLayout =
        decoder.decodeStruct(new codec.Enum(ChannelLayout));
    val.targetOutputSampleFormat =
        decoder.decodeStruct(new codec.Enum(SampleFormat));
    packed = decoder.readUint8();
    val.shouldDiscardDecoderDelay = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AudioDecoderConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioDecoderConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.codec);
    encoder.encodeStruct(codec.Int32, val.sampleFormat);
    encoder.encodeStruct(codec.Int32, val.channelLayout);
    encoder.encodeStruct(codec.Int32, val.samplesPerSecond);
    encoder.encodeArrayPointer(codec.Uint8, val.extraData);
    encoder.encodeStruct(codec.Int32, val.encryptionScheme);
    encoder.encodeStruct(codec.Int32, val.codecDelay);
    encoder.encodeStructPointer(time$.TimeDelta, val.seekPreroll);
    encoder.encodeStruct(codec.Int32, val.profile);
    encoder.encodeStruct(codec.Int32, val.targetOutputChannelLayout);
    encoder.encodeStruct(codec.Int32, val.targetOutputSampleFormat);
    packed = 0;
    packed |= (val.shouldDiscardDecoderDelay & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoDecoderConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoDecoderConfig.prototype.initDefaults_ = function() {
    this.codec = 0;
    this.profile = 0;
    this.level = 0;
    this.hasAlpha = false;
    this.transformation = null;
    this.codedSize = null;
    this.visibleRect = null;
    this.naturalSize = null;
    this.aspectRatio = null;
    this.extraData = null;
    this.encryptionScheme = 0;
    this.colorSpaceInfo = null;
    this.hdrMetadata = null;
  };
  VideoDecoderConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoDecoderConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 96}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.codec
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, VideoCodec);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.profile
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, VideoCodecProfile);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VideoDecoderConfig.transformation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, VideoTransformation, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.codedSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.visibleRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.naturalSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.aspectRatio
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, VideoAspectRatio, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.extraData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.encryptionScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 64, EncryptionScheme);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.colorSpaceInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, VideoColorSpace, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoDecoderConfig.hdrMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, hdr_metadata$.HDRMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoDecoderConfig.encodedSize = codec.kStructHeaderSize + 88;

  VideoDecoderConfig.decode = function(decoder) {
    var packed;
    var val = new VideoDecoderConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.codec =
        decoder.decodeStruct(new codec.Enum(VideoCodec));
    val.profile =
        decoder.decodeStruct(new codec.Enum(VideoCodecProfile));
    val.level =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.hasAlpha = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.transformation =
        decoder.decodeStructPointer(VideoTransformation);
    val.codedSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.visibleRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.naturalSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.aspectRatio =
        decoder.decodeStructPointer(VideoAspectRatio);
    val.extraData =
        decoder.decodeArrayPointer(codec.Uint8);
    val.encryptionScheme =
        decoder.decodeStruct(new codec.Enum(EncryptionScheme));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.colorSpaceInfo =
        decoder.decodeStructPointer(VideoColorSpace);
    val.hdrMetadata =
        decoder.decodeStructPointer(hdr_metadata$.HDRMetadata);
    return val;
  };

  VideoDecoderConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoDecoderConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.codec);
    encoder.encodeStruct(codec.Int32, val.profile);
    encoder.encodeStruct(codec.Uint32, val.level);
    packed = 0;
    packed |= (val.hasAlpha & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(VideoTransformation, val.transformation);
    encoder.encodeStructPointer(geometry$.Size, val.codedSize);
    encoder.encodeStructPointer(geometry$.Rect, val.visibleRect);
    encoder.encodeStructPointer(geometry$.Size, val.naturalSize);
    encoder.encodeStructPointer(VideoAspectRatio, val.aspectRatio);
    encoder.encodeArrayPointer(codec.Uint8, val.extraData);
    encoder.encodeStruct(codec.Int32, val.encryptionScheme);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(VideoColorSpace, val.colorSpaceInfo);
    encoder.encodeStructPointer(hdr_metadata$.HDRMetadata, val.hdrMetadata);
  };
  function SubsampleEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubsampleEntry.prototype.initDefaults_ = function() {
  };
  SubsampleEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubsampleEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubsampleEntry.encodedSize = codec.kStructHeaderSize + 0;

  SubsampleEntry.decode = function(decoder) {
    var packed;
    var val = new SubsampleEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SubsampleEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubsampleEntry.encodedSize);
    encoder.writeUint32(0);
  };
  function DecryptConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DecryptConfig.prototype.initDefaults_ = function() {
    this.encryptionScheme = 0;
    this.keyId = null;
    this.iv = null;
    this.subsamples = null;
    this.encryptionPattern = null;
  };
  DecryptConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DecryptConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecryptConfig.encryptionScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, EncryptionScheme);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecryptConfig.keyId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecryptConfig.iv
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecryptConfig.subsamples
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(SubsampleEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecryptConfig.encryptionPattern
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, encryption_pattern$.EncryptionPattern, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DecryptConfig.encodedSize = codec.kStructHeaderSize + 40;

  DecryptConfig.decode = function(decoder) {
    var packed;
    var val = new DecryptConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encryptionScheme =
        decoder.decodeStruct(new codec.Enum(EncryptionScheme));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.keyId =
        decoder.decodeStructPointer(byte_string$.ByteString);
    val.iv =
        decoder.decodeStructPointer(byte_string$.ByteString);
    val.subsamples =
        decoder.decodeArrayPointer(new codec.PointerTo(SubsampleEntry));
    val.encryptionPattern =
        decoder.decodeStructPointer(encryption_pattern$.EncryptionPattern);
    return val;
  };

  DecryptConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DecryptConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.encryptionScheme);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(byte_string$.ByteString, val.keyId);
    encoder.encodeStructPointer(byte_string$.ByteString, val.iv);
    encoder.encodeArrayPointer(new codec.PointerTo(SubsampleEntry), val.subsamples);
    encoder.encodeStructPointer(encryption_pattern$.EncryptionPattern, val.encryptionPattern);
  };
  function DecoderBufferSideData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DecoderBufferSideData.prototype.initDefaults_ = function() {
    this.spatialLayers = null;
    this.alphaData = null;
    this.secureHandle = 0;
    this.frontDiscard = null;
    this.backDiscard = null;
  };
  DecoderBufferSideData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DecoderBufferSideData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecoderBufferSideData.spatialLayers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecoderBufferSideData.alphaData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DecoderBufferSideData.frontDiscard
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecoderBufferSideData.backDiscard
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DecoderBufferSideData.encodedSize = codec.kStructHeaderSize + 40;

  DecoderBufferSideData.decode = function(decoder) {
    var packed;
    var val = new DecoderBufferSideData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.spatialLayers =
        decoder.decodeArrayPointer(codec.Uint32);
    val.alphaData =
        decoder.decodeArrayPointer(codec.Uint8);
    val.secureHandle =
        decoder.decodeStruct(codec.Uint64);
    val.frontDiscard =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.backDiscard =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  DecoderBufferSideData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DecoderBufferSideData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint32, val.spatialLayers);
    encoder.encodeArrayPointer(codec.Uint8, val.alphaData);
    encoder.encodeStruct(codec.Uint64, val.secureHandle);
    encoder.encodeStructPointer(time$.TimeDelta, val.frontDiscard);
    encoder.encodeStructPointer(time$.TimeDelta, val.backDiscard);
  };
  function DataDecoderBuffer(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataDecoderBuffer.prototype.initDefaults_ = function() {
    this.timestamp = null;
    this.duration = null;
    this.dataSize = 0;
    this.isKeyFrame = false;
    this.decryptConfig = null;
    this.sideData = null;
  };
  DataDecoderBuffer.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataDecoderBuffer.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataDecoderBuffer.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataDecoderBuffer.duration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate DataDecoderBuffer.decryptConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, DecryptConfig, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataDecoderBuffer.sideData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, DecoderBufferSideData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DataDecoderBuffer.encodedSize = codec.kStructHeaderSize + 40;

  DataDecoderBuffer.decode = function(decoder) {
    var packed;
    var val = new DataDecoderBuffer();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.duration =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.dataSize =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.isKeyFrame = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.decryptConfig =
        decoder.decodeStructPointer(DecryptConfig);
    val.sideData =
        decoder.decodeStructPointer(DecoderBufferSideData);
    return val;
  };

  DataDecoderBuffer.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataDecoderBuffer.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.timestamp);
    encoder.encodeStructPointer(time$.TimeDelta, val.duration);
    encoder.encodeStruct(codec.Uint32, val.dataSize);
    packed = 0;
    packed |= (val.isKeyFrame & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(DecryptConfig, val.decryptConfig);
    encoder.encodeStructPointer(DecoderBufferSideData, val.sideData);
  };
  function EosDecoderBuffer(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EosDecoderBuffer.prototype.initDefaults_ = function() {
    this.nextConfig = null;
  };
  EosDecoderBuffer.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EosDecoderBuffer.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EosDecoderBuffer.nextConfig
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, DecoderBufferSideDataNextConfig, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EosDecoderBuffer.encodedSize = codec.kStructHeaderSize + 16;

  EosDecoderBuffer.decode = function(decoder) {
    var packed;
    var val = new EosDecoderBuffer();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.nextConfig =
        decoder.decodeStruct(DecoderBufferSideDataNextConfig);
    return val;
  };

  EosDecoderBuffer.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EosDecoderBuffer.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(DecoderBufferSideDataNextConfig, val.nextConfig);
  };
  function AudioBuffer(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioBuffer.prototype.initDefaults_ = function() {
    this.sampleFormat = 0;
    this.channelLayout = 0;
    this.channelCount = 0;
    this.sampleRate = 0;
    this.frameCount = 0;
    this.endOfStream = false;
    this.timestamp = null;
    this.data = null;
  };
  AudioBuffer.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioBuffer.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioBuffer.sampleFormat
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SampleFormat);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioBuffer.channelLayout
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ChannelLayout);
    if (err !== validator.validationError.NONE)
        return err;






    // validate AudioBuffer.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioBuffer.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioBuffer.encodedSize = codec.kStructHeaderSize + 40;

  AudioBuffer.decode = function(decoder) {
    var packed;
    var val = new AudioBuffer();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sampleFormat =
        decoder.decodeStruct(new codec.Enum(SampleFormat));
    val.channelLayout =
        decoder.decodeStruct(new codec.Enum(ChannelLayout));
    val.channelCount =
        decoder.decodeStruct(codec.Int32);
    val.sampleRate =
        decoder.decodeStruct(codec.Int32);
    val.frameCount =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.endOfStream = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  AudioBuffer.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioBuffer.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.sampleFormat);
    encoder.encodeStruct(codec.Int32, val.channelLayout);
    encoder.encodeStruct(codec.Int32, val.channelCount);
    encoder.encodeStruct(codec.Int32, val.sampleRate);
    encoder.encodeStruct(codec.Int32, val.frameCount);
    packed = 0;
    packed |= (val.endOfStream & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.timestamp);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
  };
  function CaptureVersion(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CaptureVersion.prototype.initDefaults_ = function() {
    this.source = 0;
    this.subCapture = 0;
  };
  CaptureVersion.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CaptureVersion.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  CaptureVersion.encodedSize = codec.kStructHeaderSize + 8;

  CaptureVersion.decode = function(decoder) {
    var packed;
    var val = new CaptureVersion();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.source =
        decoder.decodeStruct(codec.Uint32);
    val.subCapture =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  CaptureVersion.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CaptureVersion.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.source);
    encoder.encodeStruct(codec.Uint32, val.subCapture);
  };
  function VideoFrameMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoFrameMetadata.prototype.initDefaults_ = function() {
    this.allowOverlay = false;
    this.hasCaptureCounter = false;
    this.copyRequired = false;
    this.endOfStream = false;
    this.hasFrameRate = false;
    this.interactiveContent = false;
    this.readLockFencesEnabled = false;
    this.inSurfaceView = false;
    this.wantsPromotionHint = false;
    this.protectedVideo = false;
    this.hwProtected = false;
    this.needsDetiling = false;
    this.isWebgpuCompatible = false;
    this.powerEfficient = false;
    this.hasDeviceScaleFactor = false;
    this.hasPageScaleFactor = false;
    this.hasRootScrollOffsetX = false;
    this.hasRootScrollOffsetY = false;
    this.hasTopControlsVisibleHeight = false;
    this.hasRtpTimestamp = false;
    this.frame_sequence_$flag = false;
    this.source_id_$flag = false;
    this.captureCounter = 0;
    this.captureBeginTime = null;
    this.captureEndTime = null;
    this.captureUpdateRect = null;
    this.sourceSize = null;
    this.regionCaptureRect = null;
    this.captureVersion = null;
    this.frameDuration = null;
    this.frameRate = 0;
    this.referenceTime = null;
    this.transformation = null;
    this.trackingToken = null;
    this.deviceScaleFactor = 0;
    this.pageScaleFactor = 0;
    this.rootScrollOffsetX = 0;
    this.rootScrollOffsetY = 0;
    this.topControlsVisibleHeight = 0;
    this.decodeBeginTime = null;
    this.decodeEndTime = null;
    this.processingTime = null;
    this.rtpTimestamp = 0;
    this.receiveTime = null;
    this.wallclockFrameDuration = null;
    this.frame_sequence_$value = 0;
    this.source_id_$value = 0;
    this.backgroundBlur = 0;
  };
  VideoFrameMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoFrameMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 216}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoFrameMetadata.captureBeginTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameMetadata.captureEndTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, true);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VideoFrameMetadata.captureUpdateRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Rect, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameMetadata.sourceSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Size, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameMetadata.regionCaptureRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Rect, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameMetadata.captureVersion
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, CaptureVersion, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VideoFrameMetadata.frameDuration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;





    // validate VideoFrameMetadata.referenceTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, time$.TimeTicks, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoFrameMetadata.transformation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, VideoTransformation, true);
    if (err !== validator.validationError.NONE)
        return err;








    // validate VideoFrameMetadata.trackingToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;













    // validate VideoFrameMetadata.decodeBeginTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, time$.TimeTicks, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameMetadata.decodeEndTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, time$.TimeTicks, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameMetadata.processingTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 152, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VideoFrameMetadata.receiveTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 168, time$.TimeTicks, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrameMetadata.wallclockFrameDuration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 176, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;






    // validate VideoFrameMetadata.backgroundBlur
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 200, EffectState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoFrameMetadata.encodedSize = codec.kStructHeaderSize + 208;

  VideoFrameMetadata.decode = function(decoder) {
    var packed;
    var val = new VideoFrameMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowOverlay = (packed >> 0) & 1 ? true : false;
    val.hasCaptureCounter = (packed >> 1) & 1 ? true : false;
    val.copyRequired = (packed >> 2) & 1 ? true : false;
    val.endOfStream = (packed >> 3) & 1 ? true : false;
    val.hasFrameRate = (packed >> 4) & 1 ? true : false;
    val.interactiveContent = (packed >> 5) & 1 ? true : false;
    val.readLockFencesEnabled = (packed >> 6) & 1 ? true : false;
    val.inSurfaceView = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.wantsPromotionHint = (packed >> 0) & 1 ? true : false;
    val.protectedVideo = (packed >> 1) & 1 ? true : false;
    val.hwProtected = (packed >> 2) & 1 ? true : false;
    val.needsDetiling = (packed >> 3) & 1 ? true : false;
    val.isWebgpuCompatible = (packed >> 4) & 1 ? true : false;
    val.powerEfficient = (packed >> 5) & 1 ? true : false;
    val.hasDeviceScaleFactor = (packed >> 6) & 1 ? true : false;
    val.hasPageScaleFactor = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.hasRootScrollOffsetX = (packed >> 0) & 1 ? true : false;
    val.hasRootScrollOffsetY = (packed >> 1) & 1 ? true : false;
    val.hasTopControlsVisibleHeight = (packed >> 2) & 1 ? true : false;
    val.hasRtpTimestamp = (packed >> 3) & 1 ? true : false;
    val.frame_sequence_$flag = (packed >> 4) & 1 ? true : false;
    val.source_id_$flag = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    val.captureCounter =
        decoder.decodeStruct(codec.Int32);
    val.captureBeginTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.captureEndTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.captureUpdateRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.sourceSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.regionCaptureRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.captureVersion =
        decoder.decodeStructPointer(CaptureVersion);
    val.frameDuration =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.frameRate =
        decoder.decodeStruct(codec.Double);
    val.referenceTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.transformation =
        decoder.decodeStructPointer(VideoTransformation);
    val.trackingToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.deviceScaleFactor =
        decoder.decodeStruct(codec.Double);
    val.pageScaleFactor =
        decoder.decodeStruct(codec.Double);
    val.rootScrollOffsetX =
        decoder.decodeStruct(codec.Double);
    val.rootScrollOffsetY =
        decoder.decodeStruct(codec.Double);
    val.topControlsVisibleHeight =
        decoder.decodeStruct(codec.Double);
    val.decodeBeginTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.decodeEndTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.processingTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.rtpTimestamp =
        decoder.decodeStruct(codec.Double);
    val.receiveTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.wallclockFrameDuration =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.frame_sequence_$value =
        decoder.decodeStruct(codec.Uint64);
    val.source_id_$value =
        decoder.decodeStruct(codec.Uint64);
    val.backgroundBlur =
        decoder.decodeStruct(new codec.Enum(EffectState));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoFrameMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoFrameMetadata.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allowOverlay & 1) << 0
    packed |= (val.hasCaptureCounter & 1) << 1
    packed |= (val.copyRequired & 1) << 2
    packed |= (val.endOfStream & 1) << 3
    packed |= (val.hasFrameRate & 1) << 4
    packed |= (val.interactiveContent & 1) << 5
    packed |= (val.readLockFencesEnabled & 1) << 6
    packed |= (val.inSurfaceView & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.wantsPromotionHint & 1) << 0
    packed |= (val.protectedVideo & 1) << 1
    packed |= (val.hwProtected & 1) << 2
    packed |= (val.needsDetiling & 1) << 3
    packed |= (val.isWebgpuCompatible & 1) << 4
    packed |= (val.powerEfficient & 1) << 5
    packed |= (val.hasDeviceScaleFactor & 1) << 6
    packed |= (val.hasPageScaleFactor & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.hasRootScrollOffsetX & 1) << 0
    packed |= (val.hasRootScrollOffsetY & 1) << 1
    packed |= (val.hasTopControlsVisibleHeight & 1) << 2
    packed |= (val.hasRtpTimestamp & 1) << 3
    packed |= (val.frame_sequence_$flag & 1) << 4
    packed |= (val.source_id_$flag & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.captureCounter);
    encoder.encodeStructPointer(time$.TimeTicks, val.captureBeginTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.captureEndTime);
    encoder.encodeStructPointer(geometry$.Rect, val.captureUpdateRect);
    encoder.encodeStructPointer(geometry$.Size, val.sourceSize);
    encoder.encodeStructPointer(geometry$.Rect, val.regionCaptureRect);
    encoder.encodeStructPointer(CaptureVersion, val.captureVersion);
    encoder.encodeStructPointer(time$.TimeDelta, val.frameDuration);
    encoder.encodeStruct(codec.Double, val.frameRate);
    encoder.encodeStructPointer(time$.TimeTicks, val.referenceTime);
    encoder.encodeStructPointer(VideoTransformation, val.transformation);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.trackingToken);
    encoder.encodeStruct(codec.Double, val.deviceScaleFactor);
    encoder.encodeStruct(codec.Double, val.pageScaleFactor);
    encoder.encodeStruct(codec.Double, val.rootScrollOffsetX);
    encoder.encodeStruct(codec.Double, val.rootScrollOffsetY);
    encoder.encodeStruct(codec.Double, val.topControlsVisibleHeight);
    encoder.encodeStructPointer(time$.TimeTicks, val.decodeBeginTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.decodeEndTime);
    encoder.encodeStructPointer(time$.TimeDelta, val.processingTime);
    encoder.encodeStruct(codec.Double, val.rtpTimestamp);
    encoder.encodeStructPointer(time$.TimeTicks, val.receiveTime);
    encoder.encodeStructPointer(time$.TimeDelta, val.wallclockFrameDuration);
    encoder.encodeStruct(codec.Uint64, val.frame_sequence_$value);
    encoder.encodeStruct(codec.Uint64, val.source_id_$value);
    encoder.encodeStruct(codec.Int32, val.backgroundBlur);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoFrame(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoFrame.prototype.initDefaults_ = function() {
    this.format = 0;
    this.codedSize = null;
    this.visibleRect = null;
    this.naturalSize = null;
    this.timestamp = null;
    this.data = null;
    this.metadata = null;
    this.colorSpace = null;
    this.hdrMetadata = null;
  };
  VideoFrame.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoFrame.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.format
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, VideoPixelFormat);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.codedSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.visibleRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.naturalSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 40, VideoFrameData, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, VideoFrameMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.colorSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, color_space$.ColorSpace, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoFrame.hdrMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, hdr_metadata$.HDRMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoFrame.encodedSize = codec.kStructHeaderSize + 80;

  VideoFrame.decode = function(decoder) {
    var packed;
    var val = new VideoFrame();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.format =
        decoder.decodeStruct(new codec.Enum(VideoPixelFormat));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.codedSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.visibleRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.naturalSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.data =
        decoder.decodeStruct(VideoFrameData);
    val.metadata =
        decoder.decodeStructPointer(VideoFrameMetadata);
    val.colorSpace =
        decoder.decodeStructPointer(color_space$.ColorSpace);
    val.hdrMetadata =
        decoder.decodeStructPointer(hdr_metadata$.HDRMetadata);
    return val;
  };

  VideoFrame.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoFrame.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.format);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Size, val.codedSize);
    encoder.encodeStructPointer(geometry$.Rect, val.visibleRect);
    encoder.encodeStructPointer(geometry$.Size, val.naturalSize);
    encoder.encodeStructPointer(time$.TimeDelta, val.timestamp);
    encoder.encodeStruct(VideoFrameData, val.data);
    encoder.encodeStructPointer(VideoFrameMetadata, val.metadata);
    encoder.encodeStructPointer(color_space$.ColorSpace, val.colorSpace);
    encoder.encodeStructPointer(hdr_metadata$.HDRMetadata, val.hdrMetadata);
  };
  function EosVideoFrameData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EosVideoFrameData.prototype.initDefaults_ = function() {
  };
  EosVideoFrameData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EosVideoFrameData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EosVideoFrameData.encodedSize = codec.kStructHeaderSize + 0;

  EosVideoFrameData.decode = function(decoder) {
    var packed;
    var val = new EosVideoFrameData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EosVideoFrameData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EosVideoFrameData.encodedSize);
    encoder.writeUint32(0);
  };
  function SharedMemoryVideoFrameData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedMemoryVideoFrameData.prototype.initDefaults_ = function() {
    this.frameData = null;
    this.strides = null;
    this.offsets = null;
  };
  SharedMemoryVideoFrameData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedMemoryVideoFrameData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedMemoryVideoFrameData.frameData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_memory$.ReadOnlySharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedMemoryVideoFrameData.strides
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, codec.Int32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedMemoryVideoFrameData.offsets
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedMemoryVideoFrameData.encodedSize = codec.kStructHeaderSize + 24;

  SharedMemoryVideoFrameData.decode = function(decoder) {
    var packed;
    var val = new SharedMemoryVideoFrameData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameData =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    val.strides =
        decoder.decodeArrayPointer(codec.Int32);
    val.offsets =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  SharedMemoryVideoFrameData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedMemoryVideoFrameData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.frameData);
    encoder.encodeArrayPointer(codec.Int32, val.strides);
    encoder.encodeArrayPointer(codec.Uint32, val.offsets);
  };
  function GpuMemoryBufferSharedImageVideoFrameData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GpuMemoryBufferSharedImageVideoFrameData.prototype.initDefaults_ = function() {
    this.gpuMemoryBufferHandle = null;
    this.sharedImage = null;
    this.syncToken = null;
  };
  GpuMemoryBufferSharedImageVideoFrameData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GpuMemoryBufferSharedImageVideoFrameData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuMemoryBufferSharedImageVideoFrameData.gpuMemoryBufferHandle
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, buffer_types$.GpuMemoryBufferHandle, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuMemoryBufferSharedImageVideoFrameData.sharedImage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, exported_shared_image$.ExportedSharedImage, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GpuMemoryBufferSharedImageVideoFrameData.syncToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, sync_token$.SyncToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GpuMemoryBufferSharedImageVideoFrameData.encodedSize = codec.kStructHeaderSize + 24;

  GpuMemoryBufferSharedImageVideoFrameData.decode = function(decoder) {
    var packed;
    var val = new GpuMemoryBufferSharedImageVideoFrameData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.gpuMemoryBufferHandle =
        decoder.decodeStructPointer(buffer_types$.GpuMemoryBufferHandle);
    val.sharedImage =
        decoder.decodeStructPointer(exported_shared_image$.ExportedSharedImage);
    val.syncToken =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    return val;
  };

  GpuMemoryBufferSharedImageVideoFrameData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GpuMemoryBufferSharedImageVideoFrameData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(buffer_types$.GpuMemoryBufferHandle, val.gpuMemoryBufferHandle);
    encoder.encodeStructPointer(exported_shared_image$.ExportedSharedImage, val.sharedImage);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.syncToken);
  };
  function SharedImageVideoFrameData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedImageVideoFrameData.prototype.initDefaults_ = function() {
    this.sharedImage = null;
    this.syncToken = null;
    this.isMappableSiEnabled = false;
  };
  SharedImageVideoFrameData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedImageVideoFrameData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedImageVideoFrameData.sharedImage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, exported_shared_image$.ExportedSharedImage, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedImageVideoFrameData.syncToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, sync_token$.SyncToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedImageVideoFrameData.encodedSize = codec.kStructHeaderSize + 24;

  SharedImageVideoFrameData.decode = function(decoder) {
    var packed;
    var val = new SharedImageVideoFrameData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sharedImage =
        decoder.decodeStructPointer(exported_shared_image$.ExportedSharedImage);
    val.syncToken =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    packed = decoder.readUint8();
    val.isMappableSiEnabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedImageVideoFrameData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedImageVideoFrameData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(exported_shared_image$.ExportedSharedImage, val.sharedImage);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.syncToken);
    packed = 0;
    packed |= (val.isMappableSiEnabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OpaqueVideoFrameData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OpaqueVideoFrameData.prototype.initDefaults_ = function() {
  };
  OpaqueVideoFrameData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OpaqueVideoFrameData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OpaqueVideoFrameData.encodedSize = codec.kStructHeaderSize + 0;

  OpaqueVideoFrameData.decode = function(decoder) {
    var packed;
    var val = new OpaqueVideoFrameData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  OpaqueVideoFrameData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OpaqueVideoFrameData.encodedSize);
    encoder.writeUint32(0);
  };
  function PipelineStatistics(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PipelineStatistics.prototype.initDefaults_ = function() {
    this.audioBytesDecoded = 0;
    this.videoBytesDecoded = 0;
    this.videoFramesDecoded = 0;
    this.videoFramesDropped = 0;
    this.audioMemoryUsage = 0;
    this.videoMemoryUsage = 0;
  };
  PipelineStatistics.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PipelineStatistics.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  PipelineStatistics.encodedSize = codec.kStructHeaderSize + 40;

  PipelineStatistics.decode = function(decoder) {
    var packed;
    var val = new PipelineStatistics();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audioBytesDecoded =
        decoder.decodeStruct(codec.Uint64);
    val.videoBytesDecoded =
        decoder.decodeStruct(codec.Uint64);
    val.videoFramesDecoded =
        decoder.decodeStruct(codec.Uint32);
    val.videoFramesDropped =
        decoder.decodeStruct(codec.Uint32);
    val.audioMemoryUsage =
        decoder.decodeStruct(codec.Int64);
    val.videoMemoryUsage =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  PipelineStatistics.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PipelineStatistics.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.audioBytesDecoded);
    encoder.encodeStruct(codec.Uint64, val.videoBytesDecoded);
    encoder.encodeStruct(codec.Uint32, val.videoFramesDecoded);
    encoder.encodeStruct(codec.Uint32, val.videoFramesDropped);
    encoder.encodeStruct(codec.Int64, val.audioMemoryUsage);
    encoder.encodeStruct(codec.Int64, val.videoMemoryUsage);
  };
  function PredictionFeatures(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PredictionFeatures.prototype.initDefaults_ = function() {
    this.profile = 0;
    this.useHwSecureCodecs = false;
    this.videoSize = null;
    this.framesPerSec = 0;
    this.keySystem = null;
  };
  PredictionFeatures.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PredictionFeatures.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PredictionFeatures.profile
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, VideoCodecProfile);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PredictionFeatures.videoSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PredictionFeatures.keySystem
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PredictionFeatures.encodedSize = codec.kStructHeaderSize + 32;

  PredictionFeatures.decode = function(decoder) {
    var packed;
    var val = new PredictionFeatures();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.profile =
        decoder.decodeStruct(new codec.Enum(VideoCodecProfile));
    packed = decoder.readUint8();
    val.useHwSecureCodecs = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.videoSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.framesPerSec =
        decoder.decodeStruct(codec.Double);
    val.keySystem =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PredictionFeatures.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PredictionFeatures.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.profile);
    packed = 0;
    packed |= (val.useHwSecureCodecs & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Size, val.videoSize);
    encoder.encodeStruct(codec.Double, val.framesPerSec);
    encoder.encodeStruct(codec.String, val.keySystem);
  };
  function PredictionTargets(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PredictionTargets.prototype.initDefaults_ = function() {
    this.framesDecoded = 0;
    this.framesDropped = 0;
    this.framesPowerEfficient = 0;
  };
  PredictionTargets.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PredictionTargets.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  PredictionTargets.encodedSize = codec.kStructHeaderSize + 16;

  PredictionTargets.decode = function(decoder) {
    var packed;
    var val = new PredictionTargets();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.framesDecoded =
        decoder.decodeStruct(codec.Uint32);
    val.framesDropped =
        decoder.decodeStruct(codec.Uint32);
    val.framesPowerEfficient =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PredictionTargets.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PredictionTargets.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.framesDecoded);
    encoder.encodeStruct(codec.Uint32, val.framesDropped);
    encoder.encodeStruct(codec.Uint32, val.framesPowerEfficient);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AudioPipelineInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioPipelineInfo.prototype.initDefaults_ = function() {
    this.decoderType = 0;
    this.isPlatformDecoder = false;
    this.hasDecryptingDemuxerStream = false;
    this.encryptionType = 0;
  };
  AudioPipelineInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioPipelineInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioPipelineInfo.decoderType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AudioDecoderType);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AudioPipelineInfo.encryptionType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, EncryptionType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioPipelineInfo.encodedSize = codec.kStructHeaderSize + 16;

  AudioPipelineInfo.decode = function(decoder) {
    var packed;
    var val = new AudioPipelineInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.decoderType =
        decoder.decodeStruct(new codec.Enum(AudioDecoderType));
    packed = decoder.readUint8();
    val.isPlatformDecoder = (packed >> 0) & 1 ? true : false;
    val.hasDecryptingDemuxerStream = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.encryptionType =
        decoder.decodeStruct(new codec.Enum(EncryptionType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AudioPipelineInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioPipelineInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.decoderType);
    packed = 0;
    packed |= (val.isPlatformDecoder & 1) << 0
    packed |= (val.hasDecryptingDemuxerStream & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.encryptionType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoPipelineInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoPipelineInfo.prototype.initDefaults_ = function() {
    this.decoderType = 0;
    this.isPlatformDecoder = false;
    this.hasDecryptingDemuxerStream = false;
    this.encryptionType = 0;
  };
  VideoPipelineInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoPipelineInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoPipelineInfo.decoderType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, VideoDecoderType);
    if (err !== validator.validationError.NONE)
        return err;




    // validate VideoPipelineInfo.encryptionType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, EncryptionType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoPipelineInfo.encodedSize = codec.kStructHeaderSize + 16;

  VideoPipelineInfo.decode = function(decoder) {
    var packed;
    var val = new VideoPipelineInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.decoderType =
        decoder.decodeStruct(new codec.Enum(VideoDecoderType));
    packed = decoder.readUint8();
    val.isPlatformDecoder = (packed >> 0) & 1 ? true : false;
    val.hasDecryptingDemuxerStream = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.encryptionType =
        decoder.decodeStruct(new codec.Enum(EncryptionType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VideoPipelineInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoPipelineInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.decoderType);
    packed = 0;
    packed |= (val.isPlatformDecoder & 1) << 0
    packed |= (val.hasDecryptingDemuxerStream & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.encryptionType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StatusData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StatusData.prototype.initDefaults_ = function() {
    this.group = null;
    this.code = 0;
    this.message = null;
    this.frames = null;
    this.cause = null;
    this.data = null;
  };
  StatusData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StatusData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StatusData.group
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate StatusData.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate StatusData.frames
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, values$.ListValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StatusData.cause
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, StatusData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StatusData.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 40, values$.Value, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StatusData.encodedSize = codec.kStructHeaderSize + 56;

  StatusData.decode = function(decoder) {
    var packed;
    var val = new StatusData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.group =
        decoder.decodeStruct(codec.String);
    val.code =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStruct(codec.String);
    val.frames =
        decoder.decodeStructPointer(values$.ListValue);
    val.cause =
        decoder.decodeStructPointer(StatusData);
    val.data =
        decoder.decodeStruct(values$.Value);
    return val;
  };

  StatusData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StatusData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.group);
    encoder.encodeStruct(codec.Uint16, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.message);
    encoder.encodeStructPointer(values$.ListValue, val.frames);
    encoder.encodeStructPointer(StatusData, val.cause);
    encoder.encodeStruct(values$.Value, val.data);
  };
  function EncoderStatus(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EncoderStatus.prototype.initDefaults_ = function() {
    this.internal = null;
  };
  EncoderStatus.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EncoderStatus.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EncoderStatus.internal
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, StatusData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EncoderStatus.encodedSize = codec.kStructHeaderSize + 8;

  EncoderStatus.decode = function(decoder) {
    var packed;
    var val = new EncoderStatus();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.internal =
        decoder.decodeStructPointer(StatusData);
    return val;
  };

  EncoderStatus.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EncoderStatus.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(StatusData, val.internal);
  };
  function DecoderStatus(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DecoderStatus.prototype.initDefaults_ = function() {
    this.internal = null;
  };
  DecoderStatus.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DecoderStatus.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DecoderStatus.internal
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, StatusData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DecoderStatus.encodedSize = codec.kStructHeaderSize + 8;

  DecoderStatus.decode = function(decoder) {
    var packed;
    var val = new DecoderStatus();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.internal =
        decoder.decodeStructPointer(StatusData);
    return val;
  };

  DecoderStatus.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DecoderStatus.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(StatusData, val.internal);
  };
  function PipelineStatus(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PipelineStatus.prototype.initDefaults_ = function() {
    this.internal = null;
  };
  PipelineStatus.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PipelineStatus.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PipelineStatus.internal
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, StatusData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PipelineStatus.encodedSize = codec.kStructHeaderSize + 8;

  PipelineStatus.decode = function(decoder) {
    var packed;
    var val = new PipelineStatus();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.internal =
        decoder.decodeStructPointer(StatusData);
    return val;
  };

  PipelineStatus.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PipelineStatus.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(StatusData, val.internal);
  };
  function AutoPipInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AutoPipInfo.prototype.initDefaults_ = function() {
    this.autoPipReason = 0;
    this.hasAudioFocus = false;
    this.isPlaying = false;
    this.wasRecentlyAudible = false;
    this.hasSafeUrl = false;
    this.meetsMediaEngagementConditions = false;
    this.blockedDueToContentSetting = false;
  };
  AutoPipInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AutoPipInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AutoPipInfo.autoPipReason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AutoPipReason);
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  AutoPipInfo.encodedSize = codec.kStructHeaderSize + 8;

  AutoPipInfo.decode = function(decoder) {
    var packed;
    var val = new AutoPipInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.autoPipReason =
        decoder.decodeStruct(new codec.Enum(AutoPipReason));
    packed = decoder.readUint8();
    val.hasAudioFocus = (packed >> 0) & 1 ? true : false;
    val.isPlaying = (packed >> 1) & 1 ? true : false;
    val.wasRecentlyAudible = (packed >> 2) & 1 ? true : false;
    val.hasSafeUrl = (packed >> 3) & 1 ? true : false;
    val.meetsMediaEngagementConditions = (packed >> 4) & 1 ? true : false;
    val.blockedDueToContentSetting = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AutoPipInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AutoPipInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.autoPipReason);
    packed = 0;
    packed |= (val.hasAudioFocus & 1) << 0
    packed |= (val.isPlaying & 1) << 1
    packed |= (val.wasRecentlyAudible & 1) << 2
    packed |= (val.hasSafeUrl & 1) << 3
    packed |= (val.meetsMediaEngagementConditions & 1) << 4
    packed |= (val.blockedDueToContentSetting & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function DecoderBufferSideDataNextConfig(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  DecoderBufferSideDataNextConfig.Tags = {
    nextAudioConfig: 0,
    nextVideoConfig: 1,
  };

  DecoderBufferSideDataNextConfig.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  DecoderBufferSideDataNextConfig.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "nextAudioConfig",
        "nextVideoConfig",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a DecoderBufferSideDataNextConfig member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(DecoderBufferSideDataNextConfig.prototype, "nextAudioConfig", {
    get: function() {
      if (this.$tag != DecoderBufferSideDataNextConfig.Tags.nextAudioConfig) {
        throw new ReferenceError(
            "DecoderBufferSideDataNextConfig.nextAudioConfig is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DecoderBufferSideDataNextConfig.Tags.nextAudioConfig;
      this.$data = value;
    }
  });
  Object.defineProperty(DecoderBufferSideDataNextConfig.prototype, "nextVideoConfig", {
    get: function() {
      if (this.$tag != DecoderBufferSideDataNextConfig.Tags.nextVideoConfig) {
        throw new ReferenceError(
            "DecoderBufferSideDataNextConfig.nextVideoConfig is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DecoderBufferSideDataNextConfig.Tags.nextVideoConfig;
      this.$data = value;
    }
  });


    DecoderBufferSideDataNextConfig.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case DecoderBufferSideDataNextConfig.Tags.nextAudioConfig:
          encoder.encodeStructPointer(AudioDecoderConfig, val.nextAudioConfig);
          break;
        case DecoderBufferSideDataNextConfig.Tags.nextVideoConfig:
          encoder.encodeStructPointer(VideoDecoderConfig, val.nextVideoConfig);
          break;
      }
      encoder.align();
    };


    DecoderBufferSideDataNextConfig.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new DecoderBufferSideDataNextConfig();
      var tag = decoder.readUint32();
      switch (tag) {
        case DecoderBufferSideDataNextConfig.Tags.nextAudioConfig:
          result.nextAudioConfig = decoder.decodeStructPointer(AudioDecoderConfig);
          break;
        case DecoderBufferSideDataNextConfig.Tags.nextVideoConfig:
          result.nextVideoConfig = decoder.decodeStructPointer(VideoDecoderConfig);
          break;
      }
      decoder.align();

      return result;
    };


    DecoderBufferSideDataNextConfig.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case DecoderBufferSideDataNextConfig.Tags.nextAudioConfig:
          

    // validate DecoderBufferSideDataNextConfig.nextAudioConfig
    err = messageValidator.validateStructPointer(data_offset, AudioDecoderConfig, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DecoderBufferSideDataNextConfig.Tags.nextVideoConfig:
          

    // validate DecoderBufferSideDataNextConfig.nextVideoConfig
    err = messageValidator.validateStructPointer(data_offset, VideoDecoderConfig, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  DecoderBufferSideDataNextConfig.encodedSize = 16;

  function DecoderBuffer(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  DecoderBuffer.Tags = {
    eos: 0,
    data: 1,
  };

  DecoderBuffer.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  DecoderBuffer.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "eos",
        "data",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a DecoderBuffer member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(DecoderBuffer.prototype, "eos", {
    get: function() {
      if (this.$tag != DecoderBuffer.Tags.eos) {
        throw new ReferenceError(
            "DecoderBuffer.eos is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DecoderBuffer.Tags.eos;
      this.$data = value;
    }
  });
  Object.defineProperty(DecoderBuffer.prototype, "data", {
    get: function() {
      if (this.$tag != DecoderBuffer.Tags.data) {
        throw new ReferenceError(
            "DecoderBuffer.data is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DecoderBuffer.Tags.data;
      this.$data = value;
    }
  });


    DecoderBuffer.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case DecoderBuffer.Tags.eos:
          encoder.encodeStructPointer(EosDecoderBuffer, val.eos);
          break;
        case DecoderBuffer.Tags.data:
          encoder.encodeStructPointer(DataDecoderBuffer, val.data);
          break;
      }
      encoder.align();
    };


    DecoderBuffer.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new DecoderBuffer();
      var tag = decoder.readUint32();
      switch (tag) {
        case DecoderBuffer.Tags.eos:
          result.eos = decoder.decodeStructPointer(EosDecoderBuffer);
          break;
        case DecoderBuffer.Tags.data:
          result.data = decoder.decodeStructPointer(DataDecoderBuffer);
          break;
      }
      decoder.align();

      return result;
    };


    DecoderBuffer.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case DecoderBuffer.Tags.eos:
          

    // validate DecoderBuffer.eos
    err = messageValidator.validateStructPointer(data_offset, EosDecoderBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DecoderBuffer.Tags.data:
          

    // validate DecoderBuffer.data
    err = messageValidator.validateStructPointer(data_offset, DataDecoderBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  DecoderBuffer.encodedSize = 16;

  function VideoFrameData(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  VideoFrameData.Tags = {
    eosData: 0,
    sharedMemoryData: 1,
    gpuMemoryBufferSharedImageData: 2,
    sharedImageData: 3,
    opaqueData: 4,
  };

  VideoFrameData.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  VideoFrameData.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "eosData",
        "sharedMemoryData",
        "gpuMemoryBufferSharedImageData",
        "sharedImageData",
        "opaqueData",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a VideoFrameData member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(VideoFrameData.prototype, "eosData", {
    get: function() {
      if (this.$tag != VideoFrameData.Tags.eosData) {
        throw new ReferenceError(
            "VideoFrameData.eosData is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = VideoFrameData.Tags.eosData;
      this.$data = value;
    }
  });
  Object.defineProperty(VideoFrameData.prototype, "sharedMemoryData", {
    get: function() {
      if (this.$tag != VideoFrameData.Tags.sharedMemoryData) {
        throw new ReferenceError(
            "VideoFrameData.sharedMemoryData is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = VideoFrameData.Tags.sharedMemoryData;
      this.$data = value;
    }
  });
  Object.defineProperty(VideoFrameData.prototype, "gpuMemoryBufferSharedImageData", {
    get: function() {
      if (this.$tag != VideoFrameData.Tags.gpuMemoryBufferSharedImageData) {
        throw new ReferenceError(
            "VideoFrameData.gpuMemoryBufferSharedImageData is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = VideoFrameData.Tags.gpuMemoryBufferSharedImageData;
      this.$data = value;
    }
  });
  Object.defineProperty(VideoFrameData.prototype, "sharedImageData", {
    get: function() {
      if (this.$tag != VideoFrameData.Tags.sharedImageData) {
        throw new ReferenceError(
            "VideoFrameData.sharedImageData is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = VideoFrameData.Tags.sharedImageData;
      this.$data = value;
    }
  });
  Object.defineProperty(VideoFrameData.prototype, "opaqueData", {
    get: function() {
      if (this.$tag != VideoFrameData.Tags.opaqueData) {
        throw new ReferenceError(
            "VideoFrameData.opaqueData is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = VideoFrameData.Tags.opaqueData;
      this.$data = value;
    }
  });


    VideoFrameData.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case VideoFrameData.Tags.eosData:
          encoder.encodeStructPointer(EosVideoFrameData, val.eosData);
          break;
        case VideoFrameData.Tags.sharedMemoryData:
          encoder.encodeStructPointer(SharedMemoryVideoFrameData, val.sharedMemoryData);
          break;
        case VideoFrameData.Tags.gpuMemoryBufferSharedImageData:
          encoder.encodeStructPointer(GpuMemoryBufferSharedImageVideoFrameData, val.gpuMemoryBufferSharedImageData);
          break;
        case VideoFrameData.Tags.sharedImageData:
          encoder.encodeStructPointer(SharedImageVideoFrameData, val.sharedImageData);
          break;
        case VideoFrameData.Tags.opaqueData:
          encoder.encodeStructPointer(OpaqueVideoFrameData, val.opaqueData);
          break;
      }
      encoder.align();
    };


    VideoFrameData.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new VideoFrameData();
      var tag = decoder.readUint32();
      switch (tag) {
        case VideoFrameData.Tags.eosData:
          result.eosData = decoder.decodeStructPointer(EosVideoFrameData);
          break;
        case VideoFrameData.Tags.sharedMemoryData:
          result.sharedMemoryData = decoder.decodeStructPointer(SharedMemoryVideoFrameData);
          break;
        case VideoFrameData.Tags.gpuMemoryBufferSharedImageData:
          result.gpuMemoryBufferSharedImageData = decoder.decodeStructPointer(GpuMemoryBufferSharedImageVideoFrameData);
          break;
        case VideoFrameData.Tags.sharedImageData:
          result.sharedImageData = decoder.decodeStructPointer(SharedImageVideoFrameData);
          break;
        case VideoFrameData.Tags.opaqueData:
          result.opaqueData = decoder.decodeStructPointer(OpaqueVideoFrameData);
          break;
      }
      decoder.align();

      return result;
    };


    VideoFrameData.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case VideoFrameData.Tags.eosData:
          

    // validate VideoFrameData.eosData
    err = messageValidator.validateStructPointer(data_offset, EosVideoFrameData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case VideoFrameData.Tags.sharedMemoryData:
          

    // validate VideoFrameData.sharedMemoryData
    err = messageValidator.validateStructPointer(data_offset, SharedMemoryVideoFrameData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case VideoFrameData.Tags.gpuMemoryBufferSharedImageData:
          

    // validate VideoFrameData.gpuMemoryBufferSharedImageData
    err = messageValidator.validateStructPointer(data_offset, GpuMemoryBufferSharedImageVideoFrameData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case VideoFrameData.Tags.sharedImageData:
          

    // validate VideoFrameData.sharedImageData
    err = messageValidator.validateStructPointer(data_offset, SharedImageVideoFrameData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case VideoFrameData.Tags.opaqueData:
          

    // validate VideoFrameData.opaqueData
    err = messageValidator.validateStructPointer(data_offset, OpaqueVideoFrameData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  VideoFrameData.encodedSize = 16;
  exports.AudioCodec = AudioCodec;
  exports.AudioCodecProfile = AudioCodecProfile;
  exports.BufferingState = BufferingState;
  exports.BufferingStateChangeReason = BufferingStateChangeReason;
  exports.ChannelLayout = ChannelLayout;
  exports.MediaContentType = MediaContentType;
  exports.OutputDeviceStatus = OutputDeviceStatus;
  exports.SampleFormat = SampleFormat;
  exports.VideoCodec = VideoCodec;
  exports.VideoCodecProfile = VideoCodecProfile;
  exports.VideoPixelFormat = VideoPixelFormat;
  exports.VideoDecoderType = VideoDecoderType;
  exports.AudioDecoderType = AudioDecoderType;
  exports.VideoRotation = VideoRotation;
  exports.FullscreenVideoStatus = FullscreenVideoStatus;
  exports.WaitingReason = WaitingReason;
  exports.WatchTimeKey = WatchTimeKey;
  exports.MediaContainerName = MediaContainerName;
  exports.MediaStatusState = MediaStatusState;
  exports.EncryptionScheme = EncryptionScheme;
  exports.EncryptionType = EncryptionType;
  exports.SVCScalabilityMode = SVCScalabilityMode;
  exports.SVCInterLayerPredMode = SVCInterLayerPredMode;
  exports.CdmSessionClosedReason = CdmSessionClosedReason;
  exports.EffectState = EffectState;
  exports.MediaStreamType = MediaStreamType;
  exports.InputStreamErrorCode = InputStreamErrorCode;
  exports.RendererType = RendererType;
  exports.DemuxerType = DemuxerType;
  exports.CreateCdmStatus = CreateCdmStatus;
  exports.AutoPipReason = AutoPipReason;
  exports.MediaLogRecord = MediaLogRecord;
  exports.VideoTransformation = VideoTransformation;
  exports.VideoAspectRatio = VideoAspectRatio;
  exports.VideoColorSpace = VideoColorSpace;
  exports.AudioDecoderConfig = AudioDecoderConfig;
  exports.VideoDecoderConfig = VideoDecoderConfig;
  exports.SubsampleEntry = SubsampleEntry;
  exports.DecryptConfig = DecryptConfig;
  exports.DecoderBufferSideData = DecoderBufferSideData;
  exports.DataDecoderBuffer = DataDecoderBuffer;
  exports.EosDecoderBuffer = EosDecoderBuffer;
  exports.AudioBuffer = AudioBuffer;
  exports.CaptureVersion = CaptureVersion;
  exports.VideoFrameMetadata = VideoFrameMetadata;
  exports.VideoFrame = VideoFrame;
  exports.EosVideoFrameData = EosVideoFrameData;
  exports.SharedMemoryVideoFrameData = SharedMemoryVideoFrameData;
  exports.GpuMemoryBufferSharedImageVideoFrameData = GpuMemoryBufferSharedImageVideoFrameData;
  exports.SharedImageVideoFrameData = SharedImageVideoFrameData;
  exports.OpaqueVideoFrameData = OpaqueVideoFrameData;
  exports.PipelineStatistics = PipelineStatistics;
  exports.PredictionFeatures = PredictionFeatures;
  exports.PredictionTargets = PredictionTargets;
  exports.AudioPipelineInfo = AudioPipelineInfo;
  exports.VideoPipelineInfo = VideoPipelineInfo;
  exports.StatusData = StatusData;
  exports.EncoderStatus = EncoderStatus;
  exports.DecoderStatus = DecoderStatus;
  exports.PipelineStatus = PipelineStatus;
  exports.AutoPipInfo = AutoPipInfo;
  exports.DecoderBufferSideDataNextConfig = DecoderBufferSideDataNextConfig;
  exports.DecoderBuffer = DecoderBuffer;
  exports.VideoFrameData = VideoFrameData;
})();