// media/mojo/mojom/provision_fetcher.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProvisionFetcherPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.ProvisionFetcher', scope);
  }
}

/** @interface */
export class ProvisionFetcherInterface {
  
  /**
   * @param { !url_mojom_Url } defaultUrl
   * @param { !string } requestData
   * @return {!Promise<{
        result: !boolean,
        response: !string,
   *  }>}
   */

  retrieve(defaultUrl, requestData) {}
}

/**
 * @implements { ProvisionFetcherInterface }
 */
export class ProvisionFetcherRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProvisionFetcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProvisionFetcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProvisionFetcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } defaultUrl
   * @param { !string } requestData
   * @return {!Promise<{
        result: !boolean,
        response: !string,
   *  }>}
   */

  retrieve(
      defaultUrl,
      requestData) {
    return this.proxy.sendMessage(
        0,
        ProvisionFetcher_Retrieve_ParamsSpec.$,
        ProvisionFetcher_Retrieve_ResponseParamsSpec.$,
        [
          defaultUrl,
          requestData
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProvisionFetcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProvisionFetcherReceiver {
  /**
   * @param {!ProvisionFetcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProvisionFetcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProvisionFetcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProvisionFetcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProvisionFetcher_Retrieve_ParamsSpec.$,
        ProvisionFetcher_Retrieve_ResponseParamsSpec.$,
        impl.retrieve.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProvisionFetcher {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.ProvisionFetcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProvisionFetcherRemote}
   */
  static getRemote() {
    let remote = new ProvisionFetcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProvisionFetcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProvisionFetcherCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProvisionFetcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProvisionFetcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.retrieve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProvisionFetcher_Retrieve_ParamsSpec.$,
        ProvisionFetcher_Retrieve_ResponseParamsSpec.$,
        this.retrieve.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProvisionFetcher_Retrieve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProvisionFetcher_Retrieve_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ProvisionFetcher_Retrieve_ParamsSpec.$,
    'ProvisionFetcher_Retrieve_Params',
    [
      mojo.internal.StructField(
        'defaultUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestData', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProvisionFetcher_Retrieve_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.defaultUrl;
    /** @type { !string } */
    this.requestData;
  }
}



mojo.internal.Struct(
    ProvisionFetcher_Retrieve_ResponseParamsSpec.$,
    'ProvisionFetcher_Retrieve_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProvisionFetcher_Retrieve_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
    /** @type { !string } */
    this.response;
  }
}

