// media/mojo/mojom/speech_recognition_audio_forwarder.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  AudioDataS16 as media_mojom_AudioDataS16,
  AudioDataS16Spec as media_mojom_AudioDataS16Spec
} from './audio_data.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionAudioForwarderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionAudioForwarder', scope);
  }
}

/** @interface */
export class SpeechRecognitionAudioForwarderInterface {
  
  /**
   * @param { !media_mojom_AudioDataS16 } buffer
   */

  addAudioFromRenderer(buffer) {}
}

/**
 * @implements { SpeechRecognitionAudioForwarderInterface }
 */
export class SpeechRecognitionAudioForwarderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionAudioForwarderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionAudioForwarderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionAudioForwarderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioDataS16 } buffer
   */

  addAudioFromRenderer(
      buffer) {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionAudioForwarder_AddAudioFromRenderer_ParamsSpec.$,
        null,
        [
          buffer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionAudioForwarder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionAudioForwarderReceiver {
  /**
   * @param {!SpeechRecognitionAudioForwarderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionAudioForwarderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionAudioForwarderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionAudioForwarderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionAudioForwarder_AddAudioFromRenderer_ParamsSpec.$,
        null,
        impl.addAudioFromRenderer.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionAudioForwarder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionAudioForwarder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionAudioForwarderRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionAudioForwarderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionAudioForwarder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionAudioForwarderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionAudioForwarderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionAudioForwarderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAudioFromRenderer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionAudioForwarder_AddAudioFromRenderer_ParamsSpec.$,
        null,
        this.addAudioFromRenderer.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionAudioForwarder_AddAudioFromRenderer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SpeechRecognitionAudioForwarder_AddAudioFromRenderer_ParamsSpec.$,
    'SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media_mojom_AudioDataS16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionAudioForwarder_AddAudioFromRenderer_Params {
  constructor() {
    /** @type { !media_mojom_AudioDataS16 } */
    this.buffer;
  }
}

