// media/mojo/mojom/video_encode_accelerator.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  UnsafeSharedMemoryRegion as mojoBase_mojom_UnsafeSharedMemoryRegion,
  UnsafeSharedMemoryRegionSpec as mojoBase_mojom_UnsafeSharedMemoryRegionSpec
} from '../../../mojo/public/mojom/base/shared_memory.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  ColorSpace as gfx_mojom_ColorSpace,
  ColorSpaceSpec as gfx_mojom_ColorSpaceSpec
} from '../../../ui/gfx/mojom/color_space.mojom.m.js';

import {
  MediaLogRemote as media_mojom_MediaLogRemote,
  MediaLogPendingReceiver as media_mojom_MediaLogPendingReceiver
} from './media_log.mojom.m.js';

import {
  SVCInterLayerPredMode as media_mojom_SVCInterLayerPredMode,
  SVCInterLayerPredModeSpec as media_mojom_SVCInterLayerPredModeSpec,
  SVCScalabilityMode as media_mojom_SVCScalabilityMode,
  SVCScalabilityModeSpec as media_mojom_SVCScalabilityModeSpec,
  VideoCodecProfile as media_mojom_VideoCodecProfile,
  VideoCodecProfileSpec as media_mojom_VideoCodecProfileSpec,
  VideoPixelFormat as media_mojom_VideoPixelFormat,
  VideoPixelFormatSpec as media_mojom_VideoPixelFormatSpec,
  EncoderStatus as media_mojom_EncoderStatus,
  EncoderStatusSpec as media_mojom_EncoderStatusSpec,
  VideoFrame as media_mojom_VideoFrame,
  VideoFrameSpec as media_mojom_VideoFrameSpec
} from './media_types.mojom.m.js';

import {
  VideoEncoderInfo as media_mojom_VideoEncoderInfo,
  VideoEncoderInfoSpec as media_mojom_VideoEncoderInfoSpec
} from './video_encoder_info.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoEncodeAcceleratorSupportedRateControlModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoEncodeAcceleratorSupportedRateControlMode = {
  
  kNoMode: 0,
  kConstantMode: 1,
  kVariableMode: 2,
  kExternalMode: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoEncodeAcceleratorProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoEncodeAcceleratorProvider', scope);
  }
}

/** @interface */
export class VideoEncodeAcceleratorProviderInterface {
  
  /**
   * @param { ?EncodeCommandBufferId } commandBufferId
   * @param { !VideoEncodeAcceleratorPendingReceiver } receiver
   */

  createVideoEncodeAccelerator(commandBufferId, receiver) {}
  
  /**
   * @return {!Promise<{
        profiles: !Array<!VideoEncodeAcceleratorSupportedProfile>,
   *  }>}
   */

  getVideoEncodeAcceleratorSupportedProfiles() {}
}

/**
 * @implements { VideoEncodeAcceleratorProviderInterface }
 */
export class VideoEncodeAcceleratorProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoEncodeAcceleratorProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoEncodeAcceleratorProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoEncodeAcceleratorProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?EncodeCommandBufferId } commandBufferId
   * @param { !VideoEncodeAcceleratorPendingReceiver } receiver
   */

  createVideoEncodeAccelerator(
      commandBufferId,
      receiver) {
    this.proxy.sendMessage(
        0,
        VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec.$,
        null,
        [
          commandBufferId,
          receiver
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        profiles: !Array<!VideoEncodeAcceleratorSupportedProfile>,
   *  }>}
   */

  getVideoEncodeAcceleratorSupportedProfiles() {
    return this.proxy.sendMessage(
        1,
        VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec.$,
        VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoEncodeAcceleratorProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoEncodeAcceleratorProviderReceiver {
  /**
   * @param {!VideoEncodeAcceleratorProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoEncodeAcceleratorProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoEncodeAcceleratorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoEncodeAcceleratorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec.$,
        null,
        impl.createVideoEncodeAccelerator.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec.$,
        VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec.$,
        impl.getVideoEncodeAcceleratorSupportedProfiles.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoEncodeAcceleratorProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncodeAcceleratorProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoEncodeAcceleratorProviderRemote}
   */
  static getRemote() {
    let remote = new VideoEncodeAcceleratorProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoEncodeAcceleratorProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoEncodeAcceleratorProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoEncodeAcceleratorProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoEncodeAcceleratorProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createVideoEncodeAccelerator =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec.$,
        null,
        this.createVideoEncodeAccelerator.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVideoEncodeAcceleratorSupportedProfiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec.$,
        VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec.$,
        this.getVideoEncodeAcceleratorSupportedProfiles.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoEncodeAcceleratorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoEncodeAccelerator', scope);
  }
}

/** @interface */
export class VideoEncodeAcceleratorInterface {
  
  /**
   * @param { !VideoEncodeAcceleratorConfig } config
   * @param { !Object } client
   * @param { !media_mojom_MediaLogRemote } mediaLog
   * @return {!Promise<{
        result: !media_mojom_EncoderStatus,
   *  }>}
   */

  initialize(config, client, mediaLog) {}
  
  /**
   * @param { !media_mojom_VideoFrame } frame
   * @param { !VideoEncodeOptions } options
   * @return {!Promise}
   */

  encode(frame, options) {}
  
  /**
   * @param { !number } bitstreamBufferId
   * @param { !mojoBase_mojom_UnsafeSharedMemoryRegion } region
   */

  useOutputBitstreamBuffer(bitstreamBufferId, region) {}
  
  /**
   * @param { !VideoBitrateAllocation } bitrateAllocation
   * @param { !number } framerate
   * @param { ?gfx_mojom_Size } size
   */

  requestEncodingParametersChangeWithLayers(bitrateAllocation, framerate, size) {}
  
  /**
   * @param { !Bitrate } bitrate
   * @param { !number } framerate
   * @param { ?gfx_mojom_Size } size
   */

  requestEncodingParametersChangeWithBitrate(bitrate, framerate, size) {}
  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isFlushSupported() {}
  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  flush() {}
}

/**
 * @implements { VideoEncodeAcceleratorInterface }
 */
export class VideoEncodeAcceleratorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoEncodeAcceleratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoEncodeAcceleratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoEncodeAcceleratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !VideoEncodeAcceleratorConfig } config
   * @param { !Object } client
   * @param { !media_mojom_MediaLogRemote } mediaLog
   * @return {!Promise<{
        result: !media_mojom_EncoderStatus,
   *  }>}
   */

  initialize(
      config,
      client,
      mediaLog) {
    return this.proxy.sendMessage(
        0,
        VideoEncodeAccelerator_Initialize_ParamsSpec.$,
        VideoEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        [
          config,
          client,
          mediaLog
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoFrame } frame
   * @param { !VideoEncodeOptions } options
   * @return {!Promise}
   */

  encode(
      frame,
      options) {
    return this.proxy.sendMessage(
        1,
        VideoEncodeAccelerator_Encode_ParamsSpec.$,
        VideoEncodeAccelerator_Encode_ResponseParamsSpec.$,
        [
          frame,
          options
        ],
        false);
  }

  
  /**
   * @param { !number } bitstreamBufferId
   * @param { !mojoBase_mojom_UnsafeSharedMemoryRegion } region
   */

  useOutputBitstreamBuffer(
      bitstreamBufferId,
      region) {
    this.proxy.sendMessage(
        2,
        VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec.$,
        null,
        [
          bitstreamBufferId,
          region
        ],
        false);
  }

  
  /**
   * @param { !VideoBitrateAllocation } bitrateAllocation
   * @param { !number } framerate
   * @param { ?gfx_mojom_Size } size
   */

  requestEncodingParametersChangeWithLayers(
      bitrateAllocation,
      framerate,
      size) {
    this.proxy.sendMessage(
        3,
        VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec.$,
        null,
        [
          bitrateAllocation,
          framerate,
          size
        ],
        false);
  }

  
  /**
   * @param { !Bitrate } bitrate
   * @param { !number } framerate
   * @param { ?gfx_mojom_Size } size
   */

  requestEncodingParametersChangeWithBitrate(
      bitrate,
      framerate,
      size) {
    this.proxy.sendMessage(
        4,
        VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec.$,
        null,
        [
          bitrate,
          framerate,
          size
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isFlushSupported() {
    return this.proxy.sendMessage(
        5,
        VideoEncodeAccelerator_IsFlushSupported_ParamsSpec.$,
        VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  flush() {
    return this.proxy.sendMessage(
        6,
        VideoEncodeAccelerator_Flush_ParamsSpec.$,
        VideoEncodeAccelerator_Flush_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoEncodeAccelerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoEncodeAcceleratorReceiver {
  /**
   * @param {!VideoEncodeAcceleratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoEncodeAcceleratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoEncodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoEncodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoEncodeAccelerator_Initialize_ParamsSpec.$,
        VideoEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VideoEncodeAccelerator_Encode_ParamsSpec.$,
        VideoEncodeAccelerator_Encode_ResponseParamsSpec.$,
        impl.encode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec.$,
        null,
        impl.useOutputBitstreamBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec.$,
        null,
        impl.requestEncodingParametersChangeWithLayers.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec.$,
        null,
        impl.requestEncodingParametersChangeWithBitrate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        VideoEncodeAccelerator_IsFlushSupported_ParamsSpec.$,
        VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec.$,
        impl.isFlushSupported.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        VideoEncodeAccelerator_Flush_ParamsSpec.$,
        VideoEncodeAccelerator_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoEncodeAccelerator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncodeAccelerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoEncodeAcceleratorRemote}
   */
  static getRemote() {
    let remote = new VideoEncodeAcceleratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoEncodeAccelerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoEncodeAcceleratorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoEncodeAcceleratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoEncodeAcceleratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoEncodeAccelerator_Initialize_ParamsSpec.$,
        VideoEncodeAccelerator_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.encode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VideoEncodeAccelerator_Encode_ParamsSpec.$,
        VideoEncodeAccelerator_Encode_ResponseParamsSpec.$,
        this.encode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.useOutputBitstreamBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec.$,
        null,
        this.useOutputBitstreamBuffer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestEncodingParametersChangeWithLayers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec.$,
        null,
        this.requestEncodingParametersChangeWithLayers.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestEncodingParametersChangeWithBitrate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec.$,
        null,
        this.requestEncodingParametersChangeWithBitrate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFlushSupported =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        VideoEncodeAccelerator_IsFlushSupported_ParamsSpec.$,
        VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec.$,
        this.isFlushSupported.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        VideoEncodeAccelerator_Flush_ParamsSpec.$,
        VideoEncodeAccelerator_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoEncodeAcceleratorClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoEncodeAcceleratorClient', scope);
  }
}

/** @interface */
export class VideoEncodeAcceleratorClientInterface {
  
  /**
   * @param { !number } inputCount
   * @param { !gfx_mojom_Size } inputCodedSize
   * @param { !number } outputBufferSize
   */

  requireBitstreamBuffers(inputCount, inputCodedSize, outputBufferSize) {}
  
  /**
   * @param { !number } bitstreamBufferId
   * @param { !BitstreamBufferMetadata } metadata
   */

  bitstreamBufferReady(bitstreamBufferId, metadata) {}
  
  /**
   * @param { !media_mojom_EncoderStatus } status
   */

  notifyErrorStatus(status) {}
  
  /**
   * @param { !media_mojom_VideoEncoderInfo } info
   */

  notifyEncoderInfoChange(info) {}
}

/**
 * @implements { VideoEncodeAcceleratorClientInterface }
 */
export class VideoEncodeAcceleratorClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoEncodeAcceleratorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoEncodeAcceleratorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoEncodeAcceleratorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } inputCount
   * @param { !gfx_mojom_Size } inputCodedSize
   * @param { !number } outputBufferSize
   */

  requireBitstreamBuffers(
      inputCount,
      inputCodedSize,
      outputBufferSize) {
    this.proxy.sendMessage(
        0,
        VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec.$,
        null,
        [
          inputCount,
          inputCodedSize,
          outputBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } bitstreamBufferId
   * @param { !BitstreamBufferMetadata } metadata
   */

  bitstreamBufferReady(
      bitstreamBufferId,
      metadata) {
    this.proxy.sendMessage(
        1,
        VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec.$,
        null,
        [
          bitstreamBufferId,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_EncoderStatus } status
   */

  notifyErrorStatus(
      status) {
    this.proxy.sendMessage(
        2,
        VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoEncoderInfo } info
   */

  notifyEncoderInfoChange(
      info) {
    this.proxy.sendMessage(
        3,
        VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoEncodeAcceleratorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoEncodeAcceleratorClientReceiver {
  /**
   * @param {!VideoEncodeAcceleratorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoEncodeAcceleratorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoEncodeAcceleratorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoEncodeAcceleratorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec.$,
        null,
        impl.requireBitstreamBuffers.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec.$,
        null,
        impl.bitstreamBufferReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec.$,
        null,
        impl.notifyErrorStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec.$,
        null,
        impl.notifyEncoderInfoChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoEncodeAcceleratorClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncodeAcceleratorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoEncodeAcceleratorClientRemote}
   */
  static getRemote() {
    let remote = new VideoEncodeAcceleratorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoEncodeAcceleratorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoEncodeAcceleratorClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoEncodeAcceleratorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoEncodeAcceleratorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requireBitstreamBuffers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec.$,
        null,
        this.requireBitstreamBuffers.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bitstreamBufferReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec.$,
        null,
        this.bitstreamBufferReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyErrorStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec.$,
        null,
        this.notifyErrorStatus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyEncoderInfoChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec.$,
        null,
        this.notifyEncoderInfoChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorSupportedProfileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EncodeCommandBufferIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VariableBitratePeakSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoBitrateAllocationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpatialLayerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ConstantBitrateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VariableBitrateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ExternalBitrateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DropFrameMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const H264MetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Vp8MetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Vp9MetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SVCGenericMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BitstreamBufferMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_Encode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_Encode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_IsFlushSupported_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAccelerator_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const BitrateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const OptionalMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VideoEncodeAcceleratorSupportedProfileSpec.$,
    'VideoEncodeAcceleratorSupportedProfile',
    [
      mojo.internal.StructField(
        'profile', 0,
        0,
        media_mojom_VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minResolution', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxResolution', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFramerateNumerator', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFramerateDenominator', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rateControlModes', 32,
        0,
        mojo.internal.Array(VideoEncodeAcceleratorSupportedRateControlModeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scalabilityModes', 40,
        0,
        mojo.internal.Array(media_mojom_SVCScalabilityModeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSoftwareCodec', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gpuSupportedPixelFormats', 48,
        0,
        mojo.internal.Array(media_mojom_VideoPixelFormatSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'supportsGpuSharedImages', 28,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorSupportedProfile {
  constructor() {
    /** @type { !media_mojom_VideoCodecProfile } */
    this.profile;
    /** @type { !gfx_mojom_Size } */
    this.minResolution;
    /** @type { !gfx_mojom_Size } */
    this.maxResolution;
    /** @type { !number } */
    this.maxFramerateNumerator;
    /** @type { !number } */
    this.maxFramerateDenominator;
    /** @type { !Array<!VideoEncodeAcceleratorSupportedRateControlMode> } */
    this.rateControlModes;
    /** @type { !Array<!media_mojom_SVCScalabilityMode> } */
    this.scalabilityModes;
    /** @type { !boolean } */
    this.isSoftwareCodec;
    /** @type { !Array<!media_mojom_VideoPixelFormat> } */
    this.gpuSupportedPixelFormats;
    /** @type { !boolean } */
    this.supportsGpuSharedImages;
  }
}



mojo.internal.Struct(
    EncodeCommandBufferIdSpec.$,
    'EncodeCommandBufferId',
    [
      mojo.internal.StructField(
        'channelToken', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'routeId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EncodeCommandBufferId {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.channelToken;
    /** @type { !number } */
    this.routeId;
  }
}



mojo.internal.Struct(
    VariableBitratePeakSpec.$,
    'VariableBitratePeak',
    [
      mojo.internal.StructField(
        'bps', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VariableBitratePeak {
  constructor() {
    /** @type { !number } */
    this.bps;
  }
}



mojo.internal.Struct(
    VideoBitrateAllocationSpec.$,
    'VideoBitrateAllocation',
    [
      mojo.internal.StructField(
        'bitrates', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'variableBitratePeak', 8,
        0,
        VariableBitratePeakSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoBitrateAllocation {
  constructor() {
    /** @type { !Array<!number> } */
    this.bitrates;
    /** @type { (VariableBitratePeak|undefined) } */
    this.variableBitratePeak;
  }
}



mojo.internal.Struct(
    SpatialLayerSpec.$,
    'SpatialLayer',
    [
      mojo.internal.StructField(
        'width', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'height', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bitrateBps', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framerate', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxQp', 16,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numOfTemporalLayers', 17,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SpatialLayer {
  constructor() {
    /** @type { !number } */
    this.width;
    /** @type { !number } */
    this.height;
    /** @type { !number } */
    this.bitrateBps;
    /** @type { !number } */
    this.framerate;
    /** @type { !number } */
    this.maxQp;
    /** @type { !number } */
    this.numOfTemporalLayers;
  }
}



mojo.internal.Struct(
    ConstantBitrateSpec.$,
    'ConstantBitrate',
    [
      mojo.internal.StructField(
        'targetBps', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ConstantBitrate {
  constructor() {
    /** @type { !number } */
    this.targetBps;
  }
}



mojo.internal.Struct(
    VariableBitrateSpec.$,
    'VariableBitrate',
    [
      mojo.internal.StructField(
        'targetBps', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peakBps', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VariableBitrate {
  constructor() {
    /** @type { !number } */
    this.targetBps;
    /** @type { !number } */
    this.peakBps;
  }
}



mojo.internal.Struct(
    ExternalBitrateSpec.$,
    'ExternalBitrate',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ExternalBitrate {
  constructor() {
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoEncodeAcceleratorConfig_ContentTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoEncodeAcceleratorConfig_ContentType = {
  
  kCamera: 0,
  kDisplay: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoEncodeAcceleratorConfig_StorageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoEncodeAcceleratorConfig_StorageType = {
  
  kShmem: 0,
  kGpuMemoryBuffer: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoEncodeAcceleratorConfig_EncoderTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoEncodeAcceleratorConfig_EncoderType = {
  
  kHardware: 0,
  kSoftware: 1,
  kNoPreference: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


mojo.internal.Struct(
    VideoEncodeAcceleratorConfigSpec.$,
    'VideoEncodeAcceleratorConfig',
    [
      mojo.internal.StructField(
        'inputFormat', 0,
        0,
        media_mojom_VideoPixelFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputVisibleSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputProfile', 4,
        0,
        media_mojom_VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bitrate', 16,
        0,
        BitrateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framerate', 32,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageType', 36,
        0,
        VideoEncodeAcceleratorConfig_StorageTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentType', 40,
        0,
        VideoEncodeAcceleratorConfig_ContentTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'gopLength', 44,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasGopLength', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'h264OutputLevel', 49,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasH264OutputLevel', 48,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isConstrainedH264', 48,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dropFrameThreshPercentage', 50,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spatialLayers', 56,
        0,
        mojo.internal.Array(SpatialLayerSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interLayerPred', 52,
        0,
        media_mojom_SVCInterLayerPredModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requireLowDelay', 48,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requiredEncoderType', 64,
        0,
        VideoEncodeAcceleratorConfig_EncoderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'manualReferenceBufferControl', 48,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorConfig {
  constructor() {
    /** @type { !media_mojom_VideoPixelFormat } */
    this.inputFormat;
    /** @type { !gfx_mojom_Size } */
    this.inputVisibleSize;
    /** @type { !media_mojom_VideoCodecProfile } */
    this.outputProfile;
    /** @type { !Bitrate } */
    this.bitrate;
    /** @type { !number } */
    this.framerate;
    /** @type { !VideoEncodeAcceleratorConfig_StorageType } */
    this.storageType;
    /** @type { !VideoEncodeAcceleratorConfig_ContentType } */
    this.contentType;
    /** @type { !number } */
    this.gopLength;
    /** @type { !boolean } */
    this.hasGopLength;
    /** @type { !number } */
    this.h264OutputLevel;
    /** @type { !boolean } */
    this.hasH264OutputLevel;
    /** @type { !boolean } */
    this.isConstrainedH264;
    /** @type { !number } */
    this.dropFrameThreshPercentage;
    /** @type { !Array<!SpatialLayer> } */
    this.spatialLayers;
    /** @type { !media_mojom_SVCInterLayerPredMode } */
    this.interLayerPred;
    /** @type { !boolean } */
    this.requireLowDelay;
    /** @type { !VideoEncodeAcceleratorConfig_EncoderType } */
    this.requiredEncoderType;
    /** @type { !boolean } */
    this.manualReferenceBufferControl;
  }
}



mojo.internal.Struct(
    VideoEncodeOptionsSpec.$,
    'VideoEncodeOptions',
    [
      mojo.internal.StructField(
        'forceKeyframe', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quantizer', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'update_buffer_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "update_buffer_$value",
          originalFieldName: "updateBuffer",
        }
      ),
      mojo.internal.StructField(
        'update_buffer_$value', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "updateBuffer",
        }
      ),
      mojo.internal.StructField(
        'referenceBuffers', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoEncodeOptions {
  constructor() {
    /** @type { !boolean } */
    this.forceKeyframe;
    /** @type { !number } */
    this.quantizer;
    /** @type { (number|undefined) } */
    this.updateBuffer;
    /** @type { !Array<!number> } */
    this.referenceBuffers;
  }
}



mojo.internal.Struct(
    DropFrameMetadataSpec.$,
    'DropFrameMetadata',
    [
      mojo.internal.StructField(
        'spatialIdx', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOfPicture', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DropFrameMetadata {
  constructor() {
    /** @type { !number } */
    this.spatialIdx;
    /** @type { !boolean } */
    this.endOfPicture;
  }
}



mojo.internal.Struct(
    H264MetadataSpec.$,
    'H264Metadata',
    [
      mojo.internal.StructField(
        'temporalIdx', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'layerSync', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class H264Metadata {
  constructor() {
    /** @type { !number } */
    this.temporalIdx;
    /** @type { !boolean } */
    this.layerSync;
  }
}



mojo.internal.Struct(
    Vp8MetadataSpec.$,
    'Vp8Metadata',
    [
      mojo.internal.StructField(
        'nonReference', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'temporalIdx', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'layerSync', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Vp8Metadata {
  constructor() {
    /** @type { !boolean } */
    this.nonReference;
    /** @type { !number } */
    this.temporalIdx;
    /** @type { !boolean } */
    this.layerSync;
  }
}



mojo.internal.Struct(
    Vp9MetadataSpec.$,
    'Vp9Metadata',
    [
      mojo.internal.StructField(
        'interPicPredicted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'temporalUpSwitch', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referencedByUpperSpatialLayers', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referenceLowerSpatialLayers', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOfPicture', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'temporalIdx', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spatialIdx', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spatialLayerResolutions', 8,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'beginActiveSpatialLayerIndex', 3,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endActiveSpatialLayerIndex', 4,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pDiffs', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Vp9Metadata {
  constructor() {
    /** @type { !boolean } */
    this.interPicPredicted;
    /** @type { !boolean } */
    this.temporalUpSwitch;
    /** @type { !boolean } */
    this.referencedByUpperSpatialLayers;
    /** @type { !boolean } */
    this.referenceLowerSpatialLayers;
    /** @type { !boolean } */
    this.endOfPicture;
    /** @type { !number } */
    this.temporalIdx;
    /** @type { !number } */
    this.spatialIdx;
    /** @type { !Array<!gfx_mojom_Size> } */
    this.spatialLayerResolutions;
    /** @type { !number } */
    this.beginActiveSpatialLayerIndex;
    /** @type { !number } */
    this.endActiveSpatialLayerIndex;
    /** @type { !Array<!number> } */
    this.pDiffs;
  }
}



mojo.internal.Struct(
    SVCGenericMetadataSpec.$,
    'SVCGenericMetadata',
    [
      mojo.internal.StructField(
        'followSvcSpec', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'temporalIdx', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spatialIdx', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reference_flags_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "reference_flags_$value",
          originalFieldName: "referenceFlags",
        }
      ),
      mojo.internal.StructField(
        'reference_flags_$value', 4,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "referenceFlags",
        }
      ),
      mojo.internal.StructField(
        'refresh_flags_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "refresh_flags_$value",
          originalFieldName: "refreshFlags",
        }
      ),
      mojo.internal.StructField(
        'refresh_flags_$value', 6,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "refreshFlags",
        }
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SVCGenericMetadata {
  constructor() {
    /** @type { !boolean } */
    this.followSvcSpec;
    /** @type { !number } */
    this.temporalIdx;
    /** @type { !number } */
    this.spatialIdx;
    /** @type { (number|undefined) } */
    this.referenceFlags;
    /** @type { (number|undefined) } */
    this.refreshFlags;
  }
}



mojo.internal.Struct(
    BitstreamBufferMetadataSpec.$,
    'BitstreamBufferMetadata',
    [
      mojo.internal.StructField(
        'payloadSizeBytes', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyFrame', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'qp', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'optionalMetadata', 24,
        0,
        OptionalMetadataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'svcGeneric', 40,
        0,
        SVCGenericMetadataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encodedSize', 48,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encodedColorSpace', 56,
        0,
        gfx_mojom_ColorSpaceSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class BitstreamBufferMetadata {
  constructor() {
    /** @type { !number } */
    this.payloadSizeBytes;
    /** @type { !boolean } */
    this.keyFrame;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timestamp;
    /** @type { !number } */
    this.qp;
    /** @type { (OptionalMetadata|undefined) } */
    this.optionalMetadata;
    /** @type { (SVCGenericMetadata|undefined) } */
    this.svcGeneric;
    /** @type { (gfx_mojom_Size|undefined) } */
    this.encodedSize;
    /** @type { (gfx_mojom_ColorSpace|undefined) } */
    this.encodedColorSpace;
  }
}



mojo.internal.Struct(
    VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsSpec.$,
    'VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params',
    [
      mojo.internal.StructField(
        'commandBufferId', 0,
        0,
        EncodeCommandBufferIdSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(VideoEncodeAcceleratorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params {
  constructor() {
    /** @type { (EncodeCommandBufferId|undefined) } */
    this.commandBufferId;
    /** @type { !VideoEncodeAcceleratorPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsSpec.$,
    'VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsSpec.$,
    'VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams',
    [
      mojo.internal.StructField(
        'profiles', 0,
        0,
        mojo.internal.Array(VideoEncodeAcceleratorSupportedProfileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams {
  constructor() {
    /** @type { !Array<!VideoEncodeAcceleratorSupportedProfile> } */
    this.profiles;
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_Initialize_ParamsSpec.$,
    'VideoEncodeAccelerator_Initialize_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        VideoEncodeAcceleratorConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(VideoEncodeAcceleratorClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaLog', 16,
        0,
        mojo.internal.InterfaceProxy(media_mojom_MediaLogRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_Initialize_Params {
  constructor() {
    /** @type { !VideoEncodeAcceleratorConfig } */
    this.config;
    /** @type { !Object } */
    this.client;
    /** @type { !media_mojom_MediaLogRemote } */
    this.mediaLog;
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_Initialize_ResponseParamsSpec.$,
    'VideoEncodeAccelerator_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media_mojom_EncoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_Initialize_ResponseParams {
  constructor() {
    /** @type { !media_mojom_EncoderStatus } */
    this.result;
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_Encode_ParamsSpec.$,
    'VideoEncodeAccelerator_Encode_Params',
    [
      mojo.internal.StructField(
        'frame', 0,
        0,
        media_mojom_VideoFrameSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        VideoEncodeOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_Encode_Params {
  constructor() {
    /** @type { !media_mojom_VideoFrame } */
    this.frame;
    /** @type { !VideoEncodeOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_Encode_ResponseParamsSpec.$,
    'VideoEncodeAccelerator_Encode_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_Encode_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsSpec.$,
    'VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params',
    [
      mojo.internal.StructField(
        'bitstreamBufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'region', 8,
        0,
        mojoBase_mojom_UnsafeSharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params {
  constructor() {
    /** @type { !number } */
    this.bitstreamBufferId;
    /** @type { !mojoBase_mojom_UnsafeSharedMemoryRegion } */
    this.region;
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsSpec.$,
    'VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params',
    [
      mojo.internal.StructField(
        'bitrateAllocation', 0,
        0,
        VideoBitrateAllocationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framerate', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params {
  constructor() {
    /** @type { !VideoBitrateAllocation } */
    this.bitrateAllocation;
    /** @type { !number } */
    this.framerate;
    /** @type { (gfx_mojom_Size|undefined) } */
    this.size;
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsSpec.$,
    'VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params',
    [
      mojo.internal.StructField(
        'bitrate', 0,
        0,
        BitrateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framerate', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'size', 24,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params {
  constructor() {
    /** @type { !Bitrate } */
    this.bitrate;
    /** @type { !number } */
    this.framerate;
    /** @type { (gfx_mojom_Size|undefined) } */
    this.size;
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_IsFlushSupported_ParamsSpec.$,
    'VideoEncodeAccelerator_IsFlushSupported_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_IsFlushSupported_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_IsFlushSupported_ResponseParamsSpec.$,
    'VideoEncodeAccelerator_IsFlushSupported_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_IsFlushSupported_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_Flush_ParamsSpec.$,
    'VideoEncodeAccelerator_Flush_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_Flush_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    VideoEncodeAccelerator_Flush_ResponseParamsSpec.$,
    'VideoEncodeAccelerator_Flush_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoEncodeAccelerator_Flush_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsSpec.$,
    'VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params',
    [
      mojo.internal.StructField(
        'inputCount', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputCodedSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputBufferSize', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params {
  constructor() {
    /** @type { !number } */
    this.inputCount;
    /** @type { !gfx_mojom_Size } */
    this.inputCodedSize;
    /** @type { !number } */
    this.outputBufferSize;
  }
}



mojo.internal.Struct(
    VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsSpec.$,
    'VideoEncodeAcceleratorClient_BitstreamBufferReady_Params',
    [
      mojo.internal.StructField(
        'bitstreamBufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        BitstreamBufferMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorClient_BitstreamBufferReady_Params {
  constructor() {
    /** @type { !number } */
    this.bitstreamBufferId;
    /** @type { !BitstreamBufferMetadata } */
    this.metadata;
  }
}



mojo.internal.Struct(
    VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsSpec.$,
    'VideoEncodeAcceleratorClient_NotifyErrorStatus_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_EncoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorClient_NotifyErrorStatus_Params {
  constructor() {
    /** @type { !media_mojom_EncoderStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsSpec.$,
    'VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        media_mojom_VideoEncoderInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params {
  constructor() {
    /** @type { !media_mojom_VideoEncoderInfo } */
    this.info;
  }
}

mojo.internal.Union(
    BitrateSpec.$, 'Bitrate',
    {
      'constant': {
        'ordinal': 0,
        'type': ConstantBitrateSpec.$,
      },
      'variable': {
        'ordinal': 1,
        'type': VariableBitrateSpec.$,
      },
      'external': {
        'ordinal': 2,
        'type': ExternalBitrateSpec.$,
      },
    });

/**
 * @typedef { {
 *   constant: (!ConstantBitrate|undefined),
 *   variable: (!VariableBitrate|undefined),
 *   external: (!ExternalBitrate|undefined),
 * } }
 */
export const Bitrate = {};
mojo.internal.Union(
    OptionalMetadataSpec.$, 'OptionalMetadata',
    {
      'drop': {
        'ordinal': 0,
        'type': DropFrameMetadataSpec.$,
      },
      'h264': {
        'ordinal': 1,
        'type': H264MetadataSpec.$,
      },
      'vp8': {
        'ordinal': 2,
        'type': Vp8MetadataSpec.$,
      },
      'vp9': {
        'ordinal': 3,
        'type': Vp9MetadataSpec.$,
      },
    });

/**
 * @typedef { {
 *   drop: (!DropFrameMetadata|undefined),
 *   h264: (!H264Metadata|undefined),
 *   vp8: (!Vp8Metadata|undefined),
 *   vp9: (!Vp9Metadata|undefined),
 * } }
 */
export const OptionalMetadata = {};
