// media/mojo/mojom/watch_time_recorder.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  AudioCodec as media_mojom_AudioCodec,
  AudioCodecSpec as media_mojom_AudioCodecSpec,
  AudioCodecProfile as media_mojom_AudioCodecProfile,
  AudioCodecProfileSpec as media_mojom_AudioCodecProfileSpec,
  AudioDecoderType as media_mojom_AudioDecoderType,
  AudioDecoderTypeSpec as media_mojom_AudioDecoderTypeSpec,
  DemuxerType as media_mojom_DemuxerType,
  DemuxerTypeSpec as media_mojom_DemuxerTypeSpec,
  EncryptionScheme as media_mojom_EncryptionScheme,
  EncryptionSchemeSpec as media_mojom_EncryptionSchemeSpec,
  MediaStreamType as media_mojom_MediaStreamType,
  MediaStreamTypeSpec as media_mojom_MediaStreamTypeSpec,
  RendererType as media_mojom_RendererType,
  RendererTypeSpec as media_mojom_RendererTypeSpec,
  VideoCodec as media_mojom_VideoCodec,
  VideoCodecSpec as media_mojom_VideoCodecSpec,
  VideoCodecProfile as media_mojom_VideoCodecProfile,
  VideoCodecProfileSpec as media_mojom_VideoCodecProfileSpec,
  VideoDecoderType as media_mojom_VideoDecoderType,
  VideoDecoderTypeSpec as media_mojom_VideoDecoderTypeSpec,
  WatchTimeKey as media_mojom_WatchTimeKey,
  WatchTimeKeySpec as media_mojom_WatchTimeKeySpec,
  PipelineStatus as media_mojom_PipelineStatus,
  PipelineStatusSpec as media_mojom_PipelineStatusSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WatchTimeRecorderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.WatchTimeRecorder', scope);
  }
}

/** @interface */
export class WatchTimeRecorderInterface {
  
  /**
   * @param { !media_mojom_WatchTimeKey } key
   * @param { !mojoBase_mojom_TimeDelta } watchTime
   */

  recordWatchTime(key, watchTime) {}
  
  /**
   * @param { !Array<!media_mojom_WatchTimeKey> } watchTimeKeys
   */

  finalizeWatchTime(watchTimeKeys) {}
  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onError(status) {}
  
  /**
   * @param { !SecondaryPlaybackProperties } secondaryProperties
   */

  updateSecondaryProperties(secondaryProperties) {}
  
  /**
   * @param { !boolean } value
   */

  setAutoplayInitiated(value) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } duration
   */

  onDurationChanged(duration) {}
  
  /**
   * @param { !number } framesDecoded
   * @param { !number } framesDropped
   */

  updateVideoDecodeStats(framesDecoded, framesDropped) {}
  
  /**
   * @param { !number } totalCount
   */

  updateUnderflowCount(totalCount) {}
  
  /**
   * @param { !number } totalCompletedCount
   * @param { !mojoBase_mojom_TimeDelta } totalDuration
   */

  updateUnderflowDuration(totalCompletedCount, totalDuration) {}
}

/**
 * @implements { WatchTimeRecorderInterface }
 */
export class WatchTimeRecorderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WatchTimeRecorderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WatchTimeRecorderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WatchTimeRecorderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_WatchTimeKey } key
   * @param { !mojoBase_mojom_TimeDelta } watchTime
   */

  recordWatchTime(
      key,
      watchTime) {
    this.proxy.sendMessage(
        0,
        WatchTimeRecorder_RecordWatchTime_ParamsSpec.$,
        null,
        [
          key,
          watchTime
        ],
        false);
  }

  
  /**
   * @param { !Array<!media_mojom_WatchTimeKey> } watchTimeKeys
   */

  finalizeWatchTime(
      watchTimeKeys) {
    this.proxy.sendMessage(
        1,
        WatchTimeRecorder_FinalizeWatchTime_ParamsSpec.$,
        null,
        [
          watchTimeKeys
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onError(
      status) {
    this.proxy.sendMessage(
        2,
        WatchTimeRecorder_OnError_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !SecondaryPlaybackProperties } secondaryProperties
   */

  updateSecondaryProperties(
      secondaryProperties) {
    this.proxy.sendMessage(
        3,
        WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec.$,
        null,
        [
          secondaryProperties
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  setAutoplayInitiated(
      value) {
    this.proxy.sendMessage(
        4,
        WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } duration
   */

  onDurationChanged(
      duration) {
    this.proxy.sendMessage(
        5,
        WatchTimeRecorder_OnDurationChanged_ParamsSpec.$,
        null,
        [
          duration
        ],
        false);
  }

  
  /**
   * @param { !number } framesDecoded
   * @param { !number } framesDropped
   */

  updateVideoDecodeStats(
      framesDecoded,
      framesDropped) {
    this.proxy.sendMessage(
        6,
        WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec.$,
        null,
        [
          framesDecoded,
          framesDropped
        ],
        false);
  }

  
  /**
   * @param { !number } totalCount
   */

  updateUnderflowCount(
      totalCount) {
    this.proxy.sendMessage(
        7,
        WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec.$,
        null,
        [
          totalCount
        ],
        false);
  }

  
  /**
   * @param { !number } totalCompletedCount
   * @param { !mojoBase_mojom_TimeDelta } totalDuration
   */

  updateUnderflowDuration(
      totalCompletedCount,
      totalDuration) {
    this.proxy.sendMessage(
        8,
        WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec.$,
        null,
        [
          totalCompletedCount,
          totalDuration
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WatchTimeRecorder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WatchTimeRecorderReceiver {
  /**
   * @param {!WatchTimeRecorderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WatchTimeRecorderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WatchTimeRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WatchTimeRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WatchTimeRecorder_RecordWatchTime_ParamsSpec.$,
        null,
        impl.recordWatchTime.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WatchTimeRecorder_FinalizeWatchTime_ParamsSpec.$,
        null,
        impl.finalizeWatchTime.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WatchTimeRecorder_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec.$,
        null,
        impl.updateSecondaryProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec.$,
        null,
        impl.setAutoplayInitiated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WatchTimeRecorder_OnDurationChanged_ParamsSpec.$,
        null,
        impl.onDurationChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec.$,
        null,
        impl.updateVideoDecodeStats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec.$,
        null,
        impl.updateUnderflowCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec.$,
        null,
        impl.updateUnderflowDuration.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WatchTimeRecorder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.WatchTimeRecorder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WatchTimeRecorderRemote}
   */
  static getRemote() {
    let remote = new WatchTimeRecorderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WatchTimeRecorder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WatchTimeRecorderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WatchTimeRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WatchTimeRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recordWatchTime =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WatchTimeRecorder_RecordWatchTime_ParamsSpec.$,
        null,
        this.recordWatchTime.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.finalizeWatchTime =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WatchTimeRecorder_FinalizeWatchTime_ParamsSpec.$,
        null,
        this.finalizeWatchTime.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WatchTimeRecorder_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateSecondaryProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec.$,
        null,
        this.updateSecondaryProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAutoplayInitiated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec.$,
        null,
        this.setAutoplayInitiated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDurationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WatchTimeRecorder_OnDurationChanged_ParamsSpec.$,
        null,
        this.onDurationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateVideoDecodeStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec.$,
        null,
        this.updateVideoDecodeStats.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUnderflowCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec.$,
        null,
        this.updateUnderflowCount.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUnderflowDuration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec.$,
        null,
        this.updateUnderflowDuration.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackPropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SecondaryPlaybackPropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_RecordWatchTime_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_FinalizeWatchTime_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_OnDurationChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PlaybackPropertiesSpec.$,
    'PlaybackProperties',
    [
      mojo.internal.StructField(
        'hasAudio', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasVideo', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isBackground', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isMuted', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isEme', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isEmbeddedMediaExperience', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaStreamType', 4,
        0,
        media_mojom_MediaStreamTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rendererType', 8,
        0,
        media_mojom_RendererTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'demuxerType', 12,
        0,
        media_mojom_DemuxerTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PlaybackProperties {
  constructor() {
    /** @type { !boolean } */
    this.hasAudio;
    /** @type { !boolean } */
    this.hasVideo;
    /** @type { !boolean } */
    this.isBackground;
    /** @type { !boolean } */
    this.isMuted;
    /** @type { !boolean } */
    this.isEme;
    /** @type { !boolean } */
    this.isEmbeddedMediaExperience;
    /** @type { !media_mojom_MediaStreamType } */
    this.mediaStreamType;
    /** @type { !media_mojom_RendererType } */
    this.rendererType;
    /** @type { !media_mojom_DemuxerType } */
    this.demuxerType;
  }
}



mojo.internal.Struct(
    SecondaryPlaybackPropertiesSpec.$,
    'SecondaryPlaybackProperties',
    [
      mojo.internal.StructField(
        'audioCodec', 0,
        0,
        media_mojom_AudioCodecSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoCodec', 4,
        0,
        media_mojom_VideoCodecSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioCodecProfile', 8,
        0,
        media_mojom_AudioCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoCodecProfile', 12,
        0,
        media_mojom_VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioDecoder', 16,
        0,
        media_mojom_AudioDecoderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoDecoder', 20,
        0,
        media_mojom_VideoDecoderTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioEncryptionScheme', 24,
        0,
        media_mojom_EncryptionSchemeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoEncryptionScheme', 28,
        0,
        media_mojom_EncryptionSchemeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'naturalSize', 32,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class SecondaryPlaybackProperties {
  constructor() {
    /** @type { !media_mojom_AudioCodec } */
    this.audioCodec;
    /** @type { !media_mojom_VideoCodec } */
    this.videoCodec;
    /** @type { !media_mojom_AudioCodecProfile } */
    this.audioCodecProfile;
    /** @type { !media_mojom_VideoCodecProfile } */
    this.videoCodecProfile;
    /** @type { !media_mojom_AudioDecoderType } */
    this.audioDecoder;
    /** @type { !media_mojom_VideoDecoderType } */
    this.videoDecoder;
    /** @type { !media_mojom_EncryptionScheme } */
    this.audioEncryptionScheme;
    /** @type { !media_mojom_EncryptionScheme } */
    this.videoEncryptionScheme;
    /** @type { !gfx_mojom_Size } */
    this.naturalSize;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_RecordWatchTime_ParamsSpec.$,
    'WatchTimeRecorder_RecordWatchTime_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        media_mojom_WatchTimeKeySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'watchTime', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WatchTimeRecorder_RecordWatchTime_Params {
  constructor() {
    /** @type { !media_mojom_WatchTimeKey } */
    this.key;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.watchTime;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_FinalizeWatchTime_ParamsSpec.$,
    'WatchTimeRecorder_FinalizeWatchTime_Params',
    [
      mojo.internal.StructField(
        'watchTimeKeys', 0,
        0,
        mojo.internal.Array(media_mojom_WatchTimeKeySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WatchTimeRecorder_FinalizeWatchTime_Params {
  constructor() {
    /** @type { !Array<!media_mojom_WatchTimeKey> } */
    this.watchTimeKeys;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_OnError_ParamsSpec.$,
    'WatchTimeRecorder_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_PipelineStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WatchTimeRecorder_OnError_Params {
  constructor() {
    /** @type { !media_mojom_PipelineStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec.$,
    'WatchTimeRecorder_UpdateSecondaryProperties_Params',
    [
      mojo.internal.StructField(
        'secondaryProperties', 0,
        0,
        SecondaryPlaybackPropertiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WatchTimeRecorder_UpdateSecondaryProperties_Params {
  constructor() {
    /** @type { !SecondaryPlaybackProperties } */
    this.secondaryProperties;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec.$,
    'WatchTimeRecorder_SetAutoplayInitiated_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WatchTimeRecorder_SetAutoplayInitiated_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_OnDurationChanged_ParamsSpec.$,
    'WatchTimeRecorder_OnDurationChanged_Params',
    [
      mojo.internal.StructField(
        'duration', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WatchTimeRecorder_OnDurationChanged_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.duration;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec.$,
    'WatchTimeRecorder_UpdateVideoDecodeStats_Params',
    [
      mojo.internal.StructField(
        'framesDecoded', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'framesDropped', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WatchTimeRecorder_UpdateVideoDecodeStats_Params {
  constructor() {
    /** @type { !number } */
    this.framesDecoded;
    /** @type { !number } */
    this.framesDropped;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec.$,
    'WatchTimeRecorder_UpdateUnderflowCount_Params',
    [
      mojo.internal.StructField(
        'totalCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WatchTimeRecorder_UpdateUnderflowCount_Params {
  constructor() {
    /** @type { !number } */
    this.totalCount;
  }
}



mojo.internal.Struct(
    WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec.$,
    'WatchTimeRecorder_UpdateUnderflowDuration_Params',
    [
      mojo.internal.StructField(
        'totalCompletedCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'totalDuration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WatchTimeRecorder_UpdateUnderflowDuration_Params {
  constructor() {
    /** @type { !number } */
    this.totalCompletedCount;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.totalDuration;
  }
}

