// services/accessibility/public/mojom/automation.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/accessibility/public/mojom/automation.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');
  var ax_action_data$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_action_data.mojom', '../../../../ui/accessibility/mojom/ax_action_data.mojom.js');
  }
  var ax_event$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_event.mojom', '../../../../ui/accessibility/mojom/ax_event.mojom.js');
  }
  var ax_relative_bounds$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_relative_bounds.mojom', '../../../../ui/accessibility/mojom/ax_relative_bounds.mojom.js');
  }
  var ax_tree_id$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_id.mojom', '../../../../ui/accessibility/mojom/ax_tree_id.mojom.js');
  }
  var ax_tree_update$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_update.mojom', '../../../../ui/accessibility/mojom/ax_tree_update.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function Automation_DispatchTreeDestroyedEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Automation_DispatchTreeDestroyedEvent_Params.prototype.initDefaults_ = function() {
    this.treeId = null;
  };
  Automation_DispatchTreeDestroyedEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Automation_DispatchTreeDestroyedEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Automation_DispatchTreeDestroyedEvent_Params.treeId
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ax_tree_id$.AXTreeID, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Automation_DispatchTreeDestroyedEvent_Params.encodedSize = codec.kStructHeaderSize + 16;

  Automation_DispatchTreeDestroyedEvent_Params.decode = function(decoder) {
    var packed;
    var val = new Automation_DispatchTreeDestroyedEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.treeId =
        decoder.decodeStruct(ax_tree_id$.AXTreeID);
    return val;
  };

  Automation_DispatchTreeDestroyedEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Automation_DispatchTreeDestroyedEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ax_tree_id$.AXTreeID, val.treeId);
  };
  function Automation_DispatchActionResult_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Automation_DispatchActionResult_Params.prototype.initDefaults_ = function() {
    this.data = null;
    this.result = false;
  };
  Automation_DispatchActionResult_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Automation_DispatchActionResult_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Automation_DispatchActionResult_Params.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ax_action_data$.AXActionData, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Automation_DispatchActionResult_Params.encodedSize = codec.kStructHeaderSize + 16;

  Automation_DispatchActionResult_Params.decode = function(decoder) {
    var packed;
    var val = new Automation_DispatchActionResult_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(ax_action_data$.AXActionData);
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Automation_DispatchActionResult_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Automation_DispatchActionResult_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ax_action_data$.AXActionData, val.data);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Automation_DispatchAccessibilityEvents_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Automation_DispatchAccessibilityEvents_Params.prototype.initDefaults_ = function() {
    this.treeId = null;
    this.updates = null;
    this.mouseLocation = null;
    this.events = null;
  };
  Automation_DispatchAccessibilityEvents_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Automation_DispatchAccessibilityEvents_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Automation_DispatchAccessibilityEvents_Params.treeId
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ax_tree_id$.AXTreeID, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Automation_DispatchAccessibilityEvents_Params.updates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(ax_tree_update$.AXTreeUpdate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Automation_DispatchAccessibilityEvents_Params.mouseLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Automation_DispatchAccessibilityEvents_Params.events
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(ax_event$.AXEvent), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Automation_DispatchAccessibilityEvents_Params.encodedSize = codec.kStructHeaderSize + 40;

  Automation_DispatchAccessibilityEvents_Params.decode = function(decoder) {
    var packed;
    var val = new Automation_DispatchAccessibilityEvents_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.treeId =
        decoder.decodeStruct(ax_tree_id$.AXTreeID);
    val.updates =
        decoder.decodeArrayPointer(new codec.PointerTo(ax_tree_update$.AXTreeUpdate));
    val.mouseLocation =
        decoder.decodeStructPointer(geometry$.Point);
    val.events =
        decoder.decodeArrayPointer(new codec.PointerTo(ax_event$.AXEvent));
    return val;
  };

  Automation_DispatchAccessibilityEvents_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Automation_DispatchAccessibilityEvents_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ax_tree_id$.AXTreeID, val.treeId);
    encoder.encodeArrayPointer(new codec.PointerTo(ax_tree_update$.AXTreeUpdate), val.updates);
    encoder.encodeStructPointer(geometry$.Point, val.mouseLocation);
    encoder.encodeArrayPointer(new codec.PointerTo(ax_event$.AXEvent), val.events);
  };
  function Automation_DispatchAccessibilityLocationChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Automation_DispatchAccessibilityLocationChange_Params.prototype.initDefaults_ = function() {
    this.treeId = null;
    this.nodeId = 0;
    this.bounds = null;
  };
  Automation_DispatchAccessibilityLocationChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Automation_DispatchAccessibilityLocationChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Automation_DispatchAccessibilityLocationChange_Params.treeId
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ax_tree_id$.AXTreeID, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Automation_DispatchAccessibilityLocationChange_Params.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ax_relative_bounds$.AXRelativeBounds, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Automation_DispatchAccessibilityLocationChange_Params.encodedSize = codec.kStructHeaderSize + 32;

  Automation_DispatchAccessibilityLocationChange_Params.decode = function(decoder) {
    var packed;
    var val = new Automation_DispatchAccessibilityLocationChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.treeId =
        decoder.decodeStruct(ax_tree_id$.AXTreeID);
    val.nodeId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.bounds =
        decoder.decodeStructPointer(ax_relative_bounds$.AXRelativeBounds);
    return val;
  };

  Automation_DispatchAccessibilityLocationChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Automation_DispatchAccessibilityLocationChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ax_tree_id$.AXTreeID, val.treeId);
    encoder.encodeStruct(codec.Int32, val.nodeId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ax_relative_bounds$.AXRelativeBounds, val.bounds);
  };
  function Automation_DispatchAccessibilityScrollChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Automation_DispatchAccessibilityScrollChange_Params.prototype.initDefaults_ = function() {
    this.treeId = null;
    this.nodeId = 0;
    this.scrollX = 0;
    this.scrollY = 0;
  };
  Automation_DispatchAccessibilityScrollChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Automation_DispatchAccessibilityScrollChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Automation_DispatchAccessibilityScrollChange_Params.treeId
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ax_tree_id$.AXTreeID, false);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  Automation_DispatchAccessibilityScrollChange_Params.encodedSize = codec.kStructHeaderSize + 32;

  Automation_DispatchAccessibilityScrollChange_Params.decode = function(decoder) {
    var packed;
    var val = new Automation_DispatchAccessibilityScrollChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.treeId =
        decoder.decodeStruct(ax_tree_id$.AXTreeID);
    val.nodeId =
        decoder.decodeStruct(codec.Int32);
    val.scrollX =
        decoder.decodeStruct(codec.Int32);
    val.scrollY =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Automation_DispatchAccessibilityScrollChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Automation_DispatchAccessibilityScrollChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ax_tree_id$.AXTreeID, val.treeId);
    encoder.encodeStruct(codec.Int32, val.nodeId);
    encoder.encodeStruct(codec.Int32, val.scrollX);
    encoder.encodeStruct(codec.Int32, val.scrollY);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kAutomation_DispatchTreeDestroyedEvent_Name = 0;
  var kAutomation_DispatchActionResult_Name = 1;
  var kAutomation_DispatchAccessibilityEvents_Name = 2;
  var kAutomation_DispatchAccessibilityLocationChange_Name = 3;
  var kAutomation_DispatchAccessibilityScrollChange_Name = 4;

  function AutomationPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Automation,
                                                   handleOrPtrInfo);
  }

  function AutomationAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Automation, associatedInterfacePtrInfo);
  }

  AutomationAssociatedPtr.prototype =
      Object.create(AutomationPtr.prototype);
  AutomationAssociatedPtr.prototype.constructor =
      AutomationAssociatedPtr;

  function AutomationProxy(receiver) {
    this.receiver_ = receiver;
  }
  AutomationPtr.prototype.dispatchTreeDestroyedEvent = function() {
    return AutomationProxy.prototype.dispatchTreeDestroyedEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  AutomationProxy.prototype.dispatchTreeDestroyedEvent = function(treeId) {
    var params_ = new Automation_DispatchTreeDestroyedEvent_Params();
    params_.treeId = treeId;
    var builder = new codec.MessageV0Builder(
        kAutomation_DispatchTreeDestroyedEvent_Name,
        codec.align(Automation_DispatchTreeDestroyedEvent_Params.encodedSize));
    builder.encodeStruct(Automation_DispatchTreeDestroyedEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AutomationPtr.prototype.dispatchActionResult = function() {
    return AutomationProxy.prototype.dispatchActionResult
        .apply(this.ptr.getProxy(), arguments);
  };

  AutomationProxy.prototype.dispatchActionResult = function(data, result) {
    var params_ = new Automation_DispatchActionResult_Params();
    params_.data = data;
    params_.result = result;
    var builder = new codec.MessageV0Builder(
        kAutomation_DispatchActionResult_Name,
        codec.align(Automation_DispatchActionResult_Params.encodedSize));
    builder.encodeStruct(Automation_DispatchActionResult_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AutomationPtr.prototype.dispatchAccessibilityEvents = function() {
    return AutomationProxy.prototype.dispatchAccessibilityEvents
        .apply(this.ptr.getProxy(), arguments);
  };

  AutomationProxy.prototype.dispatchAccessibilityEvents = function(treeId, updates, mouseLocation, events) {
    var params_ = new Automation_DispatchAccessibilityEvents_Params();
    params_.treeId = treeId;
    params_.updates = updates;
    params_.mouseLocation = mouseLocation;
    params_.events = events;
    var builder = new codec.MessageV0Builder(
        kAutomation_DispatchAccessibilityEvents_Name,
        codec.align(Automation_DispatchAccessibilityEvents_Params.encodedSize));
    builder.encodeStruct(Automation_DispatchAccessibilityEvents_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AutomationPtr.prototype.dispatchAccessibilityLocationChange = function() {
    return AutomationProxy.prototype.dispatchAccessibilityLocationChange
        .apply(this.ptr.getProxy(), arguments);
  };

  AutomationProxy.prototype.dispatchAccessibilityLocationChange = function(treeId, nodeId, bounds) {
    var params_ = new Automation_DispatchAccessibilityLocationChange_Params();
    params_.treeId = treeId;
    params_.nodeId = nodeId;
    params_.bounds = bounds;
    var builder = new codec.MessageV0Builder(
        kAutomation_DispatchAccessibilityLocationChange_Name,
        codec.align(Automation_DispatchAccessibilityLocationChange_Params.encodedSize));
    builder.encodeStruct(Automation_DispatchAccessibilityLocationChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AutomationPtr.prototype.dispatchAccessibilityScrollChange = function() {
    return AutomationProxy.prototype.dispatchAccessibilityScrollChange
        .apply(this.ptr.getProxy(), arguments);
  };

  AutomationProxy.prototype.dispatchAccessibilityScrollChange = function(treeId, nodeId, scrollX, scrollY) {
    var params_ = new Automation_DispatchAccessibilityScrollChange_Params();
    params_.treeId = treeId;
    params_.nodeId = nodeId;
    params_.scrollX = scrollX;
    params_.scrollY = scrollY;
    var builder = new codec.MessageV0Builder(
        kAutomation_DispatchAccessibilityScrollChange_Name,
        codec.align(Automation_DispatchAccessibilityScrollChange_Params.encodedSize));
    builder.encodeStruct(Automation_DispatchAccessibilityScrollChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AutomationStub(delegate) {
    this.delegate_ = delegate;
  }
  AutomationStub.prototype.dispatchTreeDestroyedEvent = function(treeId) {
    return this.delegate_ && this.delegate_.dispatchTreeDestroyedEvent && this.delegate_.dispatchTreeDestroyedEvent(treeId);
  }
  AutomationStub.prototype.dispatchActionResult = function(data, result) {
    return this.delegate_ && this.delegate_.dispatchActionResult && this.delegate_.dispatchActionResult(data, result);
  }
  AutomationStub.prototype.dispatchAccessibilityEvents = function(treeId, updates, mouseLocation, events) {
    return this.delegate_ && this.delegate_.dispatchAccessibilityEvents && this.delegate_.dispatchAccessibilityEvents(treeId, updates, mouseLocation, events);
  }
  AutomationStub.prototype.dispatchAccessibilityLocationChange = function(treeId, nodeId, bounds) {
    return this.delegate_ && this.delegate_.dispatchAccessibilityLocationChange && this.delegate_.dispatchAccessibilityLocationChange(treeId, nodeId, bounds);
  }
  AutomationStub.prototype.dispatchAccessibilityScrollChange = function(treeId, nodeId, scrollX, scrollY) {
    return this.delegate_ && this.delegate_.dispatchAccessibilityScrollChange && this.delegate_.dispatchAccessibilityScrollChange(treeId, nodeId, scrollX, scrollY);
  }

  AutomationStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAutomation_DispatchTreeDestroyedEvent_Name:
      var params = reader.decodeStruct(Automation_DispatchTreeDestroyedEvent_Params);
      this.dispatchTreeDestroyedEvent(params.treeId);
      return true;
    case kAutomation_DispatchActionResult_Name:
      var params = reader.decodeStruct(Automation_DispatchActionResult_Params);
      this.dispatchActionResult(params.data, params.result);
      return true;
    case kAutomation_DispatchAccessibilityEvents_Name:
      var params = reader.decodeStruct(Automation_DispatchAccessibilityEvents_Params);
      this.dispatchAccessibilityEvents(params.treeId, params.updates, params.mouseLocation, params.events);
      return true;
    case kAutomation_DispatchAccessibilityLocationChange_Name:
      var params = reader.decodeStruct(Automation_DispatchAccessibilityLocationChange_Params);
      this.dispatchAccessibilityLocationChange(params.treeId, params.nodeId, params.bounds);
      return true;
    case kAutomation_DispatchAccessibilityScrollChange_Name:
      var params = reader.decodeStruct(Automation_DispatchAccessibilityScrollChange_Params);
      this.dispatchAccessibilityScrollChange(params.treeId, params.nodeId, params.scrollX, params.scrollY);
      return true;
    default:
      return false;
    }
  };

  AutomationStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAutomationRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAutomation_DispatchTreeDestroyedEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Automation_DispatchTreeDestroyedEvent_Params;
      break;
      case kAutomation_DispatchActionResult_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Automation_DispatchActionResult_Params;
      break;
      case kAutomation_DispatchAccessibilityEvents_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Automation_DispatchAccessibilityEvents_Params;
      break;
      case kAutomation_DispatchAccessibilityLocationChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Automation_DispatchAccessibilityLocationChange_Params;
      break;
      case kAutomation_DispatchAccessibilityScrollChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Automation_DispatchAccessibilityScrollChange_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAutomationResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var Automation = {
    name: 'ax.mojom.Automation',
    kVersion: 0,
    ptrClass: AutomationPtr,
    proxyClass: AutomationProxy,
    stubClass: AutomationStub,
    validateRequest: validateAutomationRequest,
    validateResponse: null,
  };
  AutomationStub.prototype.validator = validateAutomationRequest;
  AutomationProxy.prototype.validator = null;
  exports.Automation = Automation;
  exports.AutomationPtr = AutomationPtr;
  exports.AutomationAssociatedPtr = AutomationAssociatedPtr;
})();