// services/accessibility/public/mojom/automation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  AXActionData as ax_mojom_AXActionData,
  AXActionDataSpec as ax_mojom_AXActionDataSpec
} from '../../../../ui/accessibility/mojom/ax_action_data.mojom.m.js';

import {
  AXEvent as ax_mojom_AXEvent,
  AXEventSpec as ax_mojom_AXEventSpec
} from '../../../../ui/accessibility/mojom/ax_event.mojom.m.js';

import {
  AXRelativeBounds as ax_mojom_AXRelativeBounds,
  AXRelativeBoundsSpec as ax_mojom_AXRelativeBoundsSpec
} from '../../../../ui/accessibility/mojom/ax_relative_bounds.mojom.m.js';

import {
  AXTreeID as ax_mojom_AXTreeID,
  AXTreeIDSpec as ax_mojom_AXTreeIDSpec
} from '../../../../ui/accessibility/mojom/ax_tree_id.mojom.m.js';

import {
  AXTreeUpdate as ax_mojom_AXTreeUpdate,
  AXTreeUpdateSpec as ax_mojom_AXTreeUpdateSpec
} from '../../../../ui/accessibility/mojom/ax_tree_update.mojom.m.js';

import {
  Point as gfx_mojom_Point,
  PointSpec as gfx_mojom_PointSpec
} from '../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AutomationPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ax.mojom.Automation', scope);
  }
}

/** @interface */
export class AutomationInterface {
  
  /**
   * @param { !ax_mojom_AXTreeID } treeId
   */

  dispatchTreeDestroyedEvent(treeId) {}
  
  /**
   * @param { !ax_mojom_AXActionData } data
   * @param { !boolean } result
   */

  dispatchActionResult(data, result) {}
  
  /**
   * @param { !ax_mojom_AXTreeID } treeId
   * @param { !Array<!ax_mojom_AXTreeUpdate> } updates
   * @param { !gfx_mojom_Point } mouseLocation
   * @param { !Array<!ax_mojom_AXEvent> } events
   */

  dispatchAccessibilityEvents(treeId, updates, mouseLocation, events) {}
  
  /**
   * @param { !ax_mojom_AXTreeID } treeId
   * @param { !number } nodeId
   * @param { !ax_mojom_AXRelativeBounds } bounds
   */

  dispatchAccessibilityLocationChange(treeId, nodeId, bounds) {}
  
  /**
   * @param { !ax_mojom_AXTreeID } treeId
   * @param { !number } nodeId
   * @param { !number } scrollX
   * @param { !number } scrollY
   */

  dispatchAccessibilityScrollChange(treeId, nodeId, scrollX, scrollY) {}
}

/**
 * @implements { AutomationInterface }
 */
export class AutomationRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AutomationPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AutomationPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AutomationPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ax_mojom_AXTreeID } treeId
   */

  dispatchTreeDestroyedEvent(
      treeId) {
    this.proxy.sendMessage(
        0,
        Automation_DispatchTreeDestroyedEvent_ParamsSpec.$,
        null,
        [
          treeId
        ],
        false);
  }

  
  /**
   * @param { !ax_mojom_AXActionData } data
   * @param { !boolean } result
   */

  dispatchActionResult(
      data,
      result) {
    this.proxy.sendMessage(
        1,
        Automation_DispatchActionResult_ParamsSpec.$,
        null,
        [
          data,
          result
        ],
        false);
  }

  
  /**
   * @param { !ax_mojom_AXTreeID } treeId
   * @param { !Array<!ax_mojom_AXTreeUpdate> } updates
   * @param { !gfx_mojom_Point } mouseLocation
   * @param { !Array<!ax_mojom_AXEvent> } events
   */

  dispatchAccessibilityEvents(
      treeId,
      updates,
      mouseLocation,
      events) {
    this.proxy.sendMessage(
        2,
        Automation_DispatchAccessibilityEvents_ParamsSpec.$,
        null,
        [
          treeId,
          updates,
          mouseLocation,
          events
        ],
        false);
  }

  
  /**
   * @param { !ax_mojom_AXTreeID } treeId
   * @param { !number } nodeId
   * @param { !ax_mojom_AXRelativeBounds } bounds
   */

  dispatchAccessibilityLocationChange(
      treeId,
      nodeId,
      bounds) {
    this.proxy.sendMessage(
        3,
        Automation_DispatchAccessibilityLocationChange_ParamsSpec.$,
        null,
        [
          treeId,
          nodeId,
          bounds
        ],
        false);
  }

  
  /**
   * @param { !ax_mojom_AXTreeID } treeId
   * @param { !number } nodeId
   * @param { !number } scrollX
   * @param { !number } scrollY
   */

  dispatchAccessibilityScrollChange(
      treeId,
      nodeId,
      scrollX,
      scrollY) {
    this.proxy.sendMessage(
        4,
        Automation_DispatchAccessibilityScrollChange_ParamsSpec.$,
        null,
        [
          treeId,
          nodeId,
          scrollX,
          scrollY
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Automation
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AutomationReceiver {
  /**
   * @param {!AutomationInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AutomationRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AutomationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AutomationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Automation_DispatchTreeDestroyedEvent_ParamsSpec.$,
        null,
        impl.dispatchTreeDestroyedEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Automation_DispatchActionResult_ParamsSpec.$,
        null,
        impl.dispatchActionResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Automation_DispatchAccessibilityEvents_ParamsSpec.$,
        null,
        impl.dispatchAccessibilityEvents.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Automation_DispatchAccessibilityLocationChange_ParamsSpec.$,
        null,
        impl.dispatchAccessibilityLocationChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Automation_DispatchAccessibilityScrollChange_ParamsSpec.$,
        null,
        impl.dispatchAccessibilityScrollChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Automation {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ax.mojom.Automation";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AutomationRemote}
   */
  static getRemote() {
    let remote = new AutomationRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Automation
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AutomationCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AutomationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AutomationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchTreeDestroyedEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Automation_DispatchTreeDestroyedEvent_ParamsSpec.$,
        null,
        this.dispatchTreeDestroyedEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchActionResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Automation_DispatchActionResult_ParamsSpec.$,
        null,
        this.dispatchActionResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchAccessibilityEvents =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Automation_DispatchAccessibilityEvents_ParamsSpec.$,
        null,
        this.dispatchAccessibilityEvents.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchAccessibilityLocationChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Automation_DispatchAccessibilityLocationChange_ParamsSpec.$,
        null,
        this.dispatchAccessibilityLocationChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchAccessibilityScrollChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Automation_DispatchAccessibilityScrollChange_ParamsSpec.$,
        null,
        this.dispatchAccessibilityScrollChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Automation_DispatchTreeDestroyedEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Automation_DispatchActionResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Automation_DispatchAccessibilityEvents_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Automation_DispatchAccessibilityLocationChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Automation_DispatchAccessibilityScrollChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    Automation_DispatchTreeDestroyedEvent_ParamsSpec.$,
    'Automation_DispatchTreeDestroyedEvent_Params',
    [
      mojo.internal.StructField(
        'treeId', 0,
        0,
        ax_mojom_AXTreeIDSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Automation_DispatchTreeDestroyedEvent_Params {
  constructor() {
    /** @type { !ax_mojom_AXTreeID } */
    this.treeId;
  }
}



mojo.internal.Struct(
    Automation_DispatchActionResult_ParamsSpec.$,
    'Automation_DispatchActionResult_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        ax_mojom_AXActionDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Automation_DispatchActionResult_Params {
  constructor() {
    /** @type { !ax_mojom_AXActionData } */
    this.data;
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    Automation_DispatchAccessibilityEvents_ParamsSpec.$,
    'Automation_DispatchAccessibilityEvents_Params',
    [
      mojo.internal.StructField(
        'treeId', 0,
        0,
        ax_mojom_AXTreeIDSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updates', 16,
        0,
        mojo.internal.Array(ax_mojom_AXTreeUpdateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mouseLocation', 24,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'events', 32,
        0,
        mojo.internal.Array(ax_mojom_AXEventSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class Automation_DispatchAccessibilityEvents_Params {
  constructor() {
    /** @type { !ax_mojom_AXTreeID } */
    this.treeId;
    /** @type { !Array<!ax_mojom_AXTreeUpdate> } */
    this.updates;
    /** @type { !gfx_mojom_Point } */
    this.mouseLocation;
    /** @type { !Array<!ax_mojom_AXEvent> } */
    this.events;
  }
}



mojo.internal.Struct(
    Automation_DispatchAccessibilityLocationChange_ParamsSpec.$,
    'Automation_DispatchAccessibilityLocationChange_Params',
    [
      mojo.internal.StructField(
        'treeId', 0,
        0,
        ax_mojom_AXTreeIDSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nodeId', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bounds', 24,
        0,
        ax_mojom_AXRelativeBoundsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class Automation_DispatchAccessibilityLocationChange_Params {
  constructor() {
    /** @type { !ax_mojom_AXTreeID } */
    this.treeId;
    /** @type { !number } */
    this.nodeId;
    /** @type { !ax_mojom_AXRelativeBounds } */
    this.bounds;
  }
}



mojo.internal.Struct(
    Automation_DispatchAccessibilityScrollChange_ParamsSpec.$,
    'Automation_DispatchAccessibilityScrollChange_Params',
    [
      mojo.internal.StructField(
        'treeId', 0,
        0,
        ax_mojom_AXTreeIDSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nodeId', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollX', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollY', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class Automation_DispatchAccessibilityScrollChange_Params {
  constructor() {
    /** @type { !ax_mojom_AXTreeID } */
    this.treeId;
    /** @type { !number } */
    this.nodeId;
    /** @type { !number } */
    this.scrollX;
    /** @type { !number } */
    this.scrollY;
  }
}

