// services/device/public/mojom/nfc_provider.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('device.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.NFCProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.NFCProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.NFCProviderInterface }
 */
device.mojom.NFCProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.NFCProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.NFCProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.NFCProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } hostId
   * @param { !device.mojom.NFCPendingReceiver } receiver
   */

  getNFCForHost(
      hostId,
      receiver) {
    this.proxy.sendMessage(
        0,
        device.mojom.NFCProvider_GetNFCForHost_ParamsSpec.$,
        null,
        [
          hostId,
          receiver
        ],
        false);
  }

  
  /**
   */

  suspendNFCOperations() {
    this.proxy.sendMessage(
        1,
        device.mojom.NFCProvider_SuspendNFCOperations_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resumeNFCOperations() {
    this.proxy.sendMessage(
        2,
        device.mojom.NFCProvider_ResumeNFCOperations_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NFCProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.NFCProviderReceiver = class {
  /**
   * @param {!device.mojom.NFCProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.NFCProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.NFCProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.NFCProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.NFCProvider_GetNFCForHost_ParamsSpec.$,
        null,
        impl.getNFCForHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.NFCProvider_SuspendNFCOperations_ParamsSpec.$,
        null,
        impl.suspendNFCOperations.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.NFCProvider_ResumeNFCOperations_ParamsSpec.$,
        null,
        impl.resumeNFCOperations.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.NFCProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.NFCProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.NFCProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.NFCProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NFCProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.NFCProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.NFCProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.NFCProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNFCForHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.NFCProvider_GetNFCForHost_ParamsSpec.$,
        null,
        this.getNFCForHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspendNFCOperations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.NFCProvider_SuspendNFCOperations_ParamsSpec.$,
        null,
        this.suspendNFCOperations.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resumeNFCOperations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.NFCProvider_ResumeNFCOperations_ParamsSpec.$,
        null,
        this.resumeNFCOperations.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFCProvider_GetNFCForHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFCProvider_SuspendNFCOperations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFCProvider_ResumeNFCOperations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.NFCProvider_GetNFCForHost_ParamsSpec.$,
    'NFCProvider_GetNFCForHost_Params',
    [
      mojo.internal.StructField(
        'hostId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 4,
        0,
        mojo.internal.InterfaceRequest(device.mojom.NFCPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.NFCProvider_GetNFCForHost_Params = class {
  constructor() {
    /** @export { !number } */
    this.hostId;
    /** @export { !device.mojom.NFCPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    device.mojom.NFCProvider_SuspendNFCOperations_ParamsSpec.$,
    'NFCProvider_SuspendNFCOperations_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.NFCProvider_SuspendNFCOperations_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.NFCProvider_ResumeNFCOperations_ParamsSpec.$,
    'NFCProvider_ResumeNFCOperations_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.NFCProvider_ResumeNFCOperations_Params = class {
  constructor() {
  }
};

