// services/device/public/mojom/power_monitor.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  BatteryPowerStatus as mojoBase_mojom_BatteryPowerStatus,
  BatteryPowerStatusSpec as mojoBase_mojom_BatteryPowerStatusSpec
} from '../../../../mojo/public/mojom/base/battery_power_status.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PowerMonitorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.PowerMonitor', scope);
  }
}

/** @interface */
export class PowerMonitorInterface {
  
  /**
   * @param { !PowerMonitorClientRemote } client
   */

  addClient(client) {}
}

/**
 * @implements { PowerMonitorInterface }
 */
export class PowerMonitorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PowerMonitorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PowerMonitorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PowerMonitorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PowerMonitorClientRemote } client
   */

  addClient(
      client) {
    this.proxy.sendMessage(
        0,
        PowerMonitor_AddClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PowerMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PowerMonitorReceiver {
  /**
   * @param {!PowerMonitorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PowerMonitorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PowerMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PowerMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PowerMonitor_AddClient_ParamsSpec.$,
        null,
        impl.addClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PowerMonitor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.PowerMonitor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PowerMonitorRemote}
   */
  static getRemote() {
    let remote = new PowerMonitorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PowerMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PowerMonitorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PowerMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PowerMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PowerMonitor_AddClient_ParamsSpec.$,
        null,
        this.addClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PowerMonitorClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.PowerMonitorClient', scope);
  }
}

/** @interface */
export class PowerMonitorClientInterface {
  
  /**
   * @param { !mojoBase_mojom_BatteryPowerStatus } batteryPowerStatus
   */

  powerStateChange(batteryPowerStatus) {}
  
  /**
   */

  suspend() {}
  
  /**
   */

  resume() {}
}

/**
 * @implements { PowerMonitorClientInterface }
 */
export class PowerMonitorClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PowerMonitorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PowerMonitorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PowerMonitorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_BatteryPowerStatus } batteryPowerStatus
   */

  powerStateChange(
      batteryPowerStatus) {
    this.proxy.sendMessage(
        0,
        PowerMonitorClient_PowerStateChange_ParamsSpec.$,
        null,
        [
          batteryPowerStatus
        ],
        false);
  }

  
  /**
   */

  suspend() {
    this.proxy.sendMessage(
        1,
        PowerMonitorClient_Suspend_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        2,
        PowerMonitorClient_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PowerMonitorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PowerMonitorClientReceiver {
  /**
   * @param {!PowerMonitorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PowerMonitorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PowerMonitorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PowerMonitorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PowerMonitorClient_PowerStateChange_ParamsSpec.$,
        null,
        impl.powerStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PowerMonitorClient_Suspend_ParamsSpec.$,
        null,
        impl.suspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PowerMonitorClient_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PowerMonitorClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.PowerMonitorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PowerMonitorClientRemote}
   */
  static getRemote() {
    let remote = new PowerMonitorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PowerMonitorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PowerMonitorClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PowerMonitorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PowerMonitorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.powerStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PowerMonitorClient_PowerStateChange_ParamsSpec.$,
        null,
        this.powerStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PowerMonitorClient_Suspend_ParamsSpec.$,
        null,
        this.suspend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PowerMonitorClient_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PowerMonitor_AddClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PowerMonitorClient_PowerStateChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PowerMonitorClient_Suspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PowerMonitorClient_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PowerMonitor_AddClient_ParamsSpec.$,
    'PowerMonitor_AddClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(PowerMonitorClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PowerMonitor_AddClient_Params {
  constructor() {
    /** @type { !PowerMonitorClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    PowerMonitorClient_PowerStateChange_ParamsSpec.$,
    'PowerMonitorClient_PowerStateChange_Params',
    [
      mojo.internal.StructField(
        'batteryPowerStatus', 0,
        0,
        mojoBase_mojom_BatteryPowerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PowerMonitorClient_PowerStateChange_Params {
  constructor() {
    /** @type { !mojoBase_mojom_BatteryPowerStatus } */
    this.batteryPowerStatus;
  }
}



mojo.internal.Struct(
    PowerMonitorClient_Suspend_ParamsSpec.$,
    'PowerMonitorClient_Suspend_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PowerMonitorClient_Suspend_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PowerMonitorClient_Resume_ParamsSpec.$,
    'PowerMonitorClient_Resume_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PowerMonitorClient_Resume_Params {
  constructor() {
  }
}

