// services/device/public/mojom/screen_orientation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ScreenOrientationLockResult as device_mojom_ScreenOrientationLockResult,
  ScreenOrientationLockResultSpec as device_mojom_ScreenOrientationLockResultSpec,
  ScreenOrientationLockType as device_mojom_ScreenOrientationLockType,
  ScreenOrientationLockTypeSpec as device_mojom_ScreenOrientationLockTypeSpec
} from './screen_orientation_lock_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ScreenOrientationPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.ScreenOrientation', scope);
  }
}

/** @interface */
export class ScreenOrientationInterface {
  
  /**
   * @param { !device_mojom_ScreenOrientationLockType } orientation
   * @return {!Promise<{
        result: !device_mojom_ScreenOrientationLockResult,
   *  }>}
   */

  lockOrientation(orientation) {}
  
  /**
   */

  unlockOrientation() {}
}

/**
 * @implements { ScreenOrientationInterface }
 */
export class ScreenOrientationRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ScreenOrientationPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ScreenOrientationPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ScreenOrientationPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_ScreenOrientationLockType } orientation
   * @return {!Promise<{
        result: !device_mojom_ScreenOrientationLockResult,
   *  }>}
   */

  lockOrientation(
      orientation) {
    return this.proxy.sendMessage(
        0,
        ScreenOrientation_LockOrientation_ParamsSpec.$,
        ScreenOrientation_LockOrientation_ResponseParamsSpec.$,
        [
          orientation
        ],
        false);
  }

  
  /**
   */

  unlockOrientation() {
    this.proxy.sendMessage(
        1,
        ScreenOrientation_UnlockOrientation_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ScreenOrientation
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ScreenOrientationReceiver {
  /**
   * @param {!ScreenOrientationInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ScreenOrientationRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ScreenOrientationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ScreenOrientationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ScreenOrientation_LockOrientation_ParamsSpec.$,
        ScreenOrientation_LockOrientation_ResponseParamsSpec.$,
        impl.lockOrientation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ScreenOrientation_UnlockOrientation_ParamsSpec.$,
        null,
        impl.unlockOrientation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ScreenOrientation {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.ScreenOrientation";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ScreenOrientationRemote}
   */
  static getRemote() {
    let remote = new ScreenOrientationRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ScreenOrientation
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ScreenOrientationCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ScreenOrientationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ScreenOrientationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.lockOrientation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ScreenOrientation_LockOrientation_ParamsSpec.$,
        ScreenOrientation_LockOrientation_ResponseParamsSpec.$,
        this.lockOrientation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unlockOrientation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ScreenOrientation_UnlockOrientation_ParamsSpec.$,
        null,
        this.unlockOrientation.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ScreenOrientationListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.ScreenOrientationListener', scope);
  }
}

/** @interface */
export class ScreenOrientationListenerInterface {
  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isAutoRotateEnabledByUser() {}
}

/**
 * @implements { ScreenOrientationListenerInterface }
 */
export class ScreenOrientationListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ScreenOrientationListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ScreenOrientationListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ScreenOrientationListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isAutoRotateEnabledByUser() {
    return this.proxy.sendMessage(
        0,
        ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec.$,
        ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ScreenOrientationListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ScreenOrientationListenerReceiver {
  /**
   * @param {!ScreenOrientationListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ScreenOrientationListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ScreenOrientationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ScreenOrientationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec.$,
        ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec.$,
        impl.isAutoRotateEnabledByUser.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ScreenOrientationListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.ScreenOrientationListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ScreenOrientationListenerRemote}
   */
  static getRemote() {
    let remote = new ScreenOrientationListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ScreenOrientationListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ScreenOrientationListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ScreenOrientationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ScreenOrientationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isAutoRotateEnabledByUser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec.$,
        ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec.$,
        this.isAutoRotateEnabledByUser.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ScreenOrientation_LockOrientation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ScreenOrientation_LockOrientation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ScreenOrientation_UnlockOrientation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ScreenOrientation_LockOrientation_ParamsSpec.$,
    'ScreenOrientation_LockOrientation_Params',
    [
      mojo.internal.StructField(
        'orientation', 0,
        0,
        device_mojom_ScreenOrientationLockTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ScreenOrientation_LockOrientation_Params {
  constructor() {
    /** @type { !device_mojom_ScreenOrientationLockType } */
    this.orientation;
  }
}



mojo.internal.Struct(
    ScreenOrientation_LockOrientation_ResponseParamsSpec.$,
    'ScreenOrientation_LockOrientation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device_mojom_ScreenOrientationLockResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ScreenOrientation_LockOrientation_ResponseParams {
  constructor() {
    /** @type { !device_mojom_ScreenOrientationLockResult } */
    this.result;
  }
}



mojo.internal.Struct(
    ScreenOrientation_UnlockOrientation_ParamsSpec.$,
    'ScreenOrientation_UnlockOrientation_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ScreenOrientation_UnlockOrientation_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec.$,
    'ScreenOrientationListener_IsAutoRotateEnabledByUser_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ScreenOrientationListener_IsAutoRotateEnabledByUser_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec.$,
    'ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.enabled;
  }
}

