// services/device/public/mojom/usb_manager_client.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('device.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.UsbDeviceManagerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.UsbDeviceManagerClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.UsbDeviceManagerClientInterface }
 */
device.mojom.UsbDeviceManagerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.UsbDeviceManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.UsbDeviceManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.UsbDeviceManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.UsbDeviceInfo } deviceInfo
   */

  onDeviceAdded(
      deviceInfo) {
    this.proxy.sendMessage(
        0,
        device.mojom.UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.UsbDeviceInfo } deviceInfo
   */

  onDeviceRemoved(
      deviceInfo) {
    this.proxy.sendMessage(
        1,
        device.mojom.UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UsbDeviceManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.UsbDeviceManagerClientReceiver = class {
  /**
   * @param {!device.mojom.UsbDeviceManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.UsbDeviceManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.UsbDeviceManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.UsbDeviceManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        impl.onDeviceAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        impl.onDeviceRemoved.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.UsbDeviceManagerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.UsbDeviceManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.UsbDeviceManagerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.UsbDeviceManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UsbDeviceManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.UsbDeviceManagerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.UsbDeviceManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.UsbDeviceManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        this.onDeviceAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        this.onDeviceRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
    'UsbDeviceManagerClient_OnDeviceAdded_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device.mojom.UsbDeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.UsbDeviceManagerClient_OnDeviceAdded_Params = class {
  constructor() {
    /** @export { !device.mojom.UsbDeviceInfo } */
    this.deviceInfo;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
    'UsbDeviceManagerClient_OnDeviceRemoved_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device.mojom.UsbDeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.UsbDeviceManagerClient_OnDeviceRemoved_Params = class {
  constructor() {
    /** @export { !device.mojom.UsbDeviceInfo } */
    this.deviceInfo;
  }
};

