// services/device/public/mojom/wake_lock.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WakeLockTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WakeLockType = {
  
  kPreventAppSuspension: 0,
  kPreventDisplaySleep: 1,
  kPreventDisplaySleepAllowDimming: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WakeLockReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WakeLockReason = {
  
  kAudioPlayback: 0,
  kVideoPlayback: 1,
  kOther: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WakeLockPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.WakeLock', scope);
  }
}

/** @interface */
export class WakeLockInterface {
  
  /**
   */

  requestWakeLock() {}
  
  /**
   */

  cancelWakeLock() {}
  
  /**
   * @param { !WakeLockPendingReceiver } wakeLock
   */

  addClient(wakeLock) {}
  
  /**
   * @param { !WakeLockType } type
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  changeType(type) {}
  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  hasWakeLockForTests() {}
}

/**
 * @implements { WakeLockInterface }
 */
export class WakeLockRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WakeLockPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WakeLockPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WakeLockPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  requestWakeLock() {
    this.proxy.sendMessage(
        0,
        WakeLock_RequestWakeLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cancelWakeLock() {
    this.proxy.sendMessage(
        1,
        WakeLock_CancelWakeLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !WakeLockPendingReceiver } wakeLock
   */

  addClient(
      wakeLock) {
    this.proxy.sendMessage(
        2,
        WakeLock_AddClient_ParamsSpec.$,
        null,
        [
          wakeLock
        ],
        false);
  }

  
  /**
   * @param { !WakeLockType } type
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  changeType(
      type) {
    return this.proxy.sendMessage(
        3,
        WakeLock_ChangeType_ParamsSpec.$,
        WakeLock_ChangeType_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  hasWakeLockForTests() {
    return this.proxy.sendMessage(
        4,
        WakeLock_HasWakeLockForTests_ParamsSpec.$,
        WakeLock_HasWakeLockForTests_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WakeLock
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WakeLockReceiver {
  /**
   * @param {!WakeLockInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WakeLockRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WakeLockRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WakeLockRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WakeLock_RequestWakeLock_ParamsSpec.$,
        null,
        impl.requestWakeLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WakeLock_CancelWakeLock_ParamsSpec.$,
        null,
        impl.cancelWakeLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WakeLock_AddClient_ParamsSpec.$,
        null,
        impl.addClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WakeLock_ChangeType_ParamsSpec.$,
        WakeLock_ChangeType_ResponseParamsSpec.$,
        impl.changeType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WakeLock_HasWakeLockForTests_ParamsSpec.$,
        WakeLock_HasWakeLockForTests_ResponseParamsSpec.$,
        impl.hasWakeLockForTests.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WakeLock {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.WakeLock";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WakeLockRemote}
   */
  static getRemote() {
    let remote = new WakeLockRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WakeLock
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WakeLockCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WakeLockRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WakeLockRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestWakeLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WakeLock_RequestWakeLock_ParamsSpec.$,
        null,
        this.requestWakeLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelWakeLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WakeLock_CancelWakeLock_ParamsSpec.$,
        null,
        this.cancelWakeLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WakeLock_AddClient_ParamsSpec.$,
        null,
        this.addClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.changeType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WakeLock_ChangeType_ParamsSpec.$,
        WakeLock_ChangeType_ResponseParamsSpec.$,
        this.changeType.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasWakeLockForTests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WakeLock_HasWakeLockForTests_ParamsSpec.$,
        WakeLock_HasWakeLockForTests_ResponseParamsSpec.$,
        this.hasWakeLockForTests.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLock_RequestWakeLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLock_CancelWakeLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLock_AddClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLock_ChangeType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLock_ChangeType_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLock_HasWakeLockForTests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLock_HasWakeLockForTests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WakeLock_RequestWakeLock_ParamsSpec.$,
    'WakeLock_RequestWakeLock_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WakeLock_RequestWakeLock_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WakeLock_CancelWakeLock_ParamsSpec.$,
    'WakeLock_CancelWakeLock_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WakeLock_CancelWakeLock_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WakeLock_AddClient_ParamsSpec.$,
    'WakeLock_AddClient_Params',
    [
      mojo.internal.StructField(
        'wakeLock', 0,
        0,
        mojo.internal.InterfaceRequest(WakeLockPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WakeLock_AddClient_Params {
  constructor() {
    /** @type { !WakeLockPendingReceiver } */
    this.wakeLock;
  }
}



mojo.internal.Struct(
    WakeLock_ChangeType_ParamsSpec.$,
    'WakeLock_ChangeType_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        WakeLockTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WakeLock_ChangeType_Params {
  constructor() {
    /** @type { !WakeLockType } */
    this.type;
  }
}



mojo.internal.Struct(
    WakeLock_ChangeType_ResponseParamsSpec.$,
    'WakeLock_ChangeType_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WakeLock_ChangeType_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    WakeLock_HasWakeLockForTests_ParamsSpec.$,
    'WakeLock_HasWakeLockForTests_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WakeLock_HasWakeLockForTests_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WakeLock_HasWakeLockForTests_ResponseParamsSpec.$,
    'WakeLock_HasWakeLockForTests_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WakeLock_HasWakeLockForTests_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}

