// services/network/public/mojom/cookie_setting_overrides.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/cookie_setting_overrides.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');



  function CookieSettingOverrides(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieSettingOverrides.prototype.initDefaults_ = function() {
    this.overridesBitmask = 0;
  };
  CookieSettingOverrides.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieSettingOverrides.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieSettingOverrides.encodedSize = codec.kStructHeaderSize + 8;

  CookieSettingOverrides.decode = function(decoder) {
    var packed;
    var val = new CookieSettingOverrides();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.overridesBitmask =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  CookieSettingOverrides.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieSettingOverrides.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.overridesBitmask);
  };
  exports.CookieSettingOverrides = CookieSettingOverrides;
})();