// services/network/public/mojom/cross_origin_opener_policy.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  SourceLocation as network_mojom_SourceLocation,
  SourceLocationSpec as network_mojom_SourceLocationSpec
} from './source_location.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CoopAccessReportTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CoopAccessReportType = {
  
  kAccessFromCoopPageToOpener: 0,
  kAccessFromCoopPageToOpenee: 1,
  kAccessFromCoopPageToOther: 2,
  kAccessToCoopPageFromOpener: 3,
  kAccessToCoopPageFromOpenee: 4,
  kAccessToCoopPageFromOther: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CrossOriginOpenerPolicyValueSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CrossOriginOpenerPolicyValue = {
  
  kUnsafeNone: 0,
  kSameOriginAllowPopups: 1,
  kSameOrigin: 2,
  kSameOriginPlusCoep: 3,
  kNoopenerAllowPopups: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CrossOriginOpenerPolicyReporterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.CrossOriginOpenerPolicyReporter', scope);
  }
}

/** @interface */
export class CrossOriginOpenerPolicyReporterInterface {
  
  /**
   * @param { !CoopAccessReportType } reportType
   * @param { !string } property
   * @param { !network_mojom_SourceLocation } sourceLocation
   * @param { !string } reportedWindowUrl
   */

  queueAccessReport(reportType, property, sourceLocation, reportedWindowUrl) {}
}

/**
 * @implements { CrossOriginOpenerPolicyReporterInterface }
 */
export class CrossOriginOpenerPolicyReporterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CrossOriginOpenerPolicyReporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CrossOriginOpenerPolicyReporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CrossOriginOpenerPolicyReporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CoopAccessReportType } reportType
   * @param { !string } property
   * @param { !network_mojom_SourceLocation } sourceLocation
   * @param { !string } reportedWindowUrl
   */

  queueAccessReport(
      reportType,
      property,
      sourceLocation,
      reportedWindowUrl) {
    this.proxy.sendMessage(
        0,
        CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec.$,
        null,
        [
          reportType,
          property,
          sourceLocation,
          reportedWindowUrl
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CrossOriginOpenerPolicyReporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CrossOriginOpenerPolicyReporterReceiver {
  /**
   * @param {!CrossOriginOpenerPolicyReporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CrossOriginOpenerPolicyReporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CrossOriginOpenerPolicyReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CrossOriginOpenerPolicyReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec.$,
        null,
        impl.queueAccessReport.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CrossOriginOpenerPolicyReporter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CrossOriginOpenerPolicyReporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CrossOriginOpenerPolicyReporterRemote}
   */
  static getRemote() {
    let remote = new CrossOriginOpenerPolicyReporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CrossOriginOpenerPolicyReporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CrossOriginOpenerPolicyReporterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CrossOriginOpenerPolicyReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CrossOriginOpenerPolicyReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueAccessReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec.$,
        null,
        this.queueAccessReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CrossOriginOpenerPolicyReporterParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CrossOriginOpenerPolicySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CrossOriginOpenerPolicyReporterParamsSpec.$,
    'CrossOriginOpenerPolicyReporterParams',
    [
      mojo.internal.StructField(
        'reportType', 0,
        0,
        CoopAccessReportTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reporter', 4,
        0,
        mojo.internal.InterfaceProxy(CrossOriginOpenerPolicyReporterRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpointDefined', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportedWindowUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CrossOriginOpenerPolicyReporterParams {
  constructor() {
    /** @type { !CoopAccessReportType } */
    this.reportType;
    /** @type { !CrossOriginOpenerPolicyReporterRemote } */
    this.reporter;
    /** @type { !boolean } */
    this.endpointDefined;
    /** @type { !string } */
    this.reportedWindowUrl;
  }
}



mojo.internal.Struct(
    CrossOriginOpenerPolicySpec.$,
    'CrossOriginOpenerPolicy',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        CrossOriginOpenerPolicyValueSpec.$,
        CrossOriginOpenerPolicyValue.kUnsafeNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingEndpoint', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportOnlyValue', 4,
        0,
        CrossOriginOpenerPolicyValueSpec.$,
        CrossOriginOpenerPolicyValue.kUnsafeNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportOnlyReportingEndpoint', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'soapByDefaultValue', 24,
        0,
        CrossOriginOpenerPolicyValueSpec.$,
        CrossOriginOpenerPolicyValue.kUnsafeNone,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CrossOriginOpenerPolicy {
  constructor() {
    /** @type { !CrossOriginOpenerPolicyValue } */
    this.value;
    /** @type { (string|undefined) } */
    this.reportingEndpoint;
    /** @type { !CrossOriginOpenerPolicyValue } */
    this.reportOnlyValue;
    /** @type { (string|undefined) } */
    this.reportOnlyReportingEndpoint;
    /** @type { !CrossOriginOpenerPolicyValue } */
    this.soapByDefaultValue;
  }
}



mojo.internal.Struct(
    CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsSpec.$,
    'CrossOriginOpenerPolicyReporter_QueueAccessReport_Params',
    [
      mojo.internal.StructField(
        'reportType', 0,
        0,
        CoopAccessReportTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'property', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceLocation', 16,
        0,
        network_mojom_SourceLocationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportedWindowUrl', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CrossOriginOpenerPolicyReporter_QueueAccessReport_Params {
  constructor() {
    /** @type { !CoopAccessReportType } */
    this.reportType;
    /** @type { !string } */
    this.property;
    /** @type { !network_mojom_SourceLocation } */
    this.sourceLocation;
    /** @type { !string } */
    this.reportedWindowUrl;
  }
}

