// services/network/public/mojom/http_cache_backend_file_operations.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/http_cache_backend_file_operations.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../mojo/public/mojom/base/file.mojom.js');
  }
  var file_error$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_error.mojom', '../../../../mojo/public/mojom/base/file_error.mojom.js');
  }
  var file_info$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_info.mojom', '../../../../mojo/public/mojom/base/file_info.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var HttpCacheBackendOpenFileFlags = {};
  HttpCacheBackendOpenFileFlags.kOpenAndRead = 33;
  HttpCacheBackendOpenFileFlags.kCreateAndWrite = 66;
  HttpCacheBackendOpenFileFlags.kOpenReadWriteWinShareDelete = 32865;
  HttpCacheBackendOpenFileFlags.kCreateReadWriteWinShareDelete = 32866;
  HttpCacheBackendOpenFileFlags.kCreateAlwaysWriteWinShareDelete = 32840;
  HttpCacheBackendOpenFileFlags.kOpenReadWinShareDeleteWinSequentialScan = 557089;
  HttpCacheBackendOpenFileFlags.MIN_VALUE = 33;
  HttpCacheBackendOpenFileFlags.MAX_VALUE = 557089;

  HttpCacheBackendOpenFileFlags.isKnownEnumValue = function(value) {
    switch (value) {
    case 33:
    case 66:
    case 32840:
    case 32865:
    case 32866:
    case 557089:
      return true;
    }
    return false;
  };

  HttpCacheBackendOpenFileFlags.toKnownEnumValue = function(value) {
    return value;
  };

  HttpCacheBackendOpenFileFlags.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HttpCacheBackendDeleteFileMode = {};
  HttpCacheBackendDeleteFileMode.kDefault = 0;
  HttpCacheBackendDeleteFileMode.kEnsureImmediateAvailability = 1;
  HttpCacheBackendDeleteFileMode.MIN_VALUE = 0;
  HttpCacheBackendDeleteFileMode.MAX_VALUE = 1;

  HttpCacheBackendDeleteFileMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  HttpCacheBackendDeleteFileMode.toKnownEnumValue = function(value) {
    return value;
  };

  HttpCacheBackendDeleteFileMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FileEnumerationEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileEnumerationEntry.prototype.initDefaults_ = function() {
    this.path = null;
    this.size = 0;
    this.lastAccessed = null;
    this.lastModified = null;
  };
  FileEnumerationEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileEnumerationEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileEnumerationEntry.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FileEnumerationEntry.lastAccessed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileEnumerationEntry.lastModified
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileEnumerationEntry.encodedSize = codec.kStructHeaderSize + 32;

  FileEnumerationEntry.decode = function(decoder) {
    var packed;
    var val = new FileEnumerationEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.size =
        decoder.decodeStruct(codec.Int64);
    val.lastAccessed =
        decoder.decodeStructPointer(time$.Time);
    val.lastModified =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  FileEnumerationEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileEnumerationEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStruct(codec.Int64, val.size);
    encoder.encodeStructPointer(time$.Time, val.lastAccessed);
    encoder.encodeStructPointer(time$.Time, val.lastModified);
  };
  function FileEnumerator_GetNext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileEnumerator_GetNext_Params.prototype.initDefaults_ = function() {
    this.numEntries = 0;
  };
  FileEnumerator_GetNext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileEnumerator_GetNext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileEnumerator_GetNext_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileEnumerator_GetNext_Params.decode = function(decoder) {
    var packed;
    var val = new FileEnumerator_GetNext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numEntries =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileEnumerator_GetNext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileEnumerator_GetNext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numEntries);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileEnumerator_GetNext_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileEnumerator_GetNext_ResponseParams.prototype.initDefaults_ = function() {
    this.entries = null;
    this.end = false;
    this.error = false;
  };
  FileEnumerator_GetNext_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileEnumerator_GetNext_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileEnumerator_GetNext_ResponseParams.entries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(FileEnumerationEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FileEnumerator_GetNext_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileEnumerator_GetNext_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileEnumerator_GetNext_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entries =
        decoder.decodeArrayPointer(new codec.PointerTo(FileEnumerationEntry));
    packed = decoder.readUint8();
    val.end = (packed >> 0) & 1 ? true : false;
    val.error = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileEnumerator_GetNext_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileEnumerator_GetNext_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(FileEnumerationEntry), val.entries);
    packed = 0;
    packed |= (val.end & 1) << 0
    packed |= (val.error & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_CreateDirectory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_CreateDirectory_Params.prototype.initDefaults_ = function() {
    this.path = null;
  };
  HttpCacheBackendFileOperations_CreateDirectory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_CreateDirectory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_CreateDirectory_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_CreateDirectory_Params.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_CreateDirectory_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_CreateDirectory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  HttpCacheBackendFileOperations_CreateDirectory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_CreateDirectory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  function HttpCacheBackendFileOperations_CreateDirectory_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_CreateDirectory_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  HttpCacheBackendFileOperations_CreateDirectory_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_CreateDirectory_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_CreateDirectory_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_CreateDirectory_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_CreateDirectory_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_CreateDirectory_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_CreateDirectory_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_PathExists_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_PathExists_Params.prototype.initDefaults_ = function() {
    this.path = null;
  };
  HttpCacheBackendFileOperations_PathExists_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_PathExists_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_PathExists_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_PathExists_Params.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_PathExists_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_PathExists_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  HttpCacheBackendFileOperations_PathExists_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_PathExists_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  function HttpCacheBackendFileOperations_PathExists_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_PathExists_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  HttpCacheBackendFileOperations_PathExists_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_PathExists_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_PathExists_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_PathExists_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_PathExists_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_PathExists_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_PathExists_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_DirectoryExists_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_DirectoryExists_Params.prototype.initDefaults_ = function() {
    this.path = null;
  };
  HttpCacheBackendFileOperations_DirectoryExists_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_DirectoryExists_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_DirectoryExists_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_DirectoryExists_Params.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_DirectoryExists_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_DirectoryExists_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  HttpCacheBackendFileOperations_DirectoryExists_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_DirectoryExists_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  function HttpCacheBackendFileOperations_DirectoryExists_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_DirectoryExists_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  HttpCacheBackendFileOperations_DirectoryExists_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_DirectoryExists_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_DirectoryExists_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_DirectoryExists_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_DirectoryExists_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_DirectoryExists_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_DirectoryExists_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_OpenFile_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_OpenFile_Params.prototype.initDefaults_ = function() {
    this.path = null;
    this.flags = 0;
  };
  HttpCacheBackendFileOperations_OpenFile_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_OpenFile_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_OpenFile_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_OpenFile_Params.flags
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, HttpCacheBackendOpenFileFlags);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_OpenFile_Params.encodedSize = codec.kStructHeaderSize + 16;

  HttpCacheBackendFileOperations_OpenFile_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_OpenFile_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.flags =
        decoder.decodeStruct(new codec.Enum(HttpCacheBackendOpenFileFlags));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_OpenFile_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_OpenFile_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStruct(codec.Int32, val.flags);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_OpenFile_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_OpenFile_ResponseParams.prototype.initDefaults_ = function() {
    this.file = null;
    this.error = 0;
  };
  HttpCacheBackendFileOperations_OpenFile_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_OpenFile_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_OpenFile_ResponseParams.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_OpenFile_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, file_error$.FileError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_OpenFile_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  HttpCacheBackendFileOperations_OpenFile_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_OpenFile_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.file =
        decoder.decodeStructPointer(file$.File);
    val.error =
        decoder.decodeStruct(new codec.Enum(file_error$.FileError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_OpenFile_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_OpenFile_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.file);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_DeleteFile_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_DeleteFile_Params.prototype.initDefaults_ = function() {
    this.path = null;
    this.mode = 0;
  };
  HttpCacheBackendFileOperations_DeleteFile_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_DeleteFile_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_DeleteFile_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_DeleteFile_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, HttpCacheBackendDeleteFileMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_DeleteFile_Params.encodedSize = codec.kStructHeaderSize + 16;

  HttpCacheBackendFileOperations_DeleteFile_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_DeleteFile_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.mode =
        decoder.decodeStruct(new codec.Enum(HttpCacheBackendDeleteFileMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_DeleteFile_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_DeleteFile_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_DeleteFile_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_DeleteFile_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  HttpCacheBackendFileOperations_DeleteFile_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_DeleteFile_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_DeleteFile_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_DeleteFile_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_DeleteFile_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_DeleteFile_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_DeleteFile_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_RenameFile_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_RenameFile_Params.prototype.initDefaults_ = function() {
    this.fromPath = null;
    this.toPath = null;
  };
  HttpCacheBackendFileOperations_RenameFile_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_RenameFile_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_RenameFile_Params.fromPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_RenameFile_Params.toPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_RenameFile_Params.encodedSize = codec.kStructHeaderSize + 16;

  HttpCacheBackendFileOperations_RenameFile_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_RenameFile_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fromPath =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.toPath =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  HttpCacheBackendFileOperations_RenameFile_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_RenameFile_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.fromPath);
    encoder.encodeStructPointer(file_path$.FilePath, val.toPath);
  };
  function HttpCacheBackendFileOperations_RenameFile_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_RenameFile_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
  };
  HttpCacheBackendFileOperations_RenameFile_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_RenameFile_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_RenameFile_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_error$.FileError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_RenameFile_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_RenameFile_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_RenameFile_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(file_error$.FileError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_RenameFile_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_RenameFile_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_GetFileInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_GetFileInfo_Params.prototype.initDefaults_ = function() {
    this.path = null;
  };
  HttpCacheBackendFileOperations_GetFileInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_GetFileInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_GetFileInfo_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_GetFileInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_GetFileInfo_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_GetFileInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  HttpCacheBackendFileOperations_GetFileInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_GetFileInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  function HttpCacheBackendFileOperations_GetFileInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.info = null;
  };
  HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_info$.FileInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_GetFileInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(file_info$.FileInfo);
    return val;
  };

  HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_info$.FileInfo, val.info);
  };
  function HttpCacheBackendFileOperations_EnumerateFiles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_EnumerateFiles_Params.prototype.initDefaults_ = function() {
    this.path = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  HttpCacheBackendFileOperations_EnumerateFiles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_EnumerateFiles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_EnumerateFiles_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_EnumerateFiles_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_EnumerateFiles_Params.encodedSize = codec.kStructHeaderSize + 16;

  HttpCacheBackendFileOperations_EnumerateFiles_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_EnumerateFiles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_EnumerateFiles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_EnumerateFiles_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperations_CleanupDirectory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_CleanupDirectory_Params.prototype.initDefaults_ = function() {
    this.path = null;
  };
  HttpCacheBackendFileOperations_CleanupDirectory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_CleanupDirectory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperations_CleanupDirectory_Params.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_CleanupDirectory_Params.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_CleanupDirectory_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_CleanupDirectory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  HttpCacheBackendFileOperations_CleanupDirectory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_CleanupDirectory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
  };
  function HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpCacheBackendFileOperationsFactory_Create_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpCacheBackendFileOperationsFactory_Create_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  HttpCacheBackendFileOperationsFactory_Create_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpCacheBackendFileOperationsFactory_Create_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpCacheBackendFileOperationsFactory_Create_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpCacheBackendFileOperationsFactory_Create_Params.encodedSize = codec.kStructHeaderSize + 8;

  HttpCacheBackendFileOperationsFactory_Create_Params.decode = function(decoder) {
    var packed;
    var val = new HttpCacheBackendFileOperationsFactory_Create_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpCacheBackendFileOperationsFactory_Create_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpCacheBackendFileOperationsFactory_Create_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kFileEnumerator_GetNext_Name = 0;

  function FileEnumeratorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileEnumerator,
                                                   handleOrPtrInfo);
  }

  function FileEnumeratorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileEnumerator, associatedInterfacePtrInfo);
  }

  FileEnumeratorAssociatedPtr.prototype =
      Object.create(FileEnumeratorPtr.prototype);
  FileEnumeratorAssociatedPtr.prototype.constructor =
      FileEnumeratorAssociatedPtr;

  function FileEnumeratorProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileEnumeratorPtr.prototype.getNext = function() {
    return FileEnumeratorProxy.prototype.getNext
        .apply(this.ptr.getProxy(), arguments);
  };

  FileEnumeratorProxy.prototype.getNext = function(numEntries) {
    var params_ = new FileEnumerator_GetNext_Params();
    params_.numEntries = numEntries;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileEnumerator_GetNext_Name,
          codec.align(FileEnumerator_GetNext_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileEnumerator_GetNext_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileEnumerator_GetNext_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FileEnumeratorStub(delegate) {
    this.delegate_ = delegate;
  }
  FileEnumeratorStub.prototype.getNext = function(numEntries) {
    return this.delegate_ && this.delegate_.getNext && this.delegate_.getNext(numEntries);
  }

  FileEnumeratorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  FileEnumeratorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileEnumerator_GetNext_Name:
      var params = reader.decodeStruct(FileEnumerator_GetNext_Params);
      this.getNext(params.numEntries).then(function(response) {
        var responseParams =
            new FileEnumerator_GetNext_ResponseParams();
        responseParams.entries = response.entries;
        responseParams.end = response.end;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kFileEnumerator_GetNext_Name,
            codec.align(FileEnumerator_GetNext_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileEnumerator_GetNext_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileEnumeratorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileEnumerator_GetNext_Name:
        if (message.expectsResponse())
          paramsClass = FileEnumerator_GetNext_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileEnumeratorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileEnumerator_GetNext_Name:
        if (message.isResponse())
          paramsClass = FileEnumerator_GetNext_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileEnumerator = {
    name: 'network.mojom.FileEnumerator',
    kVersion: 0,
    ptrClass: FileEnumeratorPtr,
    proxyClass: FileEnumeratorProxy,
    stubClass: FileEnumeratorStub,
    validateRequest: validateFileEnumeratorRequest,
    validateResponse: validateFileEnumeratorResponse,
  };
  FileEnumeratorStub.prototype.validator = validateFileEnumeratorRequest;
  FileEnumeratorProxy.prototype.validator = validateFileEnumeratorResponse;
  var kHttpCacheBackendFileOperations_CreateDirectory_Name = 0;
  var kHttpCacheBackendFileOperations_PathExists_Name = 1;
  var kHttpCacheBackendFileOperations_DirectoryExists_Name = 2;
  var kHttpCacheBackendFileOperations_OpenFile_Name = 3;
  var kHttpCacheBackendFileOperations_DeleteFile_Name = 4;
  var kHttpCacheBackendFileOperations_RenameFile_Name = 5;
  var kHttpCacheBackendFileOperations_GetFileInfo_Name = 6;
  var kHttpCacheBackendFileOperations_EnumerateFiles_Name = 7;
  var kHttpCacheBackendFileOperations_CleanupDirectory_Name = 8;

  function HttpCacheBackendFileOperationsPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(HttpCacheBackendFileOperations,
                                                   handleOrPtrInfo);
  }

  function HttpCacheBackendFileOperationsAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        HttpCacheBackendFileOperations, associatedInterfacePtrInfo);
  }

  HttpCacheBackendFileOperationsAssociatedPtr.prototype =
      Object.create(HttpCacheBackendFileOperationsPtr.prototype);
  HttpCacheBackendFileOperationsAssociatedPtr.prototype.constructor =
      HttpCacheBackendFileOperationsAssociatedPtr;

  function HttpCacheBackendFileOperationsProxy(receiver) {
    this.receiver_ = receiver;
  }
  HttpCacheBackendFileOperationsPtr.prototype.createDirectory = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.createDirectory
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.createDirectory = function(path) {
    var params_ = new HttpCacheBackendFileOperations_CreateDirectory_Params();
    params_.path = path;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHttpCacheBackendFileOperations_CreateDirectory_Name,
          codec.align(HttpCacheBackendFileOperations_CreateDirectory_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HttpCacheBackendFileOperations_CreateDirectory_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HttpCacheBackendFileOperations_CreateDirectory_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HttpCacheBackendFileOperationsPtr.prototype.pathExists = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.pathExists
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.pathExists = function(path) {
    var params_ = new HttpCacheBackendFileOperations_PathExists_Params();
    params_.path = path;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHttpCacheBackendFileOperations_PathExists_Name,
          codec.align(HttpCacheBackendFileOperations_PathExists_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HttpCacheBackendFileOperations_PathExists_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HttpCacheBackendFileOperations_PathExists_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HttpCacheBackendFileOperationsPtr.prototype.directoryExists = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.directoryExists
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.directoryExists = function(path) {
    var params_ = new HttpCacheBackendFileOperations_DirectoryExists_Params();
    params_.path = path;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHttpCacheBackendFileOperations_DirectoryExists_Name,
          codec.align(HttpCacheBackendFileOperations_DirectoryExists_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HttpCacheBackendFileOperations_DirectoryExists_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HttpCacheBackendFileOperations_DirectoryExists_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HttpCacheBackendFileOperationsPtr.prototype.openFile = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.openFile
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.openFile = function(path, flags) {
    var params_ = new HttpCacheBackendFileOperations_OpenFile_Params();
    params_.path = path;
    params_.flags = flags;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHttpCacheBackendFileOperations_OpenFile_Name,
          codec.align(HttpCacheBackendFileOperations_OpenFile_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HttpCacheBackendFileOperations_OpenFile_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HttpCacheBackendFileOperations_OpenFile_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HttpCacheBackendFileOperationsPtr.prototype.deleteFile = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.deleteFile
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.deleteFile = function(path, mode) {
    var params_ = new HttpCacheBackendFileOperations_DeleteFile_Params();
    params_.path = path;
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHttpCacheBackendFileOperations_DeleteFile_Name,
          codec.align(HttpCacheBackendFileOperations_DeleteFile_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HttpCacheBackendFileOperations_DeleteFile_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HttpCacheBackendFileOperations_DeleteFile_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HttpCacheBackendFileOperationsPtr.prototype.renameFile = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.renameFile
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.renameFile = function(fromPath, toPath) {
    var params_ = new HttpCacheBackendFileOperations_RenameFile_Params();
    params_.fromPath = fromPath;
    params_.toPath = toPath;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHttpCacheBackendFileOperations_RenameFile_Name,
          codec.align(HttpCacheBackendFileOperations_RenameFile_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HttpCacheBackendFileOperations_RenameFile_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HttpCacheBackendFileOperations_RenameFile_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HttpCacheBackendFileOperationsPtr.prototype.getFileInfo = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.getFileInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.getFileInfo = function(path) {
    var params_ = new HttpCacheBackendFileOperations_GetFileInfo_Params();
    params_.path = path;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHttpCacheBackendFileOperations_GetFileInfo_Name,
          codec.align(HttpCacheBackendFileOperations_GetFileInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HttpCacheBackendFileOperations_GetFileInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HttpCacheBackendFileOperations_GetFileInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HttpCacheBackendFileOperationsPtr.prototype.enumerateFiles = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.enumerateFiles
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.enumerateFiles = function(path, receiver) {
    var params_ = new HttpCacheBackendFileOperations_EnumerateFiles_Params();
    params_.path = path;
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kHttpCacheBackendFileOperations_EnumerateFiles_Name,
        codec.align(HttpCacheBackendFileOperations_EnumerateFiles_Params.encodedSize));
    builder.encodeStruct(HttpCacheBackendFileOperations_EnumerateFiles_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  HttpCacheBackendFileOperationsPtr.prototype.cleanupDirectory = function() {
    return HttpCacheBackendFileOperationsProxy.prototype.cleanupDirectory
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsProxy.prototype.cleanupDirectory = function(path) {
    var params_ = new HttpCacheBackendFileOperations_CleanupDirectory_Params();
    params_.path = path;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHttpCacheBackendFileOperations_CleanupDirectory_Name,
          codec.align(HttpCacheBackendFileOperations_CleanupDirectory_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HttpCacheBackendFileOperations_CleanupDirectory_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function HttpCacheBackendFileOperationsStub(delegate) {
    this.delegate_ = delegate;
  }
  HttpCacheBackendFileOperationsStub.prototype.createDirectory = function(path) {
    return this.delegate_ && this.delegate_.createDirectory && this.delegate_.createDirectory(path);
  }
  HttpCacheBackendFileOperationsStub.prototype.pathExists = function(path) {
    return this.delegate_ && this.delegate_.pathExists && this.delegate_.pathExists(path);
  }
  HttpCacheBackendFileOperationsStub.prototype.directoryExists = function(path) {
    return this.delegate_ && this.delegate_.directoryExists && this.delegate_.directoryExists(path);
  }
  HttpCacheBackendFileOperationsStub.prototype.openFile = function(path, flags) {
    return this.delegate_ && this.delegate_.openFile && this.delegate_.openFile(path, flags);
  }
  HttpCacheBackendFileOperationsStub.prototype.deleteFile = function(path, mode) {
    return this.delegate_ && this.delegate_.deleteFile && this.delegate_.deleteFile(path, mode);
  }
  HttpCacheBackendFileOperationsStub.prototype.renameFile = function(fromPath, toPath) {
    return this.delegate_ && this.delegate_.renameFile && this.delegate_.renameFile(fromPath, toPath);
  }
  HttpCacheBackendFileOperationsStub.prototype.getFileInfo = function(path) {
    return this.delegate_ && this.delegate_.getFileInfo && this.delegate_.getFileInfo(path);
  }
  HttpCacheBackendFileOperationsStub.prototype.enumerateFiles = function(path, receiver) {
    return this.delegate_ && this.delegate_.enumerateFiles && this.delegate_.enumerateFiles(path, receiver);
  }
  HttpCacheBackendFileOperationsStub.prototype.cleanupDirectory = function(path) {
    return this.delegate_ && this.delegate_.cleanupDirectory && this.delegate_.cleanupDirectory(path);
  }

  HttpCacheBackendFileOperationsStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHttpCacheBackendFileOperations_EnumerateFiles_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_EnumerateFiles_Params);
      this.enumerateFiles(params.path, params.receiver);
      return true;
    default:
      return false;
    }
  };

  HttpCacheBackendFileOperationsStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHttpCacheBackendFileOperations_CreateDirectory_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_CreateDirectory_Params);
      this.createDirectory(params.path).then(function(response) {
        var responseParams =
            new HttpCacheBackendFileOperations_CreateDirectory_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kHttpCacheBackendFileOperations_CreateDirectory_Name,
            codec.align(HttpCacheBackendFileOperations_CreateDirectory_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HttpCacheBackendFileOperations_CreateDirectory_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHttpCacheBackendFileOperations_PathExists_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_PathExists_Params);
      this.pathExists(params.path).then(function(response) {
        var responseParams =
            new HttpCacheBackendFileOperations_PathExists_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kHttpCacheBackendFileOperations_PathExists_Name,
            codec.align(HttpCacheBackendFileOperations_PathExists_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HttpCacheBackendFileOperations_PathExists_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHttpCacheBackendFileOperations_DirectoryExists_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_DirectoryExists_Params);
      this.directoryExists(params.path).then(function(response) {
        var responseParams =
            new HttpCacheBackendFileOperations_DirectoryExists_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kHttpCacheBackendFileOperations_DirectoryExists_Name,
            codec.align(HttpCacheBackendFileOperations_DirectoryExists_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HttpCacheBackendFileOperations_DirectoryExists_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHttpCacheBackendFileOperations_OpenFile_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_OpenFile_Params);
      this.openFile(params.path, params.flags).then(function(response) {
        var responseParams =
            new HttpCacheBackendFileOperations_OpenFile_ResponseParams();
        responseParams.file = response.file;
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kHttpCacheBackendFileOperations_OpenFile_Name,
            codec.align(HttpCacheBackendFileOperations_OpenFile_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HttpCacheBackendFileOperations_OpenFile_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHttpCacheBackendFileOperations_DeleteFile_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_DeleteFile_Params);
      this.deleteFile(params.path, params.mode).then(function(response) {
        var responseParams =
            new HttpCacheBackendFileOperations_DeleteFile_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kHttpCacheBackendFileOperations_DeleteFile_Name,
            codec.align(HttpCacheBackendFileOperations_DeleteFile_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HttpCacheBackendFileOperations_DeleteFile_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHttpCacheBackendFileOperations_RenameFile_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_RenameFile_Params);
      this.renameFile(params.fromPath, params.toPath).then(function(response) {
        var responseParams =
            new HttpCacheBackendFileOperations_RenameFile_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kHttpCacheBackendFileOperations_RenameFile_Name,
            codec.align(HttpCacheBackendFileOperations_RenameFile_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HttpCacheBackendFileOperations_RenameFile_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHttpCacheBackendFileOperations_GetFileInfo_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_GetFileInfo_Params);
      this.getFileInfo(params.path).then(function(response) {
        var responseParams =
            new HttpCacheBackendFileOperations_GetFileInfo_ResponseParams();
        responseParams.info = response.info;
        var builder = new codec.MessageV1Builder(
            kHttpCacheBackendFileOperations_GetFileInfo_Name,
            codec.align(HttpCacheBackendFileOperations_GetFileInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HttpCacheBackendFileOperations_GetFileInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHttpCacheBackendFileOperations_CleanupDirectory_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperations_CleanupDirectory_Params);
      this.cleanupDirectory(params.path).then(function(response) {
        var responseParams =
            new HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kHttpCacheBackendFileOperations_CleanupDirectory_Name,
            codec.align(HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateHttpCacheBackendFileOperationsRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kHttpCacheBackendFileOperations_CreateDirectory_Name:
        if (message.expectsResponse())
          paramsClass = HttpCacheBackendFileOperations_CreateDirectory_Params;
      break;
      case kHttpCacheBackendFileOperations_PathExists_Name:
        if (message.expectsResponse())
          paramsClass = HttpCacheBackendFileOperations_PathExists_Params;
      break;
      case kHttpCacheBackendFileOperations_DirectoryExists_Name:
        if (message.expectsResponse())
          paramsClass = HttpCacheBackendFileOperations_DirectoryExists_Params;
      break;
      case kHttpCacheBackendFileOperations_OpenFile_Name:
        if (message.expectsResponse())
          paramsClass = HttpCacheBackendFileOperations_OpenFile_Params;
      break;
      case kHttpCacheBackendFileOperations_DeleteFile_Name:
        if (message.expectsResponse())
          paramsClass = HttpCacheBackendFileOperations_DeleteFile_Params;
      break;
      case kHttpCacheBackendFileOperations_RenameFile_Name:
        if (message.expectsResponse())
          paramsClass = HttpCacheBackendFileOperations_RenameFile_Params;
      break;
      case kHttpCacheBackendFileOperations_GetFileInfo_Name:
        if (message.expectsResponse())
          paramsClass = HttpCacheBackendFileOperations_GetFileInfo_Params;
      break;
      case kHttpCacheBackendFileOperations_EnumerateFiles_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_EnumerateFiles_Params;
      break;
      case kHttpCacheBackendFileOperations_CleanupDirectory_Name:
        if (message.expectsResponse())
          paramsClass = HttpCacheBackendFileOperations_CleanupDirectory_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateHttpCacheBackendFileOperationsResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kHttpCacheBackendFileOperations_CreateDirectory_Name:
        if (message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_CreateDirectory_ResponseParams;
        break;
      case kHttpCacheBackendFileOperations_PathExists_Name:
        if (message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_PathExists_ResponseParams;
        break;
      case kHttpCacheBackendFileOperations_DirectoryExists_Name:
        if (message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_DirectoryExists_ResponseParams;
        break;
      case kHttpCacheBackendFileOperations_OpenFile_Name:
        if (message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_OpenFile_ResponseParams;
        break;
      case kHttpCacheBackendFileOperations_DeleteFile_Name:
        if (message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_DeleteFile_ResponseParams;
        break;
      case kHttpCacheBackendFileOperations_RenameFile_Name:
        if (message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_RenameFile_ResponseParams;
        break;
      case kHttpCacheBackendFileOperations_GetFileInfo_Name:
        if (message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_GetFileInfo_ResponseParams;
        break;
      case kHttpCacheBackendFileOperations_CleanupDirectory_Name:
        if (message.isResponse())
          paramsClass = HttpCacheBackendFileOperations_CleanupDirectory_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var HttpCacheBackendFileOperations = {
    name: 'network.mojom.HttpCacheBackendFileOperations',
    kVersion: 0,
    ptrClass: HttpCacheBackendFileOperationsPtr,
    proxyClass: HttpCacheBackendFileOperationsProxy,
    stubClass: HttpCacheBackendFileOperationsStub,
    validateRequest: validateHttpCacheBackendFileOperationsRequest,
    validateResponse: validateHttpCacheBackendFileOperationsResponse,
  };
  HttpCacheBackendFileOperationsStub.prototype.validator = validateHttpCacheBackendFileOperationsRequest;
  HttpCacheBackendFileOperationsProxy.prototype.validator = validateHttpCacheBackendFileOperationsResponse;
  var kHttpCacheBackendFileOperationsFactory_Create_Name = 0;

  function HttpCacheBackendFileOperationsFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(HttpCacheBackendFileOperationsFactory,
                                                   handleOrPtrInfo);
  }

  function HttpCacheBackendFileOperationsFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        HttpCacheBackendFileOperationsFactory, associatedInterfacePtrInfo);
  }

  HttpCacheBackendFileOperationsFactoryAssociatedPtr.prototype =
      Object.create(HttpCacheBackendFileOperationsFactoryPtr.prototype);
  HttpCacheBackendFileOperationsFactoryAssociatedPtr.prototype.constructor =
      HttpCacheBackendFileOperationsFactoryAssociatedPtr;

  function HttpCacheBackendFileOperationsFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  HttpCacheBackendFileOperationsFactoryPtr.prototype.create = function() {
    return HttpCacheBackendFileOperationsFactoryProxy.prototype.create
        .apply(this.ptr.getProxy(), arguments);
  };

  HttpCacheBackendFileOperationsFactoryProxy.prototype.create = function(receiver) {
    var params_ = new HttpCacheBackendFileOperationsFactory_Create_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kHttpCacheBackendFileOperationsFactory_Create_Name,
        codec.align(HttpCacheBackendFileOperationsFactory_Create_Params.encodedSize));
    builder.encodeStruct(HttpCacheBackendFileOperationsFactory_Create_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function HttpCacheBackendFileOperationsFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  HttpCacheBackendFileOperationsFactoryStub.prototype.create = function(receiver) {
    return this.delegate_ && this.delegate_.create && this.delegate_.create(receiver);
  }

  HttpCacheBackendFileOperationsFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHttpCacheBackendFileOperationsFactory_Create_Name:
      var params = reader.decodeStruct(HttpCacheBackendFileOperationsFactory_Create_Params);
      this.create(params.receiver);
      return true;
    default:
      return false;
    }
  };

  HttpCacheBackendFileOperationsFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateHttpCacheBackendFileOperationsFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kHttpCacheBackendFileOperationsFactory_Create_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = HttpCacheBackendFileOperationsFactory_Create_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateHttpCacheBackendFileOperationsFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var HttpCacheBackendFileOperationsFactory = {
    name: 'network.mojom.HttpCacheBackendFileOperationsFactory',
    kVersion: 0,
    ptrClass: HttpCacheBackendFileOperationsFactoryPtr,
    proxyClass: HttpCacheBackendFileOperationsFactoryProxy,
    stubClass: HttpCacheBackendFileOperationsFactoryStub,
    validateRequest: validateHttpCacheBackendFileOperationsFactoryRequest,
    validateResponse: null,
  };
  HttpCacheBackendFileOperationsFactoryStub.prototype.validator = validateHttpCacheBackendFileOperationsFactoryRequest;
  HttpCacheBackendFileOperationsFactoryProxy.prototype.validator = null;
  exports.HttpCacheBackendOpenFileFlags = HttpCacheBackendOpenFileFlags;
  exports.HttpCacheBackendDeleteFileMode = HttpCacheBackendDeleteFileMode;
  exports.FileEnumerationEntry = FileEnumerationEntry;
  exports.FileEnumerator = FileEnumerator;
  exports.FileEnumeratorPtr = FileEnumeratorPtr;
  exports.FileEnumeratorAssociatedPtr = FileEnumeratorAssociatedPtr;
  exports.HttpCacheBackendFileOperations = HttpCacheBackendFileOperations;
  exports.HttpCacheBackendFileOperationsPtr = HttpCacheBackendFileOperationsPtr;
  exports.HttpCacheBackendFileOperationsAssociatedPtr = HttpCacheBackendFileOperationsAssociatedPtr;
  exports.HttpCacheBackendFileOperationsFactory = HttpCacheBackendFileOperationsFactory;
  exports.HttpCacheBackendFileOperationsFactoryPtr = HttpCacheBackendFileOperationsFactoryPtr;
  exports.HttpCacheBackendFileOperationsFactoryAssociatedPtr = HttpCacheBackendFileOperationsFactoryAssociatedPtr;
})();