// services/network/public/mojom/net_log.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec
} from '../../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  NetLogSource as network_mojom_NetLogSource,
  NetLogSourceSpec as network_mojom_NetLogSourceSpec
} from './network_param.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NetLogCaptureModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NetLogCaptureMode = {
  
  HEAVILY_REDACTED: 0,
  DEFAULT: 1,
  INCLUDE_PRIVACY_INFO: 2,
  EVERYTHING: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NetLogEventPhaseSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NetLogEventPhase = {
  
  BEGIN: 0,
  END: 1,
  NONE: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetLogExporterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetLogExporter', scope);
  }
}

/** @interface */
export class NetLogExporterInterface {
  
  /**
   * @param { !mojoBase_mojom_File } destination
   * @param { !mojoBase_mojom_DictionaryValue } extraConstants
   * @param { !NetLogCaptureMode } captureMode
   * @param { !bigint } maxFileSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  start(destination, extraConstants, captureMode, maxFileSize) {}
  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } polledValues
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  stop(polledValues) {}
}

/**
 * @implements { NetLogExporterInterface }
 */
export class NetLogExporterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetLogExporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetLogExporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetLogExporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_File } destination
   * @param { !mojoBase_mojom_DictionaryValue } extraConstants
   * @param { !NetLogCaptureMode } captureMode
   * @param { !bigint } maxFileSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  start(
      destination,
      extraConstants,
      captureMode,
      maxFileSize) {
    return this.proxy.sendMessage(
        0,
        NetLogExporter_Start_ParamsSpec.$,
        NetLogExporter_Start_ResponseParamsSpec.$,
        [
          destination,
          extraConstants,
          captureMode,
          maxFileSize
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } polledValues
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  stop(
      polledValues) {
    return this.proxy.sendMessage(
        1,
        NetLogExporter_Stop_ParamsSpec.$,
        NetLogExporter_Stop_ResponseParamsSpec.$,
        [
          polledValues
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetLogExporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetLogExporterReceiver {
  /**
   * @param {!NetLogExporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetLogExporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetLogExporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetLogExporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetLogExporter_Start_ParamsSpec.$,
        NetLogExporter_Start_ResponseParamsSpec.$,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NetLogExporter_Stop_ParamsSpec.$,
        NetLogExporter_Stop_ResponseParamsSpec.$,
        impl.stop.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetLogExporter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetLogExporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetLogExporterRemote}
   */
  static getRemote() {
    let remote = new NetLogExporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetLogExporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetLogExporterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetLogExporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetLogExporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetLogExporter_Start_ParamsSpec.$,
        NetLogExporter_Start_ResponseParamsSpec.$,
        this.start.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NetLogExporter_Stop_ParamsSpec.$,
        NetLogExporter_Stop_ResponseParamsSpec.$,
        this.stop.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetLogProxySourcePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetLogProxySource', scope);
  }
}

/** @interface */
export class NetLogProxySourceInterface {
  
  /**
   * @param { !number } modes
   */

  updateCaptureModes(modes) {}
}

/**
 * @implements { NetLogProxySourceInterface }
 */
export class NetLogProxySourceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetLogProxySourcePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetLogProxySourcePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetLogProxySourcePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } modes
   */

  updateCaptureModes(
      modes) {
    this.proxy.sendMessage(
        0,
        NetLogProxySource_UpdateCaptureModes_ParamsSpec.$,
        null,
        [
          modes
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetLogProxySource
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetLogProxySourceReceiver {
  /**
   * @param {!NetLogProxySourceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetLogProxySourceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetLogProxySourceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetLogProxySourceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetLogProxySource_UpdateCaptureModes_ParamsSpec.$,
        null,
        impl.updateCaptureModes.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetLogProxySource {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetLogProxySource";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetLogProxySourceRemote}
   */
  static getRemote() {
    let remote = new NetLogProxySourceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetLogProxySource
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetLogProxySourceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetLogProxySourceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetLogProxySourceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCaptureModes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetLogProxySource_UpdateCaptureModes_ParamsSpec.$,
        null,
        this.updateCaptureModes.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetLogProxySinkPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetLogProxySink', scope);
  }
}

/** @interface */
export class NetLogProxySinkInterface {
  
  /**
   * @param { !number } type
   * @param { !network_mojom_NetLogSource } netLogSource
   * @param { !NetLogEventPhase } phase
   * @param { !mojoBase_mojom_TimeTicks } time
   * @param { !mojoBase_mojom_DictionaryValue } params
   */

  addEntry(type, netLogSource, phase, time, params) {}
}

/**
 * @implements { NetLogProxySinkInterface }
 */
export class NetLogProxySinkRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetLogProxySinkPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetLogProxySinkPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetLogProxySinkPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } type
   * @param { !network_mojom_NetLogSource } netLogSource
   * @param { !NetLogEventPhase } phase
   * @param { !mojoBase_mojom_TimeTicks } time
   * @param { !mojoBase_mojom_DictionaryValue } params
   */

  addEntry(
      type,
      netLogSource,
      phase,
      time,
      params) {
    this.proxy.sendMessage(
        0,
        NetLogProxySink_AddEntry_ParamsSpec.$,
        null,
        [
          type,
          netLogSource,
          phase,
          time,
          params
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetLogProxySink
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetLogProxySinkReceiver {
  /**
   * @param {!NetLogProxySinkInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetLogProxySinkRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetLogProxySinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetLogProxySinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetLogProxySink_AddEntry_ParamsSpec.$,
        null,
        impl.addEntry.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetLogProxySink {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetLogProxySink";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetLogProxySinkRemote}
   */
  static getRemote() {
    let remote = new NetLogProxySinkRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetLogProxySink
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetLogProxySinkCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetLogProxySinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetLogProxySinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetLogProxySink_AddEntry_ParamsSpec.$,
        null,
        this.addEntry.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetLogExporter_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetLogExporter_Start_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetLogExporter_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetLogExporter_Stop_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetLogProxySource_UpdateCaptureModes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetLogProxySink_AddEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    NetLogExporter_Start_ParamsSpec.$,
    'NetLogExporter_Start_Params',
    [
      mojo.internal.StructField(
        'destination', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraConstants', 8,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureMode', 16,
        0,
        NetLogCaptureModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFileSize', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetLogExporter_Start_Params {
  constructor() {
    /** @type { !mojoBase_mojom_File } */
    this.destination;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.extraConstants;
    /** @type { !NetLogCaptureMode } */
    this.captureMode;
    /** @type { !bigint } */
    this.maxFileSize;
  }
}



mojo.internal.Struct(
    NetLogExporter_Start_ResponseParamsSpec.$,
    'NetLogExporter_Start_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetLogExporter_Start_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    NetLogExporter_Stop_ParamsSpec.$,
    'NetLogExporter_Stop_Params',
    [
      mojo.internal.StructField(
        'polledValues', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetLogExporter_Stop_Params {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.polledValues;
  }
}



mojo.internal.Struct(
    NetLogExporter_Stop_ResponseParamsSpec.$,
    'NetLogExporter_Stop_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetLogExporter_Stop_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    NetLogProxySource_UpdateCaptureModes_ParamsSpec.$,
    'NetLogProxySource_UpdateCaptureModes_Params',
    [
      mojo.internal.StructField(
        'modes', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetLogProxySource_UpdateCaptureModes_Params {
  constructor() {
    /** @type { !number } */
    this.modes;
  }
}



mojo.internal.Struct(
    NetLogProxySink_AddEntry_ParamsSpec.$,
    'NetLogProxySink_AddEntry_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netLogSource', 8,
        0,
        network_mojom_NetLogSourceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'phase', 4,
        0,
        NetLogEventPhaseSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'time', 16,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 24,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetLogProxySink_AddEntry_Params {
  constructor() {
    /** @type { !number } */
    this.type;
    /** @type { !network_mojom_NetLogSource } */
    this.netLogSource;
    /** @type { !NetLogEventPhase } */
    this.phase;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.time;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.params;
  }
}

