// services/network/public/mojom/network_context.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.CredentialsMode');
goog.require('network.mojom.DefaultCredentials');
goog.require('network.mojom.DeleteStoredTrustTokensStatus');
goog.require('ipProtection.mojom.IpProxyStatus');
goog.require('ipProtection.mojom.ProxyLayer');
goog.require('network.mojom.RequestDestination');
goog.require('network.mojom.RestrictedCookieManagerRole');
goog.require('network.mojom.RestrictedUDPSocketMode');
goog.require('network.mojom.StorageAccessApiStatus');
goog.require('certVerifier.mojom.CertVerifierService');
goog.require('certVerifier.mojom.CertVerifierServiceClient');
goog.require('network.mojom.ConnectionChangeObserverClient');
goog.require('network.mojom.CookieAccessObserver');
goog.require('network.mojom.CookieEncryptionProvider');
goog.require('network.mojom.CookieManager');
goog.require('ipProtection.mojom.CoreControl');
goog.require('ipProtection.mojom.CoreHost');
goog.require('network.mojom.CrossOriginEmbedderPolicyReporter');
goog.require('network.mojom.DevToolsObserver');
goog.require('network.mojom.DeviceBoundSessionAccessObserver');
goog.require('network.mojom.DeviceBoundSessionManager');
goog.require('network.mojom.DocumentIsolationPolicyReporter');
goog.require('network.mojom.FirstPartySetsAccessDelegate');
goog.require('network.mojom.HostResolver');
goog.require('network.mojom.HttpCacheBackendFileOperationsFactory');
goog.require('network.mojom.MdnsResponder');
goog.require('network.mojom.NetLogExporter');
goog.require('network.mojom.NetworkContextClient');
goog.require('network.mojom.ObliviousHttpClient');
goog.require('network.mojom.P2PSocketManager');
goog.require('network.mojom.P2PTrustedSocketManager');
goog.require('network.mojom.P2PTrustedSocketManagerClient');
goog.require('network.mojom.ProxyConfigClient');
goog.require('network.mojom.ProxyConfigPollerClient');
goog.require('network.mojom.ProxyErrorClient');
goog.require('network.mojom.ProxyLookupClient');
goog.require('proxyResolver.mojom.ProxyResolverFactory');
goog.require('network.mojom.ProxyResolvingSocketFactory');
goog.require('network.mojom.ReportingApiObserver');
goog.require('network.mojom.ResolveHostClient');
goog.require('network.mojom.RestrictedCookieManager');
goog.require('network.mojom.RestrictedUDPSocket');
goog.require('network.mojom.SSLConfigClient');
goog.require('network.mojom.SharedDictionaryAccessObserver');
goog.require('network.mojom.SocketObserver');
goog.require('network.mojom.TCPBoundSocket');
goog.require('network.mojom.TCPConnectedSocket');
goog.require('network.mojom.TCPServerSocket');
goog.require('network.mojom.TrustTokenAccessObserver');
goog.require('network.mojom.TrustTokenQueryAnswerer');
goog.require('network.mojom.UDPSocket');
goog.require('network.mojom.UDPSocketListener');
goog.require('network.mojom.URLLoaderFactory');
goog.require('network.mojom.URLLoaderNetworkServiceObserver');
goog.require('network.mojom.WebSocketAuthenticationHandler');
goog.require('network.mojom.WebSocketHandshakeClient');
goog.require('network.mojom.WebTransportHandshakeClient');
goog.require('network.mojom.AddressList');
goog.require('network.mojom.AuthChallengeInfo');
goog.require('network.mojom.AuthCredentials');
goog.require('ipProtection.mojom.BlindSignedAuthToken');
goog.require('network.mojom.CertVerifyResult');
goog.require('network.mojom.ClearDataFilter');
goog.require('network.mojom.ClientSecurityState');
goog.require('network.mojom.ConnectionKeepAliveConfig');
goog.require('contentSettings.mojom.ContentSettingPatternSource');
goog.require('network.mojom.CookieManagerParams');
goog.require('network.mojom.CookieSettingOverrides');
goog.require('network.mojom.CorsOriginAccessPatterns');
goog.require('network.mojom.CorsOriginPattern');
goog.require('mojoBase.mojom.DictionaryValue');
goog.require('network.mojom.DnsConfigOverrides');
goog.require('mojoBase.mojom.FilePath');
goog.require('network.mojom.FirstPartySetsAccessDelegateParams');
goog.require('network.mojom.HostPortPair');
goog.require('network.mojom.HttpHeader');
goog.require('network.mojom.HttpRequestHeaders');
goog.require('network.mojom.HttpResponseHeaders');
goog.require('network.mojom.IPAddress');
goog.require('network.mojom.IPEndPoint');
goog.require('network.mojom.IsolationInfo');
goog.require('network.mojom.MutableNetworkTrafficAnnotationTag');
goog.require('network.mojom.ObliviousHttpRequest');
goog.require('url.mojom.Origin');
goog.require('network.mojom.ProxyChain');
goog.require('network.mojom.ProxyConfigWithAnnotation');
goog.require('network.mojom.ProxyRules');
goog.require('network.mojom.ResolveHostParameters');
goog.require('network.mojom.RestrictedUDPSocketParams');
goog.require('network.mojom.SHA256HashValue');
goog.require('network.mojom.SSLConfig');
goog.require('url.mojom.SchemeHostPort');
goog.require('network.mojom.SharedDictionaryIsolationKey');
goog.require('network.mojom.SharedDictionaryUsageInfo');
goog.require('network.mojom.SiteForCookies');
goog.require('network.mojom.StoredTrustTokensForIssuer');
goog.require('network.mojom.TCPConnectedSocketOptions');
goog.require('network.mojom.TCPServerSocketOptions');
goog.require('mojoBase.mojom.Time');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('network.mojom.ToplevelRedemptionRecord');
goog.require('network.mojom.URLRequest');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('url.mojom.Url');
goog.require('network.mojom.WebTransportCertificateFingerprint');
goog.require('network.mojom.X509Certificate');
goog.require('mojoBase.mojom.BigBuffer');
goog.require('network.mojom.HostResolverHost');
goog.require('network.mojom.NetworkAnonymizationKey');
goog.require('network.mojom.NetworkIsolationKey');
goog.require('network.mojom.TransferableDirectory');



goog.provide('network.mojom.WEB_SOCKET_OPTION_NONE');
/**
 * @const { !number }
 * @export
 */
network.mojom.WEB_SOCKET_OPTION_NONE = 0;
goog.provide('network.mojom.WEB_SOCKET_OPTION_BLOCK_ALL_COOKIES');
/**
 * @const { !number }
 * @export
 */
network.mojom.WEB_SOCKET_OPTION_BLOCK_ALL_COOKIES = 1;
goog.provide('network.mojom.WEB_SOCKET_OPTION_BLOCK_THIRD_PARTY_COOKIES');
/**
 * @const { !number }
 * @export
 */
network.mojom.WEB_SOCKET_OPTION_BLOCK_THIRD_PARTY_COOKIES = 2;
goog.provide('network.mojom.BROWSER_PROCESS_ID');
/**
 * @const { !number }
 * @export
 */
network.mojom.BROWSER_PROCESS_ID = 0;
goog.provide('network.mojom.INVALID_PROCESS_ID');
/**
 * @const { !number }
 * @export
 */
network.mojom.INVALID_PROCESS_ID = -1;

goog.provide('network.mojom.TrustTokenOperationPolicyVerdict');
goog.provide('network.mojom.TrustTokenOperationPolicyVerdictSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.TrustTokenOperationPolicyVerdictSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.TrustTokenOperationPolicyVerdict = {
  
  kForbid: 0,
  kPotentiallyPermit: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('network.mojom.SCTAuditingMode');
goog.provide('network.mojom.SCTAuditingModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.SCTAuditingModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.SCTAuditingMode = {
  
  kDisabled: 0,
  kEnhancedSafeBrowsingReporting: 1,
  kHashdance: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('network.mojom.CustomProxyConnectionObserver');
goog.provide('network.mojom.CustomProxyConnectionObserverReceiver');
goog.provide('network.mojom.CustomProxyConnectionObserverCallbackRouter');
goog.provide('network.mojom.CustomProxyConnectionObserverInterface');
goog.provide('network.mojom.CustomProxyConnectionObserverRemote');
goog.provide('network.mojom.CustomProxyConnectionObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.CustomProxyConnectionObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.CustomProxyConnectionObserver.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.CustomProxyConnectionObserverInterface = class {
  
  /**
   * @param { !network.mojom.ProxyChain } badChain
   * @param { !number } netError
   */

  onFallback(badChain, netError) {}
  
  /**
   * @param { !network.mojom.ProxyChain } proxyChain
   * @param { !bigint } chainIndex
   * @param { !network.mojom.HttpResponseHeaders } responseHeaders
   */

  onTunnelHeadersReceived(proxyChain, chainIndex, responseHeaders) {}
};

/**
 * @export
 * @implements { network.mojom.CustomProxyConnectionObserverInterface }
 */
network.mojom.CustomProxyConnectionObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.CustomProxyConnectionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.CustomProxyConnectionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.CustomProxyConnectionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.ProxyChain } badChain
   * @param { !number } netError
   */

  onFallback(
      badChain,
      netError) {
    this.proxy.sendMessage(
        0,
        network.mojom.CustomProxyConnectionObserver_OnFallback_ParamsSpec.$,
        null,
        [
          badChain,
          netError
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.ProxyChain } proxyChain
   * @param { !bigint } chainIndex
   * @param { !network.mojom.HttpResponseHeaders } responseHeaders
   */

  onTunnelHeadersReceived(
      proxyChain,
      chainIndex,
      responseHeaders) {
    this.proxy.sendMessage(
        1,
        network.mojom.CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec.$,
        null,
        [
          proxyChain,
          chainIndex,
          responseHeaders
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CustomProxyConnectionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.CustomProxyConnectionObserverReceiver = class {
  /**
   * @param {!network.mojom.CustomProxyConnectionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.CustomProxyConnectionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.CustomProxyConnectionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CustomProxyConnectionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.CustomProxyConnectionObserver_OnFallback_ParamsSpec.$,
        null,
        impl.onFallback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec.$,
        null,
        impl.onTunnelHeadersReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.CustomProxyConnectionObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CustomProxyConnectionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.CustomProxyConnectionObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.CustomProxyConnectionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CustomProxyConnectionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.CustomProxyConnectionObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.CustomProxyConnectionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CustomProxyConnectionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFallback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.CustomProxyConnectionObserver_OnFallback_ParamsSpec.$,
        null,
        this.onFallback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTunnelHeadersReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec.$,
        null,
        this.onTunnelHeadersReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.CustomProxyConfigClient');
goog.provide('network.mojom.CustomProxyConfigClientReceiver');
goog.provide('network.mojom.CustomProxyConfigClientCallbackRouter');
goog.provide('network.mojom.CustomProxyConfigClientInterface');
goog.provide('network.mojom.CustomProxyConfigClientRemote');
goog.provide('network.mojom.CustomProxyConfigClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.CustomProxyConfigClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.CustomProxyConfigClient.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.CustomProxyConfigClientInterface = class {
  
  /**
   * @param { !network.mojom.CustomProxyConfig } proxyConfig
   * @return {!Promise}
   */

  onCustomProxyConfigUpdated(proxyConfig) {}
};

/**
 * @export
 * @implements { network.mojom.CustomProxyConfigClientInterface }
 */
network.mojom.CustomProxyConfigClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.CustomProxyConfigClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.CustomProxyConfigClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.CustomProxyConfigClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.CustomProxyConfig } proxyConfig
   * @return {!Promise}
   */

  onCustomProxyConfigUpdated(
      proxyConfig) {
    return this.proxy.sendMessage(
        0,
        network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec.$,
        network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec.$,
        [
          proxyConfig
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CustomProxyConfigClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.CustomProxyConfigClientReceiver = class {
  /**
   * @param {!network.mojom.CustomProxyConfigClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.CustomProxyConfigClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.CustomProxyConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CustomProxyConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec.$,
        network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec.$,
        impl.onCustomProxyConfigUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.CustomProxyConfigClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CustomProxyConfigClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.CustomProxyConfigClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.CustomProxyConfigClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CustomProxyConfigClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.CustomProxyConfigClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.CustomProxyConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CustomProxyConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCustomProxyConfigUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec.$,
        network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec.$,
        this.onCustomProxyConfigUpdated.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.TrustedHeaderClient');
goog.provide('network.mojom.TrustedHeaderClientReceiver');
goog.provide('network.mojom.TrustedHeaderClientCallbackRouter');
goog.provide('network.mojom.TrustedHeaderClientInterface');
goog.provide('network.mojom.TrustedHeaderClientRemote');
goog.provide('network.mojom.TrustedHeaderClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.TrustedHeaderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.TrustedHeaderClient.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.TrustedHeaderClientInterface = class {
  
  /**
   * @param { !network.mojom.HttpRequestHeaders } headers
   * @return {!Promise<{
        result: !number,
        headers: ?network.mojom.HttpRequestHeaders,
   *  }>}
   */

  onBeforeSendHeaders(headers) {}
  
  /**
   * @param { !string } headers
   * @param { !network.mojom.IPEndPoint } remoteEndpoint
   * @return {!Promise<{
        result: !number,
        headers: ?string,
        preserveFragmentOnRedirectUrl: ?url.mojom.Url,
   *  }>}
   */

  onHeadersReceived(headers, remoteEndpoint) {}
};

/**
 * @export
 * @implements { network.mojom.TrustedHeaderClientInterface }
 */
network.mojom.TrustedHeaderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.TrustedHeaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.TrustedHeaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.TrustedHeaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.HttpRequestHeaders } headers
   * @return {!Promise<{
        result: !number,
        headers: ?network.mojom.HttpRequestHeaders,
   *  }>}
   */

  onBeforeSendHeaders(
      headers) {
    return this.proxy.sendMessage(
        0,
        network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec.$,
        network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec.$,
        [
          headers
        ],
        false);
  }

  
  /**
   * @param { !string } headers
   * @param { !network.mojom.IPEndPoint } remoteEndpoint
   * @return {!Promise<{
        result: !number,
        headers: ?string,
        preserveFragmentOnRedirectUrl: ?url.mojom.Url,
   *  }>}
   */

  onHeadersReceived(
      headers,
      remoteEndpoint) {
    return this.proxy.sendMessage(
        1,
        network.mojom.TrustedHeaderClient_OnHeadersReceived_ParamsSpec.$,
        network.mojom.TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec.$,
        [
          headers,
          remoteEndpoint
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TrustedHeaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.TrustedHeaderClientReceiver = class {
  /**
   * @param {!network.mojom.TrustedHeaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.TrustedHeaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.TrustedHeaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TrustedHeaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec.$,
        network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec.$,
        impl.onBeforeSendHeaders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.TrustedHeaderClient_OnHeadersReceived_ParamsSpec.$,
        network.mojom.TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec.$,
        impl.onHeadersReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.TrustedHeaderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TrustedHeaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.TrustedHeaderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.TrustedHeaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TrustedHeaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.TrustedHeaderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.TrustedHeaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TrustedHeaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeforeSendHeaders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec.$,
        network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec.$,
        this.onBeforeSendHeaders.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHeadersReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.TrustedHeaderClient_OnHeadersReceived_ParamsSpec.$,
        network.mojom.TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec.$,
        this.onHeadersReceived.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.TrustedURLLoaderHeaderClient');
goog.provide('network.mojom.TrustedURLLoaderHeaderClientReceiver');
goog.provide('network.mojom.TrustedURLLoaderHeaderClientCallbackRouter');
goog.provide('network.mojom.TrustedURLLoaderHeaderClientInterface');
goog.provide('network.mojom.TrustedURLLoaderHeaderClientRemote');
goog.provide('network.mojom.TrustedURLLoaderHeaderClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.TrustedURLLoaderHeaderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.TrustedURLLoaderHeaderClient.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.TrustedURLLoaderHeaderClientInterface = class {
  
  /**
   * @param { !number } requestId
   * @param { !network.mojom.TrustedHeaderClientPendingReceiver } headerClient
   */

  onLoaderCreated(requestId, headerClient) {}
  
  /**
   * @param { !network.mojom.URLRequest } request
   * @param { !network.mojom.TrustedHeaderClientPendingReceiver } headerClient
   */

  onLoaderForCorsPreflightCreated(request, headerClient) {}
};

/**
 * @export
 * @implements { network.mojom.TrustedURLLoaderHeaderClientInterface }
 */
network.mojom.TrustedURLLoaderHeaderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.TrustedURLLoaderHeaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.TrustedURLLoaderHeaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.TrustedURLLoaderHeaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } requestId
   * @param { !network.mojom.TrustedHeaderClientPendingReceiver } headerClient
   */

  onLoaderCreated(
      requestId,
      headerClient) {
    this.proxy.sendMessage(
        0,
        network.mojom.TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec.$,
        null,
        [
          requestId,
          headerClient
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLRequest } request
   * @param { !network.mojom.TrustedHeaderClientPendingReceiver } headerClient
   */

  onLoaderForCorsPreflightCreated(
      request,
      headerClient) {
    this.proxy.sendMessage(
        1,
        network.mojom.TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec.$,
        null,
        [
          request,
          headerClient
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TrustedURLLoaderHeaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.TrustedURLLoaderHeaderClientReceiver = class {
  /**
   * @param {!network.mojom.TrustedURLLoaderHeaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.TrustedURLLoaderHeaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.TrustedURLLoaderHeaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TrustedURLLoaderHeaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec.$,
        null,
        impl.onLoaderCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec.$,
        null,
        impl.onLoaderForCorsPreflightCreated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.TrustedURLLoaderHeaderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TrustedURLLoaderHeaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.TrustedURLLoaderHeaderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.TrustedURLLoaderHeaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TrustedURLLoaderHeaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.TrustedURLLoaderHeaderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.TrustedURLLoaderHeaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TrustedURLLoaderHeaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLoaderCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec.$,
        null,
        this.onLoaderCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLoaderForCorsPreflightCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec.$,
        null,
        this.onLoaderForCorsPreflightCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.PreloadedSharedDictionaryInfoHandle');
goog.provide('network.mojom.PreloadedSharedDictionaryInfoHandleReceiver');
goog.provide('network.mojom.PreloadedSharedDictionaryInfoHandleCallbackRouter');
goog.provide('network.mojom.PreloadedSharedDictionaryInfoHandleInterface');
goog.provide('network.mojom.PreloadedSharedDictionaryInfoHandleRemote');
goog.provide('network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.PreloadedSharedDictionaryInfoHandle.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.PreloadedSharedDictionaryInfoHandleInterface = class {
};

/**
 * @export
 * @implements { network.mojom.PreloadedSharedDictionaryInfoHandleInterface }
 */
network.mojom.PreloadedSharedDictionaryInfoHandleRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the PreloadedSharedDictionaryInfoHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.PreloadedSharedDictionaryInfoHandleReceiver = class {
  /**
   * @param {!network.mojom.PreloadedSharedDictionaryInfoHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.PreloadedSharedDictionaryInfoHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.PreloadedSharedDictionaryInfoHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.PreloadedSharedDictionaryInfoHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.PreloadedSharedDictionaryInfoHandle = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.PreloadedSharedDictionaryInfoHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.PreloadedSharedDictionaryInfoHandleRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.PreloadedSharedDictionaryInfoHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PreloadedSharedDictionaryInfoHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.PreloadedSharedDictionaryInfoHandleCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.PreloadedSharedDictionaryInfoHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.PreloadedSharedDictionaryInfoHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.DurableMessageCollector');
goog.provide('network.mojom.DurableMessageCollectorReceiver');
goog.provide('network.mojom.DurableMessageCollectorCallbackRouter');
goog.provide('network.mojom.DurableMessageCollectorInterface');
goog.provide('network.mojom.DurableMessageCollectorRemote');
goog.provide('network.mojom.DurableMessageCollectorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DurableMessageCollectorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DurableMessageCollector.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.DurableMessageCollectorInterface = class {
  
  /**
   * @param { !network.mojom.NetworkDurableMessageConfig } config
   */

  configure(config) {}
  
  /**
   * @param { !string } devtoolsRequestId
   * @return {!Promise<{
        message: ?mojoBase.mojom.BigBuffer,
   *  }>}
   */

  retrieve(devtoolsRequestId) {}
};

/**
 * @export
 * @implements { network.mojom.DurableMessageCollectorInterface }
 */
network.mojom.DurableMessageCollectorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DurableMessageCollectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DurableMessageCollectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DurableMessageCollectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.NetworkDurableMessageConfig } config
   */

  configure(
      config) {
    this.proxy.sendMessage(
        0,
        network.mojom.DurableMessageCollector_Configure_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !string } devtoolsRequestId
   * @return {!Promise<{
        message: ?mojoBase.mojom.BigBuffer,
   *  }>}
   */

  retrieve(
      devtoolsRequestId) {
    return this.proxy.sendMessage(
        1,
        network.mojom.DurableMessageCollector_Retrieve_ParamsSpec.$,
        network.mojom.DurableMessageCollector_Retrieve_ResponseParamsSpec.$,
        [
          devtoolsRequestId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DurableMessageCollector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DurableMessageCollectorReceiver = class {
  /**
   * @param {!network.mojom.DurableMessageCollectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DurableMessageCollectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DurableMessageCollectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DurableMessageCollectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DurableMessageCollector_Configure_ParamsSpec.$,
        null,
        impl.configure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.DurableMessageCollector_Retrieve_ParamsSpec.$,
        network.mojom.DurableMessageCollector_Retrieve_ResponseParamsSpec.$,
        impl.retrieve.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DurableMessageCollector = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DurableMessageCollector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DurableMessageCollectorRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DurableMessageCollectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DurableMessageCollector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DurableMessageCollectorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DurableMessageCollectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DurableMessageCollectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DurableMessageCollector_Configure_ParamsSpec.$,
        null,
        this.configure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.retrieve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.DurableMessageCollector_Retrieve_ParamsSpec.$,
        network.mojom.DurableMessageCollector_Retrieve_ResponseParamsSpec.$,
        this.retrieve.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.NetworkContext');
goog.provide('network.mojom.NetworkContextReceiver');
goog.provide('network.mojom.NetworkContextCallbackRouter');
goog.provide('network.mojom.NetworkContextInterface');
goog.provide('network.mojom.NetworkContextRemote');
goog.provide('network.mojom.NetworkContextPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.NetworkContextPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.NetworkContext.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.NetworkContextInterface = class {
  
  /**
   * @param { !network.mojom.NetworkContextClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @param { !network.mojom.URLLoaderFactoryPendingReceiver } urlLoaderFactory
   * @param { !network.mojom.URLLoaderFactoryParams } params
   */

  createURLLoaderFactory(urlLoaderFactory, params) {}
  
  /**
   */

  resetURLLoaderFactories() {}
  
  /**
   * @param { !network.mojom.ObliviousHttpRequest } request
   * @param { !network.mojom.ObliviousHttpClientRemote } client
   */

  getViaObliviousHttp(request, client) {}
  
  /**
   * @param { !network.mojom.CookieManagerPendingReceiver } cookieManager
   */

  getCookieManager(cookieManager) {}
  
  /**
   * @param { !network.mojom.RestrictedCookieManagerPendingReceiver } restrictedCookieManager
   * @param { !network.mojom.RestrictedCookieManagerRole } role
   * @param { !url.mojom.Origin } origin
   * @param { !network.mojom.IsolationInfo } isolationInfo
   * @param { !network.mojom.CookieSettingOverrides } cookieSettingOverrides
   * @param { !network.mojom.CookieSettingOverrides } devtoolsCookieSettingOverrides
   * @param { ?network.mojom.CookieAccessObserverRemote } cookieObserver
   */

  getRestrictedCookieManager(restrictedCookieManager, role, origin, isolationInfo, cookieSettingOverrides, devtoolsCookieSettingOverrides, cookieObserver) {}
  
  /**
   * @param { !network.mojom.TrustTokenQueryAnswererPendingReceiver } trustTokenQueryAnswerer
   * @param { !url.mojom.Origin } topFrameOrigin
   */

  getTrustTokenQueryAnswerer(trustTokenQueryAnswerer, topFrameOrigin) {}
  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearTrustTokenData(filter) {}
  
  /**
   * @return {!Promise<{
        anyDataDeleted: !boolean,
   *  }>}
   */

  clearTrustTokenSessionOnlyData() {}
  
  /**
   * @return {!Promise<{
        tokens: !Array<!network.mojom.StoredTrustTokensForIssuer>,
   *  }>}
   */

  getStoredTrustTokenCounts() {}
  
  /**
   * @return {!Promise<{
        issuerRedemptionRecordMap: !Map<!url.mojom.Origin, !Array<!network.mojom.ToplevelRedemptionRecord>>,
   *  }>}
   */

  getPrivateStateTokenRedemptionRecords() {}
  
  /**
   * @return {!Promise<{
        status: !ipProtection.mojom.IpProxyStatus,
   *  }>}
   */

  getIpProxyStatus() {}
  
  /**
   * @param { !boolean } bypassProxy
   */

  setBypassIpProtectionProxy(bypassProxy) {}
  
  /**
   * @param { !url.mojom.Origin } issuer
   * @return {!Promise<{
        status: !network.mojom.DeleteStoredTrustTokensStatus,
   *  }>}
   */

  deleteStoredTrustTokens(issuer) {}
  
  /**
   * @param { !boolean } block
   */

  setBlockTrustTokens(block) {}
  
  /**
   * @param { !Array<!contentSettings.mojom.ContentSettingPatternSource> } settings
   */

  setTrackingProtectionContentSetting(settings) {}
  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @return {!Promise}
   */

  clearNetworkingHistoryBetween(startTime, endTime) {}
  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHttpCache(startTime, endTime, filter) {}
  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @return {!Promise<{
        isUpperBound: !boolean,
        sizeOrError: !bigint,
   *  }>}
   */

  computeHttpCacheSize(startTime, endTime) {}
  
  /**
   */

  notifyBrowserIdle() {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } httpMethod
   * @param { !network.mojom.NetworkIsolationKey } key
   * @param { !boolean } includeCredentials
   */

  notifyExternalCacheHit(url, httpMethod, key, includeCredentials) {}
  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHostCache(filter) {}
  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHttpAuthCache(startTime, endTime, filter) {}
  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearCorsPreflightCache(filter) {}
  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearReportingCacheReports(filter) {}
  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearReportingCacheClients(filter) {}
  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearNetworkErrorLogging(filter) {}
  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @param { !network.mojom.NetworkContext_DomainReliabilityClearMode } mode
   * @return {!Promise}
   */

  clearDomainReliability(filter, mode) {}
  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearSharedDictionaryCache(startTime, endTime, filter) {}
  
  /**
   * @param { !network.mojom.SharedDictionaryIsolationKey } isolationKey
   * @return {!Promise}
   */

  clearSharedDictionaryCacheForIsolationKey(isolationKey) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } reportingSource
   * @param { !url.mojom.Origin } origin
   * @param { !network.mojom.IsolationInfo } isolationInfo
   * @param { !Object<!string, !string> } endpoints
   */

  setDocumentReportingEndpoints(reportingSource, origin, isolationInfo, endpoints) {}
  
  /**
   * @param { !Object<!string, !url.mojom.Url> } endpoints
   */

  setEnterpriseReportingEndpoints(endpoints) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } reportingSource
   */

  sendReportsAndRemoveSource(reportingSource) {}
  
  /**
   * @param { !string } type
   * @param { !string } group
   * @param { !url.mojom.Url } url
   * @param { ?mojoBase.mojom.UnguessableToken } reportingSource
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !mojoBase.mojom.DictionaryValue } body
   */

  queueReport(type, group, url, reportingSource, networkAnonymizationKey, body) {}
  
  /**
   * @param { !string } type
   * @param { !string } group
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.DictionaryValue } body
   */

  queueEnterpriseReport(type, group, url, body) {}
  
  /**
   * @param { !network.mojom.SignedExchangeReport } report
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   */

  queueSignedExchangeReport(report, networkAnonymizationKey) {}
  
  /**
   * @return {!Promise}
   */

  closeAllConnections() {}
  
  /**
   * @return {!Promise}
   */

  closeIdleConnections() {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } throttlingProfileId
   * @param { !Array<!network.mojom.MatchedNetworkConditions> } conditions
   */

  setNetworkConditions(throttlingProfileId, conditions) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } throttlingProfileId
   * @param { !network.mojom.DurableMessageCollectorPendingReceiver } receiver
   */

  enableDurableMessageCollector(throttlingProfileId, receiver) {}
  
  /**
   * @param { !string } newAcceptLanguage
   */

  setAcceptLanguage(newAcceptLanguage) {}
  
  /**
   * @param { !boolean } enableReferrers
   */

  setEnableReferrers(enableReferrers) {}
  
  /**
   * @param { !network.mojom.CTPolicy } ctPolicy
   */

  setCTPolicy(ctPolicy) {}
  
  /**
   * @param { !network.mojom.UDPSocketPendingReceiver } receiver
   * @param { ?network.mojom.UDPSocketListenerRemote } listener
   */

  createUDPSocket(receiver, listener) {}
  
  /**
   * @param { !network.mojom.IPEndPoint } addr
   * @param { !network.mojom.RestrictedUDPSocketMode } mode
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?network.mojom.RestrictedUDPSocketParams } params
   * @param { !network.mojom.RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network.mojom.UDPSocketListenerRemote } listener
   * @param { !boolean } allowMulticast
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network.mojom.IPEndPoint,
   *  }>}
   */

  createRestrictedUDPSocket(addr, mode, trafficAnnotation, params, receiver, listener, allowMulticast) {}
  
  /**
   * @param { !network.mojom.IPEndPoint } localAddr
   * @param { !network.mojom.TCPServerSocketOptions } options
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TCPServerSocketPendingReceiver } socket
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network.mojom.IPEndPoint,
   *  }>}
   */

  createTCPServerSocket(localAddr, options, trafficAnnotation, socket) {}
  
  /**
   * @param { ?network.mojom.IPEndPoint } localAddr
   * @param { !network.mojom.AddressList } remoteAddrList
   * @param { ?network.mojom.TCPConnectedSocketOptions } tcpConnectedSocketOptions
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TCPConnectedSocketPendingReceiver } socket
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
        peerAddr: ?network.mojom.IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  createTCPConnectedSocket(localAddr, remoteAddrList, tcpConnectedSocketOptions, trafficAnnotation, socket, observer) {}
  
  /**
   * @param { !network.mojom.IPEndPoint } localAddr
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TCPBoundSocketPendingReceiver } socket
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
   *  }>}
   */

  createTCPBoundSocket(localAddr, trafficAnnotation, socket) {}
  
  /**
   * @param { !network.mojom.ProxyResolvingSocketFactoryPendingReceiver } factory
   */

  createProxyResolvingSocketFactory(factory) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network.mojom.ProxyLookupClientRemote } proxyLookupClient
   */

  lookUpProxyForURL(url, networkAnonymizationKey, proxyLookupClient) {}
  
  /**
   * @return {!Promise}
   */

  forceReloadProxyConfig() {}
  
  /**
   * @return {!Promise}
   */

  clearBadProxiesCache() {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !Array<!string> } requestedProtocols
   * @param { !network.mojom.SiteForCookies } siteForCookies
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network.mojom.IsolationInfo } isolationInfo
   * @param { !Array<!network.mojom.HttpHeader> } additionalHeaders
   * @param { !number } processId
   * @param { !url.mojom.Origin } origin
   * @param { !network.mojom.ClientSecurityState } clientSecurityState
   * @param { !number } options
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.WebSocketHandshakeClientRemote } handshakeClient
   * @param { ?network.mojom.URLLoaderNetworkServiceObserverRemote } urlLoaderNetworkObserver
   * @param { ?network.mojom.WebSocketAuthenticationHandlerRemote } authHandler
   * @param { ?network.mojom.TrustedHeaderClientRemote } headerClient
   * @param { ?mojoBase.mojom.UnguessableToken } throttlingProfileId
   */

  createWebSocket(url, requestedProtocols, siteForCookies, storageAccessApiStatus, isolationInfo, additionalHeaders, processId, origin, clientSecurityState, options, trafficAnnotation, handshakeClient, urlLoaderNetworkObserver, authHandler, headerClient, throttlingProfileId) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !url.mojom.Origin } origin
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !Array<!network.mojom.WebTransportCertificateFingerprint> } fingerprints
   * @param { !Array<!string> } applicationProtocols
   * @param { !network.mojom.WebTransportHandshakeClientRemote } handshakeClient
   * @param { ?network.mojom.URLLoaderNetworkServiceObserverRemote } urlLoaderNetworkObserver
   * @param { !network.mojom.ClientSecurityState } clientSecurityState
   */

  createWebTransport(url, origin, networkAnonymizationKey, fingerprints, applicationProtocols, handshakeClient, urlLoaderNetworkObserver, clientSecurityState) {}
  
  /**
   * @param { !network.mojom.NetLogExporterPendingReceiver } receiver
   */

  createNetLogExporter(receiver) {}
  
  /**
   * @param { !number } numStreams
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.CredentialsMode } credentialsMode
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?network.mojom.ConnectionKeepAliveConfig } keepaliveConfig
   * @param { ?network.mojom.ConnectionChangeObserverClientRemote } observerClient
   */

  preconnectSockets(numStreams, url, credentialsMode, networkAnonymizationKey, trafficAnnotation, keepaliveConfig, observerClient) {}
  
  /**
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network.mojom.P2PTrustedSocketManagerClientRemote } client
   * @param { !network.mojom.P2PTrustedSocketManagerPendingReceiver } trustedSocketManager
   * @param { !network.mojom.P2PSocketManagerPendingReceiver } socketManager
   */

  createP2PSocketManager(networkAnonymizationKey, client, trustedSocketManager, socketManager) {}
  
  /**
   * @param { !network.mojom.MdnsResponderPendingReceiver } responderReceiver
   */

  createMdnsResponder(responderReceiver) {}
  
  /**
   * @param { !network.mojom.HostResolverHost } host
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?network.mojom.ResolveHostParameters } optionalParameters
   * @param { !network.mojom.ResolveHostClientRemote } responseClient
   */

  resolveHost(host, networkAnonymizationKey, optionalParameters, responseClient) {}
  
  /**
   * @param { ?network.mojom.DnsConfigOverrides } configOverrides
   * @param { !network.mojom.HostResolverPendingReceiver } hostResolver
   */

  createHostResolver(configOverrides, hostResolver) {}
  
  /**
   * @param { !network.mojom.X509Certificate } certificate
   * @param { !network.mojom.HostPortPair } hostPort
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
        cvResult: !network.mojom.CertVerifyResult,
        pkpBypassed: !boolean,
   *  }>}
   */

  verifyCert(certificate, hostPort, ocspResponse, sctList) {}
  
  /**
   * @param { !network.mojom.X509Certificate } certificate
   * @param { !network.mojom.HostPortPair } hostPort
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
        cvResult: !network.mojom.CertVerifyResult,
        pkpBypassed: !boolean,
   *  }>}
   */

  verifyCertForSignedExchange(certificate, hostPort, ocspResponse, sctList) {}
  
  /**
   * @param { !string } binding
   * @param { !string } hostname
   * @param { !network.mojom.X509Certificate } tlsCertificate
   * @return {!Promise<{
        verifiedCert: !network.mojom.X509Certificate,
   *  }>}
   */

  verify2QwacCertBinding(binding, hostname, tlsCertificate) {}
  
  /**
   * @param { !string } host
   * @param { !mojoBase.mojom.Time } expiry
   * @param { !boolean } includeSubdomains
   * @return {!Promise}
   */

  addHSTS(host, expiry, includeSubdomains) {}
  
  /**
   * @param { !string } host
   * @param { !boolean } isTopLevelNav
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isHSTSActiveForHost(host, isTopLevelNav) {}
  
  /**
   * @param { !string } domain
   * @return {!Promise<{
        state: !mojoBase.mojom.DictionaryValue,
   *  }>}
   */

  getHSTSState(domain) {}
  
  /**
   * @param { !url.mojom.Origin } sourceOrigin
   * @param { !Array<!network.mojom.CorsOriginPattern> } allowPatterns
   * @param { !Array<!network.mojom.CorsOriginPattern> } blockPatterns
   * @return {!Promise}
   */

  setCorsOriginAccessListsForOrigin(sourceOrigin, allowPatterns, blockPatterns) {}
  
  /**
   * @param { !string } host
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  deleteDynamicDataForHost(host) {}
  
  /**
   * @param { !boolean } splitAuthCacheByNetworkAnonymizationKey
   */

  setSplitAuthCacheByNetworkAnonymizationKey(splitAuthCacheByNetworkAnonymizationKey) {}
  
  /**
   * @return {!Promise<{
        cacheKey: !mojoBase.mojom.UnguessableToken,
   *  }>}
   */

  saveHttpAuthCacheProxyEntries() {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } cacheKey
   * @return {!Promise}
   */

  loadHttpAuthCacheProxyEntries(cacheKey) {}
  
  /**
   * @param { !network.mojom.AuthChallengeInfo } challenge
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network.mojom.AuthCredentials } credentials
   * @return {!Promise}
   */

  addAuthCacheEntry(challenge, networkAnonymizationKey, credentials) {}
  
  /**
   * @param { !boolean } value
   */

  setCorsNonWildcardRequestHeadersSupport(value) {}
  
  /**
   * @return {!Promise}
   */

  enableStaticKeyPinningForTesting() {}
  
  /**
   * @param { !network.mojom.X509Certificate } certificate
   * @param { !string } hostname
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
   *  }>}
   */

  verifyCertificateForTesting(certificate, hostname, ocspResponse, sctList) {}
  
  /**
   * @return {!Promise<{
        trustAnchorIds: !Array<!Array<!number>>,
   *  }>}
   */

  getTrustAnchorIDsForTesting() {}
  
  /**
   * @param { !url.mojom.Origin } origin
   * @param { !url.mojom.Url } uploadUrl
   * @return {!Promise}
   */

  addDomainReliabilityContextForTesting(origin, uploadUrl) {}
  
  /**
   * @return {!Promise}
   */

  forceDomainReliabilityUploadsForTesting() {}
  
  /**
   * @param { !network.mojom.SCTAuditingMode } mode
   */

  setSCTAuditingMode(mode) {}
  
  /**
   * @param { !network.mojom.ReportingApiObserverRemote } observer
   */

  addReportingApiObserver(observer) {}
  
  /**
   * @return {!Promise<{
        usageInfo: !Array<!network.mojom.SharedDictionaryUsageInfo>,
   *  }>}
   */

  getSharedDictionaryUsageInfo() {}
  
  /**
   * @param { !network.mojom.SharedDictionaryIsolationKey } isolationKey
   * @return {!Promise<{
        dictionaries: !Array<!network.mojom.SharedDictionaryInfo>,
   *  }>}
   */

  getSharedDictionaryInfo(isolationKey) {}
  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @return {!Promise<{
        origins: !Array<!url.mojom.Origin>,
   *  }>}
   */

  getSharedDictionaryOriginsBetween(startTime, endTime) {}
  
  /**
   * @param { !bigint } cacheMaxSize
   */

  setSharedDictionaryCacheMaxSize(cacheMaxSize) {}
  
  /**
   * @param { !Array<!url.mojom.Url> } urls
   * @param { !network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver } preloadHandle
   */

  preloadSharedDictionaryInfoForDocument(urls, preloadHandle) {}
  
  /**
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  hasPreloadedSharedDictionaryInfoForTesting() {}
  
  /**
   * @param { !network.mojom.HostPortPair } host
   * @param { !network.mojom.X509Certificate } certificate
   */

  flushCachedClientCertIfNeeded(host, certificate) {}
  
  /**
   * @param { !network.mojom.X509Certificate } certificate
   */

  flushMatchingCachedClientCert(certificate) {}
  
  /**
   * @param { ?string } label
   */

  setCookieDeprecationLabel(label) {}
  
  /**
   * @param { !Array<!mojoBase.mojom.UnguessableToken> } nonces
   * @return {!Promise}
   */

  revokeNetworkForNonces(nonces) {}
  
  /**
   * @param { !Array<!mojoBase.mojom.UnguessableToken> } nonces
   */

  clearNonces(nonces) {}
  
  /**
   * @param { !url.mojom.Url } exemptedUrl
   * @param { !mojoBase.mojom.UnguessableToken } nonce
   * @return {!Promise}
   */

  exemptUrlFromNetworkRevocationForNonce(exemptedUrl, nonce) {}
  
  /**
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network.mojom.URLRequest } request
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  prefetch(requestId, options, request, trafficAnnotation) {}
  
  /**
   * @return {!Promise<{
        boundNetwork: !bigint,
   *  }>}
   */

  getBoundNetworkForTesting() {}
  
  /**
   * @param { !network.mojom.DeviceBoundSessionManagerPendingReceiver } deviceBoundSessionManager
   */

  getDeviceBoundSessionManager(deviceBoundSessionManager) {}
  
  /**
   * @param { !Array<!url.mojom.SchemeHostPort> } origins
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   */

  addQuicHints(origins, networkAnonymizationKey) {}
};

/**
 * @export
 * @implements { network.mojom.NetworkContextInterface }
 */
network.mojom.NetworkContextRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.NetworkContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.NetworkContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.NetworkContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.NetworkContextClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        network.mojom.NetworkContext_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLLoaderFactoryPendingReceiver } urlLoaderFactory
   * @param { !network.mojom.URLLoaderFactoryParams } params
   */

  createURLLoaderFactory(
      urlLoaderFactory,
      params) {
    this.proxy.sendMessage(
        1,
        network.mojom.NetworkContext_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        [
          urlLoaderFactory,
          params
        ],
        false);
  }

  
  /**
   */

  resetURLLoaderFactories() {
    this.proxy.sendMessage(
        2,
        network.mojom.NetworkContext_ResetURLLoaderFactories_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.ObliviousHttpRequest } request
   * @param { !network.mojom.ObliviousHttpClientRemote } client
   */

  getViaObliviousHttp(
      request,
      client) {
    this.proxy.sendMessage(
        3,
        network.mojom.NetworkContext_GetViaObliviousHttp_ParamsSpec.$,
        null,
        [
          request,
          client
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CookieManagerPendingReceiver } cookieManager
   */

  getCookieManager(
      cookieManager) {
    this.proxy.sendMessage(
        4,
        network.mojom.NetworkContext_GetCookieManager_ParamsSpec.$,
        null,
        [
          cookieManager
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.RestrictedCookieManagerPendingReceiver } restrictedCookieManager
   * @param { !network.mojom.RestrictedCookieManagerRole } role
   * @param { !url.mojom.Origin } origin
   * @param { !network.mojom.IsolationInfo } isolationInfo
   * @param { !network.mojom.CookieSettingOverrides } cookieSettingOverrides
   * @param { !network.mojom.CookieSettingOverrides } devtoolsCookieSettingOverrides
   * @param { ?network.mojom.CookieAccessObserverRemote } cookieObserver
   */

  getRestrictedCookieManager(
      restrictedCookieManager,
      role,
      origin,
      isolationInfo,
      cookieSettingOverrides,
      devtoolsCookieSettingOverrides,
      cookieObserver) {
    this.proxy.sendMessage(
        5,
        network.mojom.NetworkContext_GetRestrictedCookieManager_ParamsSpec.$,
        null,
        [
          restrictedCookieManager,
          role,
          origin,
          isolationInfo,
          cookieSettingOverrides,
          devtoolsCookieSettingOverrides,
          cookieObserver
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.TrustTokenQueryAnswererPendingReceiver } trustTokenQueryAnswerer
   * @param { !url.mojom.Origin } topFrameOrigin
   */

  getTrustTokenQueryAnswerer(
      trustTokenQueryAnswerer,
      topFrameOrigin) {
    this.proxy.sendMessage(
        6,
        network.mojom.NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec.$,
        null,
        [
          trustTokenQueryAnswerer,
          topFrameOrigin
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearTrustTokenData(
      filter) {
    return this.proxy.sendMessage(
        7,
        network.mojom.NetworkContext_ClearTrustTokenData_ParamsSpec.$,
        network.mojom.NetworkContext_ClearTrustTokenData_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        anyDataDeleted: !boolean,
   *  }>}
   */

  clearTrustTokenSessionOnlyData() {
    return this.proxy.sendMessage(
        8,
        network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec.$,
        network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        tokens: !Array<!network.mojom.StoredTrustTokensForIssuer>,
   *  }>}
   */

  getStoredTrustTokenCounts() {
    return this.proxy.sendMessage(
        9,
        network.mojom.NetworkContext_GetStoredTrustTokenCounts_ParamsSpec.$,
        network.mojom.NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        issuerRedemptionRecordMap: !Map<!url.mojom.Origin, !Array<!network.mojom.ToplevelRedemptionRecord>>,
   *  }>}
   */

  getPrivateStateTokenRedemptionRecords() {
    return this.proxy.sendMessage(
        10,
        network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec.$,
        network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !ipProtection.mojom.IpProxyStatus,
   *  }>}
   */

  getIpProxyStatus() {
    return this.proxy.sendMessage(
        11,
        network.mojom.NetworkContext_GetIpProxyStatus_ParamsSpec.$,
        network.mojom.NetworkContext_GetIpProxyStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } bypassProxy
   */

  setBypassIpProtectionProxy(
      bypassProxy) {
    this.proxy.sendMessage(
        12,
        network.mojom.NetworkContext_SetBypassIpProtectionProxy_ParamsSpec.$,
        null,
        [
          bypassProxy
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } issuer
   * @return {!Promise<{
        status: !network.mojom.DeleteStoredTrustTokensStatus,
   *  }>}
   */

  deleteStoredTrustTokens(
      issuer) {
    return this.proxy.sendMessage(
        13,
        network.mojom.NetworkContext_DeleteStoredTrustTokens_ParamsSpec.$,
        network.mojom.NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec.$,
        [
          issuer
        ],
        false);
  }

  
  /**
   * @param { !boolean } block
   */

  setBlockTrustTokens(
      block) {
    this.proxy.sendMessage(
        14,
        network.mojom.NetworkContext_SetBlockTrustTokens_ParamsSpec.$,
        null,
        [
          block
        ],
        false);
  }

  
  /**
   * @param { !Array<!contentSettings.mojom.ContentSettingPatternSource> } settings
   */

  setTrackingProtectionContentSetting(
      settings) {
    this.proxy.sendMessage(
        15,
        network.mojom.NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @return {!Promise}
   */

  clearNetworkingHistoryBetween(
      startTime,
      endTime) {
    return this.proxy.sendMessage(
        16,
        network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec.$,
        network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec.$,
        [
          startTime,
          endTime
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHttpCache(
      startTime,
      endTime,
      filter) {
    return this.proxy.sendMessage(
        17,
        network.mojom.NetworkContext_ClearHttpCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHttpCache_ResponseParamsSpec.$,
        [
          startTime,
          endTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @return {!Promise<{
        isUpperBound: !boolean,
        sizeOrError: !bigint,
   *  }>}
   */

  computeHttpCacheSize(
      startTime,
      endTime) {
    return this.proxy.sendMessage(
        18,
        network.mojom.NetworkContext_ComputeHttpCacheSize_ParamsSpec.$,
        network.mojom.NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec.$,
        [
          startTime,
          endTime
        ],
        false);
  }

  
  /**
   */

  notifyBrowserIdle() {
    this.proxy.sendMessage(
        19,
        network.mojom.NetworkContext_NotifyBrowserIdle_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } httpMethod
   * @param { !network.mojom.NetworkIsolationKey } key
   * @param { !boolean } includeCredentials
   */

  notifyExternalCacheHit(
      url,
      httpMethod,
      key,
      includeCredentials) {
    this.proxy.sendMessage(
        20,
        network.mojom.NetworkContext_NotifyExternalCacheHit_ParamsSpec.$,
        null,
        [
          url,
          httpMethod,
          key,
          includeCredentials
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHostCache(
      filter) {
    return this.proxy.sendMessage(
        21,
        network.mojom.NetworkContext_ClearHostCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHostCache_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearHttpAuthCache(
      startTime,
      endTime,
      filter) {
    return this.proxy.sendMessage(
        22,
        network.mojom.NetworkContext_ClearHttpAuthCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHttpAuthCache_ResponseParamsSpec.$,
        [
          startTime,
          endTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearCorsPreflightCache(
      filter) {
    return this.proxy.sendMessage(
        23,
        network.mojom.NetworkContext_ClearCorsPreflightCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearReportingCacheReports(
      filter) {
    return this.proxy.sendMessage(
        24,
        network.mojom.NetworkContext_ClearReportingCacheReports_ParamsSpec.$,
        network.mojom.NetworkContext_ClearReportingCacheReports_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearReportingCacheClients(
      filter) {
    return this.proxy.sendMessage(
        25,
        network.mojom.NetworkContext_ClearReportingCacheClients_ParamsSpec.$,
        network.mojom.NetworkContext_ClearReportingCacheClients_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearNetworkErrorLogging(
      filter) {
    return this.proxy.sendMessage(
        26,
        network.mojom.NetworkContext_ClearNetworkErrorLogging_ParamsSpec.$,
        network.mojom.NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.ClearDataFilter } filter
   * @param { !network.mojom.NetworkContext_DomainReliabilityClearMode } mode
   * @return {!Promise}
   */

  clearDomainReliability(
      filter,
      mode) {
    return this.proxy.sendMessage(
        27,
        network.mojom.NetworkContext_ClearDomainReliability_ParamsSpec.$,
        network.mojom.NetworkContext_ClearDomainReliability_ResponseParamsSpec.$,
        [
          filter,
          mode
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  clearSharedDictionaryCache(
      startTime,
      endTime,
      filter) {
    return this.proxy.sendMessage(
        28,
        network.mojom.NetworkContext_ClearSharedDictionaryCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec.$,
        [
          startTime,
          endTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SharedDictionaryIsolationKey } isolationKey
   * @return {!Promise}
   */

  clearSharedDictionaryCacheForIsolationKey(
      isolationKey) {
    return this.proxy.sendMessage(
        29,
        network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec.$,
        network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec.$,
        [
          isolationKey
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } reportingSource
   * @param { !url.mojom.Origin } origin
   * @param { !network.mojom.IsolationInfo } isolationInfo
   * @param { !Object<!string, !string> } endpoints
   */

  setDocumentReportingEndpoints(
      reportingSource,
      origin,
      isolationInfo,
      endpoints) {
    this.proxy.sendMessage(
        30,
        network.mojom.NetworkContext_SetDocumentReportingEndpoints_ParamsSpec.$,
        null,
        [
          reportingSource,
          origin,
          isolationInfo,
          endpoints
        ],
        false);
  }

  
  /**
   * @param { !Object<!string, !url.mojom.Url> } endpoints
   */

  setEnterpriseReportingEndpoints(
      endpoints) {
    this.proxy.sendMessage(
        31,
        network.mojom.NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec.$,
        null,
        [
          endpoints
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } reportingSource
   */

  sendReportsAndRemoveSource(
      reportingSource) {
    this.proxy.sendMessage(
        32,
        network.mojom.NetworkContext_SendReportsAndRemoveSource_ParamsSpec.$,
        null,
        [
          reportingSource
        ],
        false);
  }

  
  /**
   * @param { !string } type
   * @param { !string } group
   * @param { !url.mojom.Url } url
   * @param { ?mojoBase.mojom.UnguessableToken } reportingSource
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !mojoBase.mojom.DictionaryValue } body
   */

  queueReport(
      type,
      group,
      url,
      reportingSource,
      networkAnonymizationKey,
      body) {
    this.proxy.sendMessage(
        33,
        network.mojom.NetworkContext_QueueReport_ParamsSpec.$,
        null,
        [
          type,
          group,
          url,
          reportingSource,
          networkAnonymizationKey,
          body
        ],
        false);
  }

  
  /**
   * @param { !string } type
   * @param { !string } group
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.DictionaryValue } body
   */

  queueEnterpriseReport(
      type,
      group,
      url,
      body) {
    this.proxy.sendMessage(
        34,
        network.mojom.NetworkContext_QueueEnterpriseReport_ParamsSpec.$,
        null,
        [
          type,
          group,
          url,
          body
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SignedExchangeReport } report
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   */

  queueSignedExchangeReport(
      report,
      networkAnonymizationKey) {
    this.proxy.sendMessage(
        35,
        network.mojom.NetworkContext_QueueSignedExchangeReport_ParamsSpec.$,
        null,
        [
          report,
          networkAnonymizationKey
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  closeAllConnections() {
    return this.proxy.sendMessage(
        36,
        network.mojom.NetworkContext_CloseAllConnections_ParamsSpec.$,
        network.mojom.NetworkContext_CloseAllConnections_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  closeIdleConnections() {
    return this.proxy.sendMessage(
        37,
        network.mojom.NetworkContext_CloseIdleConnections_ParamsSpec.$,
        network.mojom.NetworkContext_CloseIdleConnections_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } throttlingProfileId
   * @param { !Array<!network.mojom.MatchedNetworkConditions> } conditions
   */

  setNetworkConditions(
      throttlingProfileId,
      conditions) {
    this.proxy.sendMessage(
        38,
        network.mojom.NetworkContext_SetNetworkConditions_ParamsSpec.$,
        null,
        [
          throttlingProfileId,
          conditions
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } throttlingProfileId
   * @param { !network.mojom.DurableMessageCollectorPendingReceiver } receiver
   */

  enableDurableMessageCollector(
      throttlingProfileId,
      receiver) {
    this.proxy.sendMessage(
        39,
        network.mojom.NetworkContext_EnableDurableMessageCollector_ParamsSpec.$,
        null,
        [
          throttlingProfileId,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !string } newAcceptLanguage
   */

  setAcceptLanguage(
      newAcceptLanguage) {
    this.proxy.sendMessage(
        40,
        network.mojom.NetworkContext_SetAcceptLanguage_ParamsSpec.$,
        null,
        [
          newAcceptLanguage
        ],
        false);
  }

  
  /**
   * @param { !boolean } enableReferrers
   */

  setEnableReferrers(
      enableReferrers) {
    this.proxy.sendMessage(
        41,
        network.mojom.NetworkContext_SetEnableReferrers_ParamsSpec.$,
        null,
        [
          enableReferrers
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CTPolicy } ctPolicy
   */

  setCTPolicy(
      ctPolicy) {
    this.proxy.sendMessage(
        42,
        network.mojom.NetworkContext_SetCTPolicy_ParamsSpec.$,
        null,
        [
          ctPolicy
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.UDPSocketPendingReceiver } receiver
   * @param { ?network.mojom.UDPSocketListenerRemote } listener
   */

  createUDPSocket(
      receiver,
      listener) {
    this.proxy.sendMessage(
        43,
        network.mojom.NetworkContext_CreateUDPSocket_ParamsSpec.$,
        null,
        [
          receiver,
          listener
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPEndPoint } addr
   * @param { !network.mojom.RestrictedUDPSocketMode } mode
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?network.mojom.RestrictedUDPSocketParams } params
   * @param { !network.mojom.RestrictedUDPSocketPendingReceiver } receiver
   * @param { ?network.mojom.UDPSocketListenerRemote } listener
   * @param { !boolean } allowMulticast
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network.mojom.IPEndPoint,
   *  }>}
   */

  createRestrictedUDPSocket(
      addr,
      mode,
      trafficAnnotation,
      params,
      receiver,
      listener,
      allowMulticast) {
    return this.proxy.sendMessage(
        44,
        network.mojom.NetworkContext_CreateRestrictedUDPSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec.$,
        [
          addr,
          mode,
          trafficAnnotation,
          params,
          receiver,
          listener,
          allowMulticast
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPEndPoint } localAddr
   * @param { !network.mojom.TCPServerSocketOptions } options
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TCPServerSocketPendingReceiver } socket
   * @return {!Promise<{
        result: !number,
        localAddrOut: ?network.mojom.IPEndPoint,
   *  }>}
   */

  createTCPServerSocket(
      localAddr,
      options,
      trafficAnnotation,
      socket) {
    return this.proxy.sendMessage(
        45,
        network.mojom.NetworkContext_CreateTCPServerSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPServerSocket_ResponseParamsSpec.$,
        [
          localAddr,
          options,
          trafficAnnotation,
          socket
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.IPEndPoint } localAddr
   * @param { !network.mojom.AddressList } remoteAddrList
   * @param { ?network.mojom.TCPConnectedSocketOptions } tcpConnectedSocketOptions
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TCPConnectedSocketPendingReceiver } socket
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
        peerAddr: ?network.mojom.IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  createTCPConnectedSocket(
      localAddr,
      remoteAddrList,
      tcpConnectedSocketOptions,
      trafficAnnotation,
      socket,
      observer) {
    return this.proxy.sendMessage(
        46,
        network.mojom.NetworkContext_CreateTCPConnectedSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec.$,
        [
          localAddr,
          remoteAddrList,
          tcpConnectedSocketOptions,
          trafficAnnotation,
          socket,
          observer
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPEndPoint } localAddr
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TCPBoundSocketPendingReceiver } socket
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
   *  }>}
   */

  createTCPBoundSocket(
      localAddr,
      trafficAnnotation,
      socket) {
    return this.proxy.sendMessage(
        47,
        network.mojom.NetworkContext_CreateTCPBoundSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec.$,
        [
          localAddr,
          trafficAnnotation,
          socket
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.ProxyResolvingSocketFactoryPendingReceiver } factory
   */

  createProxyResolvingSocketFactory(
      factory) {
    this.proxy.sendMessage(
        48,
        network.mojom.NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec.$,
        null,
        [
          factory
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network.mojom.ProxyLookupClientRemote } proxyLookupClient
   */

  lookUpProxyForURL(
      url,
      networkAnonymizationKey,
      proxyLookupClient) {
    this.proxy.sendMessage(
        49,
        network.mojom.NetworkContext_LookUpProxyForURL_ParamsSpec.$,
        null,
        [
          url,
          networkAnonymizationKey,
          proxyLookupClient
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  forceReloadProxyConfig() {
    return this.proxy.sendMessage(
        50,
        network.mojom.NetworkContext_ForceReloadProxyConfig_ParamsSpec.$,
        network.mojom.NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  clearBadProxiesCache() {
    return this.proxy.sendMessage(
        51,
        network.mojom.NetworkContext_ClearBadProxiesCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearBadProxiesCache_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !Array<!string> } requestedProtocols
   * @param { !network.mojom.SiteForCookies } siteForCookies
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network.mojom.IsolationInfo } isolationInfo
   * @param { !Array<!network.mojom.HttpHeader> } additionalHeaders
   * @param { !number } processId
   * @param { !url.mojom.Origin } origin
   * @param { !network.mojom.ClientSecurityState } clientSecurityState
   * @param { !number } options
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.WebSocketHandshakeClientRemote } handshakeClient
   * @param { ?network.mojom.URLLoaderNetworkServiceObserverRemote } urlLoaderNetworkObserver
   * @param { ?network.mojom.WebSocketAuthenticationHandlerRemote } authHandler
   * @param { ?network.mojom.TrustedHeaderClientRemote } headerClient
   * @param { ?mojoBase.mojom.UnguessableToken } throttlingProfileId
   */

  createWebSocket(
      url,
      requestedProtocols,
      siteForCookies,
      storageAccessApiStatus,
      isolationInfo,
      additionalHeaders,
      processId,
      origin,
      clientSecurityState,
      options,
      trafficAnnotation,
      handshakeClient,
      urlLoaderNetworkObserver,
      authHandler,
      headerClient,
      throttlingProfileId) {
    this.proxy.sendMessage(
        52,
        network.mojom.NetworkContext_CreateWebSocket_ParamsSpec.$,
        null,
        [
          url,
          requestedProtocols,
          siteForCookies,
          storageAccessApiStatus,
          isolationInfo,
          additionalHeaders,
          processId,
          origin,
          clientSecurityState,
          options,
          trafficAnnotation,
          handshakeClient,
          urlLoaderNetworkObserver,
          authHandler,
          headerClient,
          throttlingProfileId
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !url.mojom.Origin } origin
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !Array<!network.mojom.WebTransportCertificateFingerprint> } fingerprints
   * @param { !Array<!string> } applicationProtocols
   * @param { !network.mojom.WebTransportHandshakeClientRemote } handshakeClient
   * @param { ?network.mojom.URLLoaderNetworkServiceObserverRemote } urlLoaderNetworkObserver
   * @param { !network.mojom.ClientSecurityState } clientSecurityState
   */

  createWebTransport(
      url,
      origin,
      networkAnonymizationKey,
      fingerprints,
      applicationProtocols,
      handshakeClient,
      urlLoaderNetworkObserver,
      clientSecurityState) {
    this.proxy.sendMessage(
        53,
        network.mojom.NetworkContext_CreateWebTransport_ParamsSpec.$,
        null,
        [
          url,
          origin,
          networkAnonymizationKey,
          fingerprints,
          applicationProtocols,
          handshakeClient,
          urlLoaderNetworkObserver,
          clientSecurityState
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetLogExporterPendingReceiver } receiver
   */

  createNetLogExporter(
      receiver) {
    this.proxy.sendMessage(
        54,
        network.mojom.NetworkContext_CreateNetLogExporter_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !number } numStreams
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.CredentialsMode } credentialsMode
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?network.mojom.ConnectionKeepAliveConfig } keepaliveConfig
   * @param { ?network.mojom.ConnectionChangeObserverClientRemote } observerClient
   */

  preconnectSockets(
      numStreams,
      url,
      credentialsMode,
      networkAnonymizationKey,
      trafficAnnotation,
      keepaliveConfig,
      observerClient) {
    this.proxy.sendMessage(
        55,
        network.mojom.NetworkContext_PreconnectSockets_ParamsSpec.$,
        null,
        [
          numStreams,
          url,
          credentialsMode,
          networkAnonymizationKey,
          trafficAnnotation,
          keepaliveConfig,
          observerClient
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network.mojom.P2PTrustedSocketManagerClientRemote } client
   * @param { !network.mojom.P2PTrustedSocketManagerPendingReceiver } trustedSocketManager
   * @param { !network.mojom.P2PSocketManagerPendingReceiver } socketManager
   */

  createP2PSocketManager(
      networkAnonymizationKey,
      client,
      trustedSocketManager,
      socketManager) {
    this.proxy.sendMessage(
        56,
        network.mojom.NetworkContext_CreateP2PSocketManager_ParamsSpec.$,
        null,
        [
          networkAnonymizationKey,
          client,
          trustedSocketManager,
          socketManager
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.MdnsResponderPendingReceiver } responderReceiver
   */

  createMdnsResponder(
      responderReceiver) {
    this.proxy.sendMessage(
        57,
        network.mojom.NetworkContext_CreateMdnsResponder_ParamsSpec.$,
        null,
        [
          responderReceiver
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.HostResolverHost } host
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?network.mojom.ResolveHostParameters } optionalParameters
   * @param { !network.mojom.ResolveHostClientRemote } responseClient
   */

  resolveHost(
      host,
      networkAnonymizationKey,
      optionalParameters,
      responseClient) {
    this.proxy.sendMessage(
        58,
        network.mojom.NetworkContext_ResolveHost_ParamsSpec.$,
        null,
        [
          host,
          networkAnonymizationKey,
          optionalParameters,
          responseClient
        ],
        false);
  }

  
  /**
   * @param { ?network.mojom.DnsConfigOverrides } configOverrides
   * @param { !network.mojom.HostResolverPendingReceiver } hostResolver
   */

  createHostResolver(
      configOverrides,
      hostResolver) {
    this.proxy.sendMessage(
        59,
        network.mojom.NetworkContext_CreateHostResolver_ParamsSpec.$,
        null,
        [
          configOverrides,
          hostResolver
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.X509Certificate } certificate
   * @param { !network.mojom.HostPortPair } hostPort
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
        cvResult: !network.mojom.CertVerifyResult,
        pkpBypassed: !boolean,
   *  }>}
   */

  verifyCert(
      certificate,
      hostPort,
      ocspResponse,
      sctList) {
    return this.proxy.sendMessage(
        60,
        network.mojom.NetworkContext_VerifyCert_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCert_ResponseParamsSpec.$,
        [
          certificate,
          hostPort,
          ocspResponse,
          sctList
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.X509Certificate } certificate
   * @param { !network.mojom.HostPortPair } hostPort
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
        cvResult: !network.mojom.CertVerifyResult,
        pkpBypassed: !boolean,
   *  }>}
   */

  verifyCertForSignedExchange(
      certificate,
      hostPort,
      ocspResponse,
      sctList) {
    return this.proxy.sendMessage(
        61,
        network.mojom.NetworkContext_VerifyCertForSignedExchange_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec.$,
        [
          certificate,
          hostPort,
          ocspResponse,
          sctList
        ],
        false);
  }

  
  /**
   * @param { !string } binding
   * @param { !string } hostname
   * @param { !network.mojom.X509Certificate } tlsCertificate
   * @return {!Promise<{
        verifiedCert: !network.mojom.X509Certificate,
   *  }>}
   */

  verify2QwacCertBinding(
      binding,
      hostname,
      tlsCertificate) {
    return this.proxy.sendMessage(
        62,
        network.mojom.NetworkContext_Verify2QwacCertBinding_ParamsSpec.$,
        network.mojom.NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec.$,
        [
          binding,
          hostname,
          tlsCertificate
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @param { !mojoBase.mojom.Time } expiry
   * @param { !boolean } includeSubdomains
   * @return {!Promise}
   */

  addHSTS(
      host,
      expiry,
      includeSubdomains) {
    return this.proxy.sendMessage(
        63,
        network.mojom.NetworkContext_AddHSTS_ParamsSpec.$,
        network.mojom.NetworkContext_AddHSTS_ResponseParamsSpec.$,
        [
          host,
          expiry,
          includeSubdomains
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @param { !boolean } isTopLevelNav
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isHSTSActiveForHost(
      host,
      isTopLevelNav) {
    return this.proxy.sendMessage(
        64,
        network.mojom.NetworkContext_IsHSTSActiveForHost_ParamsSpec.$,
        network.mojom.NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec.$,
        [
          host,
          isTopLevelNav
        ],
        false);
  }

  
  /**
   * @param { !string } domain
   * @return {!Promise<{
        state: !mojoBase.mojom.DictionaryValue,
   *  }>}
   */

  getHSTSState(
      domain) {
    return this.proxy.sendMessage(
        65,
        network.mojom.NetworkContext_GetHSTSState_ParamsSpec.$,
        network.mojom.NetworkContext_GetHSTSState_ResponseParamsSpec.$,
        [
          domain
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } sourceOrigin
   * @param { !Array<!network.mojom.CorsOriginPattern> } allowPatterns
   * @param { !Array<!network.mojom.CorsOriginPattern> } blockPatterns
   * @return {!Promise}
   */

  setCorsOriginAccessListsForOrigin(
      sourceOrigin,
      allowPatterns,
      blockPatterns) {
    return this.proxy.sendMessage(
        66,
        network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec.$,
        network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec.$,
        [
          sourceOrigin,
          allowPatterns,
          blockPatterns
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  deleteDynamicDataForHost(
      host) {
    return this.proxy.sendMessage(
        67,
        network.mojom.NetworkContext_DeleteDynamicDataForHost_ParamsSpec.$,
        network.mojom.NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec.$,
        [
          host
        ],
        false);
  }

  
  /**
   * @param { !boolean } splitAuthCacheByNetworkAnonymizationKey
   */

  setSplitAuthCacheByNetworkAnonymizationKey(
      splitAuthCacheByNetworkAnonymizationKey) {
    this.proxy.sendMessage(
        68,
        network.mojom.NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec.$,
        null,
        [
          splitAuthCacheByNetworkAnonymizationKey
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        cacheKey: !mojoBase.mojom.UnguessableToken,
   *  }>}
   */

  saveHttpAuthCacheProxyEntries() {
    return this.proxy.sendMessage(
        69,
        network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec.$,
        network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } cacheKey
   * @return {!Promise}
   */

  loadHttpAuthCacheProxyEntries(
      cacheKey) {
    return this.proxy.sendMessage(
        70,
        network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec.$,
        network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        [
          cacheKey
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.AuthChallengeInfo } challenge
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !network.mojom.AuthCredentials } credentials
   * @return {!Promise}
   */

  addAuthCacheEntry(
      challenge,
      networkAnonymizationKey,
      credentials) {
    return this.proxy.sendMessage(
        71,
        network.mojom.NetworkContext_AddAuthCacheEntry_ParamsSpec.$,
        network.mojom.NetworkContext_AddAuthCacheEntry_ResponseParamsSpec.$,
        [
          challenge,
          networkAnonymizationKey,
          credentials
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  setCorsNonWildcardRequestHeadersSupport(
      value) {
    this.proxy.sendMessage(
        72,
        network.mojom.NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  enableStaticKeyPinningForTesting() {
    return this.proxy.sendMessage(
        73,
        network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.X509Certificate } certificate
   * @param { !string } hostname
   * @param { !string } ocspResponse
   * @param { !string } sctList
   * @return {!Promise<{
        errorCode: !number,
   *  }>}
   */

  verifyCertificateForTesting(
      certificate,
      hostname,
      ocspResponse,
      sctList) {
    return this.proxy.sendMessage(
        74,
        network.mojom.NetworkContext_VerifyCertificateForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec.$,
        [
          certificate,
          hostname,
          ocspResponse,
          sctList
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        trustAnchorIds: !Array<!Array<!number>>,
   *  }>}
   */

  getTrustAnchorIDsForTesting() {
    return this.proxy.sendMessage(
        75,
        network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } origin
   * @param { !url.mojom.Url } uploadUrl
   * @return {!Promise}
   */

  addDomainReliabilityContextForTesting(
      origin,
      uploadUrl) {
    return this.proxy.sendMessage(
        76,
        network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec.$,
        [
          origin,
          uploadUrl
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  forceDomainReliabilityUploadsForTesting() {
    return this.proxy.sendMessage(
        77,
        network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SCTAuditingMode } mode
   */

  setSCTAuditingMode(
      mode) {
    this.proxy.sendMessage(
        78,
        network.mojom.NetworkContext_SetSCTAuditingMode_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.ReportingApiObserverRemote } observer
   */

  addReportingApiObserver(
      observer) {
    this.proxy.sendMessage(
        79,
        network.mojom.NetworkContext_AddReportingApiObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        usageInfo: !Array<!network.mojom.SharedDictionaryUsageInfo>,
   *  }>}
   */

  getSharedDictionaryUsageInfo() {
    return this.proxy.sendMessage(
        80,
        network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SharedDictionaryIsolationKey } isolationKey
   * @return {!Promise<{
        dictionaries: !Array<!network.mojom.SharedDictionaryInfo>,
   *  }>}
   */

  getSharedDictionaryInfo(
      isolationKey) {
    return this.proxy.sendMessage(
        81,
        network.mojom.NetworkContext_GetSharedDictionaryInfo_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec.$,
        [
          isolationKey
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Time } startTime
   * @param { !mojoBase.mojom.Time } endTime
   * @return {!Promise<{
        origins: !Array<!url.mojom.Origin>,
   *  }>}
   */

  getSharedDictionaryOriginsBetween(
      startTime,
      endTime) {
    return this.proxy.sendMessage(
        82,
        network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec.$,
        [
          startTime,
          endTime
        ],
        false);
  }

  
  /**
   * @param { !bigint } cacheMaxSize
   */

  setSharedDictionaryCacheMaxSize(
      cacheMaxSize) {
    this.proxy.sendMessage(
        83,
        network.mojom.NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec.$,
        null,
        [
          cacheMaxSize
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.Url> } urls
   * @param { !network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver } preloadHandle
   */

  preloadSharedDictionaryInfoForDocument(
      urls,
      preloadHandle) {
    this.proxy.sendMessage(
        84,
        network.mojom.NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec.$,
        null,
        [
          urls,
          preloadHandle
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        value: !boolean,
   *  }>}
   */

  hasPreloadedSharedDictionaryInfoForTesting() {
    return this.proxy.sendMessage(
        85,
        network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.HostPortPair } host
   * @param { !network.mojom.X509Certificate } certificate
   */

  flushCachedClientCertIfNeeded(
      host,
      certificate) {
    this.proxy.sendMessage(
        86,
        network.mojom.NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec.$,
        null,
        [
          host,
          certificate
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.X509Certificate } certificate
   */

  flushMatchingCachedClientCert(
      certificate) {
    this.proxy.sendMessage(
        87,
        network.mojom.NetworkContext_FlushMatchingCachedClientCert_ParamsSpec.$,
        null,
        [
          certificate
        ],
        false);
  }

  
  /**
   * @param { ?string } label
   */

  setCookieDeprecationLabel(
      label) {
    this.proxy.sendMessage(
        88,
        network.mojom.NetworkContext_SetCookieDeprecationLabel_ParamsSpec.$,
        null,
        [
          label
        ],
        false);
  }

  
  /**
   * @param { !Array<!mojoBase.mojom.UnguessableToken> } nonces
   * @return {!Promise}
   */

  revokeNetworkForNonces(
      nonces) {
    return this.proxy.sendMessage(
        89,
        network.mojom.NetworkContext_RevokeNetworkForNonces_ParamsSpec.$,
        network.mojom.NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec.$,
        [
          nonces
        ],
        false);
  }

  
  /**
   * @param { !Array<!mojoBase.mojom.UnguessableToken> } nonces
   */

  clearNonces(
      nonces) {
    this.proxy.sendMessage(
        90,
        network.mojom.NetworkContext_ClearNonces_ParamsSpec.$,
        null,
        [
          nonces
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } exemptedUrl
   * @param { !mojoBase.mojom.UnguessableToken } nonce
   * @return {!Promise}
   */

  exemptUrlFromNetworkRevocationForNonce(
      exemptedUrl,
      nonce) {
    return this.proxy.sendMessage(
        91,
        network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec.$,
        network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec.$,
        [
          exemptedUrl,
          nonce
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network.mojom.URLRequest } request
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  prefetch(
      requestId,
      options,
      request,
      trafficAnnotation) {
    this.proxy.sendMessage(
        92,
        network.mojom.NetworkContext_Prefetch_ParamsSpec.$,
        null,
        [
          requestId,
          options,
          request,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        boundNetwork: !bigint,
   *  }>}
   */

  getBoundNetworkForTesting() {
    return this.proxy.sendMessage(
        93,
        network.mojom.NetworkContext_GetBoundNetworkForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionManagerPendingReceiver } deviceBoundSessionManager
   */

  getDeviceBoundSessionManager(
      deviceBoundSessionManager) {
    this.proxy.sendMessage(
        94,
        network.mojom.NetworkContext_GetDeviceBoundSessionManager_ParamsSpec.$,
        null,
        [
          deviceBoundSessionManager
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.SchemeHostPort> } origins
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   */

  addQuicHints(
      origins,
      networkAnonymizationKey) {
    this.proxy.sendMessage(
        95,
        network.mojom.NetworkContext_AddQuicHints_ParamsSpec.$,
        null,
        [
          origins,
          networkAnonymizationKey
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NetworkContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.NetworkContextReceiver = class {
  /**
   * @param {!network.mojom.NetworkContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.NetworkContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.NetworkContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkContext_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.NetworkContext_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        impl.createURLLoaderFactory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.NetworkContext_ResetURLLoaderFactories_ParamsSpec.$,
        null,
        impl.resetURLLoaderFactories.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.NetworkContext_GetViaObliviousHttp_ParamsSpec.$,
        null,
        impl.getViaObliviousHttp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.NetworkContext_GetCookieManager_ParamsSpec.$,
        null,
        impl.getCookieManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.NetworkContext_GetRestrictedCookieManager_ParamsSpec.$,
        null,
        impl.getRestrictedCookieManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec.$,
        null,
        impl.getTrustTokenQueryAnswerer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.NetworkContext_ClearTrustTokenData_ParamsSpec.$,
        network.mojom.NetworkContext_ClearTrustTokenData_ResponseParamsSpec.$,
        impl.clearTrustTokenData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec.$,
        network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec.$,
        impl.clearTrustTokenSessionOnlyData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        network.mojom.NetworkContext_GetStoredTrustTokenCounts_ParamsSpec.$,
        network.mojom.NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec.$,
        impl.getStoredTrustTokenCounts.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec.$,
        network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec.$,
        impl.getPrivateStateTokenRedemptionRecords.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        network.mojom.NetworkContext_GetIpProxyStatus_ParamsSpec.$,
        network.mojom.NetworkContext_GetIpProxyStatus_ResponseParamsSpec.$,
        impl.getIpProxyStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        network.mojom.NetworkContext_SetBypassIpProtectionProxy_ParamsSpec.$,
        null,
        impl.setBypassIpProtectionProxy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        network.mojom.NetworkContext_DeleteStoredTrustTokens_ParamsSpec.$,
        network.mojom.NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec.$,
        impl.deleteStoredTrustTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        network.mojom.NetworkContext_SetBlockTrustTokens_ParamsSpec.$,
        null,
        impl.setBlockTrustTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        network.mojom.NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec.$,
        null,
        impl.setTrackingProtectionContentSetting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec.$,
        network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec.$,
        impl.clearNetworkingHistoryBetween.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        network.mojom.NetworkContext_ClearHttpCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHttpCache_ResponseParamsSpec.$,
        impl.clearHttpCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        network.mojom.NetworkContext_ComputeHttpCacheSize_ParamsSpec.$,
        network.mojom.NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec.$,
        impl.computeHttpCacheSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        network.mojom.NetworkContext_NotifyBrowserIdle_ParamsSpec.$,
        null,
        impl.notifyBrowserIdle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        network.mojom.NetworkContext_NotifyExternalCacheHit_ParamsSpec.$,
        null,
        impl.notifyExternalCacheHit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        network.mojom.NetworkContext_ClearHostCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHostCache_ResponseParamsSpec.$,
        impl.clearHostCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        network.mojom.NetworkContext_ClearHttpAuthCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHttpAuthCache_ResponseParamsSpec.$,
        impl.clearHttpAuthCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        network.mojom.NetworkContext_ClearCorsPreflightCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec.$,
        impl.clearCorsPreflightCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        network.mojom.NetworkContext_ClearReportingCacheReports_ParamsSpec.$,
        network.mojom.NetworkContext_ClearReportingCacheReports_ResponseParamsSpec.$,
        impl.clearReportingCacheReports.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        network.mojom.NetworkContext_ClearReportingCacheClients_ParamsSpec.$,
        network.mojom.NetworkContext_ClearReportingCacheClients_ResponseParamsSpec.$,
        impl.clearReportingCacheClients.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        network.mojom.NetworkContext_ClearNetworkErrorLogging_ParamsSpec.$,
        network.mojom.NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec.$,
        impl.clearNetworkErrorLogging.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        network.mojom.NetworkContext_ClearDomainReliability_ParamsSpec.$,
        network.mojom.NetworkContext_ClearDomainReliability_ResponseParamsSpec.$,
        impl.clearDomainReliability.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        network.mojom.NetworkContext_ClearSharedDictionaryCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec.$,
        impl.clearSharedDictionaryCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec.$,
        network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec.$,
        impl.clearSharedDictionaryCacheForIsolationKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        network.mojom.NetworkContext_SetDocumentReportingEndpoints_ParamsSpec.$,
        null,
        impl.setDocumentReportingEndpoints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        network.mojom.NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec.$,
        null,
        impl.setEnterpriseReportingEndpoints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        network.mojom.NetworkContext_SendReportsAndRemoveSource_ParamsSpec.$,
        null,
        impl.sendReportsAndRemoveSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        network.mojom.NetworkContext_QueueReport_ParamsSpec.$,
        null,
        impl.queueReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        network.mojom.NetworkContext_QueueEnterpriseReport_ParamsSpec.$,
        null,
        impl.queueEnterpriseReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        network.mojom.NetworkContext_QueueSignedExchangeReport_ParamsSpec.$,
        null,
        impl.queueSignedExchangeReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        network.mojom.NetworkContext_CloseAllConnections_ParamsSpec.$,
        network.mojom.NetworkContext_CloseAllConnections_ResponseParamsSpec.$,
        impl.closeAllConnections.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        network.mojom.NetworkContext_CloseIdleConnections_ParamsSpec.$,
        network.mojom.NetworkContext_CloseIdleConnections_ResponseParamsSpec.$,
        impl.closeIdleConnections.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        38,
        network.mojom.NetworkContext_SetNetworkConditions_ParamsSpec.$,
        null,
        impl.setNetworkConditions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        39,
        network.mojom.NetworkContext_EnableDurableMessageCollector_ParamsSpec.$,
        null,
        impl.enableDurableMessageCollector.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        40,
        network.mojom.NetworkContext_SetAcceptLanguage_ParamsSpec.$,
        null,
        impl.setAcceptLanguage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        41,
        network.mojom.NetworkContext_SetEnableReferrers_ParamsSpec.$,
        null,
        impl.setEnableReferrers.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        42,
        network.mojom.NetworkContext_SetCTPolicy_ParamsSpec.$,
        null,
        impl.setCTPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        43,
        network.mojom.NetworkContext_CreateUDPSocket_ParamsSpec.$,
        null,
        impl.createUDPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        44,
        network.mojom.NetworkContext_CreateRestrictedUDPSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec.$,
        impl.createRestrictedUDPSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        45,
        network.mojom.NetworkContext_CreateTCPServerSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPServerSocket_ResponseParamsSpec.$,
        impl.createTCPServerSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        46,
        network.mojom.NetworkContext_CreateTCPConnectedSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec.$,
        impl.createTCPConnectedSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        47,
        network.mojom.NetworkContext_CreateTCPBoundSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec.$,
        impl.createTCPBoundSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        48,
        network.mojom.NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec.$,
        null,
        impl.createProxyResolvingSocketFactory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        49,
        network.mojom.NetworkContext_LookUpProxyForURL_ParamsSpec.$,
        null,
        impl.lookUpProxyForURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        50,
        network.mojom.NetworkContext_ForceReloadProxyConfig_ParamsSpec.$,
        network.mojom.NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec.$,
        impl.forceReloadProxyConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        51,
        network.mojom.NetworkContext_ClearBadProxiesCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearBadProxiesCache_ResponseParamsSpec.$,
        impl.clearBadProxiesCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        52,
        network.mojom.NetworkContext_CreateWebSocket_ParamsSpec.$,
        null,
        impl.createWebSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        53,
        network.mojom.NetworkContext_CreateWebTransport_ParamsSpec.$,
        null,
        impl.createWebTransport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        54,
        network.mojom.NetworkContext_CreateNetLogExporter_ParamsSpec.$,
        null,
        impl.createNetLogExporter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        55,
        network.mojom.NetworkContext_PreconnectSockets_ParamsSpec.$,
        null,
        impl.preconnectSockets.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        56,
        network.mojom.NetworkContext_CreateP2PSocketManager_ParamsSpec.$,
        null,
        impl.createP2PSocketManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        57,
        network.mojom.NetworkContext_CreateMdnsResponder_ParamsSpec.$,
        null,
        impl.createMdnsResponder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        58,
        network.mojom.NetworkContext_ResolveHost_ParamsSpec.$,
        null,
        impl.resolveHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        59,
        network.mojom.NetworkContext_CreateHostResolver_ParamsSpec.$,
        null,
        impl.createHostResolver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        60,
        network.mojom.NetworkContext_VerifyCert_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCert_ResponseParamsSpec.$,
        impl.verifyCert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        61,
        network.mojom.NetworkContext_VerifyCertForSignedExchange_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec.$,
        impl.verifyCertForSignedExchange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        62,
        network.mojom.NetworkContext_Verify2QwacCertBinding_ParamsSpec.$,
        network.mojom.NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec.$,
        impl.verify2QwacCertBinding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        63,
        network.mojom.NetworkContext_AddHSTS_ParamsSpec.$,
        network.mojom.NetworkContext_AddHSTS_ResponseParamsSpec.$,
        impl.addHSTS.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        64,
        network.mojom.NetworkContext_IsHSTSActiveForHost_ParamsSpec.$,
        network.mojom.NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec.$,
        impl.isHSTSActiveForHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        65,
        network.mojom.NetworkContext_GetHSTSState_ParamsSpec.$,
        network.mojom.NetworkContext_GetHSTSState_ResponseParamsSpec.$,
        impl.getHSTSState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        66,
        network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec.$,
        network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec.$,
        impl.setCorsOriginAccessListsForOrigin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        67,
        network.mojom.NetworkContext_DeleteDynamicDataForHost_ParamsSpec.$,
        network.mojom.NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec.$,
        impl.deleteDynamicDataForHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        68,
        network.mojom.NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec.$,
        null,
        impl.setSplitAuthCacheByNetworkAnonymizationKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        69,
        network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec.$,
        network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        impl.saveHttpAuthCacheProxyEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        70,
        network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec.$,
        network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        impl.loadHttpAuthCacheProxyEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        71,
        network.mojom.NetworkContext_AddAuthCacheEntry_ParamsSpec.$,
        network.mojom.NetworkContext_AddAuthCacheEntry_ResponseParamsSpec.$,
        impl.addAuthCacheEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        72,
        network.mojom.NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec.$,
        null,
        impl.setCorsNonWildcardRequestHeadersSupport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        73,
        network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec.$,
        impl.enableStaticKeyPinningForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        74,
        network.mojom.NetworkContext_VerifyCertificateForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec.$,
        impl.verifyCertificateForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        75,
        network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec.$,
        impl.getTrustAnchorIDsForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        76,
        network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec.$,
        impl.addDomainReliabilityContextForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        77,
        network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec.$,
        impl.forceDomainReliabilityUploadsForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        78,
        network.mojom.NetworkContext_SetSCTAuditingMode_ParamsSpec.$,
        null,
        impl.setSCTAuditingMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        79,
        network.mojom.NetworkContext_AddReportingApiObserver_ParamsSpec.$,
        null,
        impl.addReportingApiObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        80,
        network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec.$,
        impl.getSharedDictionaryUsageInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        81,
        network.mojom.NetworkContext_GetSharedDictionaryInfo_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec.$,
        impl.getSharedDictionaryInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        82,
        network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec.$,
        impl.getSharedDictionaryOriginsBetween.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        83,
        network.mojom.NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec.$,
        null,
        impl.setSharedDictionaryCacheMaxSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        84,
        network.mojom.NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec.$,
        null,
        impl.preloadSharedDictionaryInfoForDocument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        85,
        network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec.$,
        impl.hasPreloadedSharedDictionaryInfoForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        86,
        network.mojom.NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec.$,
        null,
        impl.flushCachedClientCertIfNeeded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        87,
        network.mojom.NetworkContext_FlushMatchingCachedClientCert_ParamsSpec.$,
        null,
        impl.flushMatchingCachedClientCert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        88,
        network.mojom.NetworkContext_SetCookieDeprecationLabel_ParamsSpec.$,
        null,
        impl.setCookieDeprecationLabel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        89,
        network.mojom.NetworkContext_RevokeNetworkForNonces_ParamsSpec.$,
        network.mojom.NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec.$,
        impl.revokeNetworkForNonces.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        90,
        network.mojom.NetworkContext_ClearNonces_ParamsSpec.$,
        null,
        impl.clearNonces.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        91,
        network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec.$,
        network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec.$,
        impl.exemptUrlFromNetworkRevocationForNonce.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        92,
        network.mojom.NetworkContext_Prefetch_ParamsSpec.$,
        null,
        impl.prefetch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        93,
        network.mojom.NetworkContext_GetBoundNetworkForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec.$,
        impl.getBoundNetworkForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        94,
        network.mojom.NetworkContext_GetDeviceBoundSessionManager_ParamsSpec.$,
        null,
        impl.getDeviceBoundSessionManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        95,
        network.mojom.NetworkContext_AddQuicHints_ParamsSpec.$,
        null,
        impl.addQuicHints.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.NetworkContext = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.NetworkContextRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.NetworkContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};

goog.provide('network.mojom.NetworkContext_DomainReliabilityClearMode');
goog.provide('network.mojom.NetworkContext.DomainReliabilityClearModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.NetworkContext.DomainReliabilityClearModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.NetworkContext_DomainReliabilityClearMode = {
  
  CLEAR_CONTEXTS: 0,
  CLEAR_BEACONS: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * An object which receives request messages for the NetworkContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.NetworkContextCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.NetworkContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkContext_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createURLLoaderFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.NetworkContext_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        this.createURLLoaderFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetURLLoaderFactories =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.NetworkContext_ResetURLLoaderFactories_ParamsSpec.$,
        null,
        this.resetURLLoaderFactories.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getViaObliviousHttp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.NetworkContext_GetViaObliviousHttp_ParamsSpec.$,
        null,
        this.getViaObliviousHttp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCookieManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.NetworkContext_GetCookieManager_ParamsSpec.$,
        null,
        this.getCookieManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRestrictedCookieManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.NetworkContext_GetRestrictedCookieManager_ParamsSpec.$,
        null,
        this.getRestrictedCookieManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getTrustTokenQueryAnswerer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec.$,
        null,
        this.getTrustTokenQueryAnswerer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearTrustTokenData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.NetworkContext_ClearTrustTokenData_ParamsSpec.$,
        network.mojom.NetworkContext_ClearTrustTokenData_ResponseParamsSpec.$,
        this.clearTrustTokenData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearTrustTokenSessionOnlyData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec.$,
        network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec.$,
        this.clearTrustTokenSessionOnlyData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStoredTrustTokenCounts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        network.mojom.NetworkContext_GetStoredTrustTokenCounts_ParamsSpec.$,
        network.mojom.NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec.$,
        this.getStoredTrustTokenCounts.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPrivateStateTokenRedemptionRecords =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec.$,
        network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec.$,
        this.getPrivateStateTokenRedemptionRecords.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getIpProxyStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        network.mojom.NetworkContext_GetIpProxyStatus_ParamsSpec.$,
        network.mojom.NetworkContext_GetIpProxyStatus_ResponseParamsSpec.$,
        this.getIpProxyStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBypassIpProtectionProxy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        network.mojom.NetworkContext_SetBypassIpProtectionProxy_ParamsSpec.$,
        null,
        this.setBypassIpProtectionProxy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteStoredTrustTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        network.mojom.NetworkContext_DeleteStoredTrustTokens_ParamsSpec.$,
        network.mojom.NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec.$,
        this.deleteStoredTrustTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setBlockTrustTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        network.mojom.NetworkContext_SetBlockTrustTokens_ParamsSpec.$,
        null,
        this.setBlockTrustTokens.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTrackingProtectionContentSetting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        network.mojom.NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec.$,
        null,
        this.setTrackingProtectionContentSetting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearNetworkingHistoryBetween =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec.$,
        network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec.$,
        this.clearNetworkingHistoryBetween.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearHttpCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        network.mojom.NetworkContext_ClearHttpCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHttpCache_ResponseParamsSpec.$,
        this.clearHttpCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.computeHttpCacheSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        network.mojom.NetworkContext_ComputeHttpCacheSize_ParamsSpec.$,
        network.mojom.NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec.$,
        this.computeHttpCacheSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyBrowserIdle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        network.mojom.NetworkContext_NotifyBrowserIdle_ParamsSpec.$,
        null,
        this.notifyBrowserIdle.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyExternalCacheHit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        network.mojom.NetworkContext_NotifyExternalCacheHit_ParamsSpec.$,
        null,
        this.notifyExternalCacheHit.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearHostCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        network.mojom.NetworkContext_ClearHostCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHostCache_ResponseParamsSpec.$,
        this.clearHostCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearHttpAuthCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        network.mojom.NetworkContext_ClearHttpAuthCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearHttpAuthCache_ResponseParamsSpec.$,
        this.clearHttpAuthCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearCorsPreflightCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        network.mojom.NetworkContext_ClearCorsPreflightCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec.$,
        this.clearCorsPreflightCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearReportingCacheReports =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        network.mojom.NetworkContext_ClearReportingCacheReports_ParamsSpec.$,
        network.mojom.NetworkContext_ClearReportingCacheReports_ResponseParamsSpec.$,
        this.clearReportingCacheReports.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearReportingCacheClients =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        network.mojom.NetworkContext_ClearReportingCacheClients_ParamsSpec.$,
        network.mojom.NetworkContext_ClearReportingCacheClients_ResponseParamsSpec.$,
        this.clearReportingCacheClients.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearNetworkErrorLogging =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        network.mojom.NetworkContext_ClearNetworkErrorLogging_ParamsSpec.$,
        network.mojom.NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec.$,
        this.clearNetworkErrorLogging.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearDomainReliability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        network.mojom.NetworkContext_ClearDomainReliability_ParamsSpec.$,
        network.mojom.NetworkContext_ClearDomainReliability_ResponseParamsSpec.$,
        this.clearDomainReliability.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearSharedDictionaryCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        network.mojom.NetworkContext_ClearSharedDictionaryCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec.$,
        this.clearSharedDictionaryCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearSharedDictionaryCacheForIsolationKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec.$,
        network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec.$,
        this.clearSharedDictionaryCacheForIsolationKey.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDocumentReportingEndpoints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        network.mojom.NetworkContext_SetDocumentReportingEndpoints_ParamsSpec.$,
        null,
        this.setDocumentReportingEndpoints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEnterpriseReportingEndpoints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        network.mojom.NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec.$,
        null,
        this.setEnterpriseReportingEndpoints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendReportsAndRemoveSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        network.mojom.NetworkContext_SendReportsAndRemoveSource_ParamsSpec.$,
        null,
        this.sendReportsAndRemoveSource.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        network.mojom.NetworkContext_QueueReport_ParamsSpec.$,
        null,
        this.queueReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueEnterpriseReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        network.mojom.NetworkContext_QueueEnterpriseReport_ParamsSpec.$,
        null,
        this.queueEnterpriseReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueSignedExchangeReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        network.mojom.NetworkContext_QueueSignedExchangeReport_ParamsSpec.$,
        null,
        this.queueSignedExchangeReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeAllConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        network.mojom.NetworkContext_CloseAllConnections_ParamsSpec.$,
        network.mojom.NetworkContext_CloseAllConnections_ResponseParamsSpec.$,
        this.closeAllConnections.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeIdleConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        network.mojom.NetworkContext_CloseIdleConnections_ParamsSpec.$,
        network.mojom.NetworkContext_CloseIdleConnections_ResponseParamsSpec.$,
        this.closeIdleConnections.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNetworkConditions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        38,
        network.mojom.NetworkContext_SetNetworkConditions_ParamsSpec.$,
        null,
        this.setNetworkConditions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDurableMessageCollector =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        39,
        network.mojom.NetworkContext_EnableDurableMessageCollector_ParamsSpec.$,
        null,
        this.enableDurableMessageCollector.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAcceptLanguage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        40,
        network.mojom.NetworkContext_SetAcceptLanguage_ParamsSpec.$,
        null,
        this.setAcceptLanguage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEnableReferrers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        41,
        network.mojom.NetworkContext_SetEnableReferrers_ParamsSpec.$,
        null,
        this.setEnableReferrers.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCTPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        42,
        network.mojom.NetworkContext_SetCTPolicy_ParamsSpec.$,
        null,
        this.setCTPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createUDPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        43,
        network.mojom.NetworkContext_CreateUDPSocket_ParamsSpec.$,
        null,
        this.createUDPSocket.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRestrictedUDPSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        44,
        network.mojom.NetworkContext_CreateRestrictedUDPSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec.$,
        this.createRestrictedUDPSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTCPServerSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        45,
        network.mojom.NetworkContext_CreateTCPServerSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPServerSocket_ResponseParamsSpec.$,
        this.createTCPServerSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTCPConnectedSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        46,
        network.mojom.NetworkContext_CreateTCPConnectedSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec.$,
        this.createTCPConnectedSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTCPBoundSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        47,
        network.mojom.NetworkContext_CreateTCPBoundSocket_ParamsSpec.$,
        network.mojom.NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec.$,
        this.createTCPBoundSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createProxyResolvingSocketFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        48,
        network.mojom.NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec.$,
        null,
        this.createProxyResolvingSocketFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.lookUpProxyForURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        49,
        network.mojom.NetworkContext_LookUpProxyForURL_ParamsSpec.$,
        null,
        this.lookUpProxyForURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forceReloadProxyConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        50,
        network.mojom.NetworkContext_ForceReloadProxyConfig_ParamsSpec.$,
        network.mojom.NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec.$,
        this.forceReloadProxyConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearBadProxiesCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        51,
        network.mojom.NetworkContext_ClearBadProxiesCache_ParamsSpec.$,
        network.mojom.NetworkContext_ClearBadProxiesCache_ResponseParamsSpec.$,
        this.clearBadProxiesCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWebSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        52,
        network.mojom.NetworkContext_CreateWebSocket_ParamsSpec.$,
        null,
        this.createWebSocket.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWebTransport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        53,
        network.mojom.NetworkContext_CreateWebTransport_ParamsSpec.$,
        null,
        this.createWebTransport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createNetLogExporter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        54,
        network.mojom.NetworkContext_CreateNetLogExporter_ParamsSpec.$,
        null,
        this.createNetLogExporter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.preconnectSockets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        55,
        network.mojom.NetworkContext_PreconnectSockets_ParamsSpec.$,
        null,
        this.preconnectSockets.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createP2PSocketManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        56,
        network.mojom.NetworkContext_CreateP2PSocketManager_ParamsSpec.$,
        null,
        this.createP2PSocketManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createMdnsResponder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        57,
        network.mojom.NetworkContext_CreateMdnsResponder_ParamsSpec.$,
        null,
        this.createMdnsResponder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        58,
        network.mojom.NetworkContext_ResolveHost_ParamsSpec.$,
        null,
        this.resolveHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createHostResolver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        59,
        network.mojom.NetworkContext_CreateHostResolver_ParamsSpec.$,
        null,
        this.createHostResolver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verifyCert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        60,
        network.mojom.NetworkContext_VerifyCert_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCert_ResponseParamsSpec.$,
        this.verifyCert.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verifyCertForSignedExchange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        61,
        network.mojom.NetworkContext_VerifyCertForSignedExchange_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec.$,
        this.verifyCertForSignedExchange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verify2QwacCertBinding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        62,
        network.mojom.NetworkContext_Verify2QwacCertBinding_ParamsSpec.$,
        network.mojom.NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec.$,
        this.verify2QwacCertBinding.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addHSTS =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        63,
        network.mojom.NetworkContext_AddHSTS_ParamsSpec.$,
        network.mojom.NetworkContext_AddHSTS_ResponseParamsSpec.$,
        this.addHSTS.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isHSTSActiveForHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        64,
        network.mojom.NetworkContext_IsHSTSActiveForHost_ParamsSpec.$,
        network.mojom.NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec.$,
        this.isHSTSActiveForHost.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHSTSState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        65,
        network.mojom.NetworkContext_GetHSTSState_ParamsSpec.$,
        network.mojom.NetworkContext_GetHSTSState_ResponseParamsSpec.$,
        this.getHSTSState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCorsOriginAccessListsForOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        66,
        network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec.$,
        network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec.$,
        this.setCorsOriginAccessListsForOrigin.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteDynamicDataForHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        67,
        network.mojom.NetworkContext_DeleteDynamicDataForHost_ParamsSpec.$,
        network.mojom.NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec.$,
        this.deleteDynamicDataForHost.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSplitAuthCacheByNetworkAnonymizationKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        68,
        network.mojom.NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec.$,
        null,
        this.setSplitAuthCacheByNetworkAnonymizationKey.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.saveHttpAuthCacheProxyEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        69,
        network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec.$,
        network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        this.saveHttpAuthCacheProxyEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadHttpAuthCacheProxyEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        70,
        network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec.$,
        network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
        this.loadHttpAuthCacheProxyEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addAuthCacheEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        71,
        network.mojom.NetworkContext_AddAuthCacheEntry_ParamsSpec.$,
        network.mojom.NetworkContext_AddAuthCacheEntry_ResponseParamsSpec.$,
        this.addAuthCacheEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCorsNonWildcardRequestHeadersSupport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        72,
        network.mojom.NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec.$,
        null,
        this.setCorsNonWildcardRequestHeadersSupport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableStaticKeyPinningForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        73,
        network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec.$,
        this.enableStaticKeyPinningForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verifyCertificateForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        74,
        network.mojom.NetworkContext_VerifyCertificateForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec.$,
        this.verifyCertificateForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getTrustAnchorIDsForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        75,
        network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec.$,
        this.getTrustAnchorIDsForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addDomainReliabilityContextForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        76,
        network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec.$,
        this.addDomainReliabilityContextForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forceDomainReliabilityUploadsForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        77,
        network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec.$,
        this.forceDomainReliabilityUploadsForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSCTAuditingMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        78,
        network.mojom.NetworkContext_SetSCTAuditingMode_ParamsSpec.$,
        null,
        this.setSCTAuditingMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addReportingApiObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        79,
        network.mojom.NetworkContext_AddReportingApiObserver_ParamsSpec.$,
        null,
        this.addReportingApiObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSharedDictionaryUsageInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        80,
        network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec.$,
        this.getSharedDictionaryUsageInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSharedDictionaryInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        81,
        network.mojom.NetworkContext_GetSharedDictionaryInfo_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec.$,
        this.getSharedDictionaryInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSharedDictionaryOriginsBetween =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        82,
        network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec.$,
        network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec.$,
        this.getSharedDictionaryOriginsBetween.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSharedDictionaryCacheMaxSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        83,
        network.mojom.NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec.$,
        null,
        this.setSharedDictionaryCacheMaxSize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.preloadSharedDictionaryInfoForDocument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        84,
        network.mojom.NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec.$,
        null,
        this.preloadSharedDictionaryInfoForDocument.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasPreloadedSharedDictionaryInfoForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        85,
        network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec.$,
        this.hasPreloadedSharedDictionaryInfoForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushCachedClientCertIfNeeded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        86,
        network.mojom.NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec.$,
        null,
        this.flushCachedClientCertIfNeeded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushMatchingCachedClientCert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        87,
        network.mojom.NetworkContext_FlushMatchingCachedClientCert_ParamsSpec.$,
        null,
        this.flushMatchingCachedClientCert.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCookieDeprecationLabel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        88,
        network.mojom.NetworkContext_SetCookieDeprecationLabel_ParamsSpec.$,
        null,
        this.setCookieDeprecationLabel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.revokeNetworkForNonces =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        89,
        network.mojom.NetworkContext_RevokeNetworkForNonces_ParamsSpec.$,
        network.mojom.NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec.$,
        this.revokeNetworkForNonces.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearNonces =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        90,
        network.mojom.NetworkContext_ClearNonces_ParamsSpec.$,
        null,
        this.clearNonces.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exemptUrlFromNetworkRevocationForNonce =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        91,
        network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec.$,
        network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec.$,
        this.exemptUrlFromNetworkRevocationForNonce.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.prefetch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        92,
        network.mojom.NetworkContext_Prefetch_ParamsSpec.$,
        null,
        this.prefetch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getBoundNetworkForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        93,
        network.mojom.NetworkContext_GetBoundNetworkForTesting_ParamsSpec.$,
        network.mojom.NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec.$,
        this.getBoundNetworkForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeviceBoundSessionManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        94,
        network.mojom.NetworkContext_GetDeviceBoundSessionManager_ParamsSpec.$,
        null,
        this.getDeviceBoundSessionManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addQuicHints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        95,
        network.mojom.NetworkContext_AddQuicHints_ParamsSpec.$,
        null,
        this.addQuicHints.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.CustomProxyConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CustomProxyConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CertVerifierServiceRemoteParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CertVerifierServiceRemoteParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpAuthStaticNetworkContextParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpAuthStaticNetworkContextParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CTPolicySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CTPolicySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContextFilePathsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextFilePathsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContextParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContextParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkConditionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkConditionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.MatchedNetworkConditionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MatchedNetworkConditionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkDurableMessageConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkDurableMessageConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SharedDictionaryInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SharedDictionaryInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SignedExchangeReportSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SignedExchangeReportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.URLLoaderFactoryOverrideSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderFactoryOverrideSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.URLLoaderFactoryParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderFactoryParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CustomProxyConnectionObserver_OnFallback_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CustomProxyConnectionObserver_OnFallback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TrustedHeaderClient_OnHeadersReceived_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustedHeaderClient_OnHeadersReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DurableMessageCollector_Configure_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DurableMessageCollector_Configure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DurableMessageCollector_Retrieve_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DurableMessageCollector_Retrieve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DurableMessageCollector_Retrieve_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DurableMessageCollector_Retrieve_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateURLLoaderFactory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateURLLoaderFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ResetURLLoaderFactories_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ResetURLLoaderFactories_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetViaObliviousHttp_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetViaObliviousHttp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetCookieManager_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetCookieManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetRestrictedCookieManager_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetRestrictedCookieManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearTrustTokenData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearTrustTokenData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearTrustTokenData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearTrustTokenData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetStoredTrustTokenCounts_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetStoredTrustTokenCounts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetIpProxyStatus_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetIpProxyStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetIpProxyStatus_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetIpProxyStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetBypassIpProtectionProxy_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetBypassIpProtectionProxy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_DeleteStoredTrustTokens_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_DeleteStoredTrustTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetBlockTrustTokens_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetBlockTrustTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearHttpCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearHttpCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearHttpCache_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearHttpCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ComputeHttpCacheSize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ComputeHttpCacheSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_NotifyBrowserIdle_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_NotifyBrowserIdle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_NotifyExternalCacheHit_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_NotifyExternalCacheHit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearHostCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearHostCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearHostCache_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearHostCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearHttpAuthCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearHttpAuthCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearHttpAuthCache_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearHttpAuthCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearCorsPreflightCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearCorsPreflightCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearReportingCacheReports_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearReportingCacheReports_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearReportingCacheReports_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearReportingCacheReports_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearReportingCacheClients_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearReportingCacheClients_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearReportingCacheClients_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearReportingCacheClients_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearNetworkErrorLogging_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearNetworkErrorLogging_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearDomainReliability_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearDomainReliability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearDomainReliability_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearDomainReliability_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearSharedDictionaryCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearSharedDictionaryCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetDocumentReportingEndpoints_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetDocumentReportingEndpoints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SendReportsAndRemoveSource_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SendReportsAndRemoveSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_QueueReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_QueueReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_QueueEnterpriseReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_QueueEnterpriseReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_QueueSignedExchangeReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_QueueSignedExchangeReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CloseAllConnections_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CloseAllConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CloseAllConnections_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CloseAllConnections_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CloseIdleConnections_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CloseIdleConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CloseIdleConnections_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CloseIdleConnections_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetNetworkConditions_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetNetworkConditions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_EnableDurableMessageCollector_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_EnableDurableMessageCollector_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetAcceptLanguage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetAcceptLanguage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetEnableReferrers_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetEnableReferrers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetCTPolicy_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetCTPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateUDPSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateUDPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateRestrictedUDPSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateRestrictedUDPSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateTCPServerSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateTCPServerSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateTCPServerSocket_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateTCPServerSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateTCPConnectedSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateTCPConnectedSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateTCPBoundSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateTCPBoundSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_LookUpProxyForURL_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_LookUpProxyForURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ForceReloadProxyConfig_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ForceReloadProxyConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearBadProxiesCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearBadProxiesCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearBadProxiesCache_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearBadProxiesCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateWebSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateWebSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateWebTransport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateWebTransport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateNetLogExporter_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateNetLogExporter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_PreconnectSockets_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_PreconnectSockets_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateP2PSocketManager_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateP2PSocketManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateMdnsResponder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateMdnsResponder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ResolveHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ResolveHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_CreateHostResolver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_CreateHostResolver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_VerifyCert_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_VerifyCert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_VerifyCert_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_VerifyCert_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_VerifyCertForSignedExchange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_VerifyCertForSignedExchange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_Verify2QwacCertBinding_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_Verify2QwacCertBinding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_AddHSTS_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_AddHSTS_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_AddHSTS_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_AddHSTS_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_IsHSTSActiveForHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_IsHSTSActiveForHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetHSTSState_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetHSTSState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetHSTSState_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetHSTSState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_DeleteDynamicDataForHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_DeleteDynamicDataForHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_AddAuthCacheEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_AddAuthCacheEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_AddAuthCacheEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_AddAuthCacheEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_VerifyCertificateForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_VerifyCertificateForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetSCTAuditingMode_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetSCTAuditingMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_AddReportingApiObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_AddReportingApiObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetSharedDictionaryInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetSharedDictionaryInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_FlushMatchingCachedClientCert_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_FlushMatchingCachedClientCert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_SetCookieDeprecationLabel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_SetCookieDeprecationLabel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_RevokeNetworkForNonces_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_RevokeNetworkForNonces_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ClearNonces_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ClearNonces_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_Prefetch_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_Prefetch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetBoundNetworkForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetBoundNetworkForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_GetDeviceBoundSessionManager_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_GetDeviceBoundSessionManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkContext_AddQuicHints_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkContext_AddQuicHints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.CustomProxyConfigSpec.$,
    'CustomProxyConfig',
    [
      mojo.internal.StructField(
        'rules', 0,
        0,
        network.mojom.ProxyRulesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldOverrideExistingConfig', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowNonIdempotentMethods', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectTunnelHeaders', 16,
        0,
        network.mojom.HttpRequestHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CustomProxyConfig');

/** @record */
network.mojom.CustomProxyConfig = class {
  constructor() {
    /** @export { !network.mojom.ProxyRules } */
    this.rules;
    /** @export { !boolean } */
    this.shouldOverrideExistingConfig;
    /** @export { !boolean } */
    this.allowNonIdempotentMethods;
    /** @export { !network.mojom.HttpRequestHeaders } */
    this.connectTunnelHeaders;
  }
};



mojo.internal.Struct(
    network.mojom.CertVerifierServiceRemoteParamsSpec.$,
    'CertVerifierServiceRemoteParams',
    [
      mojo.internal.StructField(
        'certVerifierService', 0,
        0,
        mojo.internal.InterfaceProxy(certVerifier.mojom.CertVerifierServiceRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certVerifierServiceClientReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(certVerifier.mojom.CertVerifierServiceClientPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CertVerifierServiceRemoteParams');

/** @record */
network.mojom.CertVerifierServiceRemoteParams = class {
  constructor() {
    /** @export { (certVerifier.mojom.CertVerifierServiceRemote|undefined) } */
    this.certVerifierService;
    /** @export { (certVerifier.mojom.CertVerifierServiceClientPendingReceiver|undefined) } */
    this.certVerifierServiceClientReceiver;
  }
};



mojo.internal.Struct(
    network.mojom.HttpAuthStaticNetworkContextParamsSpec.$,
    'HttpAuthStaticNetworkContextParams',
    [
      mojo.internal.StructField(
        'allowDefaultCredentials', 0,
        0,
        network.mojom.DefaultCredentialsSpec.$,
        network.mojom.DefaultCredentials.ALLOW_DEFAULT_CREDENTIALS,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpAuthStaticNetworkContextParams');

/** @record */
network.mojom.HttpAuthStaticNetworkContextParams = class {
  constructor() {
    /** @export { !network.mojom.DefaultCredentials } */
    this.allowDefaultCredentials;
  }
};



mojo.internal.Struct(
    network.mojom.CTPolicySpec.$,
    'CTPolicy',
    [
      mojo.internal.StructField(
        'excludedHosts', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'excludedSpkis', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CTPolicy');

/** @record */
network.mojom.CTPolicy = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.excludedHosts;
    /** @export { !Array<!string> } */
    this.excludedSpkis;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextFilePathsSpec.$,
    'NetworkContextFilePaths',
    [
      mojo.internal.StructField(
        'sharedDictionaryDirectory', 0,
        0,
        network.mojom.TransferableDirectorySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpCacheDirectory', 16,
        0,
        network.mojom.TransferableDirectorySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'noVarySearchDirectory', 32,
        0,
        network.mojom.TransferableDirectorySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataDirectory', 48,
        0,
        network.mojom.TransferableDirectorySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unsandboxedDataPath', 64,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieDatabaseName', 72,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceBoundSessionsDatabaseName', 80,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustTokenDatabaseName', 88,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpServerPropertiesFileName', 96,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transportSecurityPersisterFileName', 104,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportingAndNelStoreDatabaseName', 112,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sctAuditingPendingReportsFileName', 120,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'triggerMigration', 128,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 144],]);



goog.provide('network.mojom.NetworkContextFilePaths');

/** @record */
network.mojom.NetworkContextFilePaths = class {
  constructor() {
    /** @export { (network.mojom.TransferableDirectory|undefined) } */
    this.sharedDictionaryDirectory;
    /** @export { (network.mojom.TransferableDirectory|undefined) } */
    this.httpCacheDirectory;
    /** @export { (network.mojom.TransferableDirectory|undefined) } */
    this.noVarySearchDirectory;
    /** @export { !network.mojom.TransferableDirectory } */
    this.dataDirectory;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.unsandboxedDataPath;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.cookieDatabaseName;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.deviceBoundSessionsDatabaseName;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.trustTokenDatabaseName;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.httpServerPropertiesFileName;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.transportSecurityPersisterFileName;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.reportingAndNelStoreDatabaseName;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.sctAuditingPendingReportsFileName;
    /** @export { !boolean } */
    this.triggerMigration;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContextParamsSpec.$,
    'NetworkContextParams',
    [
      mojo.internal.StructField(
        'userAgent', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'acceptLanguage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableBrotli', 16,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableZstd', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableReferrers', 16,
        2,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'validateReferrerPolicyOnInitialRequest', 16,
        3,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyResolverFactory', 20,
        0,
        mojo.internal.InterfaceProxy(proxyResolver.mojom.ProxyResolverFactoryRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableEncryptedCookies', 16,
        4,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'restoreOldSessionCookies', 16,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'persistSessionCookies', 16,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpCacheEnabled', 16,
        7,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpCacheMaxSize', 28,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpCacheFileOperationsFactory', 32,
        0,
        mojo.internal.InterfaceProxy(network.mojom.HttpCacheBackendFileOperationsFactoryRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disableIdleSocketsCloseOnMemoryPressure', 17,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialSslConfig', 40,
        0,
        network.mojom.SSLConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sslConfigClientReceiver', 48,
        0,
        mojo.internal.InterfaceRequest(network.mojom.SSLConfigClientPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialProxyConfig', 56,
        0,
        network.mojom.ProxyConfigWithAnnotationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyConfigClientReceiver', 52,
        0,
        mojo.internal.InterfaceRequest(network.mojom.ProxyConfigClientPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialCustomProxyConfig', 64,
        0,
        network.mojom.CustomProxyConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'customProxyConfigClientReceiver', 72,
        0,
        mojo.internal.InterfaceRequest(network.mojom.CustomProxyConfigClientPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'customProxyConnectionObserverRemote', 76,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CustomProxyConnectionObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyConfigPollerClient', 84,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ProxyConfigPollerClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyErrorClient', 92,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ProxyErrorClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipProtectionCoreHost', 100,
        0,
        mojo.internal.InterfaceProxy(ipProtection.mojom.CoreHostRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipProtectionControl', 108,
        0,
        mojo.internal.InterfaceRequest(ipProtection.mojom.CoreControlPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableIpProtection', 17,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipProtectionIncognito', 17,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialIpProtectionTokens', 112,
        0,
        mojo.internal.Map(ipProtection.mojom.ProxyLayerSpec.$, mojo.internal.Array(ipProtection.mojom.BlindSignedAuthTokenSpec.$, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipProtectionDataDirectory', 120,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pacQuickCheckEnabled', 17,
        3,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableCertificateReporting', 17,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enforceChromeCtPolicy', 17,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sctAuditingMode', 128,
        0,
        network.mojom.SCTAuditingModeSpec.$,
        network.mojom.SCTAuditingMode.kDisabled,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ctPolicy', 136,
        0,
        network.mojom.CTPolicySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certVerifierParams', 144,
        0,
        network.mojom.CertVerifierServiceRemoteParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieManagerParams', 152,
        0,
        network.mojom.CookieManagerParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableDomainReliability', 17,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domainReliabilityUploadReporter', 160,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'discardDomainReliablityUploads', 17,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportingDeliveryInterval', 168,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'skipReportingSendPermissionCheck', 18,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'corsOriginAccessList', 176,
        0,
        mojo.internal.Array(network.mojom.CorsOriginAccessPatternsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'corsExemptHeaderList', 184,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowAnyCorsExemptHeaderForBrowser', 18,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hstsPolicyBypassList', 192,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpAuthStaticNetworkContextParams', 200,
        0,
        network.mojom.HttpAuthStaticNetworkContextParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resetHttpCacheBackend', 18,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'splitAuthCacheByNetworkAnonymizationKey', 18,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requireNetworkAnonymizationKey', 18,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filePaths', 208,
        0,
        network.mojom.NetworkContextFilePathsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blockTrustTokens', 18,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedDictionaryEnabled', 18,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedDictionaryCacheMaxSize', 216,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'firstPartySetsAccessDelegateParams', 224,
        0,
        network.mojom.FirstPartySetsAccessDelegateParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'firstPartySetsAccessDelegateReceiver', 132,
        0,
        mojo.internal.InterfaceRequest(network.mojom.FirstPartySetsAccessDelegatePendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'acamPreflightSpecConformant', 18,
        7,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieDeprecationLabel', 232,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieEncryptionProvider', 240,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CookieEncryptionProviderRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceBoundSessionsEnabled', 19,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'boundNetwork', 248,
        0,
        mojo.internal.Int64,
        BigInt('-1'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enterpriseReportingEndpoints', 256,
        0,
        mojo.internal.Map(mojo.internal.String, url.mojom.UrlSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quic_idle_connection_timeout_seconds_$flag', 19,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "quic_idle_connection_timeout_seconds_$value",
          originalFieldName: "quicIdleConnectionTimeoutSeconds",
        }
      ),
      mojo.internal.StructField(
        'quic_idle_connection_timeout_seconds_$value', 264,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "quicIdleConnectionTimeoutSeconds",
        }
      ),
      mojo.internal.StructField(
        'trackingProtectionContentSettings', 272,
        0,
        mojo.internal.Array(contentSettings.mojom.ContentSettingPatternSourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 288],]);



goog.provide('network.mojom.NetworkContextParams');

/** @record */
network.mojom.NetworkContextParams = class {
  constructor() {
    /** @export { !string } */
    this.userAgent;
    /** @export { !string } */
    this.acceptLanguage;
    /** @export { !boolean } */
    this.enableBrotli;
    /** @export { !boolean } */
    this.enableZstd;
    /** @export { !boolean } */
    this.enableReferrers;
    /** @export { !boolean } */
    this.validateReferrerPolicyOnInitialRequest;
    /** @export { (proxyResolver.mojom.ProxyResolverFactoryRemote|undefined) } */
    this.proxyResolverFactory;
    /** @export { !boolean } */
    this.enableEncryptedCookies;
    /** @export { !boolean } */
    this.restoreOldSessionCookies;
    /** @export { !boolean } */
    this.persistSessionCookies;
    /** @export { !boolean } */
    this.httpCacheEnabled;
    /** @export { !number } */
    this.httpCacheMaxSize;
    /** @export { (network.mojom.HttpCacheBackendFileOperationsFactoryRemote|undefined) } */
    this.httpCacheFileOperationsFactory;
    /** @export { !boolean } */
    this.disableIdleSocketsCloseOnMemoryPressure;
    /** @export { (network.mojom.SSLConfig|undefined) } */
    this.initialSslConfig;
    /** @export { (network.mojom.SSLConfigClientPendingReceiver|undefined) } */
    this.sslConfigClientReceiver;
    /** @export { (network.mojom.ProxyConfigWithAnnotation|undefined) } */
    this.initialProxyConfig;
    /** @export { (network.mojom.ProxyConfigClientPendingReceiver|undefined) } */
    this.proxyConfigClientReceiver;
    /** @export { (network.mojom.CustomProxyConfig|undefined) } */
    this.initialCustomProxyConfig;
    /** @export { (network.mojom.CustomProxyConfigClientPendingReceiver|undefined) } */
    this.customProxyConfigClientReceiver;
    /** @export { (network.mojom.CustomProxyConnectionObserverRemote|undefined) } */
    this.customProxyConnectionObserverRemote;
    /** @export { (network.mojom.ProxyConfigPollerClientRemote|undefined) } */
    this.proxyConfigPollerClient;
    /** @export { (network.mojom.ProxyErrorClientRemote|undefined) } */
    this.proxyErrorClient;
    /** @export { (ipProtection.mojom.CoreHostRemote|undefined) } */
    this.ipProtectionCoreHost;
    /** @export { (ipProtection.mojom.CoreControlPendingReceiver|undefined) } */
    this.ipProtectionControl;
    /** @export { !boolean } */
    this.enableIpProtection;
    /** @export { !boolean } */
    this.ipProtectionIncognito;
    /** @export { !Object<!ipProtection.mojom.ProxyLayer, !Array<!ipProtection.mojom.BlindSignedAuthToken>> } */
    this.initialIpProtectionTokens;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.ipProtectionDataDirectory;
    /** @export { !boolean } */
    this.pacQuickCheckEnabled;
    /** @export { !boolean } */
    this.enableCertificateReporting;
    /** @export { !boolean } */
    this.enforceChromeCtPolicy;
    /** @export { !network.mojom.SCTAuditingMode } */
    this.sctAuditingMode;
    /** @export { (network.mojom.CTPolicy|undefined) } */
    this.ctPolicy;
    /** @export { !network.mojom.CertVerifierServiceRemoteParams } */
    this.certVerifierParams;
    /** @export { (network.mojom.CookieManagerParams|undefined) } */
    this.cookieManagerParams;
    /** @export { !boolean } */
    this.enableDomainReliability;
    /** @export { !string } */
    this.domainReliabilityUploadReporter;
    /** @export { !boolean } */
    this.discardDomainReliablityUploads;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.reportingDeliveryInterval;
    /** @export { !boolean } */
    this.skipReportingSendPermissionCheck;
    /** @export { !Array<!network.mojom.CorsOriginAccessPatterns> } */
    this.corsOriginAccessList;
    /** @export { !Array<!string> } */
    this.corsExemptHeaderList;
    /** @export { !boolean } */
    this.allowAnyCorsExemptHeaderForBrowser;
    /** @export { !Array<!string> } */
    this.hstsPolicyBypassList;
    /** @export { (network.mojom.HttpAuthStaticNetworkContextParams|undefined) } */
    this.httpAuthStaticNetworkContextParams;
    /** @export { !boolean } */
    this.resetHttpCacheBackend;
    /** @export { !boolean } */
    this.splitAuthCacheByNetworkAnonymizationKey;
    /** @export { !boolean } */
    this.requireNetworkAnonymizationKey;
    /** @export { (network.mojom.NetworkContextFilePaths|undefined) } */
    this.filePaths;
    /** @export { !boolean } */
    this.blockTrustTokens;
    /** @export { !boolean } */
    this.sharedDictionaryEnabled;
    /** @export { !bigint } */
    this.sharedDictionaryCacheMaxSize;
    /** @export { (network.mojom.FirstPartySetsAccessDelegateParams|undefined) } */
    this.firstPartySetsAccessDelegateParams;
    /** @export { (network.mojom.FirstPartySetsAccessDelegatePendingReceiver|undefined) } */
    this.firstPartySetsAccessDelegateReceiver;
    /** @export { !boolean } */
    this.acamPreflightSpecConformant;
    /** @export { (string|undefined) } */
    this.cookieDeprecationLabel;
    /** @export { (network.mojom.CookieEncryptionProviderRemote|undefined) } */
    this.cookieEncryptionProvider;
    /** @export { !boolean } */
    this.deviceBoundSessionsEnabled;
    /** @export { !bigint } */
    this.boundNetwork;
    /** @export { (Object<!string, !url.mojom.Url>|undefined) } */
    this.enterpriseReportingEndpoints;
    /** @export { (bigint|undefined) } */
    this.quicIdleConnectionTimeoutSeconds;
    /** @export { !Array<!contentSettings.mojom.ContentSettingPatternSource> } */
    this.trackingProtectionContentSettings;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkConditionsSpec.$,
    'NetworkConditions',
    [
      mojo.internal.StructField(
        'offline', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'latency', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'downloadThroughput', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uploadThroughput', 24,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetLoss', 32,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetQueueLength', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetReordering', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ruleId', 40,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('network.mojom.NetworkConditions');

/** @record */
network.mojom.NetworkConditions = class {
  constructor() {
    /** @export { !boolean } */
    this.offline;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.latency;
    /** @export { !number } */
    this.downloadThroughput;
    /** @export { !number } */
    this.uploadThroughput;
    /** @export { !number } */
    this.packetLoss;
    /** @export { !number } */
    this.packetQueueLength;
    /** @export { !boolean } */
    this.packetReordering;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.ruleId;
  }
};



mojo.internal.Struct(
    network.mojom.MatchedNetworkConditionsSpec.$,
    'MatchedNetworkConditions',
    [
      mojo.internal.StructField(
        'pattern', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'conditions', 8,
        0,
        network.mojom.NetworkConditionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.MatchedNetworkConditions');

/** @record */
network.mojom.MatchedNetworkConditions = class {
  constructor() {
    /** @export { !string } */
    this.pattern;
    /** @export { !network.mojom.NetworkConditions } */
    this.conditions;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkDurableMessageConfigSpec.$,
    'NetworkDurableMessageConfig',
    [
      mojo.internal.StructField(
        'httpStorageMaxSize', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkDurableMessageConfig');

/** @record */
network.mojom.NetworkDurableMessageConfig = class {
  constructor() {
    /** @export { !bigint } */
    this.httpStorageMaxSize;
  }
};



mojo.internal.Struct(
    network.mojom.SharedDictionaryInfoSpec.$,
    'SharedDictionaryInfo',
    [
      mojo.internal.StructField(
        'match', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchDest', 8,
        0,
        mojo.internal.Array(network.mojom.RequestDestinationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dictionaryUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastFetchTime', 32,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseTime', 40,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expiration', 48,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastUsedTime', 56,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'size', 64,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hash', 72,
        0,
        network.mojom.SHA256HashValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 88],]);



goog.provide('network.mojom.SharedDictionaryInfo');

/** @record */
network.mojom.SharedDictionaryInfo = class {
  constructor() {
    /** @export { !string } */
    this.match;
    /** @export { !Array<!network.mojom.RequestDestination> } */
    this.matchDest;
    /** @export { !string } */
    this.id;
    /** @export { !url.mojom.Url } */
    this.dictionaryUrl;
    /** @export { !mojoBase.mojom.Time } */
    this.lastFetchTime;
    /** @export { !mojoBase.mojom.Time } */
    this.responseTime;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.expiration;
    /** @export { !mojoBase.mojom.Time } */
    this.lastUsedTime;
    /** @export { !bigint } */
    this.size;
    /** @export { !network.mojom.SHA256HashValue } */
    this.hash;
  }
};



mojo.internal.Struct(
    network.mojom.SignedExchangeReportSpec.$,
    'SignedExchangeReport',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outerUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'innerUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certUrl', 32,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serverIpAddress', 48,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protocol', 56,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'method', 64,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'statusCode', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'elapsedTime', 72,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 88],]);



goog.provide('network.mojom.SignedExchangeReport');

/** @record */
network.mojom.SignedExchangeReport = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.type;
    /** @export { !url.mojom.Url } */
    this.outerUrl;
    /** @export { !url.mojom.Url } */
    this.innerUrl;
    /** @export { !url.mojom.Url } */
    this.certUrl;
    /** @export { !string } */
    this.referrer;
    /** @export { !network.mojom.IPAddress } */
    this.serverIpAddress;
    /** @export { !string } */
    this.protocol;
    /** @export { !string } */
    this.method;
    /** @export { !number } */
    this.statusCode;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.elapsedTime;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderFactoryOverrideSpec.$,
    'URLLoaderFactoryOverride',
    [
      mojo.internal.StructField(
        'overridingFactory', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'overriddenFactoryReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderFactoryPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'skipCorsEnabledSchemeCheck', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.URLLoaderFactoryOverride');

/** @record */
network.mojom.URLLoaderFactoryOverride = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderFactoryRemote } */
    this.overridingFactory;
    /** @export { (network.mojom.URLLoaderFactoryPendingReceiver|undefined) } */
    this.overriddenFactoryReceiver;
    /** @export { !boolean } */
    this.skipCorsEnabledSchemeCheck;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderFactoryParamsSpec.$,
    'URLLoaderFactoryParams',
    [
      mojo.internal.StructField(
        'processId', 0,
        0,
        mojo.internal.Int32,
        network.mojom.INVALID_PROCESS_ID,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestInitiatorOriginLock', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isOrbEnabled', 4,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ignoreIsolatedWorldOrigin', 4,
        1,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unsafeNonWebbyInitiator', 4,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disableWebSecurity', 4,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headerClient', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.TrustedURLLoaderHeaderClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isolationInfo', 24,
        0,
        network.mojom.IsolationInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disableSecureDns', 4,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isTrusted', 4,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'automaticallyAssignIsolationInfo', 4,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameId', 32,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'factoryOverride', 40,
        0,
        network.mojom.URLLoaderFactoryOverrideSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 48,
        0,
        network.mojom.ClientSecurityStateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'coepReporter', 56,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CrossOriginEmbedderPolicyReporterRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dipReporter', 64,
        0,
        mojo.internal.InterfaceProxy(network.mojom.DocumentIsolationPolicyReporterRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieObserver', 72,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CookieAccessObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustTokenObserver', 80,
        0,
        mojo.internal.InterfaceProxy(network.mojom.TrustTokenAccessObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sharedDictionaryObserver', 88,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SharedDictionaryAccessObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlLoaderNetworkObserver', 96,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderNetworkServiceObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsObserver', 104,
        0,
        mojo.internal.InterfaceProxy(network.mojom.DevToolsObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceBoundSessionObserver', 112,
        0,
        mojo.internal.InterfaceProxy(network.mojom.DeviceBoundSessionAccessObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustTokenIssuancePolicy', 120,
        0,
        network.mojom.TrustTokenOperationPolicyVerdictSpec.$,
        network.mojom.TrustTokenOperationPolicyVerdict.kPotentiallyPermit,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustTokenRedemptionPolicy', 124,
        0,
        network.mojom.TrustTokenOperationPolicyVerdictSpec.$,
        network.mojom.TrustTokenOperationPolicyVerdict.kPotentiallyPermit,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'debugTag', 128,
        0,
        mojo.internal.String,
        "",
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieSettingOverrides', 136,
        0,
        network.mojom.CookieSettingOverridesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsCookieSettingOverrides', 144,
        0,
        network.mojom.CookieSettingOverridesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requireCrossSiteRequestForCookies', 4,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ignoreFactoryReset', 5,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isMainFrameOriginRecentlyAccessed', 5,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 160],]);



goog.provide('network.mojom.URLLoaderFactoryParams');

/** @record */
network.mojom.URLLoaderFactoryParams = class {
  constructor() {
    /** @export { !number } */
    this.processId;
    /** @export { (url.mojom.Origin|undefined) } */
    this.requestInitiatorOriginLock;
    /** @export { !boolean } */
    this.isOrbEnabled;
    /** @export { !boolean } */
    this.ignoreIsolatedWorldOrigin;
    /** @export { !boolean } */
    this.unsafeNonWebbyInitiator;
    /** @export { !boolean } */
    this.disableWebSecurity;
    /** @export { (network.mojom.TrustedURLLoaderHeaderClientRemote|undefined) } */
    this.headerClient;
    /** @export { !network.mojom.IsolationInfo } */
    this.isolationInfo;
    /** @export { !boolean } */
    this.disableSecureDns;
    /** @export { !boolean } */
    this.isTrusted;
    /** @export { !boolean } */
    this.automaticallyAssignIsolationInfo;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.topFrameId;
    /** @export { (network.mojom.URLLoaderFactoryOverride|undefined) } */
    this.factoryOverride;
    /** @export { (network.mojom.ClientSecurityState|undefined) } */
    this.clientSecurityState;
    /** @export { (network.mojom.CrossOriginEmbedderPolicyReporterRemote|undefined) } */
    this.coepReporter;
    /** @export { (network.mojom.DocumentIsolationPolicyReporterRemote|undefined) } */
    this.dipReporter;
    /** @export { (network.mojom.CookieAccessObserverRemote|undefined) } */
    this.cookieObserver;
    /** @export { (network.mojom.TrustTokenAccessObserverRemote|undefined) } */
    this.trustTokenObserver;
    /** @export { (network.mojom.SharedDictionaryAccessObserverRemote|undefined) } */
    this.sharedDictionaryObserver;
    /** @export { (network.mojom.URLLoaderNetworkServiceObserverRemote|undefined) } */
    this.urlLoaderNetworkObserver;
    /** @export { (network.mojom.DevToolsObserverRemote|undefined) } */
    this.devtoolsObserver;
    /** @export { (network.mojom.DeviceBoundSessionAccessObserverRemote|undefined) } */
    this.deviceBoundSessionObserver;
    /** @export { !network.mojom.TrustTokenOperationPolicyVerdict } */
    this.trustTokenIssuancePolicy;
    /** @export { !network.mojom.TrustTokenOperationPolicyVerdict } */
    this.trustTokenRedemptionPolicy;
    /** @export { !string } */
    this.debugTag;
    /** @export { !network.mojom.CookieSettingOverrides } */
    this.cookieSettingOverrides;
    /** @export { !network.mojom.CookieSettingOverrides } */
    this.devtoolsCookieSettingOverrides;
    /** @export { !boolean } */
    this.requireCrossSiteRequestForCookies;
    /** @export { !boolean } */
    this.ignoreFactoryReset;
    /** @export { !boolean } */
    this.isMainFrameOriginRecentlyAccessed;
  }
};



mojo.internal.Struct(
    network.mojom.CustomProxyConnectionObserver_OnFallback_ParamsSpec.$,
    'CustomProxyConnectionObserver_OnFallback_Params',
    [
      mojo.internal.StructField(
        'badChain', 0,
        0,
        network.mojom.ProxyChainSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netError', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.CustomProxyConnectionObserver_OnFallback_Params');

/** @record */
network.mojom.CustomProxyConnectionObserver_OnFallback_Params = class {
  constructor() {
    /** @export { !network.mojom.ProxyChain } */
    this.badChain;
    /** @export { !number } */
    this.netError;
  }
};



mojo.internal.Struct(
    network.mojom.CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsSpec.$,
    'CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params',
    [
      mojo.internal.StructField(
        'proxyChain', 0,
        0,
        network.mojom.ProxyChainSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'chainIndex', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseHeaders', 16,
        0,
        network.mojom.HttpResponseHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params');

/** @record */
network.mojom.CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params = class {
  constructor() {
    /** @export { !network.mojom.ProxyChain } */
    this.proxyChain;
    /** @export { !bigint } */
    this.chainIndex;
    /** @export { !network.mojom.HttpResponseHeaders } */
    this.responseHeaders;
  }
};



mojo.internal.Struct(
    network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsSpec.$,
    'CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params',
    [
      mojo.internal.StructField(
        'proxyConfig', 0,
        0,
        network.mojom.CustomProxyConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params');

/** @record */
network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params = class {
  constructor() {
    /** @export { !network.mojom.CustomProxyConfig } */
    this.proxyConfig;
  }
};



mojo.internal.Struct(
    network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsSpec.$,
    'CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams');

/** @record */
network.mojom.CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ParamsSpec.$,
    'TrustedHeaderClient_OnBeforeSendHeaders_Params',
    [
      mojo.internal.StructField(
        'headers', 0,
        0,
        network.mojom.HttpRequestHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_Params');

/** @record */
network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_Params = class {
  constructor() {
    /** @export { !network.mojom.HttpRequestHeaders } */
    this.headers;
  }
};



mojo.internal.Struct(
    network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsSpec.$,
    'TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network.mojom.HttpRequestHeadersSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams');

/** @record */
network.mojom.TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.HttpRequestHeaders|undefined) } */
    this.headers;
  }
};



mojo.internal.Struct(
    network.mojom.TrustedHeaderClient_OnHeadersReceived_ParamsSpec.$,
    'TrustedHeaderClient_OnHeadersReceived_Params',
    [
      mojo.internal.StructField(
        'headers', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.TrustedHeaderClient_OnHeadersReceived_Params');

/** @record */
network.mojom.TrustedHeaderClient_OnHeadersReceived_Params = class {
  constructor() {
    /** @export { !string } */
    this.headers;
    /** @export { !network.mojom.IPEndPoint } */
    this.remoteEndpoint;
  }
};



mojo.internal.Struct(
    network.mojom.TrustedHeaderClient_OnHeadersReceived_ResponseParamsSpec.$,
    'TrustedHeaderClient_OnHeadersReceived_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preserveFragmentOnRedirectUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.TrustedHeaderClient_OnHeadersReceived_ResponseParams');

/** @record */
network.mojom.TrustedHeaderClient_OnHeadersReceived_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (string|undefined) } */
    this.headers;
    /** @export { (url.mojom.Url|undefined) } */
    this.preserveFragmentOnRedirectUrl;
  }
};



mojo.internal.Struct(
    network.mojom.TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsSpec.$,
    'TrustedURLLoaderHeaderClient_OnLoaderCreated_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headerClient', 4,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TrustedHeaderClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TrustedURLLoaderHeaderClient_OnLoaderCreated_Params');

/** @record */
network.mojom.TrustedURLLoaderHeaderClient_OnLoaderCreated_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !network.mojom.TrustedHeaderClientPendingReceiver } */
    this.headerClient;
  }
};



mojo.internal.Struct(
    network.mojom.TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsSpec.$,
    'TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        network.mojom.URLRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headerClient', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TrustedHeaderClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params');

/** @record */
network.mojom.TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params = class {
  constructor() {
    /** @export { !network.mojom.URLRequest } */
    this.request;
    /** @export { !network.mojom.TrustedHeaderClientPendingReceiver } */
    this.headerClient;
  }
};



mojo.internal.Struct(
    network.mojom.DurableMessageCollector_Configure_ParamsSpec.$,
    'DurableMessageCollector_Configure_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        network.mojom.NetworkDurableMessageConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.DurableMessageCollector_Configure_Params');

/** @record */
network.mojom.DurableMessageCollector_Configure_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkDurableMessageConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    network.mojom.DurableMessageCollector_Retrieve_ParamsSpec.$,
    'DurableMessageCollector_Retrieve_Params',
    [
      mojo.internal.StructField(
        'devtoolsRequestId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.DurableMessageCollector_Retrieve_Params');

/** @record */
network.mojom.DurableMessageCollector_Retrieve_Params = class {
  constructor() {
    /** @export { !string } */
    this.devtoolsRequestId;
  }
};



mojo.internal.Struct(
    network.mojom.DurableMessageCollector_Retrieve_ResponseParamsSpec.$,
    'DurableMessageCollector_Retrieve_ResponseParams',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.DurableMessageCollector_Retrieve_ResponseParams');

/** @record */
network.mojom.DurableMessageCollector_Retrieve_ResponseParams = class {
  constructor() {
    /** @export { (mojoBase.mojom.BigBuffer|undefined) } */
    this.message;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetClient_ParamsSpec.$,
    'NetworkContext_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.NetworkContextClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetClient_Params');

/** @record */
network.mojom.NetworkContext_SetClient_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkContextClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateURLLoaderFactory_ParamsSpec.$,
    'NetworkContext_CreateURLLoaderFactory_Params',
    [
      mojo.internal.StructField(
        'urlLoaderFactory', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        network.mojom.URLLoaderFactoryParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_CreateURLLoaderFactory_Params');

/** @record */
network.mojom.NetworkContext_CreateURLLoaderFactory_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderFactoryPendingReceiver } */
    this.urlLoaderFactory;
    /** @export { !network.mojom.URLLoaderFactoryParams } */
    this.params;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ResetURLLoaderFactories_ParamsSpec.$,
    'NetworkContext_ResetURLLoaderFactories_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ResetURLLoaderFactories_Params');

/** @record */
network.mojom.NetworkContext_ResetURLLoaderFactories_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetViaObliviousHttp_ParamsSpec.$,
    'NetworkContext_GetViaObliviousHttp_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        network.mojom.ObliviousHttpRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ObliviousHttpClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_GetViaObliviousHttp_Params');

/** @record */
network.mojom.NetworkContext_GetViaObliviousHttp_Params = class {
  constructor() {
    /** @export { !network.mojom.ObliviousHttpRequest } */
    this.request;
    /** @export { !network.mojom.ObliviousHttpClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetCookieManager_ParamsSpec.$,
    'NetworkContext_GetCookieManager_Params',
    [
      mojo.internal.StructField(
        'cookieManager', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.CookieManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetCookieManager_Params');

/** @record */
network.mojom.NetworkContext_GetCookieManager_Params = class {
  constructor() {
    /** @export { !network.mojom.CookieManagerPendingReceiver } */
    this.cookieManager;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetRestrictedCookieManager_ParamsSpec.$,
    'NetworkContext_GetRestrictedCookieManager_Params',
    [
      mojo.internal.StructField(
        'restrictedCookieManager', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.RestrictedCookieManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'role', 4,
        0,
        network.mojom.RestrictedCookieManagerRoleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isolationInfo', 16,
        0,
        network.mojom.IsolationInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieSettingOverrides', 24,
        0,
        network.mojom.CookieSettingOverridesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsCookieSettingOverrides', 32,
        0,
        network.mojom.CookieSettingOverridesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookieObserver', 40,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CookieAccessObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('network.mojom.NetworkContext_GetRestrictedCookieManager_Params');

/** @record */
network.mojom.NetworkContext_GetRestrictedCookieManager_Params = class {
  constructor() {
    /** @export { !network.mojom.RestrictedCookieManagerPendingReceiver } */
    this.restrictedCookieManager;
    /** @export { !network.mojom.RestrictedCookieManagerRole } */
    this.role;
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !network.mojom.IsolationInfo } */
    this.isolationInfo;
    /** @export { !network.mojom.CookieSettingOverrides } */
    this.cookieSettingOverrides;
    /** @export { !network.mojom.CookieSettingOverrides } */
    this.devtoolsCookieSettingOverrides;
    /** @export { (network.mojom.CookieAccessObserverRemote|undefined) } */
    this.cookieObserver;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetTrustTokenQueryAnswerer_ParamsSpec.$,
    'NetworkContext_GetTrustTokenQueryAnswerer_Params',
    [
      mojo.internal.StructField(
        'trustTokenQueryAnswerer', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TrustTokenQueryAnswererPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_GetTrustTokenQueryAnswerer_Params');

/** @record */
network.mojom.NetworkContext_GetTrustTokenQueryAnswerer_Params = class {
  constructor() {
    /** @export { !network.mojom.TrustTokenQueryAnswererPendingReceiver } */
    this.trustTokenQueryAnswerer;
    /** @export { !url.mojom.Origin } */
    this.topFrameOrigin;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearTrustTokenData_ParamsSpec.$,
    'NetworkContext_ClearTrustTokenData_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearTrustTokenData_Params');

/** @record */
network.mojom.NetworkContext_ClearTrustTokenData_Params = class {
  constructor() {
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearTrustTokenData_ResponseParamsSpec.$,
    'NetworkContext_ClearTrustTokenData_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearTrustTokenData_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearTrustTokenData_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ParamsSpec.$,
    'NetworkContext_ClearTrustTokenSessionOnlyData_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_Params');

/** @record */
network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsSpec.$,
    'NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams',
    [
      mojo.internal.StructField(
        'anyDataDeleted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.anyDataDeleted;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetStoredTrustTokenCounts_ParamsSpec.$,
    'NetworkContext_GetStoredTrustTokenCounts_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_GetStoredTrustTokenCounts_Params');

/** @record */
network.mojom.NetworkContext_GetStoredTrustTokenCounts_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetStoredTrustTokenCounts_ResponseParamsSpec.$,
    'NetworkContext_GetStoredTrustTokenCounts_ResponseParams',
    [
      mojo.internal.StructField(
        'tokens', 0,
        0,
        mojo.internal.Array(network.mojom.StoredTrustTokensForIssuerSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetStoredTrustTokenCounts_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetStoredTrustTokenCounts_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.StoredTrustTokensForIssuer> } */
    this.tokens;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsSpec.$,
    'NetworkContext_GetPrivateStateTokenRedemptionRecords_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_Params');

/** @record */
network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsSpec.$,
    'NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams',
    [
      mojo.internal.StructField(
        'issuerRedemptionRecordMap', 0,
        0,
        mojo.internal.Map(url.mojom.OriginSpec.$, mojo.internal.Array(network.mojom.ToplevelRedemptionRecordSpec.$, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams = class {
  constructor() {
    /** @export { !Map<!url.mojom.Origin, !Array<!network.mojom.ToplevelRedemptionRecord>> } */
    this.issuerRedemptionRecordMap;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetIpProxyStatus_ParamsSpec.$,
    'NetworkContext_GetIpProxyStatus_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_GetIpProxyStatus_Params');

/** @record */
network.mojom.NetworkContext_GetIpProxyStatus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetIpProxyStatus_ResponseParamsSpec.$,
    'NetworkContext_GetIpProxyStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ipProtection.mojom.IpProxyStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetIpProxyStatus_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetIpProxyStatus_ResponseParams = class {
  constructor() {
    /** @export { !ipProtection.mojom.IpProxyStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetBypassIpProtectionProxy_ParamsSpec.$,
    'NetworkContext_SetBypassIpProtectionProxy_Params',
    [
      mojo.internal.StructField(
        'bypassProxy', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetBypassIpProtectionProxy_Params');

/** @record */
network.mojom.NetworkContext_SetBypassIpProtectionProxy_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.bypassProxy;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_DeleteStoredTrustTokens_ParamsSpec.$,
    'NetworkContext_DeleteStoredTrustTokens_Params',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_DeleteStoredTrustTokens_Params');

/** @record */
network.mojom.NetworkContext_DeleteStoredTrustTokens_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.issuer;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_DeleteStoredTrustTokens_ResponseParamsSpec.$,
    'NetworkContext_DeleteStoredTrustTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        network.mojom.DeleteStoredTrustTokensStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_DeleteStoredTrustTokens_ResponseParams');

/** @record */
network.mojom.NetworkContext_DeleteStoredTrustTokens_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.DeleteStoredTrustTokensStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetBlockTrustTokens_ParamsSpec.$,
    'NetworkContext_SetBlockTrustTokens_Params',
    [
      mojo.internal.StructField(
        'block', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetBlockTrustTokens_Params');

/** @record */
network.mojom.NetworkContext_SetBlockTrustTokens_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.block;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetTrackingProtectionContentSetting_ParamsSpec.$,
    'NetworkContext_SetTrackingProtectionContentSetting_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        mojo.internal.Array(contentSettings.mojom.ContentSettingPatternSourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetTrackingProtectionContentSetting_Params');

/** @record */
network.mojom.NetworkContext_SetTrackingProtectionContentSetting_Params = class {
  constructor() {
    /** @export { !Array<!contentSettings.mojom.ContentSettingPatternSource> } */
    this.settings;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ParamsSpec.$,
    'NetworkContext_ClearNetworkingHistoryBetween_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_ClearNetworkingHistoryBetween_Params');

/** @record */
network.mojom.NetworkContext_ClearNetworkingHistoryBetween_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.startTime;
    /** @export { !mojoBase.mojom.Time } */
    this.endTime;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsSpec.$,
    'NetworkContext_ClearNetworkingHistoryBetween_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearNetworkingHistoryBetween_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearHttpCache_ParamsSpec.$,
    'NetworkContext_ClearHttpCache_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 16,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_ClearHttpCache_Params');

/** @record */
network.mojom.NetworkContext_ClearHttpCache_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.startTime;
    /** @export { !mojoBase.mojom.Time } */
    this.endTime;
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearHttpCache_ResponseParamsSpec.$,
    'NetworkContext_ClearHttpCache_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearHttpCache_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearHttpCache_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ComputeHttpCacheSize_ParamsSpec.$,
    'NetworkContext_ComputeHttpCacheSize_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_ComputeHttpCacheSize_Params');

/** @record */
network.mojom.NetworkContext_ComputeHttpCacheSize_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.startTime;
    /** @export { !mojoBase.mojom.Time } */
    this.endTime;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ComputeHttpCacheSize_ResponseParamsSpec.$,
    'NetworkContext_ComputeHttpCacheSize_ResponseParams',
    [
      mojo.internal.StructField(
        'isUpperBound', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sizeOrError', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_ComputeHttpCacheSize_ResponseParams');

/** @record */
network.mojom.NetworkContext_ComputeHttpCacheSize_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.isUpperBound;
    /** @export { !bigint } */
    this.sizeOrError;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_NotifyBrowserIdle_ParamsSpec.$,
    'NetworkContext_NotifyBrowserIdle_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_NotifyBrowserIdle_Params');

/** @record */
network.mojom.NetworkContext_NotifyBrowserIdle_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_NotifyExternalCacheHit_ParamsSpec.$,
    'NetworkContext_NotifyExternalCacheHit_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'httpMethod', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'key', 16,
        0,
        network.mojom.NetworkIsolationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeCredentials', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('network.mojom.NetworkContext_NotifyExternalCacheHit_Params');

/** @record */
network.mojom.NetworkContext_NotifyExternalCacheHit_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.httpMethod;
    /** @export { !network.mojom.NetworkIsolationKey } */
    this.key;
    /** @export { !boolean } */
    this.includeCredentials;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearHostCache_ParamsSpec.$,
    'NetworkContext_ClearHostCache_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearHostCache_Params');

/** @record */
network.mojom.NetworkContext_ClearHostCache_Params = class {
  constructor() {
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearHostCache_ResponseParamsSpec.$,
    'NetworkContext_ClearHostCache_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearHostCache_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearHostCache_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearHttpAuthCache_ParamsSpec.$,
    'NetworkContext_ClearHttpAuthCache_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 16,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_ClearHttpAuthCache_Params');

/** @record */
network.mojom.NetworkContext_ClearHttpAuthCache_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.startTime;
    /** @export { !mojoBase.mojom.Time } */
    this.endTime;
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearHttpAuthCache_ResponseParamsSpec.$,
    'NetworkContext_ClearHttpAuthCache_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearHttpAuthCache_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearHttpAuthCache_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearCorsPreflightCache_ParamsSpec.$,
    'NetworkContext_ClearCorsPreflightCache_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearCorsPreflightCache_Params');

/** @record */
network.mojom.NetworkContext_ClearCorsPreflightCache_Params = class {
  constructor() {
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearCorsPreflightCache_ResponseParamsSpec.$,
    'NetworkContext_ClearCorsPreflightCache_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearCorsPreflightCache_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearCorsPreflightCache_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearReportingCacheReports_ParamsSpec.$,
    'NetworkContext_ClearReportingCacheReports_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearReportingCacheReports_Params');

/** @record */
network.mojom.NetworkContext_ClearReportingCacheReports_Params = class {
  constructor() {
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearReportingCacheReports_ResponseParamsSpec.$,
    'NetworkContext_ClearReportingCacheReports_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearReportingCacheReports_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearReportingCacheReports_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearReportingCacheClients_ParamsSpec.$,
    'NetworkContext_ClearReportingCacheClients_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearReportingCacheClients_Params');

/** @record */
network.mojom.NetworkContext_ClearReportingCacheClients_Params = class {
  constructor() {
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearReportingCacheClients_ResponseParamsSpec.$,
    'NetworkContext_ClearReportingCacheClients_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearReportingCacheClients_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearReportingCacheClients_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearNetworkErrorLogging_ParamsSpec.$,
    'NetworkContext_ClearNetworkErrorLogging_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearNetworkErrorLogging_Params');

/** @record */
network.mojom.NetworkContext_ClearNetworkErrorLogging_Params = class {
  constructor() {
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearNetworkErrorLogging_ResponseParamsSpec.$,
    'NetworkContext_ClearNetworkErrorLogging_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearNetworkErrorLogging_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearNetworkErrorLogging_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearDomainReliability_ParamsSpec.$,
    'NetworkContext_ClearDomainReliability_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        network.mojom.NetworkContext.DomainReliabilityClearModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_ClearDomainReliability_Params');

/** @record */
network.mojom.NetworkContext_ClearDomainReliability_Params = class {
  constructor() {
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
    /** @export { !network.mojom.NetworkContext_DomainReliabilityClearMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearDomainReliability_ResponseParamsSpec.$,
    'NetworkContext_ClearDomainReliability_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearDomainReliability_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearDomainReliability_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearSharedDictionaryCache_ParamsSpec.$,
    'NetworkContext_ClearSharedDictionaryCache_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 16,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_ClearSharedDictionaryCache_Params');

/** @record */
network.mojom.NetworkContext_ClearSharedDictionaryCache_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.startTime;
    /** @export { !mojoBase.mojom.Time } */
    this.endTime;
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearSharedDictionaryCache_ResponseParamsSpec.$,
    'NetworkContext_ClearSharedDictionaryCache_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearSharedDictionaryCache_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearSharedDictionaryCache_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsSpec.$,
    'NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params',
    [
      mojo.internal.StructField(
        'isolationKey', 0,
        0,
        network.mojom.SharedDictionaryIsolationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params');

/** @record */
network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedDictionaryIsolationKey } */
    this.isolationKey;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsSpec.$,
    'NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetDocumentReportingEndpoints_ParamsSpec.$,
    'NetworkContext_SetDocumentReportingEndpoints_Params',
    [
      mojo.internal.StructField(
        'reportingSource', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isolationInfo', 16,
        0,
        network.mojom.IsolationInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoints', 24,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_SetDocumentReportingEndpoints_Params');

/** @record */
network.mojom.NetworkContext_SetDocumentReportingEndpoints_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.reportingSource;
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !network.mojom.IsolationInfo } */
    this.isolationInfo;
    /** @export { !Object<!string, !string> } */
    this.endpoints;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetEnterpriseReportingEndpoints_ParamsSpec.$,
    'NetworkContext_SetEnterpriseReportingEndpoints_Params',
    [
      mojo.internal.StructField(
        'endpoints', 0,
        0,
        mojo.internal.Map(mojo.internal.String, url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetEnterpriseReportingEndpoints_Params');

/** @record */
network.mojom.NetworkContext_SetEnterpriseReportingEndpoints_Params = class {
  constructor() {
    /** @export { !Object<!string, !url.mojom.Url> } */
    this.endpoints;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SendReportsAndRemoveSource_ParamsSpec.$,
    'NetworkContext_SendReportsAndRemoveSource_Params',
    [
      mojo.internal.StructField(
        'reportingSource', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SendReportsAndRemoveSource_Params');

/** @record */
network.mojom.NetworkContext_SendReportsAndRemoveSource_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.reportingSource;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_QueueReport_ParamsSpec.$,
    'NetworkContext_QueueReport_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'group', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportingSource', 24,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 32,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'body', 48,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('network.mojom.NetworkContext_QueueReport_Params');

/** @record */
network.mojom.NetworkContext_QueueReport_Params = class {
  constructor() {
    /** @export { !string } */
    this.type;
    /** @export { !string } */
    this.group;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.reportingSource;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.body;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_QueueEnterpriseReport_ParamsSpec.$,
    'NetworkContext_QueueEnterpriseReport_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'group', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'body', 24,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_QueueEnterpriseReport_Params');

/** @record */
network.mojom.NetworkContext_QueueEnterpriseReport_Params = class {
  constructor() {
    /** @export { !string } */
    this.type;
    /** @export { !string } */
    this.group;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.body;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_QueueSignedExchangeReport_ParamsSpec.$,
    'NetworkContext_QueueSignedExchangeReport_Params',
    [
      mojo.internal.StructField(
        'report', 0,
        0,
        network.mojom.SignedExchangeReportSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_QueueSignedExchangeReport_Params');

/** @record */
network.mojom.NetworkContext_QueueSignedExchangeReport_Params = class {
  constructor() {
    /** @export { !network.mojom.SignedExchangeReport } */
    this.report;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CloseAllConnections_ParamsSpec.$,
    'NetworkContext_CloseAllConnections_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_CloseAllConnections_Params');

/** @record */
network.mojom.NetworkContext_CloseAllConnections_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CloseAllConnections_ResponseParamsSpec.$,
    'NetworkContext_CloseAllConnections_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_CloseAllConnections_ResponseParams');

/** @record */
network.mojom.NetworkContext_CloseAllConnections_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CloseIdleConnections_ParamsSpec.$,
    'NetworkContext_CloseIdleConnections_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_CloseIdleConnections_Params');

/** @record */
network.mojom.NetworkContext_CloseIdleConnections_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CloseIdleConnections_ResponseParamsSpec.$,
    'NetworkContext_CloseIdleConnections_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_CloseIdleConnections_ResponseParams');

/** @record */
network.mojom.NetworkContext_CloseIdleConnections_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetNetworkConditions_ParamsSpec.$,
    'NetworkContext_SetNetworkConditions_Params',
    [
      mojo.internal.StructField(
        'throttlingProfileId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'conditions', 8,
        0,
        mojo.internal.Array(network.mojom.MatchedNetworkConditionsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_SetNetworkConditions_Params');

/** @record */
network.mojom.NetworkContext_SetNetworkConditions_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.throttlingProfileId;
    /** @export { !Array<!network.mojom.MatchedNetworkConditions> } */
    this.conditions;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_EnableDurableMessageCollector_ParamsSpec.$,
    'NetworkContext_EnableDurableMessageCollector_Params',
    [
      mojo.internal.StructField(
        'throttlingProfileId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.DurableMessageCollectorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_EnableDurableMessageCollector_Params');

/** @record */
network.mojom.NetworkContext_EnableDurableMessageCollector_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.throttlingProfileId;
    /** @export { !network.mojom.DurableMessageCollectorPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetAcceptLanguage_ParamsSpec.$,
    'NetworkContext_SetAcceptLanguage_Params',
    [
      mojo.internal.StructField(
        'newAcceptLanguage', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetAcceptLanguage_Params');

/** @record */
network.mojom.NetworkContext_SetAcceptLanguage_Params = class {
  constructor() {
    /** @export { !string } */
    this.newAcceptLanguage;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetEnableReferrers_ParamsSpec.$,
    'NetworkContext_SetEnableReferrers_Params',
    [
      mojo.internal.StructField(
        'enableReferrers', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetEnableReferrers_Params');

/** @record */
network.mojom.NetworkContext_SetEnableReferrers_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enableReferrers;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetCTPolicy_ParamsSpec.$,
    'NetworkContext_SetCTPolicy_Params',
    [
      mojo.internal.StructField(
        'ctPolicy', 0,
        0,
        network.mojom.CTPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetCTPolicy_Params');

/** @record */
network.mojom.NetworkContext_SetCTPolicy_Params = class {
  constructor() {
    /** @export { !network.mojom.CTPolicy } */
    this.ctPolicy;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateUDPSocket_ParamsSpec.$,
    'NetworkContext_CreateUDPSocket_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.UDPSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'listener', 4,
        0,
        mojo.internal.InterfaceProxy(network.mojom.UDPSocketListenerRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_CreateUDPSocket_Params');

/** @record */
network.mojom.NetworkContext_CreateUDPSocket_Params = class {
  constructor() {
    /** @export { !network.mojom.UDPSocketPendingReceiver } */
    this.receiver;
    /** @export { (network.mojom.UDPSocketListenerRemote|undefined) } */
    this.listener;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateRestrictedUDPSocket_ParamsSpec.$,
    'NetworkContext_CreateRestrictedUDPSocket_Params',
    [
      mojo.internal.StructField(
        'addr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        network.mojom.RestrictedUDPSocketModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 24,
        0,
        network.mojom.RestrictedUDPSocketParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 12,
        0,
        mojo.internal.InterfaceRequest(network.mojom.RestrictedUDPSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'listener', 32,
        0,
        mojo.internal.InterfaceProxy(network.mojom.UDPSocketListenerRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowMulticast', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('network.mojom.NetworkContext_CreateRestrictedUDPSocket_Params');

/** @record */
network.mojom.NetworkContext_CreateRestrictedUDPSocket_Params = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.addr;
    /** @export { !network.mojom.RestrictedUDPSocketMode } */
    this.mode;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { (network.mojom.RestrictedUDPSocketParams|undefined) } */
    this.params;
    /** @export { !network.mojom.RestrictedUDPSocketPendingReceiver } */
    this.receiver;
    /** @export { (network.mojom.UDPSocketListenerRemote|undefined) } */
    this.listener;
    /** @export { !boolean } */
    this.allowMulticast;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateRestrictedUDPSocket_ResponseParamsSpec.$,
    'NetworkContext_CreateRestrictedUDPSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddrOut', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_CreateRestrictedUDPSocket_ResponseParams');

/** @record */
network.mojom.NetworkContext_CreateRestrictedUDPSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddrOut;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateTCPServerSocket_ParamsSpec.$,
    'NetworkContext_CreateTCPServerSocket_Params',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        network.mojom.TCPServerSocketOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socket', 24,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TCPServerSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_CreateTCPServerSocket_Params');

/** @record */
network.mojom.NetworkContext_CreateTCPServerSocket_Params = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.localAddr;
    /** @export { !network.mojom.TCPServerSocketOptions } */
    this.options;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { !network.mojom.TCPServerSocketPendingReceiver } */
    this.socket;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateTCPServerSocket_ResponseParamsSpec.$,
    'NetworkContext_CreateTCPServerSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddrOut', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_CreateTCPServerSocket_ResponseParams');

/** @record */
network.mojom.NetworkContext_CreateTCPServerSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddrOut;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateTCPConnectedSocket_ParamsSpec.$,
    'NetworkContext_CreateTCPConnectedSocket_Params',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteAddrList', 8,
        0,
        network.mojom.AddressListSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tcpConnectedSocketOptions', 16,
        0,
        network.mojom.TCPConnectedSocketOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 24,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socket', 32,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TCPConnectedSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 36,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SocketObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('network.mojom.NetworkContext_CreateTCPConnectedSocket_Params');

/** @record */
network.mojom.NetworkContext_CreateTCPConnectedSocket_Params = class {
  constructor() {
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
    /** @export { !network.mojom.AddressList } */
    this.remoteAddrList;
    /** @export { (network.mojom.TCPConnectedSocketOptions|undefined) } */
    this.tcpConnectedSocketOptions;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { !network.mojom.TCPConnectedSocketPendingReceiver } */
    this.socket;
    /** @export { (network.mojom.SocketObserverRemote|undefined) } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateTCPConnectedSocket_ResponseParamsSpec.$,
    'NetworkContext_CreateTCPConnectedSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_CreateTCPConnectedSocket_ResponseParams');

/** @record */
network.mojom.NetworkContext_CreateTCPConnectedSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.peerAddr;
    /** @export { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @export { (MojoHandle|undefined) } */
    this.sendStream;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateTCPBoundSocket_ParamsSpec.$,
    'NetworkContext_CreateTCPBoundSocket_Params',
    [
      mojo.internal.StructField(
        'localAddr', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socket', 16,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TCPBoundSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_CreateTCPBoundSocket_Params');

/** @record */
network.mojom.NetworkContext_CreateTCPBoundSocket_Params = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.localAddr;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { !network.mojom.TCPBoundSocketPendingReceiver } */
    this.socket;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateTCPBoundSocket_ResponseParamsSpec.$,
    'NetworkContext_CreateTCPBoundSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_CreateTCPBoundSocket_ResponseParams');

/** @record */
network.mojom.NetworkContext_CreateTCPBoundSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateProxyResolvingSocketFactory_ParamsSpec.$,
    'NetworkContext_CreateProxyResolvingSocketFactory_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.ProxyResolvingSocketFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_CreateProxyResolvingSocketFactory_Params');

/** @record */
network.mojom.NetworkContext_CreateProxyResolvingSocketFactory_Params = class {
  constructor() {
    /** @export { !network.mojom.ProxyResolvingSocketFactoryPendingReceiver } */
    this.factory;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_LookUpProxyForURL_ParamsSpec.$,
    'NetworkContext_LookUpProxyForURL_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyLookupClient', 24,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ProxyLookupClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_LookUpProxyForURL_Params');

/** @record */
network.mojom.NetworkContext_LookUpProxyForURL_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !network.mojom.ProxyLookupClientRemote } */
    this.proxyLookupClient;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ForceReloadProxyConfig_ParamsSpec.$,
    'NetworkContext_ForceReloadProxyConfig_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ForceReloadProxyConfig_Params');

/** @record */
network.mojom.NetworkContext_ForceReloadProxyConfig_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ForceReloadProxyConfig_ResponseParamsSpec.$,
    'NetworkContext_ForceReloadProxyConfig_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ForceReloadProxyConfig_ResponseParams');

/** @record */
network.mojom.NetworkContext_ForceReloadProxyConfig_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearBadProxiesCache_ParamsSpec.$,
    'NetworkContext_ClearBadProxiesCache_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearBadProxiesCache_Params');

/** @record */
network.mojom.NetworkContext_ClearBadProxiesCache_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearBadProxiesCache_ResponseParamsSpec.$,
    'NetworkContext_ClearBadProxiesCache_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ClearBadProxiesCache_ResponseParams');

/** @record */
network.mojom.NetworkContext_ClearBadProxiesCache_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateWebSocket_ParamsSpec.$,
    'NetworkContext_CreateWebSocket_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestedProtocols', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 16,
        0,
        network.mojom.SiteForCookiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 24,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isolationInfo', 32,
        0,
        network.mojom.IsolationInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'additionalHeaders', 40,
        0,
        mojo.internal.Array(network.mojom.HttpHeaderSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'processId', 28,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 48,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 56,
        0,
        network.mojom.ClientSecurityStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 64,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 72,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'handshakeClient', 80,
        0,
        mojo.internal.InterfaceProxy(network.mojom.WebSocketHandshakeClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlLoaderNetworkObserver', 88,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderNetworkServiceObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authHandler', 96,
        0,
        mojo.internal.InterfaceProxy(network.mojom.WebSocketAuthenticationHandlerRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headerClient', 104,
        0,
        mojo.internal.InterfaceProxy(network.mojom.TrustedHeaderClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'throttlingProfileId', 112,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 128],]);



goog.provide('network.mojom.NetworkContext_CreateWebSocket_Params');

/** @record */
network.mojom.NetworkContext_CreateWebSocket_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Array<!string> } */
    this.requestedProtocols;
    /** @export { !network.mojom.SiteForCookies } */
    this.siteForCookies;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @export { !network.mojom.IsolationInfo } */
    this.isolationInfo;
    /** @export { !Array<!network.mojom.HttpHeader> } */
    this.additionalHeaders;
    /** @export { !number } */
    this.processId;
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !network.mojom.ClientSecurityState } */
    this.clientSecurityState;
    /** @export { !number } */
    this.options;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { !network.mojom.WebSocketHandshakeClientRemote } */
    this.handshakeClient;
    /** @export { (network.mojom.URLLoaderNetworkServiceObserverRemote|undefined) } */
    this.urlLoaderNetworkObserver;
    /** @export { (network.mojom.WebSocketAuthenticationHandlerRemote|undefined) } */
    this.authHandler;
    /** @export { (network.mojom.TrustedHeaderClientRemote|undefined) } */
    this.headerClient;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.throttlingProfileId;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateWebTransport_ParamsSpec.$,
    'NetworkContext_CreateWebTransport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fingerprints', 32,
        0,
        mojo.internal.Array(network.mojom.WebTransportCertificateFingerprintSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'applicationProtocols', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'handshakeClient', 48,
        0,
        mojo.internal.InterfaceProxy(network.mojom.WebTransportHandshakeClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlLoaderNetworkObserver', 56,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderNetworkServiceObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientSecurityState', 64,
        0,
        network.mojom.ClientSecurityStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('network.mojom.NetworkContext_CreateWebTransport_Params');

/** @record */
network.mojom.NetworkContext_CreateWebTransport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !Array<!network.mojom.WebTransportCertificateFingerprint> } */
    this.fingerprints;
    /** @export { !Array<!string> } */
    this.applicationProtocols;
    /** @export { !network.mojom.WebTransportHandshakeClientRemote } */
    this.handshakeClient;
    /** @export { (network.mojom.URLLoaderNetworkServiceObserverRemote|undefined) } */
    this.urlLoaderNetworkObserver;
    /** @export { !network.mojom.ClientSecurityState } */
    this.clientSecurityState;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateNetLogExporter_ParamsSpec.$,
    'NetworkContext_CreateNetLogExporter_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.NetLogExporterPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_CreateNetLogExporter_Params');

/** @record */
network.mojom.NetworkContext_CreateNetLogExporter_Params = class {
  constructor() {
    /** @export { !network.mojom.NetLogExporterPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_PreconnectSockets_ParamsSpec.$,
    'NetworkContext_PreconnectSockets_Params',
    [
      mojo.internal.StructField(
        'numStreams', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credentialsMode', 4,
        0,
        network.mojom.CredentialsModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 32,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keepaliveConfig', 40,
        0,
        network.mojom.ConnectionKeepAliveConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observerClient', 48,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ConnectionChangeObserverClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('network.mojom.NetworkContext_PreconnectSockets_Params');

/** @record */
network.mojom.NetworkContext_PreconnectSockets_Params = class {
  constructor() {
    /** @export { !number } */
    this.numStreams;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.CredentialsMode } */
    this.credentialsMode;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { (network.mojom.ConnectionKeepAliveConfig|undefined) } */
    this.keepaliveConfig;
    /** @export { (network.mojom.ConnectionChangeObserverClientRemote|undefined) } */
    this.observerClient;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateP2PSocketManager_ParamsSpec.$,
    'NetworkContext_CreateP2PSocketManager_Params',
    [
      mojo.internal.StructField(
        'networkAnonymizationKey', 0,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.P2PTrustedSocketManagerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustedSocketManager', 24,
        0,
        mojo.internal.InterfaceRequest(network.mojom.P2PTrustedSocketManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socketManager', 28,
        0,
        mojo.internal.InterfaceRequest(network.mojom.P2PSocketManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_CreateP2PSocketManager_Params');

/** @record */
network.mojom.NetworkContext_CreateP2PSocketManager_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !network.mojom.P2PTrustedSocketManagerClientRemote } */
    this.client;
    /** @export { !network.mojom.P2PTrustedSocketManagerPendingReceiver } */
    this.trustedSocketManager;
    /** @export { !network.mojom.P2PSocketManagerPendingReceiver } */
    this.socketManager;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateMdnsResponder_ParamsSpec.$,
    'NetworkContext_CreateMdnsResponder_Params',
    [
      mojo.internal.StructField(
        'responderReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.MdnsResponderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_CreateMdnsResponder_Params');

/** @record */
network.mojom.NetworkContext_CreateMdnsResponder_Params = class {
  constructor() {
    /** @export { !network.mojom.MdnsResponderPendingReceiver } */
    this.responderReceiver;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ResolveHost_ParamsSpec.$,
    'NetworkContext_ResolveHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        network.mojom.HostResolverHostSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'optionalParameters', 32,
        0,
        network.mojom.ResolveHostParametersSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseClient', 40,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ResolveHostClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('network.mojom.NetworkContext_ResolveHost_Params');

/** @record */
network.mojom.NetworkContext_ResolveHost_Params = class {
  constructor() {
    /** @export { !network.mojom.HostResolverHost } */
    this.host;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { (network.mojom.ResolveHostParameters|undefined) } */
    this.optionalParameters;
    /** @export { !network.mojom.ResolveHostClientRemote } */
    this.responseClient;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_CreateHostResolver_ParamsSpec.$,
    'NetworkContext_CreateHostResolver_Params',
    [
      mojo.internal.StructField(
        'configOverrides', 0,
        0,
        network.mojom.DnsConfigOverridesSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostResolver', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.HostResolverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_CreateHostResolver_Params');

/** @record */
network.mojom.NetworkContext_CreateHostResolver_Params = class {
  constructor() {
    /** @export { (network.mojom.DnsConfigOverrides|undefined) } */
    this.configOverrides;
    /** @export { !network.mojom.HostResolverPendingReceiver } */
    this.hostResolver;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_VerifyCert_ParamsSpec.$,
    'NetworkContext_VerifyCert_Params',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostPort', 8,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ocspResponse', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sctList', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_VerifyCert_Params');

/** @record */
network.mojom.NetworkContext_VerifyCert_Params = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.certificate;
    /** @export { !network.mojom.HostPortPair } */
    this.hostPort;
    /** @export { !string } */
    this.ocspResponse;
    /** @export { !string } */
    this.sctList;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_VerifyCert_ResponseParamsSpec.$,
    'NetworkContext_VerifyCert_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cvResult', 8,
        0,
        network.mojom.CertVerifyResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pkpBypassed', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_VerifyCert_ResponseParams');

/** @record */
network.mojom.NetworkContext_VerifyCert_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.errorCode;
    /** @export { !network.mojom.CertVerifyResult } */
    this.cvResult;
    /** @export { !boolean } */
    this.pkpBypassed;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_VerifyCertForSignedExchange_ParamsSpec.$,
    'NetworkContext_VerifyCertForSignedExchange_Params',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostPort', 8,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ocspResponse', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sctList', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_VerifyCertForSignedExchange_Params');

/** @record */
network.mojom.NetworkContext_VerifyCertForSignedExchange_Params = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.certificate;
    /** @export { !network.mojom.HostPortPair } */
    this.hostPort;
    /** @export { !string } */
    this.ocspResponse;
    /** @export { !string } */
    this.sctList;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_VerifyCertForSignedExchange_ResponseParamsSpec.$,
    'NetworkContext_VerifyCertForSignedExchange_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cvResult', 8,
        0,
        network.mojom.CertVerifyResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pkpBypassed', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_VerifyCertForSignedExchange_ResponseParams');

/** @record */
network.mojom.NetworkContext_VerifyCertForSignedExchange_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.errorCode;
    /** @export { !network.mojom.CertVerifyResult } */
    this.cvResult;
    /** @export { !boolean } */
    this.pkpBypassed;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_Verify2QwacCertBinding_ParamsSpec.$,
    'NetworkContext_Verify2QwacCertBinding_Params',
    [
      mojo.internal.StructField(
        'binding', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostname', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tlsCertificate', 16,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_Verify2QwacCertBinding_Params');

/** @record */
network.mojom.NetworkContext_Verify2QwacCertBinding_Params = class {
  constructor() {
    /** @export { !string } */
    this.binding;
    /** @export { !string } */
    this.hostname;
    /** @export { !network.mojom.X509Certificate } */
    this.tlsCertificate;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_Verify2QwacCertBinding_ResponseParamsSpec.$,
    'NetworkContext_Verify2QwacCertBinding_ResponseParams',
    [
      mojo.internal.StructField(
        'verifiedCert', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_Verify2QwacCertBinding_ResponseParams');

/** @record */
network.mojom.NetworkContext_Verify2QwacCertBinding_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.verifiedCert;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_AddHSTS_ParamsSpec.$,
    'NetworkContext_AddHSTS_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expiry', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeSubdomains', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_AddHSTS_Params');

/** @record */
network.mojom.NetworkContext_AddHSTS_Params = class {
  constructor() {
    /** @export { !string } */
    this.host;
    /** @export { !mojoBase.mojom.Time } */
    this.expiry;
    /** @export { !boolean } */
    this.includeSubdomains;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_AddHSTS_ResponseParamsSpec.$,
    'NetworkContext_AddHSTS_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_AddHSTS_ResponseParams');

/** @record */
network.mojom.NetworkContext_AddHSTS_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_IsHSTSActiveForHost_ParamsSpec.$,
    'NetworkContext_IsHSTSActiveForHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isTopLevelNav', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_IsHSTSActiveForHost_Params');

/** @record */
network.mojom.NetworkContext_IsHSTSActiveForHost_Params = class {
  constructor() {
    /** @export { !string } */
    this.host;
    /** @export { !boolean } */
    this.isTopLevelNav;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_IsHSTSActiveForHost_ResponseParamsSpec.$,
    'NetworkContext_IsHSTSActiveForHost_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_IsHSTSActiveForHost_ResponseParams');

/** @record */
network.mojom.NetworkContext_IsHSTSActiveForHost_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetHSTSState_ParamsSpec.$,
    'NetworkContext_GetHSTSState_Params',
    [
      mojo.internal.StructField(
        'domain', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetHSTSState_Params');

/** @record */
network.mojom.NetworkContext_GetHSTSState_Params = class {
  constructor() {
    /** @export { !string } */
    this.domain;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetHSTSState_ResponseParamsSpec.$,
    'NetworkContext_GetHSTSState_ResponseParams',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetHSTSState_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetHSTSState_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.state;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsSpec.$,
    'NetworkContext_SetCorsOriginAccessListsForOrigin_Params',
    [
      mojo.internal.StructField(
        'sourceOrigin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowPatterns', 8,
        0,
        mojo.internal.Array(network.mojom.CorsOriginPatternSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blockPatterns', 16,
        0,
        mojo.internal.Array(network.mojom.CorsOriginPatternSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_Params');

/** @record */
network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.sourceOrigin;
    /** @export { !Array<!network.mojom.CorsOriginPattern> } */
    this.allowPatterns;
    /** @export { !Array<!network.mojom.CorsOriginPattern> } */
    this.blockPatterns;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsSpec.$,
    'NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams');

/** @record */
network.mojom.NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_DeleteDynamicDataForHost_ParamsSpec.$,
    'NetworkContext_DeleteDynamicDataForHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_DeleteDynamicDataForHost_Params');

/** @record */
network.mojom.NetworkContext_DeleteDynamicDataForHost_Params = class {
  constructor() {
    /** @export { !string } */
    this.host;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_DeleteDynamicDataForHost_ResponseParamsSpec.$,
    'NetworkContext_DeleteDynamicDataForHost_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_DeleteDynamicDataForHost_ResponseParams');

/** @record */
network.mojom.NetworkContext_DeleteDynamicDataForHost_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsSpec.$,
    'NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params',
    [
      mojo.internal.StructField(
        'splitAuthCacheByNetworkAnonymizationKey', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params');

/** @record */
network.mojom.NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.splitAuthCacheByNetworkAnonymizationKey;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsSpec.$,
    'NetworkContext_SaveHttpAuthCacheProxyEntries_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_Params');

/** @record */
network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
    'NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams',
    [
      mojo.internal.StructField(
        'cacheKey', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams');

/** @record */
network.mojom.NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.cacheKey;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsSpec.$,
    'NetworkContext_LoadHttpAuthCacheProxyEntries_Params',
    [
      mojo.internal.StructField(
        'cacheKey', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_Params');

/** @record */
network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.cacheKey;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsSpec.$,
    'NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams');

/** @record */
network.mojom.NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_AddAuthCacheEntry_ParamsSpec.$,
    'NetworkContext_AddAuthCacheEntry_Params',
    [
      mojo.internal.StructField(
        'challenge', 0,
        0,
        network.mojom.AuthChallengeInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credentials', 24,
        0,
        network.mojom.AuthCredentialsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_AddAuthCacheEntry_Params');

/** @record */
network.mojom.NetworkContext_AddAuthCacheEntry_Params = class {
  constructor() {
    /** @export { !network.mojom.AuthChallengeInfo } */
    this.challenge;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !network.mojom.AuthCredentials } */
    this.credentials;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_AddAuthCacheEntry_ResponseParamsSpec.$,
    'NetworkContext_AddAuthCacheEntry_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_AddAuthCacheEntry_ResponseParams');

/** @record */
network.mojom.NetworkContext_AddAuthCacheEntry_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsSpec.$,
    'NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params');

/** @record */
network.mojom.NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ParamsSpec.$,
    'NetworkContext_EnableStaticKeyPinningForTesting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_Params');

/** @record */
network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsSpec.$,
    'NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams');

/** @record */
network.mojom.NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_VerifyCertificateForTesting_ParamsSpec.$,
    'NetworkContext_VerifyCertificateForTesting_Params',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostname', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ocspResponse', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sctList', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkContext_VerifyCertificateForTesting_Params');

/** @record */
network.mojom.NetworkContext_VerifyCertificateForTesting_Params = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.certificate;
    /** @export { !string } */
    this.hostname;
    /** @export { !string } */
    this.ocspResponse;
    /** @export { !string } */
    this.sctList;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_VerifyCertificateForTesting_ResponseParamsSpec.$,
    'NetworkContext_VerifyCertificateForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_VerifyCertificateForTesting_ResponseParams');

/** @record */
network.mojom.NetworkContext_VerifyCertificateForTesting_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.errorCode;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ParamsSpec.$,
    'NetworkContext_GetTrustAnchorIDsForTesting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_Params');

/** @record */
network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsSpec.$,
    'NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'trustAnchorIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams = class {
  constructor() {
    /** @export { !Array<!Array<!number>> } */
    this.trustAnchorIds;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ParamsSpec.$,
    'NetworkContext_AddDomainReliabilityContextForTesting_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uploadUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_Params');

/** @record */
network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
    /** @export { !url.mojom.Url } */
    this.uploadUrl;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsSpec.$,
    'NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams');

/** @record */
network.mojom.NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsSpec.$,
    'NetworkContext_ForceDomainReliabilityUploadsForTesting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_Params');

/** @record */
network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsSpec.$,
    'NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams');

/** @record */
network.mojom.NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetSCTAuditingMode_ParamsSpec.$,
    'NetworkContext_SetSCTAuditingMode_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        network.mojom.SCTAuditingModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetSCTAuditingMode_Params');

/** @record */
network.mojom.NetworkContext_SetSCTAuditingMode_Params = class {
  constructor() {
    /** @export { !network.mojom.SCTAuditingMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_AddReportingApiObserver_ParamsSpec.$,
    'NetworkContext_AddReportingApiObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ReportingApiObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_AddReportingApiObserver_Params');

/** @record */
network.mojom.NetworkContext_AddReportingApiObserver_Params = class {
  constructor() {
    /** @export { !network.mojom.ReportingApiObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ParamsSpec.$,
    'NetworkContext_GetSharedDictionaryUsageInfo_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_Params');

/** @record */
network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsSpec.$,
    'NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'usageInfo', 0,
        0,
        mojo.internal.Array(network.mojom.SharedDictionaryUsageInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.SharedDictionaryUsageInfo> } */
    this.usageInfo;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetSharedDictionaryInfo_ParamsSpec.$,
    'NetworkContext_GetSharedDictionaryInfo_Params',
    [
      mojo.internal.StructField(
        'isolationKey', 0,
        0,
        network.mojom.SharedDictionaryIsolationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetSharedDictionaryInfo_Params');

/** @record */
network.mojom.NetworkContext_GetSharedDictionaryInfo_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedDictionaryIsolationKey } */
    this.isolationKey;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetSharedDictionaryInfo_ResponseParamsSpec.$,
    'NetworkContext_GetSharedDictionaryInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'dictionaries', 0,
        0,
        mojo.internal.Array(network.mojom.SharedDictionaryInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetSharedDictionaryInfo_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetSharedDictionaryInfo_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.SharedDictionaryInfo> } */
    this.dictionaries;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ParamsSpec.$,
    'NetworkContext_GetSharedDictionaryOriginsBetween_Params',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_Params');

/** @record */
network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Time } */
    this.startTime;
    /** @export { !mojoBase.mojom.Time } */
    this.endTime;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsSpec.$,
    'NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams',
    [
      mojo.internal.StructField(
        'origins', 0,
        0,
        mojo.internal.Array(url.mojom.OriginSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams = class {
  constructor() {
    /** @export { !Array<!url.mojom.Origin> } */
    this.origins;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsSpec.$,
    'NetworkContext_SetSharedDictionaryCacheMaxSize_Params',
    [
      mojo.internal.StructField(
        'cacheMaxSize', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetSharedDictionaryCacheMaxSize_Params');

/** @record */
network.mojom.NetworkContext_SetSharedDictionaryCacheMaxSize_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.cacheMaxSize;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsSpec.$,
    'NetworkContext_PreloadSharedDictionaryInfoForDocument_Params',
    [
      mojo.internal.StructField(
        'urls', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preloadHandle', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_PreloadSharedDictionaryInfoForDocument_Params');

/** @record */
network.mojom.NetworkContext_PreloadSharedDictionaryInfoForDocument_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.urls;
    /** @export { !network.mojom.PreloadedSharedDictionaryInfoHandlePendingReceiver } */
    this.preloadHandle;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsSpec.$,
    'NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params');

/** @record */
network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsSpec.$,
    'NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams');

/** @record */
network.mojom.NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_FlushCachedClientCertIfNeeded_ParamsSpec.$,
    'NetworkContext_FlushCachedClientCertIfNeeded_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certificate', 8,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_FlushCachedClientCertIfNeeded_Params');

/** @record */
network.mojom.NetworkContext_FlushCachedClientCertIfNeeded_Params = class {
  constructor() {
    /** @export { !network.mojom.HostPortPair } */
    this.host;
    /** @export { !network.mojom.X509Certificate } */
    this.certificate;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_FlushMatchingCachedClientCert_ParamsSpec.$,
    'NetworkContext_FlushMatchingCachedClientCert_Params',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_FlushMatchingCachedClientCert_Params');

/** @record */
network.mojom.NetworkContext_FlushMatchingCachedClientCert_Params = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.certificate;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_SetCookieDeprecationLabel_ParamsSpec.$,
    'NetworkContext_SetCookieDeprecationLabel_Params',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_SetCookieDeprecationLabel_Params');

/** @record */
network.mojom.NetworkContext_SetCookieDeprecationLabel_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.label;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_RevokeNetworkForNonces_ParamsSpec.$,
    'NetworkContext_RevokeNetworkForNonces_Params',
    [
      mojo.internal.StructField(
        'nonces', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.UnguessableTokenSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_RevokeNetworkForNonces_Params');

/** @record */
network.mojom.NetworkContext_RevokeNetworkForNonces_Params = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.UnguessableToken> } */
    this.nonces;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_RevokeNetworkForNonces_ResponseParamsSpec.$,
    'NetworkContext_RevokeNetworkForNonces_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_RevokeNetworkForNonces_ResponseParams');

/** @record */
network.mojom.NetworkContext_RevokeNetworkForNonces_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ClearNonces_ParamsSpec.$,
    'NetworkContext_ClearNonces_Params',
    [
      mojo.internal.StructField(
        'nonces', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.UnguessableTokenSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_ClearNonces_Params');

/** @record */
network.mojom.NetworkContext_ClearNonces_Params = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.UnguessableToken> } */
    this.nonces;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsSpec.$,
    'NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params',
    [
      mojo.internal.StructField(
        'exemptedUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nonce', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params');

/** @record */
network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.exemptedUrl;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.nonce;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsSpec.$,
    'NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams');

/** @record */
network.mojom.NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_Prefetch_ParamsSpec.$,
    'NetworkContext_Prefetch_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        network.mojom.URLRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_Prefetch_Params');

/** @record */
network.mojom.NetworkContext_Prefetch_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !number } */
    this.options;
    /** @export { !network.mojom.URLRequest } */
    this.request;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetBoundNetworkForTesting_ParamsSpec.$,
    'NetworkContext_GetBoundNetworkForTesting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkContext_GetBoundNetworkForTesting_Params');

/** @record */
network.mojom.NetworkContext_GetBoundNetworkForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetBoundNetworkForTesting_ResponseParamsSpec.$,
    'NetworkContext_GetBoundNetworkForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'boundNetwork', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetBoundNetworkForTesting_ResponseParams');

/** @record */
network.mojom.NetworkContext_GetBoundNetworkForTesting_ResponseParams = class {
  constructor() {
    /** @export { !bigint } */
    this.boundNetwork;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_GetDeviceBoundSessionManager_ParamsSpec.$,
    'NetworkContext_GetDeviceBoundSessionManager_Params',
    [
      mojo.internal.StructField(
        'deviceBoundSessionManager', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.DeviceBoundSessionManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkContext_GetDeviceBoundSessionManager_Params');

/** @record */
network.mojom.NetworkContext_GetDeviceBoundSessionManager_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionManagerPendingReceiver } */
    this.deviceBoundSessionManager;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkContext_AddQuicHints_ParamsSpec.$,
    'NetworkContext_AddQuicHints_Params',
    [
      mojo.internal.StructField(
        'origins', 0,
        0,
        mojo.internal.Array(url.mojom.SchemeHostPortSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkContext_AddQuicHints_Params');

/** @record */
network.mojom.NetworkContext_AddQuicHints_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.SchemeHostPort> } */
    this.origins;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
  }
};

