// services/network/public/mojom/network_quality_estimator_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  EffectiveConnectionType as network_mojom_EffectiveConnectionType,
  EffectiveConnectionTypeSpec as network_mojom_EffectiveConnectionTypeSpec
} from './network_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetworkQualityEstimatorManagerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetworkQualityEstimatorManagerClient', scope);
  }
}

/** @interface */
export class NetworkQualityEstimatorManagerClientInterface {
  
  /**
   * @param { !network_mojom_EffectiveConnectionType } type
   * @param { !mojoBase_mojom_TimeDelta } httpRtt
   * @param { !mojoBase_mojom_TimeDelta } transportRtt
   * @param { !number } downlinkBandwidthKbps
   */

  onNetworkQualityChanged(type, httpRtt, transportRtt, downlinkBandwidthKbps) {}
}

/**
 * @implements { NetworkQualityEstimatorManagerClientInterface }
 */
export class NetworkQualityEstimatorManagerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetworkQualityEstimatorManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetworkQualityEstimatorManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetworkQualityEstimatorManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_EffectiveConnectionType } type
   * @param { !mojoBase_mojom_TimeDelta } httpRtt
   * @param { !mojoBase_mojom_TimeDelta } transportRtt
   * @param { !number } downlinkBandwidthKbps
   */

  onNetworkQualityChanged(
      type,
      httpRtt,
      transportRtt,
      downlinkBandwidthKbps) {
    this.proxy.sendMessage(
        0,
        NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_ParamsSpec.$,
        null,
        [
          type,
          httpRtt,
          transportRtt,
          downlinkBandwidthKbps
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetworkQualityEstimatorManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkQualityEstimatorManagerClientReceiver {
  /**
   * @param {!NetworkQualityEstimatorManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetworkQualityEstimatorManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetworkQualityEstimatorManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkQualityEstimatorManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_ParamsSpec.$,
        null,
        impl.onNetworkQualityChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetworkQualityEstimatorManagerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkQualityEstimatorManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetworkQualityEstimatorManagerClientRemote}
   */
  static getRemote() {
    let remote = new NetworkQualityEstimatorManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetworkQualityEstimatorManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkQualityEstimatorManagerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetworkQualityEstimatorManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkQualityEstimatorManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNetworkQualityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_ParamsSpec.$,
        null,
        this.onNetworkQualityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetworkQualityEstimatorManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetworkQualityEstimatorManager', scope);
  }
}

/** @interface */
export class NetworkQualityEstimatorManagerInterface {
  
  /**
   * @param { !NetworkQualityEstimatorManagerClientRemote } client
   */

  requestNotifications(client) {}
}

/**
 * @implements { NetworkQualityEstimatorManagerInterface }
 */
export class NetworkQualityEstimatorManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetworkQualityEstimatorManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetworkQualityEstimatorManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetworkQualityEstimatorManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !NetworkQualityEstimatorManagerClientRemote } client
   */

  requestNotifications(
      client) {
    this.proxy.sendMessage(
        0,
        NetworkQualityEstimatorManager_RequestNotifications_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetworkQualityEstimatorManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkQualityEstimatorManagerReceiver {
  /**
   * @param {!NetworkQualityEstimatorManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetworkQualityEstimatorManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetworkQualityEstimatorManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkQualityEstimatorManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetworkQualityEstimatorManager_RequestNotifications_ParamsSpec.$,
        null,
        impl.requestNotifications.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetworkQualityEstimatorManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkQualityEstimatorManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetworkQualityEstimatorManagerRemote}
   */
  static getRemote() {
    let remote = new NetworkQualityEstimatorManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetworkQualityEstimatorManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkQualityEstimatorManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetworkQualityEstimatorManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkQualityEstimatorManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetworkQualityEstimatorManager_RequestNotifications_ParamsSpec.$,
        null,
        this.requestNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkQualityEstimatorManager_RequestNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_ParamsSpec.$,
    'NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network_mojom_EffectiveConnectionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpRtt', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transportRtt', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'downlinkBandwidthKbps', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params {
  constructor() {
    /** @type { !network_mojom_EffectiveConnectionType } */
    this.type;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.httpRtt;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.transportRtt;
    /** @type { !number } */
    this.downlinkBandwidthKbps;
  }
}



mojo.internal.Struct(
    NetworkQualityEstimatorManager_RequestNotifications_ParamsSpec.$,
    'NetworkQualityEstimatorManager_RequestNotifications_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(NetworkQualityEstimatorManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkQualityEstimatorManager_RequestNotifications_Params {
  constructor() {
    /** @type { !NetworkQualityEstimatorManagerClientRemote } */
    this.client;
  }
}

