// services/network/public/mojom/reporting_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/reporting_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../mojo/public/mojom/base/values.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var network_anonymization_key$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_anonymization_key.mojom', 'network_anonymization_key.mojom.js');
  }


  var ReportingApiReportStatus = {};
  ReportingApiReportStatus.kQueued = 0;
  ReportingApiReportStatus.kPending = 1;
  ReportingApiReportStatus.kDoomed = 2;
  ReportingApiReportStatus.kSuccess = 3;
  ReportingApiReportStatus.MIN_VALUE = 0;
  ReportingApiReportStatus.MAX_VALUE = 3;

  ReportingApiReportStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  ReportingApiReportStatus.toKnownEnumValue = function(value) {
    return value;
  };

  ReportingApiReportStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ReportingApiReport(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingApiReport.prototype.initDefaults_ = function() {
    this.id = null;
    this.url = null;
    this.group = null;
    this.type = null;
    this.timestamp = null;
    this.depth = 0;
    this.attempts = 0;
    this.body = null;
    this.status = 0;
  };
  ReportingApiReport.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingApiReport.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiReport.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiReport.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiReport.group
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiReport.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiReport.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ReportingApiReport.body
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiReport.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 56, ReportingApiReportStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ReportingApiReport.encodedSize = codec.kStructHeaderSize + 64;

  ReportingApiReport.decode = function(decoder) {
    var packed;
    var val = new ReportingApiReport();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.group =
        decoder.decodeStruct(codec.String);
    val.type =
        decoder.decodeStruct(codec.String);
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.depth =
        decoder.decodeStruct(codec.Int32);
    val.attempts =
        decoder.decodeStruct(codec.Int32);
    val.body =
        decoder.decodeStructPointer(values$.DictionaryValue);
    val.status =
        decoder.decodeStruct(new codec.Enum(ReportingApiReportStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ReportingApiReport.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingApiReport.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.id);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.group);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeStructPointer(time$.TimeTicks, val.timestamp);
    encoder.encodeStruct(codec.Int32, val.depth);
    encoder.encodeStruct(codec.Int32, val.attempts);
    encoder.encodeStructPointer(values$.DictionaryValue, val.body);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ReportingApiEndpoint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingApiEndpoint.prototype.initDefaults_ = function() {
    this.url = null;
    this.attemptedUploads = 0;
    this.successfulUploads = 0;
    this.attemptedReports = 0;
    this.successfulReports = 0;
    this.priority = 0;
    this.weight = 0;
    this.origin = null;
    this.groupName = null;
    this.networkAnonymizationKey = null;
    this.reportingSource = null;
  };
  ReportingApiEndpoint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingApiEndpoint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiEndpoint.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;








    // validate ReportingApiEndpoint.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiEndpoint.groupName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiEndpoint.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 48, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiEndpoint.reportingSource
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ReportingApiEndpoint.encodedSize = codec.kStructHeaderSize + 72;

  ReportingApiEndpoint.decode = function(decoder) {
    var packed;
    var val = new ReportingApiEndpoint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.attemptedUploads =
        decoder.decodeStruct(codec.Int32);
    val.successfulUploads =
        decoder.decodeStruct(codec.Int32);
    val.attemptedReports =
        decoder.decodeStruct(codec.Int32);
    val.successfulReports =
        decoder.decodeStruct(codec.Int32);
    val.priority =
        decoder.decodeStruct(codec.Int32);
    val.weight =
        decoder.decodeStruct(codec.Int32);
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.groupName =
        decoder.decodeStruct(codec.String);
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    val.reportingSource =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  ReportingApiEndpoint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingApiEndpoint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.attemptedUploads);
    encoder.encodeStruct(codec.Int32, val.successfulUploads);
    encoder.encodeStruct(codec.Int32, val.attemptedReports);
    encoder.encodeStruct(codec.Int32, val.successfulReports);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.encodeStruct(codec.Int32, val.weight);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStruct(codec.String, val.groupName);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.reportingSource);
  };
  function ReportingApiObserver_OnReportAdded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingApiObserver_OnReportAdded_Params.prototype.initDefaults_ = function() {
    this.report = null;
  };
  ReportingApiObserver_OnReportAdded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingApiObserver_OnReportAdded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiObserver_OnReportAdded_Params.report
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ReportingApiReport, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ReportingApiObserver_OnReportAdded_Params.encodedSize = codec.kStructHeaderSize + 8;

  ReportingApiObserver_OnReportAdded_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingApiObserver_OnReportAdded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.report =
        decoder.decodeStructPointer(ReportingApiReport);
    return val;
  };

  ReportingApiObserver_OnReportAdded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingApiObserver_OnReportAdded_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ReportingApiReport, val.report);
  };
  function ReportingApiObserver_OnReportUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingApiObserver_OnReportUpdated_Params.prototype.initDefaults_ = function() {
    this.report = null;
  };
  ReportingApiObserver_OnReportUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingApiObserver_OnReportUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiObserver_OnReportUpdated_Params.report
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ReportingApiReport, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ReportingApiObserver_OnReportUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  ReportingApiObserver_OnReportUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingApiObserver_OnReportUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.report =
        decoder.decodeStructPointer(ReportingApiReport);
    return val;
  };

  ReportingApiObserver_OnReportUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingApiObserver_OnReportUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ReportingApiReport, val.report);
  };
  function ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.prototype.initDefaults_ = function() {
    this.endpoints = null;
  };
  ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.endpoints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ReportingApiEndpoint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.encodedSize = codec.kStructHeaderSize + 8;

  ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.endpoints =
        decoder.decodeArrayPointer(new codec.PointerTo(ReportingApiEndpoint));
    return val;
  };

  ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ReportingApiEndpoint), val.endpoints);
  };
  var kReportingApiObserver_OnReportAdded_Name = 0;
  var kReportingApiObserver_OnReportUpdated_Name = 1;
  var kReportingApiObserver_OnEndpointsUpdatedForOrigin_Name = 2;

  function ReportingApiObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ReportingApiObserver,
                                                   handleOrPtrInfo);
  }

  function ReportingApiObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ReportingApiObserver, associatedInterfacePtrInfo);
  }

  ReportingApiObserverAssociatedPtr.prototype =
      Object.create(ReportingApiObserverPtr.prototype);
  ReportingApiObserverAssociatedPtr.prototype.constructor =
      ReportingApiObserverAssociatedPtr;

  function ReportingApiObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  ReportingApiObserverPtr.prototype.onReportAdded = function() {
    return ReportingApiObserverProxy.prototype.onReportAdded
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingApiObserverProxy.prototype.onReportAdded = function(report) {
    var params_ = new ReportingApiObserver_OnReportAdded_Params();
    params_.report = report;
    var builder = new codec.MessageV0Builder(
        kReportingApiObserver_OnReportAdded_Name,
        codec.align(ReportingApiObserver_OnReportAdded_Params.encodedSize));
    builder.encodeStruct(ReportingApiObserver_OnReportAdded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingApiObserverPtr.prototype.onReportUpdated = function() {
    return ReportingApiObserverProxy.prototype.onReportUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingApiObserverProxy.prototype.onReportUpdated = function(report) {
    var params_ = new ReportingApiObserver_OnReportUpdated_Params();
    params_.report = report;
    var builder = new codec.MessageV0Builder(
        kReportingApiObserver_OnReportUpdated_Name,
        codec.align(ReportingApiObserver_OnReportUpdated_Params.encodedSize));
    builder.encodeStruct(ReportingApiObserver_OnReportUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingApiObserverPtr.prototype.onEndpointsUpdatedForOrigin = function() {
    return ReportingApiObserverProxy.prototype.onEndpointsUpdatedForOrigin
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingApiObserverProxy.prototype.onEndpointsUpdatedForOrigin = function(endpoints) {
    var params_ = new ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params();
    params_.endpoints = endpoints;
    var builder = new codec.MessageV0Builder(
        kReportingApiObserver_OnEndpointsUpdatedForOrigin_Name,
        codec.align(ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params.encodedSize));
    builder.encodeStruct(ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ReportingApiObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  ReportingApiObserverStub.prototype.onReportAdded = function(report) {
    return this.delegate_ && this.delegate_.onReportAdded && this.delegate_.onReportAdded(report);
  }
  ReportingApiObserverStub.prototype.onReportUpdated = function(report) {
    return this.delegate_ && this.delegate_.onReportUpdated && this.delegate_.onReportUpdated(report);
  }
  ReportingApiObserverStub.prototype.onEndpointsUpdatedForOrigin = function(endpoints) {
    return this.delegate_ && this.delegate_.onEndpointsUpdatedForOrigin && this.delegate_.onEndpointsUpdatedForOrigin(endpoints);
  }

  ReportingApiObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kReportingApiObserver_OnReportAdded_Name:
      var params = reader.decodeStruct(ReportingApiObserver_OnReportAdded_Params);
      this.onReportAdded(params.report);
      return true;
    case kReportingApiObserver_OnReportUpdated_Name:
      var params = reader.decodeStruct(ReportingApiObserver_OnReportUpdated_Params);
      this.onReportUpdated(params.report);
      return true;
    case kReportingApiObserver_OnEndpointsUpdatedForOrigin_Name:
      var params = reader.decodeStruct(ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params);
      this.onEndpointsUpdatedForOrigin(params.endpoints);
      return true;
    default:
      return false;
    }
  };

  ReportingApiObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateReportingApiObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kReportingApiObserver_OnReportAdded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingApiObserver_OnReportAdded_Params;
      break;
      case kReportingApiObserver_OnReportUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingApiObserver_OnReportUpdated_Params;
      break;
      case kReportingApiObserver_OnEndpointsUpdatedForOrigin_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateReportingApiObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ReportingApiObserver = {
    name: 'network.mojom.ReportingApiObserver',
    kVersion: 0,
    ptrClass: ReportingApiObserverPtr,
    proxyClass: ReportingApiObserverProxy,
    stubClass: ReportingApiObserverStub,
    validateRequest: validateReportingApiObserverRequest,
    validateResponse: null,
  };
  ReportingApiObserverStub.prototype.validator = validateReportingApiObserverRequest;
  ReportingApiObserverProxy.prototype.validator = null;
  exports.ReportingApiReportStatus = ReportingApiReportStatus;
  exports.ReportingApiReport = ReportingApiReport;
  exports.ReportingApiEndpoint = ReportingApiEndpoint;
  exports.ReportingApiObserver = ReportingApiObserver;
  exports.ReportingApiObserverPtr = ReportingApiObserverPtr;
  exports.ReportingApiObserverAssociatedPtr = ReportingApiObserverAssociatedPtr;
})();