// services/network/public/mojom/socket_broker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  AddressFamily as network_mojom_AddressFamily,
  AddressFamilySpec as network_mojom_AddressFamilySpec
} from './address_family.mojom.m.js';

import {
  TransferableSocket as network_mojom_TransferableSocket,
  TransferableSocketSpec as network_mojom_TransferableSocketSpec
} from './transferable_socket.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SocketBrokerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SocketBroker', scope);
  }
}

/** @interface */
export class SocketBrokerInterface {
  
  /**
   * @param { !network_mojom_AddressFamily } addressFamily
   * @return {!Promise<{
        createdSocket: !network_mojom_TransferableSocket,
        rv: !number,
   *  }>}
   */

  createTcpSocket(addressFamily) {}
  
  /**
   * @param { !network_mojom_AddressFamily } addressFamily
   * @return {!Promise<{
        createdSocket: !network_mojom_TransferableSocket,
        rv: !number,
   *  }>}
   */

  createUdpSocket(addressFamily) {}
}

/**
 * @implements { SocketBrokerInterface }
 */
export class SocketBrokerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SocketBrokerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SocketBrokerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SocketBrokerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_AddressFamily } addressFamily
   * @return {!Promise<{
        createdSocket: !network_mojom_TransferableSocket,
        rv: !number,
   *  }>}
   */

  createTcpSocket(
      addressFamily) {
    return this.proxy.sendMessage(
        0,
        SocketBroker_CreateTcpSocket_ParamsSpec.$,
        SocketBroker_CreateTcpSocket_ResponseParamsSpec.$,
        [
          addressFamily
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_AddressFamily } addressFamily
   * @return {!Promise<{
        createdSocket: !network_mojom_TransferableSocket,
        rv: !number,
   *  }>}
   */

  createUdpSocket(
      addressFamily) {
    return this.proxy.sendMessage(
        1,
        SocketBroker_CreateUdpSocket_ParamsSpec.$,
        SocketBroker_CreateUdpSocket_ResponseParamsSpec.$,
        [
          addressFamily
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SocketBroker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SocketBrokerReceiver {
  /**
   * @param {!SocketBrokerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SocketBrokerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SocketBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SocketBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SocketBroker_CreateTcpSocket_ParamsSpec.$,
        SocketBroker_CreateTcpSocket_ResponseParamsSpec.$,
        impl.createTcpSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SocketBroker_CreateUdpSocket_ParamsSpec.$,
        SocketBroker_CreateUdpSocket_ResponseParamsSpec.$,
        impl.createUdpSocket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SocketBroker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SocketBroker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SocketBrokerRemote}
   */
  static getRemote() {
    let remote = new SocketBrokerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SocketBroker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SocketBrokerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SocketBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SocketBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTcpSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SocketBroker_CreateTcpSocket_ParamsSpec.$,
        SocketBroker_CreateTcpSocket_ResponseParamsSpec.$,
        this.createTcpSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createUdpSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SocketBroker_CreateUdpSocket_ParamsSpec.$,
        SocketBroker_CreateUdpSocket_ResponseParamsSpec.$,
        this.createUdpSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SocketBroker_CreateTcpSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SocketBroker_CreateTcpSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SocketBroker_CreateUdpSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SocketBroker_CreateUdpSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SocketBroker_CreateTcpSocket_ParamsSpec.$,
    'SocketBroker_CreateTcpSocket_Params',
    [
      mojo.internal.StructField(
        'addressFamily', 0,
        0,
        network_mojom_AddressFamilySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SocketBroker_CreateTcpSocket_Params {
  constructor() {
    /** @type { !network_mojom_AddressFamily } */
    this.addressFamily;
  }
}



mojo.internal.Struct(
    SocketBroker_CreateTcpSocket_ResponseParamsSpec.$,
    'SocketBroker_CreateTcpSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'createdSocket', 0,
        0,
        network_mojom_TransferableSocketSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rv', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SocketBroker_CreateTcpSocket_ResponseParams {
  constructor() {
    /** @type { !network_mojom_TransferableSocket } */
    this.createdSocket;
    /** @type { !number } */
    this.rv;
  }
}



mojo.internal.Struct(
    SocketBroker_CreateUdpSocket_ParamsSpec.$,
    'SocketBroker_CreateUdpSocket_Params',
    [
      mojo.internal.StructField(
        'addressFamily', 0,
        0,
        network_mojom_AddressFamilySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SocketBroker_CreateUdpSocket_Params {
  constructor() {
    /** @type { !network_mojom_AddressFamily } */
    this.addressFamily;
  }
}



mojo.internal.Struct(
    SocketBroker_CreateUdpSocket_ResponseParamsSpec.$,
    'SocketBroker_CreateUdpSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'createdSocket', 0,
        0,
        network_mojom_TransferableSocketSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rv', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SocketBroker_CreateUdpSocket_ResponseParams {
  constructor() {
    /** @type { !network_mojom_TransferableSocket } */
    this.createdSocket;
    /** @type { !number } */
    this.rv;
  }
}

