// services/network/public/mojom/web_bundle_handle.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');





goog.provide('network.mojom.WebBundleErrorType');
goog.provide('network.mojom.WebBundleErrorTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.WebBundleErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.WebBundleErrorType = {
  
  kMetadataParseError: 0,
  kResponseParseError: 1,
  kResourceNotFound: 2,
  kMemoryQuotaExceeded: 3,
  kServingConstraintsNotMet: 4,
  kWebBundleFetchFailed: 5,
  kWebBundleRedirected: 6,
  kDeprecationWarning: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



goog.provide('network.mojom.WebBundleHandle');
goog.provide('network.mojom.WebBundleHandleReceiver');
goog.provide('network.mojom.WebBundleHandleCallbackRouter');
goog.provide('network.mojom.WebBundleHandleInterface');
goog.provide('network.mojom.WebBundleHandleRemote');
goog.provide('network.mojom.WebBundleHandlePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.WebBundleHandlePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.WebBundleHandle.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.WebBundleHandleInterface = class {
  
  /**
   * @param { !network.mojom.WebBundleHandlePendingReceiver } receiver
   */

  clone(receiver) {}
  
  /**
   * @param { !network.mojom.WebBundleErrorType } type
   * @param { !string } message
   */

  onWebBundleError(type, message) {}
  
  /**
   * @param { !boolean } success
   */

  onWebBundleLoadFinished(success) {}
};

/**
 * @export
 * @implements { network.mojom.WebBundleHandleInterface }
 */
network.mojom.WebBundleHandleRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.WebBundleHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.WebBundleHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.WebBundleHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.WebBundleHandlePendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        0,
        network.mojom.WebBundleHandle_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.WebBundleErrorType } type
   * @param { !string } message
   */

  onWebBundleError(
      type,
      message) {
    this.proxy.sendMessage(
        1,
        network.mojom.WebBundleHandle_OnWebBundleError_ParamsSpec.$,
        null,
        [
          type,
          message
        ],
        false);
  }

  
  /**
   * @param { !boolean } success
   */

  onWebBundleLoadFinished(
      success) {
    this.proxy.sendMessage(
        2,
        network.mojom.WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec.$,
        null,
        [
          success
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebBundleHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.WebBundleHandleReceiver = class {
  /**
   * @param {!network.mojom.WebBundleHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.WebBundleHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.WebBundleHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebBundleHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebBundleHandle_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebBundleHandle_OnWebBundleError_ParamsSpec.$,
        null,
        impl.onWebBundleError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec.$,
        null,
        impl.onWebBundleLoadFinished.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.WebBundleHandle = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.WebBundleHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.WebBundleHandleRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.WebBundleHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WebBundleHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.WebBundleHandleCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.WebBundleHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.WebBundleHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.WebBundleHandle_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWebBundleError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.WebBundleHandle_OnWebBundleError_ParamsSpec.$,
        null,
        this.onWebBundleError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWebBundleLoadFinished =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec.$,
        null,
        this.onWebBundleLoadFinished.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.WebBundleHandle_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebBundleHandle_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.WebBundleHandle_OnWebBundleError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebBundleHandle_OnWebBundleError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.WebBundleHandle_Clone_ParamsSpec.$,
    'WebBundleHandle_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.WebBundleHandlePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.WebBundleHandle_Clone_Params');

/** @record */
network.mojom.WebBundleHandle_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.WebBundleHandlePendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    network.mojom.WebBundleHandle_OnWebBundleError_ParamsSpec.$,
    'WebBundleHandle_OnWebBundleError_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network.mojom.WebBundleErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.WebBundleHandle_OnWebBundleError_Params');

/** @record */
network.mojom.WebBundleHandle_OnWebBundleError_Params = class {
  constructor() {
    /** @export { !network.mojom.WebBundleErrorType } */
    this.type;
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    network.mojom.WebBundleHandle_OnWebBundleLoadFinished_ParamsSpec.$,
    'WebBundleHandle_OnWebBundleLoadFinished_Params',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.WebBundleHandle_OnWebBundleLoadFinished_Params');

/** @record */
network.mojom.WebBundleHandle_OnWebBundleLoadFinished_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};

