// services/service_manager/public/mojom/service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('serviceManager.mojom.Connector');
goog.require('serviceManager.mojom.ProcessMetadata');
goog.require('serviceManager.mojom.ServiceControl');
goog.require('serviceManager.mojom.CapabilitySet');
goog.require('serviceManager.mojom.Identity');






goog.provide('serviceManager.mojom.Service');
goog.provide('serviceManager.mojom.ServiceReceiver');
goog.provide('serviceManager.mojom.ServiceCallbackRouter');
goog.provide('serviceManager.mojom.ServiceInterface');
goog.provide('serviceManager.mojom.ServiceRemote');
goog.provide('serviceManager.mojom.ServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
serviceManager.mojom.ServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        serviceManager.mojom.Service.$interfaceName,
        scope);
  }
};

/** @interface */
serviceManager.mojom.ServiceInterface = class {
  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   * @return {!Promise<{
        connectorReceiver: !serviceManager.mojom.ConnectorPendingReceiver,
        controlReceiver: !Object,
   *  }>}
   */

  onStart(identity) {}
  
  /**
   * @param { !serviceManager.mojom.BindSourceInfo } source
   * @param { !string } interfaceName
   * @param { !MojoHandle } interfacePipe
   * @return {!Promise}
   */

  onBindInterface(source, interfaceName, interfacePipe) {}
  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   * @param { !serviceManager.mojom.ServicePendingReceiver } receiver
   * @param { !serviceManager.mojom.ProcessMetadataRemote } metadata
   */

  createPackagedServiceInstance(identity, receiver, metadata) {}
};

/**
 * @export
 * @implements { serviceManager.mojom.ServiceInterface }
 */
serviceManager.mojom.ServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!serviceManager.mojom.ServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          serviceManager.mojom.ServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!serviceManager.mojom.ServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   * @return {!Promise<{
        connectorReceiver: !serviceManager.mojom.ConnectorPendingReceiver,
        controlReceiver: !Object,
   *  }>}
   */

  onStart(
      identity) {
    return this.proxy.sendMessage(
        0,
        serviceManager.mojom.Service_OnStart_ParamsSpec.$,
        serviceManager.mojom.Service_OnStart_ResponseParamsSpec.$,
        [
          identity
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.BindSourceInfo } source
   * @param { !string } interfaceName
   * @param { !MojoHandle } interfacePipe
   * @return {!Promise}
   */

  onBindInterface(
      source,
      interfaceName,
      interfacePipe) {
    return this.proxy.sendMessage(
        1,
        serviceManager.mojom.Service_OnBindInterface_ParamsSpec.$,
        serviceManager.mojom.Service_OnBindInterface_ResponseParamsSpec.$,
        [
          source,
          interfaceName,
          interfacePipe
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   * @param { !serviceManager.mojom.ServicePendingReceiver } receiver
   * @param { !serviceManager.mojom.ProcessMetadataRemote } metadata
   */

  createPackagedServiceInstance(
      identity,
      receiver,
      metadata) {
    this.proxy.sendMessage(
        2,
        serviceManager.mojom.Service_CreatePackagedServiceInstance_ParamsSpec.$,
        null,
        [
          identity,
          receiver,
          metadata
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Service
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
serviceManager.mojom.ServiceReceiver = class {
  /**
   * @param {!serviceManager.mojom.ServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!serviceManager.mojom.ServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        serviceManager.mojom.ServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.Service_OnStart_ParamsSpec.$,
        serviceManager.mojom.Service_OnStart_ResponseParamsSpec.$,
        impl.onStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        serviceManager.mojom.Service_OnBindInterface_ParamsSpec.$,
        serviceManager.mojom.Service_OnBindInterface_ResponseParamsSpec.$,
        impl.onBindInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        serviceManager.mojom.Service_CreatePackagedServiceInstance_ParamsSpec.$,
        null,
        impl.createPackagedServiceInstance.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
serviceManager.mojom.Service = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.Service";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!serviceManager.mojom.ServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new serviceManager.mojom.ServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Service
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
serviceManager.mojom.ServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      serviceManager.mojom.ServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.Service_OnStart_ParamsSpec.$,
        serviceManager.mojom.Service_OnStart_ResponseParamsSpec.$,
        this.onStart.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBindInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        serviceManager.mojom.Service_OnBindInterface_ParamsSpec.$,
        serviceManager.mojom.Service_OnBindInterface_ResponseParamsSpec.$,
        this.onBindInterface.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createPackagedServiceInstance =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        serviceManager.mojom.Service_CreatePackagedServiceInstance_ParamsSpec.$,
        null,
        this.createPackagedServiceInstance.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('serviceManager.mojom.BindSourceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.BindSourceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('serviceManager.mojom.Service_OnStart_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Service_OnStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('serviceManager.mojom.Service_OnStart_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Service_OnStart_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('serviceManager.mojom.Service_OnBindInterface_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Service_OnBindInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('serviceManager.mojom.Service_OnBindInterface_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Service_OnBindInterface_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('serviceManager.mojom.Service_CreatePackagedServiceInstance_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Service_CreatePackagedServiceInstance_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    serviceManager.mojom.BindSourceInfoSpec.$,
    'BindSourceInfo',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requiredCapabilities', 8,
        0,
        serviceManager.mojom.CapabilitySetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('serviceManager.mojom.BindSourceInfo');

/** @record */
serviceManager.mojom.BindSourceInfo = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
    /** @export { !serviceManager.mojom.CapabilitySet } */
    this.requiredCapabilities;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Service_OnStart_ParamsSpec.$,
    'Service_OnStart_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('serviceManager.mojom.Service_OnStart_Params');

/** @record */
serviceManager.mojom.Service_OnStart_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Service_OnStart_ResponseParamsSpec.$,
    'Service_OnStart_ResponseParams',
    [
      mojo.internal.StructField(
        'connectorReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(serviceManager.mojom.ConnectorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controlReceiver', 4,
        0,
        mojo.internal.AssociatedInterfaceRequest(serviceManager.mojom.ServiceControlPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('serviceManager.mojom.Service_OnStart_ResponseParams');

/** @record */
serviceManager.mojom.Service_OnStart_ResponseParams = class {
  constructor() {
    /** @export { !serviceManager.mojom.ConnectorPendingReceiver } */
    this.connectorReceiver;
    /** @export { !Object } */
    this.controlReceiver;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Service_OnBindInterface_ParamsSpec.$,
    'Service_OnBindInterface_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        serviceManager.mojom.BindSourceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interfaceName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interfacePipe', 16,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('serviceManager.mojom.Service_OnBindInterface_Params');

/** @record */
serviceManager.mojom.Service_OnBindInterface_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.BindSourceInfo } */
    this.source;
    /** @export { !string } */
    this.interfaceName;
    /** @export { !MojoHandle } */
    this.interfacePipe;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Service_OnBindInterface_ResponseParamsSpec.$,
    'Service_OnBindInterface_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('serviceManager.mojom.Service_OnBindInterface_ResponseParams');

/** @record */
serviceManager.mojom.Service_OnBindInterface_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Service_CreatePackagedServiceInstance_ParamsSpec.$,
    'Service_CreatePackagedServiceInstance_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(serviceManager.mojom.ServicePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadata', 12,
        0,
        mojo.internal.InterfaceProxy(serviceManager.mojom.ProcessMetadataRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('serviceManager.mojom.Service_CreatePackagedServiceInstance_Params');

/** @record */
serviceManager.mojom.Service_CreatePackagedServiceInstance_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
    /** @export { !serviceManager.mojom.ServicePendingReceiver } */
    this.receiver;
    /** @export { !serviceManager.mojom.ProcessMetadataRemote } */
    this.metadata;
  }
};

