// services/viz/public/mojom/compositing/compositor_render_pass.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/compositor_render_pass.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var compositor_render_pass_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_render_pass_id.mojom', 'compositor_render_pass_id.mojom.js');
  }
  var copy_output_request$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/copy_output_request.mojom', 'copy_output_request.mojom.js');
  }
  var filter_operations$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/filter_operations.mojom', 'filter_operations.mojom.js');
  }
  var quads$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/quads.mojom', 'quads.mojom.js');
  }
  var view_transition_element_resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom', 'view_transition_element_resource_id.mojom.js');
  }
  var subtree_capture_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/subtree_capture_id.mojom', 'subtree_capture_id.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/transform.mojom', '../../../../../ui/gfx/mojom/transform.mojom.js');
  }
  var skpath$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skpath.mojom', '../../../../../skia/public/mojom/skpath.mojom.js');
  }



  function CompositorRenderPass(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorRenderPass.prototype.initDefaults_ = function() {
    this.id = null;
    this.outputRect = null;
    this.damageRect = null;
    this.transformToRootTarget = null;
    this.filters = null;
    this.backdropFilters = null;
    this.backdropFilterBounds = null;
    this.subtreeCaptureId = null;
    this.subtreeSize = null;
    this.viewTransitionElementResourceId = null;
    this.hasTransparentBackground = false;
    this.cacheRenderPass = false;
    this.hasDamageFromContributingContent = false;
    this.generateMipmap = false;
    this.hasPerQuadDamage = false;
    this.copyRequests = null;
    this.quadList = null;
  };
  CompositorRenderPass.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorRenderPass.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 112}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, compositor_render_pass_id$.CompositorRenderPassId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.outputRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.damageRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.transformToRootTarget
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, transform$.Transform, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.filters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, filter_operations$.FilterOperations, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.backdropFilters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, filter_operations$.FilterOperations, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.backdropFilterBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, skpath$.SkPath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.subtreeCaptureId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, subtree_capture_id$.SubtreeCaptureId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.subtreeSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.viewTransitionElementResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, view_transition_element_resource_id$.ViewTransitionElementResourceId, true);
    if (err !== validator.validationError.NONE)
        return err;






    // validate CompositorRenderPass.copyRequests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 88, 8, new codec.PointerTo(copy_output_request$.CopyOutputRequest), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPass.quadList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 96, 8, new codec.PointerTo(quads$.DrawQuad), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CompositorRenderPass.encodedSize = codec.kStructHeaderSize + 104;

  CompositorRenderPass.decode = function(decoder) {
    var packed;
    var val = new CompositorRenderPass();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStructPointer(compositor_render_pass_id$.CompositorRenderPassId);
    val.outputRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.damageRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.transformToRootTarget =
        decoder.decodeStructPointer(transform$.Transform);
    val.filters =
        decoder.decodeStructPointer(filter_operations$.FilterOperations);
    val.backdropFilters =
        decoder.decodeStructPointer(filter_operations$.FilterOperations);
    val.backdropFilterBounds =
        decoder.decodeStructPointer(skpath$.SkPath);
    val.subtreeCaptureId =
        decoder.decodeStructPointer(subtree_capture_id$.SubtreeCaptureId);
    val.subtreeSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.viewTransitionElementResourceId =
        decoder.decodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId);
    packed = decoder.readUint8();
    val.hasTransparentBackground = (packed >> 0) & 1 ? true : false;
    val.cacheRenderPass = (packed >> 1) & 1 ? true : false;
    val.hasDamageFromContributingContent = (packed >> 2) & 1 ? true : false;
    val.generateMipmap = (packed >> 3) & 1 ? true : false;
    val.hasPerQuadDamage = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.copyRequests =
        decoder.decodeArrayPointer(new codec.PointerTo(copy_output_request$.CopyOutputRequest));
    val.quadList =
        decoder.decodeArrayPointer(new codec.PointerTo(quads$.DrawQuad));
    return val;
  };

  CompositorRenderPass.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorRenderPass.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(compositor_render_pass_id$.CompositorRenderPassId, val.id);
    encoder.encodeStructPointer(geometry$.Rect, val.outputRect);
    encoder.encodeStructPointer(geometry$.Rect, val.damageRect);
    encoder.encodeStructPointer(transform$.Transform, val.transformToRootTarget);
    encoder.encodeStructPointer(filter_operations$.FilterOperations, val.filters);
    encoder.encodeStructPointer(filter_operations$.FilterOperations, val.backdropFilters);
    encoder.encodeStructPointer(skpath$.SkPath, val.backdropFilterBounds);
    encoder.encodeStructPointer(subtree_capture_id$.SubtreeCaptureId, val.subtreeCaptureId);
    encoder.encodeStructPointer(geometry$.Size, val.subtreeSize);
    encoder.encodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId, val.viewTransitionElementResourceId);
    packed = 0;
    packed |= (val.hasTransparentBackground & 1) << 0
    packed |= (val.cacheRenderPass & 1) << 1
    packed |= (val.hasDamageFromContributingContent & 1) << 2
    packed |= (val.generateMipmap & 1) << 3
    packed |= (val.hasPerQuadDamage & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(copy_output_request$.CopyOutputRequest), val.copyRequests);
    encoder.encodeArrayPointer(new codec.PointerTo(quads$.DrawQuad), val.quadList);
  };
  exports.CompositorRenderPass = CompositorRenderPass;
})();