// services/viz/public/mojom/compositing/frame_sink_bundle.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/frame_sink_bundle.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var begin_frame_args$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/begin_frame_args.mojom', 'begin_frame_args.mojom.js');
  }
  var compositor_frame$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_frame.mojom', 'compositor_frame.mojom.js');
  }
  var compositor_frame_sink$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_frame_sink.mojom', 'compositor_frame_sink.mojom.js');
  }
  var local_surface_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/local_surface_id.mojom', 'local_surface_id.mojom.js');
  }
  var frame_timing_details$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/frame_timing_details.mojom', 'frame_timing_details.mojom.js');
  }
  var returned_resource$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/returned_resource.mojom', 'returned_resource.mojom.js');
  }
  var thread$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/thread.mojom', 'thread.mojom.js');
  }
  var hit_test_region_list$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/hit_test/hit_test_region_list.mojom', '../hit_test/hit_test_region_list.mojom.js');
  }



  function BundledFrameSubmission(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BundledFrameSubmission.prototype.initDefaults_ = function() {
    this.sinkId = 0;
    this.data = null;
  };
  BundledFrameSubmission.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BundledFrameSubmission.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BundledFrameSubmission.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, BundledFrameSubmissionData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BundledFrameSubmission.encodedSize = codec.kStructHeaderSize + 24;

  BundledFrameSubmission.decode = function(decoder) {
    var packed;
    var val = new BundledFrameSubmission();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sinkId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeStruct(BundledFrameSubmissionData);
    return val;
  };

  BundledFrameSubmission.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BundledFrameSubmission.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.sinkId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(BundledFrameSubmissionData, val.data);
  };
  function BundledCompositorFrame(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BundledCompositorFrame.prototype.initDefaults_ = function() {
    this.localSurfaceId = null;
    this.frame = null;
    this.hitTestRegionList = null;
    this.submitTime = 0;
  };
  BundledCompositorFrame.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BundledCompositorFrame.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BundledCompositorFrame.localSurfaceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, local_surface_id$.LocalSurfaceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BundledCompositorFrame.frame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, compositor_frame$.CompositorFrame, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BundledCompositorFrame.hitTestRegionList
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, hit_test_region_list$.HitTestRegionList, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BundledCompositorFrame.encodedSize = codec.kStructHeaderSize + 32;

  BundledCompositorFrame.decode = function(decoder) {
    var packed;
    var val = new BundledCompositorFrame();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localSurfaceId =
        decoder.decodeStructPointer(local_surface_id$.LocalSurfaceId);
    val.frame =
        decoder.decodeStructPointer(compositor_frame$.CompositorFrame);
    val.hitTestRegionList =
        decoder.decodeStructPointer(hit_test_region_list$.HitTestRegionList);
    val.submitTime =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  BundledCompositorFrame.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BundledCompositorFrame.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(local_surface_id$.LocalSurfaceId, val.localSurfaceId);
    encoder.encodeStructPointer(compositor_frame$.CompositorFrame, val.frame);
    encoder.encodeStructPointer(hit_test_region_list$.HitTestRegionList, val.hitTestRegionList);
    encoder.encodeStruct(codec.Uint64, val.submitTime);
  };
  function BundledReturnedResources(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BundledReturnedResources.prototype.initDefaults_ = function() {
    this.sinkId = 0;
    this.resources = null;
  };
  BundledReturnedResources.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BundledReturnedResources.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BundledReturnedResources.resources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(returned_resource$.ReturnedResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BundledReturnedResources.encodedSize = codec.kStructHeaderSize + 16;

  BundledReturnedResources.decode = function(decoder) {
    var packed;
    var val = new BundledReturnedResources();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sinkId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.resources =
        decoder.decodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource));
    return val;
  };

  BundledReturnedResources.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BundledReturnedResources.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.sinkId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource), val.resources);
  };
  function BeginFrameInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BeginFrameInfo.prototype.initDefaults_ = function() {
    this.sinkId = 0;
    this.args = null;
    this.details = null;
    this.resources = null;
  };
  BeginFrameInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BeginFrameInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BeginFrameInfo.args
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, begin_frame_args$.BeginFrameArgs, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginFrameInfo.details
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, codec.Uint32, new codec.PointerTo(frame_timing_details$.FrameTimingDetails), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginFrameInfo.resources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(returned_resource$.ReturnedResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BeginFrameInfo.encodedSize = codec.kStructHeaderSize + 32;

  BeginFrameInfo.decode = function(decoder) {
    var packed;
    var val = new BeginFrameInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sinkId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.args =
        decoder.decodeStructPointer(begin_frame_args$.BeginFrameArgs);
    val.details =
        decoder.decodeMapPointer(codec.Uint32, new codec.PointerTo(frame_timing_details$.FrameTimingDetails));
    val.resources =
        decoder.decodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource));
    return val;
  };

  BeginFrameInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BeginFrameInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.sinkId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(begin_frame_args$.BeginFrameArgs, val.args);
    encoder.encodeMapPointer(codec.Uint32, new codec.PointerTo(frame_timing_details$.FrameTimingDetails), val.details);
    encoder.encodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource), val.resources);
  };
  function FrameSinkBundle_SetNeedsBeginFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameSinkBundle_SetNeedsBeginFrame_Params.prototype.initDefaults_ = function() {
    this.sinkId = 0;
    this.needsBeginFrame = false;
  };
  FrameSinkBundle_SetNeedsBeginFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameSinkBundle_SetNeedsBeginFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameSinkBundle_SetNeedsBeginFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameSinkBundle_SetNeedsBeginFrame_Params.decode = function(decoder) {
    var packed;
    var val = new FrameSinkBundle_SetNeedsBeginFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sinkId =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.needsBeginFrame = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameSinkBundle_SetNeedsBeginFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameSinkBundle_SetNeedsBeginFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.sinkId);
    packed = 0;
    packed |= (val.needsBeginFrame & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameSinkBundle_Submit_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameSinkBundle_Submit_Params.prototype.initDefaults_ = function() {
    this.submissions = null;
  };
  FrameSinkBundle_Submit_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameSinkBundle_Submit_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameSinkBundle_Submit_Params.submissions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(BundledFrameSubmission), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameSinkBundle_Submit_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameSinkBundle_Submit_Params.decode = function(decoder) {
    var packed;
    var val = new FrameSinkBundle_Submit_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.submissions =
        decoder.decodeArrayPointer(new codec.PointerTo(BundledFrameSubmission));
    return val;
  };

  FrameSinkBundle_Submit_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameSinkBundle_Submit_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(BundledFrameSubmission), val.submissions);
  };
  function FrameSinkBundleClient_FlushNotifications_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameSinkBundleClient_FlushNotifications_Params.prototype.initDefaults_ = function() {
    this.acks = null;
    this.beginFrames = null;
    this.reclaimedResources = null;
  };
  FrameSinkBundleClient_FlushNotifications_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameSinkBundleClient_FlushNotifications_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameSinkBundleClient_FlushNotifications_Params.acks
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(BundledReturnedResources), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameSinkBundleClient_FlushNotifications_Params.beginFrames
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(BeginFrameInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameSinkBundleClient_FlushNotifications_Params.reclaimedResources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(BundledReturnedResources), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameSinkBundleClient_FlushNotifications_Params.encodedSize = codec.kStructHeaderSize + 24;

  FrameSinkBundleClient_FlushNotifications_Params.decode = function(decoder) {
    var packed;
    var val = new FrameSinkBundleClient_FlushNotifications_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.acks =
        decoder.decodeArrayPointer(new codec.PointerTo(BundledReturnedResources));
    val.beginFrames =
        decoder.decodeArrayPointer(new codec.PointerTo(BeginFrameInfo));
    val.reclaimedResources =
        decoder.decodeArrayPointer(new codec.PointerTo(BundledReturnedResources));
    return val;
  };

  FrameSinkBundleClient_FlushNotifications_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameSinkBundleClient_FlushNotifications_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(BundledReturnedResources), val.acks);
    encoder.encodeArrayPointer(new codec.PointerTo(BeginFrameInfo), val.beginFrames);
    encoder.encodeArrayPointer(new codec.PointerTo(BundledReturnedResources), val.reclaimedResources);
  };
  function FrameSinkBundleClient_OnBeginFramePausedChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameSinkBundleClient_OnBeginFramePausedChanged_Params.prototype.initDefaults_ = function() {
    this.sinkId = 0;
    this.paused = false;
  };
  FrameSinkBundleClient_OnBeginFramePausedChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameSinkBundleClient_OnBeginFramePausedChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameSinkBundleClient_OnBeginFramePausedChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameSinkBundleClient_OnBeginFramePausedChanged_Params.decode = function(decoder) {
    var packed;
    var val = new FrameSinkBundleClient_OnBeginFramePausedChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sinkId =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.paused = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FrameSinkBundleClient_OnBeginFramePausedChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameSinkBundleClient_OnBeginFramePausedChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.sinkId);
    packed = 0;
    packed |= (val.paused & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params.prototype.initDefaults_ = function() {
    this.sinkId = 0;
    this.sequenceId = 0;
  };
  FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params.decode = function(decoder) {
    var packed;
    var val = new FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sinkId =
        decoder.decodeStruct(codec.Uint32);
    val.sequenceId =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.sinkId);
    encoder.encodeStruct(codec.Uint32, val.sequenceId);
  };

  function BundledFrameSubmissionData(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  BundledFrameSubmissionData.Tags = {
    frame: 0,
    didNotProduceFrame: 1,
  };

  BundledFrameSubmissionData.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  BundledFrameSubmissionData.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "frame",
        "didNotProduceFrame",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a BundledFrameSubmissionData member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(BundledFrameSubmissionData.prototype, "frame", {
    get: function() {
      if (this.$tag != BundledFrameSubmissionData.Tags.frame) {
        throw new ReferenceError(
            "BundledFrameSubmissionData.frame is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = BundledFrameSubmissionData.Tags.frame;
      this.$data = value;
    }
  });
  Object.defineProperty(BundledFrameSubmissionData.prototype, "didNotProduceFrame", {
    get: function() {
      if (this.$tag != BundledFrameSubmissionData.Tags.didNotProduceFrame) {
        throw new ReferenceError(
            "BundledFrameSubmissionData.didNotProduceFrame is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = BundledFrameSubmissionData.Tags.didNotProduceFrame;
      this.$data = value;
    }
  });


    BundledFrameSubmissionData.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case BundledFrameSubmissionData.Tags.frame:
          encoder.encodeStructPointer(BundledCompositorFrame, val.frame);
          break;
        case BundledFrameSubmissionData.Tags.didNotProduceFrame:
          encoder.encodeStructPointer(begin_frame_args$.BeginFrameAck, val.didNotProduceFrame);
          break;
      }
      encoder.align();
    };


    BundledFrameSubmissionData.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new BundledFrameSubmissionData();
      var tag = decoder.readUint32();
      switch (tag) {
        case BundledFrameSubmissionData.Tags.frame:
          result.frame = decoder.decodeStructPointer(BundledCompositorFrame);
          break;
        case BundledFrameSubmissionData.Tags.didNotProduceFrame:
          result.didNotProduceFrame = decoder.decodeStructPointer(begin_frame_args$.BeginFrameAck);
          break;
      }
      decoder.align();

      return result;
    };


    BundledFrameSubmissionData.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case BundledFrameSubmissionData.Tags.frame:
          

    // validate BundledFrameSubmissionData.frame
    err = messageValidator.validateStructPointer(data_offset, BundledCompositorFrame, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case BundledFrameSubmissionData.Tags.didNotProduceFrame:
          

    // validate BundledFrameSubmissionData.didNotProduceFrame
    err = messageValidator.validateStructPointer(data_offset, begin_frame_args$.BeginFrameAck, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  BundledFrameSubmissionData.encodedSize = 16;
  var kFrameSinkBundle_SetNeedsBeginFrame_Name = 0;
  var kFrameSinkBundle_Submit_Name = 1;

  function FrameSinkBundlePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FrameSinkBundle,
                                                   handleOrPtrInfo);
  }

  function FrameSinkBundleAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FrameSinkBundle, associatedInterfacePtrInfo);
  }

  FrameSinkBundleAssociatedPtr.prototype =
      Object.create(FrameSinkBundlePtr.prototype);
  FrameSinkBundleAssociatedPtr.prototype.constructor =
      FrameSinkBundleAssociatedPtr;

  function FrameSinkBundleProxy(receiver) {
    this.receiver_ = receiver;
  }
  FrameSinkBundlePtr.prototype.setNeedsBeginFrame = function() {
    return FrameSinkBundleProxy.prototype.setNeedsBeginFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameSinkBundleProxy.prototype.setNeedsBeginFrame = function(sinkId, needsBeginFrame) {
    var params_ = new FrameSinkBundle_SetNeedsBeginFrame_Params();
    params_.sinkId = sinkId;
    params_.needsBeginFrame = needsBeginFrame;
    var builder = new codec.MessageV0Builder(
        kFrameSinkBundle_SetNeedsBeginFrame_Name,
        codec.align(FrameSinkBundle_SetNeedsBeginFrame_Params.encodedSize));
    builder.encodeStruct(FrameSinkBundle_SetNeedsBeginFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameSinkBundlePtr.prototype.submit = function() {
    return FrameSinkBundleProxy.prototype.submit
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameSinkBundleProxy.prototype.submit = function(submissions) {
    var params_ = new FrameSinkBundle_Submit_Params();
    params_.submissions = submissions;
    var builder = new codec.MessageV0Builder(
        kFrameSinkBundle_Submit_Name,
        codec.align(FrameSinkBundle_Submit_Params.encodedSize));
    builder.encodeStruct(FrameSinkBundle_Submit_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FrameSinkBundleStub(delegate) {
    this.delegate_ = delegate;
  }
  FrameSinkBundleStub.prototype.setNeedsBeginFrame = function(sinkId, needsBeginFrame) {
    return this.delegate_ && this.delegate_.setNeedsBeginFrame && this.delegate_.setNeedsBeginFrame(sinkId, needsBeginFrame);
  }
  FrameSinkBundleStub.prototype.submit = function(submissions) {
    return this.delegate_ && this.delegate_.submit && this.delegate_.submit(submissions);
  }

  FrameSinkBundleStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFrameSinkBundle_SetNeedsBeginFrame_Name:
      var params = reader.decodeStruct(FrameSinkBundle_SetNeedsBeginFrame_Params);
      this.setNeedsBeginFrame(params.sinkId, params.needsBeginFrame);
      return true;
    case kFrameSinkBundle_Submit_Name:
      var params = reader.decodeStruct(FrameSinkBundle_Submit_Params);
      this.submit(params.submissions);
      return true;
    default:
      return false;
    }
  };

  FrameSinkBundleStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFrameSinkBundleRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFrameSinkBundle_SetNeedsBeginFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameSinkBundle_SetNeedsBeginFrame_Params;
      break;
      case kFrameSinkBundle_Submit_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameSinkBundle_Submit_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFrameSinkBundleResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FrameSinkBundle = {
    name: 'viz.mojom.FrameSinkBundle',
    kVersion: 0,
    ptrClass: FrameSinkBundlePtr,
    proxyClass: FrameSinkBundleProxy,
    stubClass: FrameSinkBundleStub,
    validateRequest: validateFrameSinkBundleRequest,
    validateResponse: null,
  };
  FrameSinkBundleStub.prototype.validator = validateFrameSinkBundleRequest;
  FrameSinkBundleProxy.prototype.validator = null;
  var kFrameSinkBundleClient_FlushNotifications_Name = 0;
  var kFrameSinkBundleClient_OnBeginFramePausedChanged_Name = 1;
  var kFrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Name = 2;

  function FrameSinkBundleClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FrameSinkBundleClient,
                                                   handleOrPtrInfo);
  }

  function FrameSinkBundleClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FrameSinkBundleClient, associatedInterfacePtrInfo);
  }

  FrameSinkBundleClientAssociatedPtr.prototype =
      Object.create(FrameSinkBundleClientPtr.prototype);
  FrameSinkBundleClientAssociatedPtr.prototype.constructor =
      FrameSinkBundleClientAssociatedPtr;

  function FrameSinkBundleClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  FrameSinkBundleClientPtr.prototype.flushNotifications = function() {
    return FrameSinkBundleClientProxy.prototype.flushNotifications
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameSinkBundleClientProxy.prototype.flushNotifications = function(acks, beginFrames, reclaimedResources) {
    var params_ = new FrameSinkBundleClient_FlushNotifications_Params();
    params_.acks = acks;
    params_.beginFrames = beginFrames;
    params_.reclaimedResources = reclaimedResources;
    var builder = new codec.MessageV0Builder(
        kFrameSinkBundleClient_FlushNotifications_Name,
        codec.align(FrameSinkBundleClient_FlushNotifications_Params.encodedSize));
    builder.encodeStruct(FrameSinkBundleClient_FlushNotifications_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameSinkBundleClientPtr.prototype.onBeginFramePausedChanged = function() {
    return FrameSinkBundleClientProxy.prototype.onBeginFramePausedChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameSinkBundleClientProxy.prototype.onBeginFramePausedChanged = function(sinkId, paused) {
    var params_ = new FrameSinkBundleClient_OnBeginFramePausedChanged_Params();
    params_.sinkId = sinkId;
    params_.paused = paused;
    var builder = new codec.MessageV0Builder(
        kFrameSinkBundleClient_OnBeginFramePausedChanged_Name,
        codec.align(FrameSinkBundleClient_OnBeginFramePausedChanged_Params.encodedSize));
    builder.encodeStruct(FrameSinkBundleClient_OnBeginFramePausedChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameSinkBundleClientPtr.prototype.onCompositorFrameTransitionDirectiveProcessed = function() {
    return FrameSinkBundleClientProxy.prototype.onCompositorFrameTransitionDirectiveProcessed
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameSinkBundleClientProxy.prototype.onCompositorFrameTransitionDirectiveProcessed = function(sinkId, sequenceId) {
    var params_ = new FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params();
    params_.sinkId = sinkId;
    params_.sequenceId = sequenceId;
    var builder = new codec.MessageV0Builder(
        kFrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Name,
        codec.align(FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params.encodedSize));
    builder.encodeStruct(FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FrameSinkBundleClientStub(delegate) {
    this.delegate_ = delegate;
  }
  FrameSinkBundleClientStub.prototype.flushNotifications = function(acks, beginFrames, reclaimedResources) {
    return this.delegate_ && this.delegate_.flushNotifications && this.delegate_.flushNotifications(acks, beginFrames, reclaimedResources);
  }
  FrameSinkBundleClientStub.prototype.onBeginFramePausedChanged = function(sinkId, paused) {
    return this.delegate_ && this.delegate_.onBeginFramePausedChanged && this.delegate_.onBeginFramePausedChanged(sinkId, paused);
  }
  FrameSinkBundleClientStub.prototype.onCompositorFrameTransitionDirectiveProcessed = function(sinkId, sequenceId) {
    return this.delegate_ && this.delegate_.onCompositorFrameTransitionDirectiveProcessed && this.delegate_.onCompositorFrameTransitionDirectiveProcessed(sinkId, sequenceId);
  }

  FrameSinkBundleClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFrameSinkBundleClient_FlushNotifications_Name:
      var params = reader.decodeStruct(FrameSinkBundleClient_FlushNotifications_Params);
      this.flushNotifications(params.acks, params.beginFrames, params.reclaimedResources);
      return true;
    case kFrameSinkBundleClient_OnBeginFramePausedChanged_Name:
      var params = reader.decodeStruct(FrameSinkBundleClient_OnBeginFramePausedChanged_Params);
      this.onBeginFramePausedChanged(params.sinkId, params.paused);
      return true;
    case kFrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Name:
      var params = reader.decodeStruct(FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params);
      this.onCompositorFrameTransitionDirectiveProcessed(params.sinkId, params.sequenceId);
      return true;
    default:
      return false;
    }
  };

  FrameSinkBundleClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFrameSinkBundleClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFrameSinkBundleClient_FlushNotifications_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameSinkBundleClient_FlushNotifications_Params;
      break;
      case kFrameSinkBundleClient_OnBeginFramePausedChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameSinkBundleClient_OnBeginFramePausedChanged_Params;
      break;
      case kFrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFrameSinkBundleClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FrameSinkBundleClient = {
    name: 'viz.mojom.FrameSinkBundleClient',
    kVersion: 0,
    ptrClass: FrameSinkBundleClientPtr,
    proxyClass: FrameSinkBundleClientProxy,
    stubClass: FrameSinkBundleClientStub,
    validateRequest: validateFrameSinkBundleClientRequest,
    validateResponse: null,
  };
  FrameSinkBundleClientStub.prototype.validator = validateFrameSinkBundleClientRequest;
  FrameSinkBundleClientProxy.prototype.validator = null;
  exports.BundledFrameSubmission = BundledFrameSubmission;
  exports.BundledCompositorFrame = BundledCompositorFrame;
  exports.BundledReturnedResources = BundledReturnedResources;
  exports.BeginFrameInfo = BeginFrameInfo;
  exports.BundledFrameSubmissionData = BundledFrameSubmissionData;
  exports.FrameSinkBundle = FrameSinkBundle;
  exports.FrameSinkBundlePtr = FrameSinkBundlePtr;
  exports.FrameSinkBundleAssociatedPtr = FrameSinkBundleAssociatedPtr;
  exports.FrameSinkBundleClient = FrameSinkBundleClient;
  exports.FrameSinkBundleClientPtr = FrameSinkBundleClientPtr;
  exports.FrameSinkBundleClientAssociatedPtr = FrameSinkBundleClientAssociatedPtr;
})();