// services/viz/public/mojom/compositing/layer_context.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BrowserControlsOffsetTagModifications as cc_mojom_BrowserControlsOffsetTagModifications,
  BrowserControlsOffsetTagModificationsSpec as cc_mojom_BrowserControlsOffsetTagModificationsSpec
} from '../../../../../cc/mojom/browser_controls_offset_tag_modifications.mojom.m.js';

import {
  BrowserControlsParams as cc_mojom_BrowserControlsParams,
  BrowserControlsParamsSpec as cc_mojom_BrowserControlsParamsSpec
} from '../../../../../cc/mojom/browser_controls_params.mojom.m.js';

import {
  LayerSelection as cc_mojom_LayerSelection,
  LayerSelectionSpec as cc_mojom_LayerSelectionSpec
} from '../../../../../cc/mojom/layer_selection_bound.mojom.m.js';

import {
  LayerTreeDebugState as cc_mojom_LayerTreeDebugState,
  LayerTreeDebugStateSpec as cc_mojom_LayerTreeDebugStateSpec
} from '../../../../../cc/mojom/layer_tree_debug_state.mojom.m.js';

import {
  UIResourceId as cc_mojom_UIResourceId,
  UIResourceIdSpec as cc_mojom_UIResourceIdSpec
} from '../../../../../cc/mojom/ui_resource_id.mojom.m.js';

import {
  SkColor4f as skia_mojom_SkColor4f,
  SkColor4fSpec as skia_mojom_SkColor4fSpec
} from '../../../../../skia/public/mojom/skcolor4f.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  DisplayColorSpaces as gfx_mojom_DisplayColorSpaces,
  DisplayColorSpacesSpec as gfx_mojom_DisplayColorSpacesSpec
} from '../../../../../ui/gfx/mojom/display_color_spaces.mojom.m.js';

import {
  OverlayTransform as gfx_mojom_OverlayTransform,
  OverlayTransformSpec as gfx_mojom_OverlayTransformSpec
} from '../../../../../ui/gfx/mojom/overlay_transform.mojom.m.js';

import {
  AnimationTimeline as viz_mojom_AnimationTimeline,
  AnimationTimelineSpec as viz_mojom_AnimationTimelineSpec
} from './animation.mojom.m.js';

import {
  BeginFrameArgs as viz_mojom_BeginFrameArgs,
  BeginFrameArgsSpec as viz_mojom_BeginFrameArgsSpec
} from './begin_frame_args.mojom.m.js';

import {
  ClipNode as viz_mojom_ClipNode,
  ClipNodeSpec as viz_mojom_ClipNodeSpec,
  EffectNode as viz_mojom_EffectNode,
  EffectNodeSpec as viz_mojom_EffectNodeSpec,
  Layer as viz_mojom_Layer,
  LayerSpec as viz_mojom_LayerSpec,
  ScrollNode as viz_mojom_ScrollNode,
  ScrollNodeSpec as viz_mojom_ScrollNodeSpec,
  ScrollTreeUpdate as viz_mojom_ScrollTreeUpdate,
  ScrollTreeUpdateSpec as viz_mojom_ScrollTreeUpdateSpec,
  TransformNode as viz_mojom_TransformNode,
  TransformNodeSpec as viz_mojom_TransformNodeSpec,
  TransformTreeUpdate as viz_mojom_TransformTreeUpdate,
  TransformTreeUpdateSpec as viz_mojom_TransformTreeUpdateSpec
} from './layer.mojom.m.js';

import {
  LocalSurfaceId as viz_mojom_LocalSurfaceId,
  LocalSurfaceIdSpec as viz_mojom_LocalSurfaceIdSpec
} from './local_surface_id.mojom.m.js';

import {
  SurfaceRange as viz_mojom_SurfaceRange,
  SurfaceRangeSpec as viz_mojom_SurfaceRangeSpec
} from './surface_range.mojom.m.js';

import {
  Tiling as viz_mojom_Tiling,
  TilingSpec as viz_mojom_TilingSpec
} from './tiling.mojom.m.js';

import {
  TransferableResource as viz_mojom_TransferableResource,
  TransferableResourceSpec as viz_mojom_TransferableResourceSpec
} from './transferable_resource.mojom.m.js';

import {
  ViewTransitionRequest as viz_mojom_ViewTransitionRequest,
  ViewTransitionRequestSpec as viz_mojom_ViewTransitionRequestSpec
} from './view_transition_request.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LayerContextPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.LayerContext', scope);
  }
}

/** @interface */
export class LayerContextInterface {
  
  /**
   * @param { !boolean } visible
   */

  setVisible(visible) {}
  
  /**
   * @param { !LayerTreeUpdate } update
   */

  updateDisplayTree(update) {}
  
  /**
   * @param { !viz_mojom_Tiling } tiling
   * @param { !boolean } updateDamage
   */

  updateDisplayTiling(tiling, updateDamage) {}
}

/**
 * @implements { LayerContextInterface }
 */
export class LayerContextRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LayerContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LayerContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LayerContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } visible
   */

  setVisible(
      visible) {
    this.proxy.sendMessage(
        0,
        LayerContext_SetVisible_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  
  /**
   * @param { !LayerTreeUpdate } update
   */

  updateDisplayTree(
      update) {
    this.proxy.sendMessage(
        1,
        LayerContext_UpdateDisplayTree_ParamsSpec.$,
        null,
        [
          update
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_Tiling } tiling
   * @param { !boolean } updateDamage
   */

  updateDisplayTiling(
      tiling,
      updateDamage) {
    this.proxy.sendMessage(
        2,
        LayerContext_UpdateDisplayTiling_ParamsSpec.$,
        null,
        [
          tiling,
          updateDamage
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LayerContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LayerContextReceiver {
  /**
   * @param {!LayerContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LayerContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LayerContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LayerContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LayerContext_SetVisible_ParamsSpec.$,
        null,
        impl.setVisible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LayerContext_UpdateDisplayTree_ParamsSpec.$,
        null,
        impl.updateDisplayTree.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LayerContext_UpdateDisplayTiling_ParamsSpec.$,
        null,
        impl.updateDisplayTiling.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LayerContext {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.LayerContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LayerContextRemote}
   */
  static getRemote() {
    let remote = new LayerContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LayerContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LayerContextCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LayerContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LayerContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LayerContext_SetVisible_ParamsSpec.$,
        null,
        this.setVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateDisplayTree =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LayerContext_UpdateDisplayTree_ParamsSpec.$,
        null,
        this.updateDisplayTree.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateDisplayTiling =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LayerContext_UpdateDisplayTiling_ParamsSpec.$,
        null,
        this.updateDisplayTiling.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LayerContextClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.LayerContextClient', scope);
  }
}

/** @interface */
export class LayerContextClientInterface {
  
  /**
   * @param { !viz_mojom_BeginFrameArgs } args
   */

  onRequestCommitForFrame(args) {}
}

/**
 * @implements { LayerContextClientInterface }
 */
export class LayerContextClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LayerContextClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LayerContextClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LayerContextClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !viz_mojom_BeginFrameArgs } args
   */

  onRequestCommitForFrame(
      args) {
    this.proxy.sendMessage(
        0,
        LayerContextClient_OnRequestCommitForFrame_ParamsSpec.$,
        null,
        [
          args
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LayerContextClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LayerContextClientReceiver {
  /**
   * @param {!LayerContextClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LayerContextClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LayerContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LayerContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LayerContextClient_OnRequestCommitForFrame_ParamsSpec.$,
        null,
        impl.onRequestCommitForFrame.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LayerContextClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.LayerContextClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LayerContextClientRemote}
   */
  static getRemote() {
    let remote = new LayerContextClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LayerContextClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LayerContextClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LayerContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LayerContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRequestCommitForFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LayerContextClient_OnRequestCommitForFrame_ParamsSpec.$,
        null,
        this.onRequestCommitForFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TransferableUIResourceRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LayerTreeUpdateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PendingLayerContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LayerContext_SetVisible_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LayerContext_UpdateDisplayTree_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LayerContext_UpdateDisplayTiling_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LayerContextClient_OnRequestCommitForFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };



/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TransferableUIResourceRequest_TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TransferableUIResourceRequest_Type = {
  
  kCreate: 0,
  kDelete: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    TransferableUIResourceRequestSpec.$,
    'TransferableUIResourceRequest',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        TransferableUIResourceRequest_TypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uid', 8,
        0,
        cc_mojom_UIResourceIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transferableResource', 16,
        0,
        viz_mojom_TransferableResourceSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'opaque', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TransferableUIResourceRequest {
  constructor() {
    /** @type { !TransferableUIResourceRequest_Type } */
    this.type;
    /** @type { !cc_mojom_UIResourceId } */
    this.uid;
    /** @type { (viz_mojom_TransferableResource|undefined) } */
    this.transferableResource;
    /** @type { !boolean } */
    this.opaque;
  }
}



mojo.internal.Struct(
    LayerTreeUpdateSpec.$,
    'LayerTreeUpdate',
    [
      mojo.internal.StructField(
        'beginFrameArgs', 0,
        0,
        viz_mojom_BeginFrameArgsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceFrameNumber', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryMainFrameItemSequenceNumber', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selection', 32,
        0,
        cc_mojom_LayerSelectionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pageScaleFactor', 12,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minPageScaleFactor', 40,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxPageScaleFactor', 44,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'externalPageScaleFactor', 48,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceViewport', 56,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceScaleFactor', 52,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paintedDeviceScaleFactor', 64,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayColorSpaces', 72,
        0,
        gfx_mojom_DisplayColorSpacesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localSurfaceIdFromParent', 80,
        0,
        viz_mojom_LocalSurfaceIdSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentLocalSurfaceId', 88,
        0,
        viz_mojom_LocalSurfaceIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nextFrameToken', 68,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendFrameTokenToEmbedder', 96,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetLocalSurfaceId', 104,
        0,
        viz_mojom_LocalSurfaceIdSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'backgroundColor', 112,
        0,
        skia_mojom_SkColor4fSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'overscrollElasticityTransform', 100,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pageScaleTransform', 120,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'innerScroll', 124,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outerClip', 128,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outerScroll', 132,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewportDamageRect', 136,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fullTreeDamaged', 96,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'debugState', 144,
        0,
        cc_mojom_LayerTreeDebugStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'displayTransformHint', 152,
        0,
        gfx_mojom_OverlayTransformSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxSafeAreaInsetBottom', 156,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'browserControlsParams', 160,
        0,
        cc_mojom_BrowserControlsParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'browserControlsOffsetTagModifications', 168,
        0,
        cc_mojom_BrowserControlsOffsetTagModificationsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topControlsShownRatio', 176,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bottomControlsShownRatio', 180,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uiResourceRequests', 184,
        0,
        mojo.internal.Array(TransferableUIResourceRequestSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'layers', 192,
        0,
        mojo.internal.Array(viz_mojom_LayerSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'layerOrder', 200,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transformTreeUpdate', 208,
        0,
        viz_mojom_TransformTreeUpdateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollTreeUpdate', 216,
        0,
        viz_mojom_ScrollTreeUpdateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transformNodes', 224,
        0,
        mojo.internal.Array(viz_mojom_TransformNodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clipNodes', 232,
        0,
        mojo.internal.Array(viz_mojom_ClipNodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'effectNodes', 240,
        0,
        mojo.internal.Array(viz_mojom_EffectNodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollNodes', 248,
        0,
        mojo.internal.Array(viz_mojom_ScrollNodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numTransformNodes', 256,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numClipNodes', 260,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numEffectNodes', 264,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numScrollNodes', 268,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tilings', 272,
        0,
        mojo.internal.Array(viz_mojom_TilingSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'surfaceRanges', 280,
        0,
        mojo.internal.Array(viz_mojom_SurfaceRangeSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewTransitionRequests', 288,
        0,
        mojo.internal.Array(viz_mojom_ViewTransitionRequestSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'animationTimelines', 296,
        0,
        mojo.internal.Array(viz_mojom_AnimationTimelineSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'removedAnimationTimelines', 304,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 320],]);



/**
 * @record
 */
export class LayerTreeUpdate {
  constructor() {
    /** @type { !viz_mojom_BeginFrameArgs } */
    this.beginFrameArgs;
    /** @type { !number } */
    this.sourceFrameNumber;
    /** @type { !bigint } */
    this.traceId;
    /** @type { !bigint } */
    this.primaryMainFrameItemSequenceNumber;
    /** @type { !cc_mojom_LayerSelection } */
    this.selection;
    /** @type { !number } */
    this.pageScaleFactor;
    /** @type { !number } */
    this.minPageScaleFactor;
    /** @type { !number } */
    this.maxPageScaleFactor;
    /** @type { !number } */
    this.externalPageScaleFactor;
    /** @type { !gfx_mojom_Rect } */
    this.deviceViewport;
    /** @type { !number } */
    this.deviceScaleFactor;
    /** @type { !number } */
    this.paintedDeviceScaleFactor;
    /** @type { !gfx_mojom_DisplayColorSpaces } */
    this.displayColorSpaces;
    /** @type { (viz_mojom_LocalSurfaceId|undefined) } */
    this.localSurfaceIdFromParent;
    /** @type { !viz_mojom_LocalSurfaceId } */
    this.currentLocalSurfaceId;
    /** @type { !number } */
    this.nextFrameToken;
    /** @type { !boolean } */
    this.sendFrameTokenToEmbedder;
    /** @type { (viz_mojom_LocalSurfaceId|undefined) } */
    this.targetLocalSurfaceId;
    /** @type { !skia_mojom_SkColor4f } */
    this.backgroundColor;
    /** @type { !number } */
    this.overscrollElasticityTransform;
    /** @type { !number } */
    this.pageScaleTransform;
    /** @type { !number } */
    this.innerScroll;
    /** @type { !number } */
    this.outerClip;
    /** @type { !number } */
    this.outerScroll;
    /** @type { !gfx_mojom_Rect } */
    this.viewportDamageRect;
    /** @type { !boolean } */
    this.fullTreeDamaged;
    /** @type { !cc_mojom_LayerTreeDebugState } */
    this.debugState;
    /** @type { !gfx_mojom_OverlayTransform } */
    this.displayTransformHint;
    /** @type { !number } */
    this.maxSafeAreaInsetBottom;
    /** @type { !cc_mojom_BrowserControlsParams } */
    this.browserControlsParams;
    /** @type { !cc_mojom_BrowserControlsOffsetTagModifications } */
    this.browserControlsOffsetTagModifications;
    /** @type { !number } */
    this.topControlsShownRatio;
    /** @type { !number } */
    this.bottomControlsShownRatio;
    /** @type { !Array<!TransferableUIResourceRequest> } */
    this.uiResourceRequests;
    /** @type { !Array<!viz_mojom_Layer> } */
    this.layers;
    /** @type { (Array<!number>|undefined) } */
    this.layerOrder;
    /** @type { (viz_mojom_TransformTreeUpdate|undefined) } */
    this.transformTreeUpdate;
    /** @type { (viz_mojom_ScrollTreeUpdate|undefined) } */
    this.scrollTreeUpdate;
    /** @type { !Array<!viz_mojom_TransformNode> } */
    this.transformNodes;
    /** @type { !Array<!viz_mojom_ClipNode> } */
    this.clipNodes;
    /** @type { !Array<!viz_mojom_EffectNode> } */
    this.effectNodes;
    /** @type { !Array<!viz_mojom_ScrollNode> } */
    this.scrollNodes;
    /** @type { !number } */
    this.numTransformNodes;
    /** @type { !number } */
    this.numClipNodes;
    /** @type { !number } */
    this.numEffectNodes;
    /** @type { !number } */
    this.numScrollNodes;
    /** @type { !Array<!viz_mojom_Tiling> } */
    this.tilings;
    /** @type { (Array<!viz_mojom_SurfaceRange>|undefined) } */
    this.surfaceRanges;
    /** @type { (Array<!viz_mojom_ViewTransitionRequest>|undefined) } */
    this.viewTransitionRequests;
    /** @type { (Array<!viz_mojom_AnimationTimeline>|undefined) } */
    this.animationTimelines;
    /** @type { (Array<!number>|undefined) } */
    this.removedAnimationTimelines;
  }
}



mojo.internal.Struct(
    PendingLayerContextSpec.$,
    'PendingLayerContext',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(LayerContextPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.AssociatedInterfaceProxy(LayerContextClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PendingLayerContext {
  constructor() {
    /** @type { !Object } */
    this.receiver;
    /** @type { !Object } */
    this.client;
  }
}



mojo.internal.Struct(
    LayerContext_SetVisible_ParamsSpec.$,
    'LayerContext_SetVisible_Params',
    [
      mojo.internal.StructField(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LayerContext_SetVisible_Params {
  constructor() {
    /** @type { !boolean } */
    this.visible;
  }
}



mojo.internal.Struct(
    LayerContext_UpdateDisplayTree_ParamsSpec.$,
    'LayerContext_UpdateDisplayTree_Params',
    [
      mojo.internal.StructField(
        'update', 0,
        0,
        LayerTreeUpdateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LayerContext_UpdateDisplayTree_Params {
  constructor() {
    /** @type { !LayerTreeUpdate } */
    this.update;
  }
}



mojo.internal.Struct(
    LayerContext_UpdateDisplayTiling_ParamsSpec.$,
    'LayerContext_UpdateDisplayTiling_Params',
    [
      mojo.internal.StructField(
        'tiling', 0,
        0,
        viz_mojom_TilingSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateDamage', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LayerContext_UpdateDisplayTiling_Params {
  constructor() {
    /** @type { !viz_mojom_Tiling } */
    this.tiling;
    /** @type { !boolean } */
    this.updateDamage;
  }
}



mojo.internal.Struct(
    LayerContextClient_OnRequestCommitForFrame_ParamsSpec.$,
    'LayerContextClient_OnRequestCommitForFrame_Params',
    [
      mojo.internal.StructField(
        'args', 0,
        0,
        viz_mojom_BeginFrameArgsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LayerContextClient_OnRequestCommitForFrame_Params {
  constructor() {
    /** @type { !viz_mojom_BeginFrameArgs } */
    this.args;
  }
}

