// services/viz/public/mojom/compositing/returned_resource.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/returned_resource.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var sync_token$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/sync_token.mojom', '../../../../../gpu/ipc/common/sync_token.mojom.js');
  }
  var resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/resource_id.mojom', 'resource_id.mojom.js');
  }
  var gpu_fence_handle$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/gpu_fence_handle.mojom', '../../../../../ui/gfx/mojom/gpu_fence_handle.mojom.js');
  }



  function ReturnedResource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReturnedResource.prototype.initDefaults_ = function() {
    this.id = null;
    this.syncToken = null;
    this.releaseFence = null;
    this.count = 0;
    this.lost = false;
  };
  ReturnedResource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReturnedResource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReturnedResource.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, resource_id$.ResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReturnedResource.syncToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, sync_token$.SyncToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReturnedResource.releaseFence
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, gpu_fence_handle$.GpuFenceHandle, true);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ReturnedResource.encodedSize = codec.kStructHeaderSize + 32;

  ReturnedResource.decode = function(decoder) {
    var packed;
    var val = new ReturnedResource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStructPointer(resource_id$.ResourceId);
    val.syncToken =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    val.releaseFence =
        decoder.decodeStructPointer(gpu_fence_handle$.GpuFenceHandle);
    val.count =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.lost = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ReturnedResource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReturnedResource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(resource_id$.ResourceId, val.id);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.syncToken);
    encoder.encodeStructPointer(gpu_fence_handle$.GpuFenceHandle, val.releaseFence);
    encoder.encodeStruct(codec.Int32, val.count);
    packed = 0;
    packed |= (val.lost & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.ReturnedResource = ReturnedResource;
})();