// services/viz/public/mojom/hit_test/input_target_client.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('viz.mojom.FrameSinkId');
goog.require('gfx.mojom.PointF');






goog.provide('viz.mojom.InputTargetClient');
goog.provide('viz.mojom.InputTargetClientReceiver');
goog.provide('viz.mojom.InputTargetClientCallbackRouter');
goog.provide('viz.mojom.InputTargetClientInterface');
goog.provide('viz.mojom.InputTargetClientRemote');
goog.provide('viz.mojom.InputTargetClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
viz.mojom.InputTargetClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        viz.mojom.InputTargetClient.$interfaceName,
        scope);
  }
};

/** @interface */
viz.mojom.InputTargetClientInterface = class {
  
  /**
   * @param { !gfx.mojom.PointF } point
   * @param { !bigint } traceId
   * @return {!Promise<{
        id: !viz.mojom.FrameSinkId,
        localPoint: !gfx.mojom.PointF,
   *  }>}
   */

  frameSinkIdAt(point, traceId) {}
};

/**
 * @export
 * @implements { viz.mojom.InputTargetClientInterface }
 */
viz.mojom.InputTargetClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!viz.mojom.InputTargetClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          viz.mojom.InputTargetClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!viz.mojom.InputTargetClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx.mojom.PointF } point
   * @param { !bigint } traceId
   * @return {!Promise<{
        id: !viz.mojom.FrameSinkId,
        localPoint: !gfx.mojom.PointF,
   *  }>}
   */

  frameSinkIdAt(
      point,
      traceId) {
    return this.proxy.sendMessage(
        0,
        viz.mojom.InputTargetClient_FrameSinkIdAt_ParamsSpec.$,
        viz.mojom.InputTargetClient_FrameSinkIdAt_ResponseParamsSpec.$,
        [
          point,
          traceId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InputTargetClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
viz.mojom.InputTargetClientReceiver = class {
  /**
   * @param {!viz.mojom.InputTargetClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!viz.mojom.InputTargetClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        viz.mojom.InputTargetClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.InputTargetClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        viz.mojom.InputTargetClient_FrameSinkIdAt_ParamsSpec.$,
        viz.mojom.InputTargetClient_FrameSinkIdAt_ResponseParamsSpec.$,
        impl.frameSinkIdAt.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
viz.mojom.InputTargetClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.InputTargetClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!viz.mojom.InputTargetClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new viz.mojom.InputTargetClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InputTargetClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
viz.mojom.InputTargetClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      viz.mojom.InputTargetClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.InputTargetClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.frameSinkIdAt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        viz.mojom.InputTargetClient_FrameSinkIdAt_ParamsSpec.$,
        viz.mojom.InputTargetClient_FrameSinkIdAt_ResponseParamsSpec.$,
        this.frameSinkIdAt.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('viz.mojom.InputTargetClient_FrameSinkIdAt_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.InputTargetClient_FrameSinkIdAt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('viz.mojom.InputTargetClient_FrameSinkIdAt_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.InputTargetClient_FrameSinkIdAt_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    viz.mojom.InputTargetClient_FrameSinkIdAt_ParamsSpec.$,
    'InputTargetClient_FrameSinkIdAt_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('viz.mojom.InputTargetClient_FrameSinkIdAt_Params');

/** @record */
viz.mojom.InputTargetClient_FrameSinkIdAt_Params = class {
  constructor() {
    /** @export { !gfx.mojom.PointF } */
    this.point;
    /** @export { !bigint } */
    this.traceId;
  }
};



mojo.internal.Struct(
    viz.mojom.InputTargetClient_FrameSinkIdAt_ResponseParamsSpec.$,
    'InputTargetClient_FrameSinkIdAt_ResponseParams',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        viz.mojom.FrameSinkIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localPoint', 8,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('viz.mojom.InputTargetClient_FrameSinkIdAt_ResponseParams');

/** @record */
viz.mojom.InputTargetClient_FrameSinkIdAt_ResponseParams = class {
  constructor() {
    /** @export { !viz.mojom.FrameSinkId } */
    this.id;
    /** @export { !gfx.mojom.PointF } */
    this.localPoint;
  }
};

