// third_party/blink/public/mojom/ai/model_download_progress_observer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/model_download_progress_observer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params.prototype.initDefaults_ = function() {
    this.downloadedBytes = 0;
    this.totalBytes = 0;
  };
  ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params.encodedSize = codec.kStructHeaderSize + 16;

  ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.downloadedBytes =
        decoder.decodeStruct(codec.Uint64);
    val.totalBytes =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.downloadedBytes);
    encoder.encodeStruct(codec.Uint64, val.totalBytes);
  };
  var kModelDownloadProgressObserver_OnDownloadProgressUpdate_Name = 0;

  function ModelDownloadProgressObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ModelDownloadProgressObserver,
                                                   handleOrPtrInfo);
  }

  function ModelDownloadProgressObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ModelDownloadProgressObserver, associatedInterfacePtrInfo);
  }

  ModelDownloadProgressObserverAssociatedPtr.prototype =
      Object.create(ModelDownloadProgressObserverPtr.prototype);
  ModelDownloadProgressObserverAssociatedPtr.prototype.constructor =
      ModelDownloadProgressObserverAssociatedPtr;

  function ModelDownloadProgressObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  ModelDownloadProgressObserverPtr.prototype.onDownloadProgressUpdate = function() {
    return ModelDownloadProgressObserverProxy.prototype.onDownloadProgressUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  ModelDownloadProgressObserverProxy.prototype.onDownloadProgressUpdate = function(downloadedBytes, totalBytes) {
    var params_ = new ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params();
    params_.downloadedBytes = downloadedBytes;
    params_.totalBytes = totalBytes;
    var builder = new codec.MessageV0Builder(
        kModelDownloadProgressObserver_OnDownloadProgressUpdate_Name,
        codec.align(ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params.encodedSize));
    builder.encodeStruct(ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ModelDownloadProgressObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  ModelDownloadProgressObserverStub.prototype.onDownloadProgressUpdate = function(downloadedBytes, totalBytes) {
    return this.delegate_ && this.delegate_.onDownloadProgressUpdate && this.delegate_.onDownloadProgressUpdate(downloadedBytes, totalBytes);
  }

  ModelDownloadProgressObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kModelDownloadProgressObserver_OnDownloadProgressUpdate_Name:
      var params = reader.decodeStruct(ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params);
      this.onDownloadProgressUpdate(params.downloadedBytes, params.totalBytes);
      return true;
    default:
      return false;
    }
  };

  ModelDownloadProgressObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateModelDownloadProgressObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kModelDownloadProgressObserver_OnDownloadProgressUpdate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateModelDownloadProgressObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ModelDownloadProgressObserver = {
    name: 'blink.mojom.ModelDownloadProgressObserver',
    kVersion: 0,
    ptrClass: ModelDownloadProgressObserverPtr,
    proxyClass: ModelDownloadProgressObserverProxy,
    stubClass: ModelDownloadProgressObserverStub,
    validateRequest: validateModelDownloadProgressObserverRequest,
    validateResponse: null,
  };
  ModelDownloadProgressObserverStub.prototype.validator = validateModelDownloadProgressObserverRequest;
  ModelDownloadProgressObserverProxy.prototype.validator = null;
  exports.ModelDownloadProgressObserver = ModelDownloadProgressObserver;
  exports.ModelDownloadProgressObserverPtr = ModelDownloadProgressObserverPtr;
  exports.ModelDownloadProgressObserverAssociatedPtr = ModelDownloadProgressObserverAssociatedPtr;
})();