// third_party/blink/public/mojom/annotation/annotation.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AnnotationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AnnotationType = {
  
  kSharedHighlight: 0,
  kUserNote: 1,
  kTextFinder: 2,
  kGlic: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AttachmentResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AttachmentResult = {
  
  kSuccess: 0,
  kSelectorNotMatched: 1,
  kRangeInvalid: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AnnotationAgentPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AnnotationAgent.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.AnnotationAgentInterface }
 */
blink.mojom.AnnotationAgentRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AnnotationAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AnnotationAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AnnotationAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } appliesFocus
   */

  scrollIntoView(
      appliesFocus) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AnnotationAgent_ScrollIntoView_ParamsSpec.$,
        null,
        [
          appliesFocus
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AnnotationAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AnnotationAgentReceiver = class {
  /**
   * @param {!blink.mojom.AnnotationAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AnnotationAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AnnotationAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnnotationAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnnotationAgent_ScrollIntoView_ParamsSpec.$,
        null,
        impl.scrollIntoView.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AnnotationAgent = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnnotationAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AnnotationAgentRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AnnotationAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AnnotationAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AnnotationAgentCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AnnotationAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnnotationAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrollIntoView =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnnotationAgent_ScrollIntoView_ParamsSpec.$,
        null,
        this.scrollIntoView.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AnnotationAgentHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AnnotationAgentHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.AnnotationAgentHostInterface }
 */
blink.mojom.AnnotationAgentHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AnnotationAgentHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AnnotationAgentHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AnnotationAgentHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx.mojom.Rect } documentRelativeRect
   * @param { !blink.mojom.AttachmentResult } attachmentResult
   */

  didFinishAttachment(
      documentRelativeRect,
      attachmentResult) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AnnotationAgentHost_DidFinishAttachment_ParamsSpec.$,
        null,
        [
          documentRelativeRect,
          attachmentResult
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AnnotationAgentHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AnnotationAgentHostReceiver = class {
  /**
   * @param {!blink.mojom.AnnotationAgentHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AnnotationAgentHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AnnotationAgentHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnnotationAgentHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnnotationAgentHost_DidFinishAttachment_ParamsSpec.$,
        null,
        impl.didFinishAttachment.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AnnotationAgentHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnnotationAgentHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AnnotationAgentHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AnnotationAgentHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AnnotationAgentHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AnnotationAgentHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AnnotationAgentHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnnotationAgentHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didFinishAttachment =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnnotationAgentHost_DidFinishAttachment_ParamsSpec.$,
        null,
        this.didFinishAttachment.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AnnotationAgentContainerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AnnotationAgentContainer.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.AnnotationAgentContainerInterface }
 */
blink.mojom.AnnotationAgentContainerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AnnotationAgentContainerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AnnotationAgentContainerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AnnotationAgentContainerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AnnotationAgentHostRemote } hostRemote
   * @param { !blink.mojom.AnnotationAgentPendingReceiver } agentReceiver
   * @param { !blink.mojom.AnnotationType } type
   * @param { !blink.mojom.Selector } selector
   * @param { ?number } searchRangeStartNodeId
   */

  createAgent(
      hostRemote,
      agentReceiver,
      type,
      selector,
      searchRangeStartNodeId) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AnnotationAgentContainer_CreateAgent_ParamsSpec.$,
        null,
        [
          hostRemote,
          agentReceiver,
          type,
          selector,
          searchRangeStartNodeId
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AnnotationType } type
   * @return {!Promise<{
        result: ?blink.mojom.SelectorCreationResult,
        error: !blink.mojom.LinkGenerationError,
        readyStatus: !blink.mojom.LinkGenerationReadyStatus,
   *  }>}
   */

  createAgentFromSelection(
      type) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec.$,
        blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AnnotationType } type
   */

  removeAgentsOfType(
      type) {
    this.proxy.sendMessage(
        2,
        blink.mojom.AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec.$,
        null,
        [
          type
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AnnotationAgentContainer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AnnotationAgentContainerReceiver = class {
  /**
   * @param {!blink.mojom.AnnotationAgentContainerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AnnotationAgentContainerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AnnotationAgentContainerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnnotationAgentContainerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnnotationAgentContainer_CreateAgent_ParamsSpec.$,
        null,
        impl.createAgent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec.$,
        blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec.$,
        impl.createAgentFromSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec.$,
        null,
        impl.removeAgentsOfType.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AnnotationAgentContainer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnnotationAgentContainer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AnnotationAgentContainerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AnnotationAgentContainerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AnnotationAgentContainer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AnnotationAgentContainerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AnnotationAgentContainerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnnotationAgentContainerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAgent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnnotationAgentContainer_CreateAgent_ParamsSpec.$,
        null,
        this.createAgent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAgentFromSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec.$,
        blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec.$,
        this.createAgentFromSelection.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeAgentsOfType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec.$,
        null,
        this.removeAgentsOfType.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SelectorCreationResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnnotationAgent_ScrollIntoView_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnnotationAgentHost_DidFinishAttachment_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnnotationAgentContainer_CreateAgent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SelectorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SelectorCreationResultSpec.$,
    'SelectorCreationResult',
    [
      mojo.internal.StructField(
        'hostReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.AnnotationAgentHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'agentRemote', 4,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AnnotationAgentRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serializedSelector', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectedText', 24,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.SelectorCreationResult = class {
  constructor() {
    /** @export { !blink.mojom.AnnotationAgentHostPendingReceiver } */
    this.hostReceiver;
    /** @export { !blink.mojom.AnnotationAgentRemote } */
    this.agentRemote;
    /** @export { !string } */
    this.serializedSelector;
    /** @export { !mojoBase.mojom.String16 } */
    this.selectedText;
  }
};



mojo.internal.Struct(
    blink.mojom.AnnotationAgent_ScrollIntoView_ParamsSpec.$,
    'AnnotationAgent_ScrollIntoView_Params',
    [
      mojo.internal.StructField(
        'appliesFocus', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AnnotationAgent_ScrollIntoView_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.appliesFocus;
  }
};



mojo.internal.Struct(
    blink.mojom.AnnotationAgentHost_DidFinishAttachment_ParamsSpec.$,
    'AnnotationAgentHost_DidFinishAttachment_Params',
    [
      mojo.internal.StructField(
        'documentRelativeRect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attachmentResult', 8,
        0,
        blink.mojom.AttachmentResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.AnnotationAgentHost_DidFinishAttachment_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.documentRelativeRect;
    /** @export { !blink.mojom.AttachmentResult } */
    this.attachmentResult;
  }
};



mojo.internal.Struct(
    blink.mojom.AnnotationAgentContainer_CreateAgent_ParamsSpec.$,
    'AnnotationAgentContainer_CreateAgent_Params',
    [
      mojo.internal.StructField(
        'hostRemote', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AnnotationAgentHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'agentReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.AnnotationAgentPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 12,
        0,
        blink.mojom.AnnotationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selector', 16,
        0,
        blink.mojom.SelectorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'search_range_start_node_id_$flag', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "search_range_start_node_id_$value",
          originalFieldName: "searchRangeStartNodeId",
        }
      ),
      mojo.internal.StructField(
        'search_range_start_node_id_$value', 36,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "searchRangeStartNodeId",
        }
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.AnnotationAgentContainer_CreateAgent_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnnotationAgentHostRemote } */
    this.hostRemote;
    /** @export { !blink.mojom.AnnotationAgentPendingReceiver } */
    this.agentReceiver;
    /** @export { !blink.mojom.AnnotationType } */
    this.type;
    /** @export { !blink.mojom.Selector } */
    this.selector;
    /** @export { (number|undefined) } */
    this.searchRangeStartNodeId;
  }
};



mojo.internal.Struct(
    blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ParamsSpec.$,
    'AnnotationAgentContainer_CreateAgentFromSelection_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.AnnotationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnnotationType } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsSpec.$,
    'AnnotationAgentContainer_CreateAgentFromSelection_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.SelectorCreationResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        blink.mojom.LinkGenerationErrorSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'readyStatus', 12,
        0,
        blink.mojom.LinkGenerationReadyStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.AnnotationAgentContainer_CreateAgentFromSelection_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.SelectorCreationResult|undefined) } */
    this.result;
    /** @export { !blink.mojom.LinkGenerationError } */
    this.error;
    /** @export { !blink.mojom.LinkGenerationReadyStatus } */
    this.readyStatus;
  }
};



mojo.internal.Struct(
    blink.mojom.AnnotationAgentContainer_RemoveAgentsOfType_ParamsSpec.$,
    'AnnotationAgentContainer_RemoveAgentsOfType_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.AnnotationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AnnotationAgentContainer_RemoveAgentsOfType_Params = class {
  constructor() {
    /** @export { !blink.mojom.AnnotationType } */
    this.type;
  }
};



mojo.internal.Union(
    blink.mojom.SelectorSpec.$, 'Selector',
    {
      'serializedSelector': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'nodeId': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
      },
    });

/**
 * @typedef { {
 *   serializedSelector: (!string|undefined),
 *   nodeId: (!number|undefined),
 * } }
 */
blink.mojom.Selector;
