// third_party/blink/public/mojom/blob/blob.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.DataPipeGetter');
goog.require('network.mojom.URLLoader');
goog.require('network.mojom.URLLoaderClient');
goog.require('network.mojom.HttpRequestHeaders');
goog.require('mojoBase.mojom.Time');
goog.require('mojoBase.mojom.BigBuffer');






goog.provide('blink.mojom.BlobReaderClient');
goog.provide('blink.mojom.BlobReaderClientReceiver');
goog.provide('blink.mojom.BlobReaderClientCallbackRouter');
goog.provide('blink.mojom.BlobReaderClientInterface');
goog.provide('blink.mojom.BlobReaderClientRemote');
goog.provide('blink.mojom.BlobReaderClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BlobReaderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.BlobReaderClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.BlobReaderClientInterface = class {
  
  /**
   * @param { !bigint } totalSize
   * @param { !bigint } expectedContentSize
   */

  onCalculatedSize(totalSize, expectedContentSize) {}
  
  /**
   * @param { !number } status
   * @param { !bigint } dataLength
   */

  onComplete(status, dataLength) {}
};

/**
 * @export
 * @implements { blink.mojom.BlobReaderClientInterface }
 */
blink.mojom.BlobReaderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BlobReaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BlobReaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BlobReaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } totalSize
   * @param { !bigint } expectedContentSize
   */

  onCalculatedSize(
      totalSize,
      expectedContentSize) {
    this.proxy.sendMessage(
        0,
        blink.mojom.BlobReaderClient_OnCalculatedSize_ParamsSpec.$,
        null,
        [
          totalSize,
          expectedContentSize
        ],
        false);
  }

  
  /**
   * @param { !number } status
   * @param { !bigint } dataLength
   */

  onComplete(
      status,
      dataLength) {
    this.proxy.sendMessage(
        1,
        blink.mojom.BlobReaderClient_OnComplete_ParamsSpec.$,
        null,
        [
          status,
          dataLength
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BlobReaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BlobReaderClientReceiver = class {
  /**
   * @param {!blink.mojom.BlobReaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BlobReaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BlobReaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BlobReaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BlobReaderClient_OnCalculatedSize_ParamsSpec.$,
        null,
        impl.onCalculatedSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BlobReaderClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.BlobReaderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BlobReaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BlobReaderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BlobReaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BlobReaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BlobReaderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BlobReaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BlobReaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCalculatedSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.BlobReaderClient_OnCalculatedSize_ParamsSpec.$,
        null,
        this.onCalculatedSize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.BlobReaderClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.Blob');
goog.provide('blink.mojom.BlobReceiver');
goog.provide('blink.mojom.BlobCallbackRouter');
goog.provide('blink.mojom.BlobInterface');
goog.provide('blink.mojom.BlobRemote');
goog.provide('blink.mojom.BlobPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.BlobPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.Blob.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.BlobInterface = class {
  
  /**
   * @param { !blink.mojom.BlobPendingReceiver } blob
   */

  clone(blob) {}
  
  /**
   * @param { !network.mojom.DataPipeGetterPendingReceiver } dataPipeGetter
   */

  asDataPipeGetter(dataPipeGetter) {}
  
  /**
   * @param { !MojoHandle } pipe
   * @param { ?blink.mojom.BlobReaderClientRemote } client
   */

  readAll(pipe, client) {}
  
  /**
   * @param { !bigint } offset
   * @param { !bigint } length
   * @param { !MojoHandle } pipe
   * @param { ?blink.mojom.BlobReaderClientRemote } client
   */

  readRange(offset, length, pipe, client) {}
  
  /**
   * @param { !network.mojom.URLLoaderPendingReceiver } loader
   * @param { !string } requestMethod
   * @param { !network.mojom.HttpRequestHeaders } headers
   * @param { !network.mojom.URLLoaderClientRemote } client
   */

  load(loader, requestMethod, headers, client) {}
  
  /**
   * @return {!Promise<{
        data: ?mojoBase.mojom.BigBuffer,
   *  }>}
   */

  readSideData() {}
  
  /**
   * @return {!Promise<{
        length: !bigint,
        modificationTime: ?mojoBase.mojom.Time,
   *  }>}
   */

  captureSnapshot() {}
  
  /**
   * @return {!Promise<{
        uuid: !string,
   *  }>}
   */

  getInternalUUID() {}
};

/**
 * @export
 * @implements { blink.mojom.BlobInterface }
 */
blink.mojom.BlobRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.BlobPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.BlobPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.BlobPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.BlobPendingReceiver } blob
   */

  clone(
      blob) {
    this.proxy.sendMessage(
        0,
        blink.mojom.Blob_Clone_ParamsSpec.$,
        null,
        [
          blob
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DataPipeGetterPendingReceiver } dataPipeGetter
   */

  asDataPipeGetter(
      dataPipeGetter) {
    this.proxy.sendMessage(
        1,
        blink.mojom.Blob_AsDataPipeGetter_ParamsSpec.$,
        null,
        [
          dataPipeGetter
        ],
        false);
  }

  
  /**
   * @param { !MojoHandle } pipe
   * @param { ?blink.mojom.BlobReaderClientRemote } client
   */

  readAll(
      pipe,
      client) {
    this.proxy.sendMessage(
        2,
        blink.mojom.Blob_ReadAll_ParamsSpec.$,
        null,
        [
          pipe,
          client
        ],
        false);
  }

  
  /**
   * @param { !bigint } offset
   * @param { !bigint } length
   * @param { !MojoHandle } pipe
   * @param { ?blink.mojom.BlobReaderClientRemote } client
   */

  readRange(
      offset,
      length,
      pipe,
      client) {
    this.proxy.sendMessage(
        3,
        blink.mojom.Blob_ReadRange_ParamsSpec.$,
        null,
        [
          offset,
          length,
          pipe,
          client
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLLoaderPendingReceiver } loader
   * @param { !string } requestMethod
   * @param { !network.mojom.HttpRequestHeaders } headers
   * @param { !network.mojom.URLLoaderClientRemote } client
   */

  load(
      loader,
      requestMethod,
      headers,
      client) {
    this.proxy.sendMessage(
        4,
        blink.mojom.Blob_Load_ParamsSpec.$,
        null,
        [
          loader,
          requestMethod,
          headers,
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        data: ?mojoBase.mojom.BigBuffer,
   *  }>}
   */

  readSideData() {
    return this.proxy.sendMessage(
        5,
        blink.mojom.Blob_ReadSideData_ParamsSpec.$,
        blink.mojom.Blob_ReadSideData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        length: !bigint,
        modificationTime: ?mojoBase.mojom.Time,
   *  }>}
   */

  captureSnapshot() {
    return this.proxy.sendMessage(
        6,
        blink.mojom.Blob_CaptureSnapshot_ParamsSpec.$,
        blink.mojom.Blob_CaptureSnapshot_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        uuid: !string,
   *  }>}
   */

  getInternalUUID() {
    return this.proxy.sendMessage(
        7,
        blink.mojom.Blob_GetInternalUUID_ParamsSpec.$,
        blink.mojom.Blob_GetInternalUUID_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Blob
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.BlobReceiver = class {
  /**
   * @param {!blink.mojom.BlobInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.BlobRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.BlobRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BlobRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.Blob_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.Blob_AsDataPipeGetter_ParamsSpec.$,
        null,
        impl.asDataPipeGetter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.Blob_ReadAll_ParamsSpec.$,
        null,
        impl.readAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.Blob_ReadRange_ParamsSpec.$,
        null,
        impl.readRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.Blob_Load_ParamsSpec.$,
        null,
        impl.load.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.Blob_ReadSideData_ParamsSpec.$,
        blink.mojom.Blob_ReadSideData_ResponseParamsSpec.$,
        impl.readSideData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.Blob_CaptureSnapshot_ParamsSpec.$,
        blink.mojom.Blob_CaptureSnapshot_ResponseParamsSpec.$,
        impl.captureSnapshot.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.Blob_GetInternalUUID_ParamsSpec.$,
        blink.mojom.Blob_GetInternalUUID_ResponseParamsSpec.$,
        impl.getInternalUUID.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.Blob = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Blob";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.BlobRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.BlobRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Blob
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.BlobCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.BlobRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.BlobRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.Blob_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.asDataPipeGetter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.Blob_AsDataPipeGetter_ParamsSpec.$,
        null,
        this.asDataPipeGetter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.Blob_ReadAll_ParamsSpec.$,
        null,
        this.readAll.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.Blob_ReadRange_ParamsSpec.$,
        null,
        this.readRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.load =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.Blob_Load_ParamsSpec.$,
        null,
        this.load.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readSideData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.Blob_ReadSideData_ParamsSpec.$,
        blink.mojom.Blob_ReadSideData_ResponseParamsSpec.$,
        this.readSideData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.captureSnapshot =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.Blob_CaptureSnapshot_ParamsSpec.$,
        blink.mojom.Blob_CaptureSnapshot_ResponseParamsSpec.$,
        this.captureSnapshot.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInternalUUID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.Blob_GetInternalUUID_ParamsSpec.$,
        blink.mojom.Blob_GetInternalUUID_ResponseParamsSpec.$,
        this.getInternalUUID.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.BlobReaderClient_OnCalculatedSize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BlobReaderClient_OnCalculatedSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.BlobReaderClient_OnComplete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.BlobReaderClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_AsDataPipeGetter_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_AsDataPipeGetter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_ReadAll_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_ReadAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_ReadRange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_ReadRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_Load_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_Load_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_ReadSideData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_ReadSideData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_ReadSideData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_ReadSideData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_CaptureSnapshot_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_CaptureSnapshot_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_CaptureSnapshot_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_CaptureSnapshot_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_GetInternalUUID_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_GetInternalUUID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Blob_GetInternalUUID_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Blob_GetInternalUUID_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.BlobReaderClient_OnCalculatedSize_ParamsSpec.$,
    'BlobReaderClient_OnCalculatedSize_Params',
    [
      mojo.internal.StructField(
        'totalSize', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedContentSize', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.BlobReaderClient_OnCalculatedSize_Params');

/** @record */
blink.mojom.BlobReaderClient_OnCalculatedSize_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.totalSize;
    /** @export { !bigint } */
    this.expectedContentSize;
  }
};



mojo.internal.Struct(
    blink.mojom.BlobReaderClient_OnComplete_ParamsSpec.$,
    'BlobReaderClient_OnComplete_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataLength', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.BlobReaderClient_OnComplete_Params');

/** @record */
blink.mojom.BlobReaderClient_OnComplete_Params = class {
  constructor() {
    /** @export { !number } */
    this.status;
    /** @export { !bigint } */
    this.dataLength;
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_Clone_ParamsSpec.$,
    'Blob_Clone_Params',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.BlobPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.Blob_Clone_Params');

/** @record */
blink.mojom.Blob_Clone_Params = class {
  constructor() {
    /** @export { !blink.mojom.BlobPendingReceiver } */
    this.blob;
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_AsDataPipeGetter_ParamsSpec.$,
    'Blob_AsDataPipeGetter_Params',
    [
      mojo.internal.StructField(
        'dataPipeGetter', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.DataPipeGetterPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.Blob_AsDataPipeGetter_Params');

/** @record */
blink.mojom.Blob_AsDataPipeGetter_Params = class {
  constructor() {
    /** @export { !network.mojom.DataPipeGetterPendingReceiver } */
    this.dataPipeGetter;
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_ReadAll_ParamsSpec.$,
    'Blob_ReadAll_Params',
    [
      mojo.internal.StructField(
        'pipe', 0,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobReaderClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.Blob_ReadAll_Params');

/** @record */
blink.mojom.Blob_ReadAll_Params = class {
  constructor() {
    /** @export { !MojoHandle } */
    this.pipe;
    /** @export { (blink.mojom.BlobReaderClientRemote|undefined) } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_ReadRange_ParamsSpec.$,
    'Blob_ReadRange_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pipe', 16,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 20,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobReaderClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.Blob_ReadRange_Params');

/** @record */
blink.mojom.Blob_ReadRange_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.offset;
    /** @export { !bigint } */
    this.length;
    /** @export { !MojoHandle } */
    this.pipe;
    /** @export { (blink.mojom.BlobReaderClientRemote|undefined) } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_Load_ParamsSpec.$,
    'Blob_Load_Params',
    [
      mojo.internal.StructField(
        'loader', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestMethod', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 16,
        0,
        network.mojom.HttpRequestHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.Blob_Load_Params');

/** @record */
blink.mojom.Blob_Load_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderPendingReceiver } */
    this.loader;
    /** @export { !string } */
    this.requestMethod;
    /** @export { !network.mojom.HttpRequestHeaders } */
    this.headers;
    /** @export { !network.mojom.URLLoaderClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_ReadSideData_ParamsSpec.$,
    'Blob_ReadSideData_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.Blob_ReadSideData_Params');

/** @record */
blink.mojom.Blob_ReadSideData_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_ReadSideData_ResponseParamsSpec.$,
    'Blob_ReadSideData_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.Blob_ReadSideData_ResponseParams');

/** @record */
blink.mojom.Blob_ReadSideData_ResponseParams = class {
  constructor() {
    /** @export { (mojoBase.mojom.BigBuffer|undefined) } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_CaptureSnapshot_ParamsSpec.$,
    'Blob_CaptureSnapshot_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.Blob_CaptureSnapshot_Params');

/** @record */
blink.mojom.Blob_CaptureSnapshot_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_CaptureSnapshot_ResponseParamsSpec.$,
    'Blob_CaptureSnapshot_ResponseParams',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modificationTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.Blob_CaptureSnapshot_ResponseParams');

/** @record */
blink.mojom.Blob_CaptureSnapshot_ResponseParams = class {
  constructor() {
    /** @export { !bigint } */
    this.length;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.modificationTime;
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_GetInternalUUID_ParamsSpec.$,
    'Blob_GetInternalUUID_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.Blob_GetInternalUUID_Params');

/** @record */
blink.mojom.Blob_GetInternalUUID_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.Blob_GetInternalUUID_ResponseParamsSpec.$,
    'Blob_GetInternalUUID_ResponseParams',
    [
      mojo.internal.StructField(
        'uuid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.Blob_GetInternalUUID_ResponseParams');

/** @record */
blink.mojom.Blob_GetInternalUUID_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.uuid;
  }
};

