// third_party/blink/public/mojom/blob/blob.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  DataPipeGetterRemote as network_mojom_DataPipeGetterRemote,
  DataPipeGetterPendingReceiver as network_mojom_DataPipeGetterPendingReceiver
} from '../../../../../services/network/public/mojom/data_pipe_getter.mojom.m.js';

import {
  HttpRequestHeaders as network_mojom_HttpRequestHeaders,
  HttpRequestHeadersSpec as network_mojom_HttpRequestHeadersSpec
} from '../../../../../services/network/public/mojom/http_request_headers.mojom.m.js';

import {
  URLLoaderRemote as network_mojom_URLLoaderRemote,
  URLLoaderPendingReceiver as network_mojom_URLLoaderPendingReceiver,
  URLLoaderClientRemote as network_mojom_URLLoaderClientRemote,
  URLLoaderClientPendingReceiver as network_mojom_URLLoaderClientPendingReceiver
} from '../../../../../services/network/public/mojom/url_loader.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BlobReaderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BlobReaderClient', scope);
  }
}

/** @interface */
export class BlobReaderClientInterface {
  
  /**
   * @param { !bigint } totalSize
   * @param { !bigint } expectedContentSize
   */

  onCalculatedSize(totalSize, expectedContentSize) {}
  
  /**
   * @param { !number } status
   * @param { !bigint } dataLength
   */

  onComplete(status, dataLength) {}
}

/**
 * @implements { BlobReaderClientInterface }
 */
export class BlobReaderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BlobReaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BlobReaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BlobReaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } totalSize
   * @param { !bigint } expectedContentSize
   */

  onCalculatedSize(
      totalSize,
      expectedContentSize) {
    this.proxy.sendMessage(
        0,
        BlobReaderClient_OnCalculatedSize_ParamsSpec.$,
        null,
        [
          totalSize,
          expectedContentSize
        ],
        false);
  }

  
  /**
   * @param { !number } status
   * @param { !bigint } dataLength
   */

  onComplete(
      status,
      dataLength) {
    this.proxy.sendMessage(
        1,
        BlobReaderClient_OnComplete_ParamsSpec.$,
        null,
        [
          status,
          dataLength
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BlobReaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BlobReaderClientReceiver {
  /**
   * @param {!BlobReaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BlobReaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BlobReaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobReaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BlobReaderClient_OnCalculatedSize_ParamsSpec.$,
        null,
        impl.onCalculatedSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BlobReaderClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BlobReaderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BlobReaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BlobReaderClientRemote}
   */
  static getRemote() {
    let remote = new BlobReaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BlobReaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BlobReaderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BlobReaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobReaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCalculatedSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BlobReaderClient_OnCalculatedSize_ParamsSpec.$,
        null,
        this.onCalculatedSize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BlobReaderClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BlobPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.Blob', scope);
  }
}

/** @interface */
export class BlobInterface {
  
  /**
   * @param { !BlobPendingReceiver } blob
   */

  clone(blob) {}
  
  /**
   * @param { !network_mojom_DataPipeGetterPendingReceiver } dataPipeGetter
   */

  asDataPipeGetter(dataPipeGetter) {}
  
  /**
   * @param { !MojoHandle } pipe
   * @param { ?BlobReaderClientRemote } client
   */

  readAll(pipe, client) {}
  
  /**
   * @param { !bigint } offset
   * @param { !bigint } length
   * @param { !MojoHandle } pipe
   * @param { ?BlobReaderClientRemote } client
   */

  readRange(offset, length, pipe, client) {}
  
  /**
   * @param { !network_mojom_URLLoaderPendingReceiver } loader
   * @param { !string } requestMethod
   * @param { !network_mojom_HttpRequestHeaders } headers
   * @param { !network_mojom_URLLoaderClientRemote } client
   */

  load(loader, requestMethod, headers, client) {}
  
  /**
   * @return {!Promise<{
        data: ?mojoBase_mojom_BigBuffer,
   *  }>}
   */

  readSideData() {}
  
  /**
   * @return {!Promise<{
        length: !bigint,
        modificationTime: ?mojoBase_mojom_Time,
   *  }>}
   */

  captureSnapshot() {}
  
  /**
   * @return {!Promise<{
        uuid: !string,
   *  }>}
   */

  getInternalUUID() {}
}

/**
 * @implements { BlobInterface }
 */
export class BlobRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BlobPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BlobPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BlobPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !BlobPendingReceiver } blob
   */

  clone(
      blob) {
    this.proxy.sendMessage(
        0,
        Blob_Clone_ParamsSpec.$,
        null,
        [
          blob
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_DataPipeGetterPendingReceiver } dataPipeGetter
   */

  asDataPipeGetter(
      dataPipeGetter) {
    this.proxy.sendMessage(
        1,
        Blob_AsDataPipeGetter_ParamsSpec.$,
        null,
        [
          dataPipeGetter
        ],
        false);
  }

  
  /**
   * @param { !MojoHandle } pipe
   * @param { ?BlobReaderClientRemote } client
   */

  readAll(
      pipe,
      client) {
    this.proxy.sendMessage(
        2,
        Blob_ReadAll_ParamsSpec.$,
        null,
        [
          pipe,
          client
        ],
        false);
  }

  
  /**
   * @param { !bigint } offset
   * @param { !bigint } length
   * @param { !MojoHandle } pipe
   * @param { ?BlobReaderClientRemote } client
   */

  readRange(
      offset,
      length,
      pipe,
      client) {
    this.proxy.sendMessage(
        3,
        Blob_ReadRange_ParamsSpec.$,
        null,
        [
          offset,
          length,
          pipe,
          client
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_URLLoaderPendingReceiver } loader
   * @param { !string } requestMethod
   * @param { !network_mojom_HttpRequestHeaders } headers
   * @param { !network_mojom_URLLoaderClientRemote } client
   */

  load(
      loader,
      requestMethod,
      headers,
      client) {
    this.proxy.sendMessage(
        4,
        Blob_Load_ParamsSpec.$,
        null,
        [
          loader,
          requestMethod,
          headers,
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        data: ?mojoBase_mojom_BigBuffer,
   *  }>}
   */

  readSideData() {
    return this.proxy.sendMessage(
        5,
        Blob_ReadSideData_ParamsSpec.$,
        Blob_ReadSideData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        length: !bigint,
        modificationTime: ?mojoBase_mojom_Time,
   *  }>}
   */

  captureSnapshot() {
    return this.proxy.sendMessage(
        6,
        Blob_CaptureSnapshot_ParamsSpec.$,
        Blob_CaptureSnapshot_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        uuid: !string,
   *  }>}
   */

  getInternalUUID() {
    return this.proxy.sendMessage(
        7,
        Blob_GetInternalUUID_ParamsSpec.$,
        Blob_GetInternalUUID_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Blob
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BlobReceiver {
  /**
   * @param {!BlobInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BlobRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BlobRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Blob_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Blob_AsDataPipeGetter_ParamsSpec.$,
        null,
        impl.asDataPipeGetter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Blob_ReadAll_ParamsSpec.$,
        null,
        impl.readAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Blob_ReadRange_ParamsSpec.$,
        null,
        impl.readRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Blob_Load_ParamsSpec.$,
        null,
        impl.load.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Blob_ReadSideData_ParamsSpec.$,
        Blob_ReadSideData_ResponseParamsSpec.$,
        impl.readSideData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Blob_CaptureSnapshot_ParamsSpec.$,
        Blob_CaptureSnapshot_ResponseParamsSpec.$,
        impl.captureSnapshot.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Blob_GetInternalUUID_ParamsSpec.$,
        Blob_GetInternalUUID_ResponseParamsSpec.$,
        impl.getInternalUUID.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Blob {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Blob";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BlobRemote}
   */
  static getRemote() {
    let remote = new BlobRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Blob
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BlobCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BlobRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Blob_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.asDataPipeGetter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Blob_AsDataPipeGetter_ParamsSpec.$,
        null,
        this.asDataPipeGetter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Blob_ReadAll_ParamsSpec.$,
        null,
        this.readAll.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Blob_ReadRange_ParamsSpec.$,
        null,
        this.readRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.load =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Blob_Load_ParamsSpec.$,
        null,
        this.load.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readSideData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Blob_ReadSideData_ParamsSpec.$,
        Blob_ReadSideData_ResponseParamsSpec.$,
        this.readSideData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.captureSnapshot =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Blob_CaptureSnapshot_ParamsSpec.$,
        Blob_CaptureSnapshot_ResponseParamsSpec.$,
        this.captureSnapshot.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInternalUUID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Blob_GetInternalUUID_ParamsSpec.$,
        Blob_GetInternalUUID_ResponseParamsSpec.$,
        this.getInternalUUID.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobReaderClient_OnCalculatedSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobReaderClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_AsDataPipeGetter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_ReadAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_ReadRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_Load_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_ReadSideData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_ReadSideData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_CaptureSnapshot_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_CaptureSnapshot_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_GetInternalUUID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Blob_GetInternalUUID_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BlobReaderClient_OnCalculatedSize_ParamsSpec.$,
    'BlobReaderClient_OnCalculatedSize_Params',
    [
      mojo.internal.StructField(
        'totalSize', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedContentSize', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BlobReaderClient_OnCalculatedSize_Params {
  constructor() {
    /** @type { !bigint } */
    this.totalSize;
    /** @type { !bigint } */
    this.expectedContentSize;
  }
}



mojo.internal.Struct(
    BlobReaderClient_OnComplete_ParamsSpec.$,
    'BlobReaderClient_OnComplete_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataLength', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BlobReaderClient_OnComplete_Params {
  constructor() {
    /** @type { !number } */
    this.status;
    /** @type { !bigint } */
    this.dataLength;
  }
}



mojo.internal.Struct(
    Blob_Clone_ParamsSpec.$,
    'Blob_Clone_Params',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceRequest(BlobPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Blob_Clone_Params {
  constructor() {
    /** @type { !BlobPendingReceiver } */
    this.blob;
  }
}



mojo.internal.Struct(
    Blob_AsDataPipeGetter_ParamsSpec.$,
    'Blob_AsDataPipeGetter_Params',
    [
      mojo.internal.StructField(
        'dataPipeGetter', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_DataPipeGetterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Blob_AsDataPipeGetter_Params {
  constructor() {
    /** @type { !network_mojom_DataPipeGetterPendingReceiver } */
    this.dataPipeGetter;
  }
}



mojo.internal.Struct(
    Blob_ReadAll_ParamsSpec.$,
    'Blob_ReadAll_Params',
    [
      mojo.internal.StructField(
        'pipe', 0,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(BlobReaderClientRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Blob_ReadAll_Params {
  constructor() {
    /** @type { !MojoHandle } */
    this.pipe;
    /** @type { (BlobReaderClientRemote|undefined) } */
    this.client;
  }
}



mojo.internal.Struct(
    Blob_ReadRange_ParamsSpec.$,
    'Blob_ReadRange_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pipe', 16,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 20,
        0,
        mojo.internal.InterfaceProxy(BlobReaderClientRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class Blob_ReadRange_Params {
  constructor() {
    /** @type { !bigint } */
    this.offset;
    /** @type { !bigint } */
    this.length;
    /** @type { !MojoHandle } */
    this.pipe;
    /** @type { (BlobReaderClientRemote|undefined) } */
    this.client;
  }
}



mojo.internal.Struct(
    Blob_Load_ParamsSpec.$,
    'Blob_Load_Params',
    [
      mojo.internal.StructField(
        'loader', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_URLLoaderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestMethod', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 16,
        0,
        network_mojom_HttpRequestHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class Blob_Load_Params {
  constructor() {
    /** @type { !network_mojom_URLLoaderPendingReceiver } */
    this.loader;
    /** @type { !string } */
    this.requestMethod;
    /** @type { !network_mojom_HttpRequestHeaders } */
    this.headers;
    /** @type { !network_mojom_URLLoaderClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    Blob_ReadSideData_ParamsSpec.$,
    'Blob_ReadSideData_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Blob_ReadSideData_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Blob_ReadSideData_ResponseParamsSpec.$,
    'Blob_ReadSideData_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Blob_ReadSideData_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_BigBuffer|undefined) } */
    this.data;
  }
}



mojo.internal.Struct(
    Blob_CaptureSnapshot_ParamsSpec.$,
    'Blob_CaptureSnapshot_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Blob_CaptureSnapshot_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Blob_CaptureSnapshot_ResponseParamsSpec.$,
    'Blob_CaptureSnapshot_ResponseParams',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modificationTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Blob_CaptureSnapshot_ResponseParams {
  constructor() {
    /** @type { !bigint } */
    this.length;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.modificationTime;
  }
}



mojo.internal.Struct(
    Blob_GetInternalUUID_ParamsSpec.$,
    'Blob_GetInternalUUID_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Blob_GetInternalUUID_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Blob_GetInternalUUID_ResponseParamsSpec.$,
    'Blob_GetInternalUUID_ResponseParams',
    [
      mojo.internal.StructField(
        'uuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Blob_GetInternalUUID_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.uuid;
  }
}

