// third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/blob/file_backed_blob_factory.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob.mojom', 'blob.mojom.js');
  }
  var data_element$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/data_element.mojom', 'data_element.mojom.js');
  }



  function FileBackedBlobFactory_RegisterBlob_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileBackedBlobFactory_RegisterBlob_Params.prototype.initDefaults_ = function() {
    this.blob = new bindings.InterfaceRequest();
    this.uuid = null;
    this.contentType = null;
    this.file = null;
  };
  FileBackedBlobFactory_RegisterBlob_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileBackedBlobFactory_RegisterBlob_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileBackedBlobFactory_RegisterBlob_Params.blob
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileBackedBlobFactory_RegisterBlob_Params.uuid
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileBackedBlobFactory_RegisterBlob_Params.contentType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileBackedBlobFactory_RegisterBlob_Params.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, data_element$.DataElementFile, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileBackedBlobFactory_RegisterBlob_Params.encodedSize = codec.kStructHeaderSize + 32;

  FileBackedBlobFactory_RegisterBlob_Params.decode = function(decoder) {
    var packed;
    var val = new FileBackedBlobFactory_RegisterBlob_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blob =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.uuid =
        decoder.decodeStruct(codec.String);
    val.contentType =
        decoder.decodeStruct(codec.String);
    val.file =
        decoder.decodeStructPointer(data_element$.DataElementFile);
    return val;
  };

  FileBackedBlobFactory_RegisterBlob_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileBackedBlobFactory_RegisterBlob_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.blob);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.uuid);
    encoder.encodeStruct(codec.String, val.contentType);
    encoder.encodeStructPointer(data_element$.DataElementFile, val.file);
  };
  function FileBackedBlobFactory_RegisterBlobSync_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileBackedBlobFactory_RegisterBlobSync_Params.prototype.initDefaults_ = function() {
    this.blob = new bindings.InterfaceRequest();
    this.uuid = null;
    this.contentType = null;
    this.file = null;
  };
  FileBackedBlobFactory_RegisterBlobSync_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileBackedBlobFactory_RegisterBlobSync_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileBackedBlobFactory_RegisterBlobSync_Params.blob
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileBackedBlobFactory_RegisterBlobSync_Params.uuid
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileBackedBlobFactory_RegisterBlobSync_Params.contentType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileBackedBlobFactory_RegisterBlobSync_Params.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, data_element$.DataElementFile, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileBackedBlobFactory_RegisterBlobSync_Params.encodedSize = codec.kStructHeaderSize + 32;

  FileBackedBlobFactory_RegisterBlobSync_Params.decode = function(decoder) {
    var packed;
    var val = new FileBackedBlobFactory_RegisterBlobSync_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blob =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.uuid =
        decoder.decodeStruct(codec.String);
    val.contentType =
        decoder.decodeStruct(codec.String);
    val.file =
        decoder.decodeStructPointer(data_element$.DataElementFile);
    return val;
  };

  FileBackedBlobFactory_RegisterBlobSync_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileBackedBlobFactory_RegisterBlobSync_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.blob);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.uuid);
    encoder.encodeStruct(codec.String, val.contentType);
    encoder.encodeStructPointer(data_element$.DataElementFile, val.file);
  };
  function FileBackedBlobFactory_RegisterBlobSync_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileBackedBlobFactory_RegisterBlobSync_ResponseParams.prototype.initDefaults_ = function() {
  };
  FileBackedBlobFactory_RegisterBlobSync_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileBackedBlobFactory_RegisterBlobSync_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileBackedBlobFactory_RegisterBlobSync_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  FileBackedBlobFactory_RegisterBlobSync_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileBackedBlobFactory_RegisterBlobSync_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileBackedBlobFactory_RegisterBlobSync_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileBackedBlobFactory_RegisterBlobSync_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  var kFileBackedBlobFactory_RegisterBlob_Name = 0;
  var kFileBackedBlobFactory_RegisterBlobSync_Name = 1;

  function FileBackedBlobFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileBackedBlobFactory,
                                                   handleOrPtrInfo);
  }

  function FileBackedBlobFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileBackedBlobFactory, associatedInterfacePtrInfo);
  }

  FileBackedBlobFactoryAssociatedPtr.prototype =
      Object.create(FileBackedBlobFactoryPtr.prototype);
  FileBackedBlobFactoryAssociatedPtr.prototype.constructor =
      FileBackedBlobFactoryAssociatedPtr;

  function FileBackedBlobFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileBackedBlobFactoryPtr.prototype.registerBlob = function() {
    return FileBackedBlobFactoryProxy.prototype.registerBlob
        .apply(this.ptr.getProxy(), arguments);
  };

  FileBackedBlobFactoryProxy.prototype.registerBlob = function(blob, uuid, contentType, file) {
    var params_ = new FileBackedBlobFactory_RegisterBlob_Params();
    params_.blob = blob;
    params_.uuid = uuid;
    params_.contentType = contentType;
    params_.file = file;
    var builder = new codec.MessageV0Builder(
        kFileBackedBlobFactory_RegisterBlob_Name,
        codec.align(FileBackedBlobFactory_RegisterBlob_Params.encodedSize));
    builder.encodeStruct(FileBackedBlobFactory_RegisterBlob_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FileBackedBlobFactoryPtr.prototype.registerBlobSync = function() {
    return FileBackedBlobFactoryProxy.prototype.registerBlobSync
        .apply(this.ptr.getProxy(), arguments);
  };

  FileBackedBlobFactoryProxy.prototype.registerBlobSync = function(blob, uuid, contentType, file) {
    var params_ = new FileBackedBlobFactory_RegisterBlobSync_Params();
    params_.blob = blob;
    params_.uuid = uuid;
    params_.contentType = contentType;
    params_.file = file;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileBackedBlobFactory_RegisterBlobSync_Name,
          codec.align(FileBackedBlobFactory_RegisterBlobSync_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileBackedBlobFactory_RegisterBlobSync_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileBackedBlobFactory_RegisterBlobSync_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FileBackedBlobFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  FileBackedBlobFactoryStub.prototype.registerBlob = function(blob, uuid, contentType, file) {
    return this.delegate_ && this.delegate_.registerBlob && this.delegate_.registerBlob(blob, uuid, contentType, file);
  }
  FileBackedBlobFactoryStub.prototype.registerBlobSync = function(blob, uuid, contentType, file) {
    return this.delegate_ && this.delegate_.registerBlobSync && this.delegate_.registerBlobSync(blob, uuid, contentType, file);
  }

  FileBackedBlobFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileBackedBlobFactory_RegisterBlob_Name:
      var params = reader.decodeStruct(FileBackedBlobFactory_RegisterBlob_Params);
      this.registerBlob(params.blob, params.uuid, params.contentType, params.file);
      return true;
    default:
      return false;
    }
  };

  FileBackedBlobFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileBackedBlobFactory_RegisterBlobSync_Name:
      var params = reader.decodeStruct(FileBackedBlobFactory_RegisterBlobSync_Params);
      this.registerBlobSync(params.blob, params.uuid, params.contentType, params.file).then(function(response) {
        var responseParams =
            new FileBackedBlobFactory_RegisterBlobSync_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kFileBackedBlobFactory_RegisterBlobSync_Name,
            codec.align(FileBackedBlobFactory_RegisterBlobSync_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileBackedBlobFactory_RegisterBlobSync_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileBackedBlobFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileBackedBlobFactory_RegisterBlob_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileBackedBlobFactory_RegisterBlob_Params;
      break;
      case kFileBackedBlobFactory_RegisterBlobSync_Name:
        if (message.expectsResponse())
          paramsClass = FileBackedBlobFactory_RegisterBlobSync_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileBackedBlobFactoryResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileBackedBlobFactory_RegisterBlobSync_Name:
        if (message.isResponse())
          paramsClass = FileBackedBlobFactory_RegisterBlobSync_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileBackedBlobFactory = {
    name: 'blink.mojom.FileBackedBlobFactory',
    kVersion: 0,
    ptrClass: FileBackedBlobFactoryPtr,
    proxyClass: FileBackedBlobFactoryProxy,
    stubClass: FileBackedBlobFactoryStub,
    validateRequest: validateFileBackedBlobFactoryRequest,
    validateResponse: validateFileBackedBlobFactoryResponse,
  };
  FileBackedBlobFactoryStub.prototype.validator = validateFileBackedBlobFactoryRequest;
  FileBackedBlobFactoryProxy.prototype.validator = validateFileBackedBlobFactoryResponse;
  exports.FileBackedBlobFactory = FileBackedBlobFactory;
  exports.FileBackedBlobFactoryPtr = FileBackedBlobFactoryPtr;
  exports.FileBackedBlobFactoryAssociatedPtr = FileBackedBlobFactoryAssociatedPtr;
})();