// third_party/blink/public/mojom/clipboard/clipboard.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.BigString');
goog.require('mojoBase.mojom.BigString16');
goog.require('skia.mojom.BitmapN32');
goog.require('blink.mojom.DataTransferFile');
goog.require('mojoBase.mojom.String16');
goog.require('mojoBase.mojom.Uint128');
goog.require('url.mojom.Url');
goog.require('mojoBase.mojom.BigBuffer');




goog.provide('blink.mojom.ClipboardFormat');
goog.provide('blink.mojom.ClipboardFormatSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ClipboardFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ClipboardFormat = {
  
  kPlaintext: 0,
  kHtml: 1,
  kSmartPaste: 2,
  kBookmark: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.ClipboardBuffer');
goog.provide('blink.mojom.ClipboardBufferSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ClipboardBufferSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ClipboardBuffer = {
  
  kStandard: 0,
  kSelection: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.PlatformClipboardPermissionState');
goog.provide('blink.mojom.PlatformClipboardPermissionStateSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PlatformClipboardPermissionStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PlatformClipboardPermissionState = {
  
  kAllow: 0,
  kAsk: 1,
  kDeny: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('blink.mojom.ClipboardListener');
goog.provide('blink.mojom.ClipboardListenerReceiver');
goog.provide('blink.mojom.ClipboardListenerCallbackRouter');
goog.provide('blink.mojom.ClipboardListenerInterface');
goog.provide('blink.mojom.ClipboardListenerRemote');
goog.provide('blink.mojom.ClipboardListenerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ClipboardListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ClipboardListener.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ClipboardListenerInterface = class {
  
  /**
   */

  onClipboardDataChanged() {}
};

/**
 * @export
 * @implements { blink.mojom.ClipboardListenerInterface }
 */
blink.mojom.ClipboardListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ClipboardListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ClipboardListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ClipboardListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onClipboardDataChanged() {
    this.proxy.sendMessage(
        0,
        blink.mojom.ClipboardListener_OnClipboardDataChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ClipboardListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ClipboardListenerReceiver = class {
  /**
   * @param {!blink.mojom.ClipboardListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ClipboardListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ClipboardListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ClipboardListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ClipboardListener_OnClipboardDataChanged_ParamsSpec.$,
        null,
        impl.onClipboardDataChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ClipboardListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ClipboardListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ClipboardListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ClipboardListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ClipboardListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ClipboardListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ClipboardListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ClipboardListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClipboardDataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ClipboardListener_OnClipboardDataChanged_ParamsSpec.$,
        null,
        this.onClipboardDataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ClipboardHost');
goog.provide('blink.mojom.ClipboardHostReceiver');
goog.provide('blink.mojom.ClipboardHostCallbackRouter');
goog.provide('blink.mojom.ClipboardHostInterface');
goog.provide('blink.mojom.ClipboardHostRemote');
goog.provide('blink.mojom.ClipboardHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ClipboardHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ClipboardHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ClipboardHostInterface = class {
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase.mojom.Uint128,
   *  }>}
   */

  getSequenceNumber(buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardFormat } format
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isFormatAvailable(format, buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        types: !Array<!mojoBase.mojom.String16>,
   *  }>}
   */

  readAvailableTypes(buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString16,
   *  }>}
   */

  readText(buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        markup: !mojoBase.mojom.BigString16,
        url: !url.mojom.Url,
        fragmentStart: !number,
        fragmentEnd: !number,
   *  }>}
   */

  readHtml(buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString16,
   *  }>}
   */

  readSvg(buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString,
   *  }>}
   */

  readRtf(buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        png: !mojoBase.mojom.BigBuffer,
   *  }>}
   */

  readPng(buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !blink.mojom.ClipboardFiles,
   *  }>}
   */

  readFiles(buffer) {}
  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @param { !mojoBase.mojom.String16 } type
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString16,
   *  }>}
   */

  readDataTransferCustomData(buffer, type) {}
  
  /**
   * @return {!Promise<{
        formatTypes: !Array<!mojoBase.mojom.String16>,
   *  }>}
   */

  readAvailableCustomAndStandardFormats() {}
  
  /**
   * @param { !mojoBase.mojom.String16 } format
   * @return {!Promise<{
        data: !mojoBase.mojom.BigBuffer,
   *  }>}
   */

  readUnsanitizedCustomFormat(format) {}
  
  /**
   * @param { !mojoBase.mojom.BigString16 } text
   */

  writeText(text) {}
  
  /**
   * @param { !mojoBase.mojom.BigString16 } markup
   * @param { !url.mojom.Url } url
   */

  writeHtml(markup, url) {}
  
  /**
   * @param { !mojoBase.mojom.BigString16 } markup
   */

  writeSvg(markup) {}
  
  /**
   */

  writeSmartPasteMarker() {}
  
  /**
   * @param { !Map<!mojoBase.mojom.String16, !mojoBase.mojom.BigString16> } data
   */

  writeDataTransferCustomData(data) {}
  
  /**
   * @param { !string } url
   * @param { !mojoBase.mojom.String16 } title
   */

  writeBookmark(url, title) {}
  
  /**
   * @param { !skia.mojom.BitmapN32 } image
   */

  writeImage(image) {}
  
  /**
   * @param { !mojoBase.mojom.String16 } format
   * @param { !mojoBase.mojom.BigBuffer } data
   */

  writeUnsanitizedCustomFormat(format, data) {}
  
  /**
   */

  commitWrite() {}
  
  /**
   * @param { !mojoBase.mojom.String16 } text
   */

  writeStringToFindPboard(text) {}
  
  /**
   * @return {!Promise<{
        state: !blink.mojom.PlatformClipboardPermissionState,
   *  }>}
   */

  getPlatformPermissionState() {}
  
  /**
   * @param { !blink.mojom.ClipboardListenerRemote } listener
   */

  registerClipboardListener(listener) {}
};

/**
 * @export
 * @implements { blink.mojom.ClipboardHostInterface }
 */
blink.mojom.ClipboardHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ClipboardHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ClipboardHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ClipboardHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase.mojom.Uint128,
   *  }>}
   */

  getSequenceNumber(
      buffer) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ClipboardHost_GetSequenceNumber_ParamsSpec.$,
        blink.mojom.ClipboardHost_GetSequenceNumber_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardFormat } format
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  isFormatAvailable(
      format,
      buffer) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.ClipboardHost_IsFormatAvailable_ParamsSpec.$,
        blink.mojom.ClipboardHost_IsFormatAvailable_ResponseParamsSpec.$,
        [
          format,
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        types: !Array<!mojoBase.mojom.String16>,
   *  }>}
   */

  readAvailableTypes(
      buffer) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.ClipboardHost_ReadAvailableTypes_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadAvailableTypes_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString16,
   *  }>}
   */

  readText(
      buffer) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.ClipboardHost_ReadText_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadText_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        markup: !mojoBase.mojom.BigString16,
        url: !url.mojom.Url,
        fragmentStart: !number,
        fragmentEnd: !number,
   *  }>}
   */

  readHtml(
      buffer) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.ClipboardHost_ReadHtml_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadHtml_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString16,
   *  }>}
   */

  readSvg(
      buffer) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.ClipboardHost_ReadSvg_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadSvg_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString,
   *  }>}
   */

  readRtf(
      buffer) {
    return this.proxy.sendMessage(
        6,
        blink.mojom.ClipboardHost_ReadRtf_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadRtf_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        png: !mojoBase.mojom.BigBuffer,
   *  }>}
   */

  readPng(
      buffer) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.ClipboardHost_ReadPng_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadPng_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @return {!Promise<{
        result: !blink.mojom.ClipboardFiles,
   *  }>}
   */

  readFiles(
      buffer) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.ClipboardHost_ReadFiles_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadFiles_ResponseParamsSpec.$,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardBuffer } buffer
   * @param { !mojoBase.mojom.String16 } type
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString16,
   *  }>}
   */

  readDataTransferCustomData(
      buffer,
      type) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.ClipboardHost_ReadDataTransferCustomData_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec.$,
        [
          buffer,
          type
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        formatTypes: !Array<!mojoBase.mojom.String16>,
   *  }>}
   */

  readAvailableCustomAndStandardFormats() {
    return this.proxy.sendMessage(
        10,
        blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } format
   * @return {!Promise<{
        data: !mojoBase.mojom.BigBuffer,
   *  }>}
   */

  readUnsanitizedCustomFormat(
      format) {
    return this.proxy.sendMessage(
        11,
        blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec.$,
        [
          format
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } text
   */

  writeText(
      text) {
    this.proxy.sendMessage(
        12,
        blink.mojom.ClipboardHost_WriteText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } markup
   * @param { !url.mojom.Url } url
   */

  writeHtml(
      markup,
      url) {
    this.proxy.sendMessage(
        13,
        blink.mojom.ClipboardHost_WriteHtml_ParamsSpec.$,
        null,
        [
          markup,
          url
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.BigString16 } markup
   */

  writeSvg(
      markup) {
    this.proxy.sendMessage(
        14,
        blink.mojom.ClipboardHost_WriteSvg_ParamsSpec.$,
        null,
        [
          markup
        ],
        false);
  }

  
  /**
   */

  writeSmartPasteMarker() {
    this.proxy.sendMessage(
        15,
        blink.mojom.ClipboardHost_WriteSmartPasteMarker_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Map<!mojoBase.mojom.String16, !mojoBase.mojom.BigString16> } data
   */

  writeDataTransferCustomData(
      data) {
    this.proxy.sendMessage(
        16,
        blink.mojom.ClipboardHost_WriteDataTransferCustomData_ParamsSpec.$,
        null,
        [
          data
        ],
        false);
  }

  
  /**
   * @param { !string } url
   * @param { !mojoBase.mojom.String16 } title
   */

  writeBookmark(
      url,
      title) {
    this.proxy.sendMessage(
        17,
        blink.mojom.ClipboardHost_WriteBookmark_ParamsSpec.$,
        null,
        [
          url,
          title
        ],
        false);
  }

  
  /**
   * @param { !skia.mojom.BitmapN32 } image
   */

  writeImage(
      image) {
    this.proxy.sendMessage(
        18,
        blink.mojom.ClipboardHost_WriteImage_ParamsSpec.$,
        null,
        [
          image
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } format
   * @param { !mojoBase.mojom.BigBuffer } data
   */

  writeUnsanitizedCustomFormat(
      format,
      data) {
    this.proxy.sendMessage(
        19,
        blink.mojom.ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec.$,
        null,
        [
          format,
          data
        ],
        false);
  }

  
  /**
   */

  commitWrite() {
    this.proxy.sendMessage(
        20,
        blink.mojom.ClipboardHost_CommitWrite_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } text
   */

  writeStringToFindPboard(
      text) {
    this.proxy.sendMessage(
        21,
        blink.mojom.ClipboardHost_WriteStringToFindPboard_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        state: !blink.mojom.PlatformClipboardPermissionState,
   *  }>}
   */

  getPlatformPermissionState() {
    return this.proxy.sendMessage(
        22,
        blink.mojom.ClipboardHost_GetPlatformPermissionState_ParamsSpec.$,
        blink.mojom.ClipboardHost_GetPlatformPermissionState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ClipboardListenerRemote } listener
   */

  registerClipboardListener(
      listener) {
    this.proxy.sendMessage(
        23,
        blink.mojom.ClipboardHost_RegisterClipboardListener_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ClipboardHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ClipboardHostReceiver = class {
  /**
   * @param {!blink.mojom.ClipboardHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ClipboardHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ClipboardHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ClipboardHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ClipboardHost_GetSequenceNumber_ParamsSpec.$,
        blink.mojom.ClipboardHost_GetSequenceNumber_ResponseParamsSpec.$,
        impl.getSequenceNumber.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ClipboardHost_IsFormatAvailable_ParamsSpec.$,
        blink.mojom.ClipboardHost_IsFormatAvailable_ResponseParamsSpec.$,
        impl.isFormatAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ClipboardHost_ReadAvailableTypes_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadAvailableTypes_ResponseParamsSpec.$,
        impl.readAvailableTypes.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ClipboardHost_ReadText_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadText_ResponseParamsSpec.$,
        impl.readText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ClipboardHost_ReadHtml_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadHtml_ResponseParamsSpec.$,
        impl.readHtml.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ClipboardHost_ReadSvg_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadSvg_ResponseParamsSpec.$,
        impl.readSvg.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ClipboardHost_ReadRtf_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadRtf_ResponseParamsSpec.$,
        impl.readRtf.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ClipboardHost_ReadPng_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadPng_ResponseParamsSpec.$,
        impl.readPng.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.ClipboardHost_ReadFiles_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadFiles_ResponseParamsSpec.$,
        impl.readFiles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.ClipboardHost_ReadDataTransferCustomData_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec.$,
        impl.readDataTransferCustomData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec.$,
        impl.readAvailableCustomAndStandardFormats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec.$,
        impl.readUnsanitizedCustomFormat.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.ClipboardHost_WriteText_ParamsSpec.$,
        null,
        impl.writeText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.ClipboardHost_WriteHtml_ParamsSpec.$,
        null,
        impl.writeHtml.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.ClipboardHost_WriteSvg_ParamsSpec.$,
        null,
        impl.writeSvg.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.ClipboardHost_WriteSmartPasteMarker_ParamsSpec.$,
        null,
        impl.writeSmartPasteMarker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        blink.mojom.ClipboardHost_WriteDataTransferCustomData_ParamsSpec.$,
        null,
        impl.writeDataTransferCustomData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        blink.mojom.ClipboardHost_WriteBookmark_ParamsSpec.$,
        null,
        impl.writeBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        blink.mojom.ClipboardHost_WriteImage_ParamsSpec.$,
        null,
        impl.writeImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        blink.mojom.ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec.$,
        null,
        impl.writeUnsanitizedCustomFormat.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        blink.mojom.ClipboardHost_CommitWrite_ParamsSpec.$,
        null,
        impl.commitWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        blink.mojom.ClipboardHost_WriteStringToFindPboard_ParamsSpec.$,
        null,
        impl.writeStringToFindPboard.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        blink.mojom.ClipboardHost_GetPlatformPermissionState_ParamsSpec.$,
        blink.mojom.ClipboardHost_GetPlatformPermissionState_ResponseParamsSpec.$,
        impl.getPlatformPermissionState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        blink.mojom.ClipboardHost_RegisterClipboardListener_ParamsSpec.$,
        null,
        impl.registerClipboardListener.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ClipboardHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ClipboardHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ClipboardHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ClipboardHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ClipboardHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ClipboardHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ClipboardHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ClipboardHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSequenceNumber =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ClipboardHost_GetSequenceNumber_ParamsSpec.$,
        blink.mojom.ClipboardHost_GetSequenceNumber_ResponseParamsSpec.$,
        this.getSequenceNumber.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFormatAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ClipboardHost_IsFormatAvailable_ParamsSpec.$,
        blink.mojom.ClipboardHost_IsFormatAvailable_ResponseParamsSpec.$,
        this.isFormatAvailable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readAvailableTypes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ClipboardHost_ReadAvailableTypes_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadAvailableTypes_ResponseParamsSpec.$,
        this.readAvailableTypes.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ClipboardHost_ReadText_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadText_ResponseParamsSpec.$,
        this.readText.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readHtml =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ClipboardHost_ReadHtml_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadHtml_ResponseParamsSpec.$,
        this.readHtml.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readSvg =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ClipboardHost_ReadSvg_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadSvg_ResponseParamsSpec.$,
        this.readSvg.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readRtf =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ClipboardHost_ReadRtf_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadRtf_ResponseParamsSpec.$,
        this.readRtf.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readPng =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ClipboardHost_ReadPng_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadPng_ResponseParamsSpec.$,
        this.readPng.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.ClipboardHost_ReadFiles_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadFiles_ResponseParamsSpec.$,
        this.readFiles.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readDataTransferCustomData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.ClipboardHost_ReadDataTransferCustomData_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec.$,
        this.readDataTransferCustomData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readAvailableCustomAndStandardFormats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec.$,
        this.readAvailableCustomAndStandardFormats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readUnsanitizedCustomFormat =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec.$,
        blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec.$,
        this.readUnsanitizedCustomFormat.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.ClipboardHost_WriteText_ParamsSpec.$,
        null,
        this.writeText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeHtml =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.ClipboardHost_WriteHtml_ParamsSpec.$,
        null,
        this.writeHtml.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSvg =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.ClipboardHost_WriteSvg_ParamsSpec.$,
        null,
        this.writeSvg.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSmartPasteMarker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.ClipboardHost_WriteSmartPasteMarker_ParamsSpec.$,
        null,
        this.writeSmartPasteMarker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeDataTransferCustomData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        blink.mojom.ClipboardHost_WriteDataTransferCustomData_ParamsSpec.$,
        null,
        this.writeDataTransferCustomData.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        blink.mojom.ClipboardHost_WriteBookmark_ParamsSpec.$,
        null,
        this.writeBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        blink.mojom.ClipboardHost_WriteImage_ParamsSpec.$,
        null,
        this.writeImage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeUnsanitizedCustomFormat =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        blink.mojom.ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec.$,
        null,
        this.writeUnsanitizedCustomFormat.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commitWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        blink.mojom.ClipboardHost_CommitWrite_ParamsSpec.$,
        null,
        this.commitWrite.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeStringToFindPboard =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        blink.mojom.ClipboardHost_WriteStringToFindPboard_ParamsSpec.$,
        null,
        this.writeStringToFindPboard.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPlatformPermissionState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        blink.mojom.ClipboardHost_GetPlatformPermissionState_ParamsSpec.$,
        blink.mojom.ClipboardHost_GetPlatformPermissionState_ResponseParamsSpec.$,
        this.getPlatformPermissionState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerClipboardListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        blink.mojom.ClipboardHost_RegisterClipboardListener_ParamsSpec.$,
        null,
        this.registerClipboardListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ClipboardFilesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardFilesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardListener_OnClipboardDataChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardListener_OnClipboardDataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_GetSequenceNumber_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_GetSequenceNumber_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_GetSequenceNumber_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_GetSequenceNumber_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_IsFormatAvailable_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_IsFormatAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_IsFormatAvailable_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_IsFormatAvailable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadAvailableTypes_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadAvailableTypes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadAvailableTypes_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadAvailableTypes_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadText_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadText_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadText_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadHtml_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadHtml_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadHtml_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadHtml_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadSvg_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadSvg_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadSvg_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadSvg_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadRtf_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadRtf_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadRtf_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadRtf_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadPng_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadPng_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadPng_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadPng_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadFiles_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadFiles_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadFiles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadDataTransferCustomData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadDataTransferCustomData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteText_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteHtml_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteHtml_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteSvg_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteSvg_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteSmartPasteMarker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteSmartPasteMarker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteDataTransferCustomData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteDataTransferCustomData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteBookmark_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteBookmark_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteImage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_CommitWrite_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_CommitWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_WriteStringToFindPboard_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_WriteStringToFindPboard_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_GetPlatformPermissionState_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_GetPlatformPermissionState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_GetPlatformPermissionState_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_GetPlatformPermissionState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ClipboardHost_RegisterClipboardListener_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ClipboardHost_RegisterClipboardListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ClipboardFilesSpec.$,
    'ClipboardFiles',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(blink.mojom.DataTransferFileSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileSystemId', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ClipboardFiles');

/** @record */
blink.mojom.ClipboardFiles = class {
  constructor() {
    /** @export { !Array<!blink.mojom.DataTransferFile> } */
    this.files;
    /** @export { (string|undefined) } */
    this.fileSystemId;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardListener_OnClipboardDataChanged_ParamsSpec.$,
    'ClipboardListener_OnClipboardDataChanged_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ClipboardListener_OnClipboardDataChanged_Params');

/** @record */
blink.mojom.ClipboardListener_OnClipboardDataChanged_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_GetSequenceNumber_ParamsSpec.$,
    'ClipboardHost_GetSequenceNumber_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_GetSequenceNumber_Params');

/** @record */
blink.mojom.ClipboardHost_GetSequenceNumber_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_GetSequenceNumber_ResponseParamsSpec.$,
    'ClipboardHost_GetSequenceNumber_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.Uint128Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_GetSequenceNumber_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_GetSequenceNumber_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.Uint128 } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_IsFormatAvailable_ParamsSpec.$,
    'ClipboardHost_IsFormatAvailable_Params',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        blink.mojom.ClipboardFormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buffer', 4,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_IsFormatAvailable_Params');

/** @record */
blink.mojom.ClipboardHost_IsFormatAvailable_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardFormat } */
    this.format;
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_IsFormatAvailable_ResponseParamsSpec.$,
    'ClipboardHost_IsFormatAvailable_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_IsFormatAvailable_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_IsFormatAvailable_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadAvailableTypes_ParamsSpec.$,
    'ClipboardHost_ReadAvailableTypes_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadAvailableTypes_Params');

/** @record */
blink.mojom.ClipboardHost_ReadAvailableTypes_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadAvailableTypes_ResponseParamsSpec.$,
    'ClipboardHost_ReadAvailableTypes_ResponseParams',
    [
      mojo.internal.StructField(
        'types', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.String16Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadAvailableTypes_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadAvailableTypes_ResponseParams = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.String16> } */
    this.types;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadText_ParamsSpec.$,
    'ClipboardHost_ReadText_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadText_Params');

/** @record */
blink.mojom.ClipboardHost_ReadText_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadText_ResponseParamsSpec.$,
    'ClipboardHost_ReadText_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadText_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadText_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadHtml_ParamsSpec.$,
    'ClipboardHost_ReadHtml_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadHtml_Params');

/** @record */
blink.mojom.ClipboardHost_ReadHtml_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadHtml_ResponseParamsSpec.$,
    'ClipboardHost_ReadHtml_ResponseParams',
    [
      mojo.internal.StructField(
        'markup', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fragmentStart', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fragmentEnd', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ClipboardHost_ReadHtml_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadHtml_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.markup;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !number } */
    this.fragmentStart;
    /** @export { !number } */
    this.fragmentEnd;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadSvg_ParamsSpec.$,
    'ClipboardHost_ReadSvg_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadSvg_Params');

/** @record */
blink.mojom.ClipboardHost_ReadSvg_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadSvg_ResponseParamsSpec.$,
    'ClipboardHost_ReadSvg_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadSvg_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadSvg_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadRtf_ParamsSpec.$,
    'ClipboardHost_ReadRtf_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadRtf_Params');

/** @record */
blink.mojom.ClipboardHost_ReadRtf_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadRtf_ResponseParamsSpec.$,
    'ClipboardHost_ReadRtf_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.BigStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadRtf_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadRtf_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadPng_ParamsSpec.$,
    'ClipboardHost_ReadPng_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadPng_Params');

/** @record */
blink.mojom.ClipboardHost_ReadPng_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadPng_ResponseParamsSpec.$,
    'ClipboardHost_ReadPng_ResponseParams',
    [
      mojo.internal.StructField(
        'png', 0,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ClipboardHost_ReadPng_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadPng_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.png;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadFiles_ParamsSpec.$,
    'ClipboardHost_ReadFiles_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadFiles_Params');

/** @record */
blink.mojom.ClipboardHost_ReadFiles_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadFiles_ResponseParamsSpec.$,
    'ClipboardHost_ReadFiles_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.ClipboardFilesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadFiles_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadFiles_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardFiles } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadDataTransferCustomData_ParamsSpec.$,
    'ClipboardHost_ReadDataTransferCustomData_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        blink.mojom.ClipboardBufferSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ClipboardHost_ReadDataTransferCustomData_Params');

/** @record */
blink.mojom.ClipboardHost_ReadDataTransferCustomData_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardBuffer } */
    this.buffer;
    /** @export { !mojoBase.mojom.String16 } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadDataTransferCustomData_ResponseParamsSpec.$,
    'ClipboardHost_ReadDataTransferCustomData_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadDataTransferCustomData_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadDataTransferCustomData_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsSpec.$,
    'ClipboardHost_ReadAvailableCustomAndStandardFormats_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_Params');

/** @record */
blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsSpec.$,
    'ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams',
    [
      mojo.internal.StructField(
        'formatTypes', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.String16Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.String16> } */
    this.formatTypes;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ParamsSpec.$,
    'ClipboardHost_ReadUnsanitizedCustomFormat_Params',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_Params');

/** @record */
blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.format;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsSpec.$,
    'ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteText_ParamsSpec.$,
    'ClipboardHost_WriteText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_WriteText_Params');

/** @record */
blink.mojom.ClipboardHost_WriteText_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.text;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteHtml_ParamsSpec.$,
    'ClipboardHost_WriteHtml_Params',
    [
      mojo.internal.StructField(
        'markup', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ClipboardHost_WriteHtml_Params');

/** @record */
blink.mojom.ClipboardHost_WriteHtml_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.markup;
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteSvg_ParamsSpec.$,
    'ClipboardHost_WriteSvg_Params',
    [
      mojo.internal.StructField(
        'markup', 0,
        0,
        mojoBase.mojom.BigString16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_WriteSvg_Params');

/** @record */
blink.mojom.ClipboardHost_WriteSvg_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString16 } */
    this.markup;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteSmartPasteMarker_ParamsSpec.$,
    'ClipboardHost_WriteSmartPasteMarker_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ClipboardHost_WriteSmartPasteMarker_Params');

/** @record */
blink.mojom.ClipboardHost_WriteSmartPasteMarker_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteDataTransferCustomData_ParamsSpec.$,
    'ClipboardHost_WriteDataTransferCustomData_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Map(mojoBase.mojom.String16Spec.$, mojoBase.mojom.BigString16Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_WriteDataTransferCustomData_Params');

/** @record */
blink.mojom.ClipboardHost_WriteDataTransferCustomData_Params = class {
  constructor() {
    /** @export { !Map<!mojoBase.mojom.String16, !mojoBase.mojom.BigString16> } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteBookmark_ParamsSpec.$,
    'ClipboardHost_WriteBookmark_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'title', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ClipboardHost_WriteBookmark_Params');

/** @record */
blink.mojom.ClipboardHost_WriteBookmark_Params = class {
  constructor() {
    /** @export { !string } */
    this.url;
    /** @export { !mojoBase.mojom.String16 } */
    this.title;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteImage_ParamsSpec.$,
    'ClipboardHost_WriteImage_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        skia.mojom.BitmapN32Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_WriteImage_Params');

/** @record */
blink.mojom.ClipboardHost_WriteImage_Params = class {
  constructor() {
    /** @export { !skia.mojom.BitmapN32 } */
    this.image;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteUnsanitizedCustomFormat_ParamsSpec.$,
    'ClipboardHost_WriteUnsanitizedCustomFormat_Params',
    [
      mojo.internal.StructField(
        'format', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ClipboardHost_WriteUnsanitizedCustomFormat_Params');

/** @record */
blink.mojom.ClipboardHost_WriteUnsanitizedCustomFormat_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.format;
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_CommitWrite_ParamsSpec.$,
    'ClipboardHost_CommitWrite_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ClipboardHost_CommitWrite_Params');

/** @record */
blink.mojom.ClipboardHost_CommitWrite_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_WriteStringToFindPboard_ParamsSpec.$,
    'ClipboardHost_WriteStringToFindPboard_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_WriteStringToFindPboard_Params');

/** @record */
blink.mojom.ClipboardHost_WriteStringToFindPboard_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_GetPlatformPermissionState_ParamsSpec.$,
    'ClipboardHost_GetPlatformPermissionState_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ClipboardHost_GetPlatformPermissionState_Params');

/** @record */
blink.mojom.ClipboardHost_GetPlatformPermissionState_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_GetPlatformPermissionState_ResponseParamsSpec.$,
    'ClipboardHost_GetPlatformPermissionState_ResponseParams',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.PlatformClipboardPermissionStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_GetPlatformPermissionState_ResponseParams');

/** @record */
blink.mojom.ClipboardHost_GetPlatformPermissionState_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PlatformClipboardPermissionState } */
    this.state;
  }
};



mojo.internal.Struct(
    blink.mojom.ClipboardHost_RegisterClipboardListener_ParamsSpec.$,
    'ClipboardHost_RegisterClipboardListener_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ClipboardListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ClipboardHost_RegisterClipboardListener_Params');

/** @record */
blink.mojom.ClipboardHost_RegisterClipboardListener_Params = class {
  constructor() {
    /** @export { !blink.mojom.ClipboardListenerRemote } */
    this.listener;
  }
};

