// third_party/blink/public/mojom/close_watcher/close_listener.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/close_watcher/close_listener.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function CloseListener_Signal_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CloseListener_Signal_Params.prototype.initDefaults_ = function() {
  };
  CloseListener_Signal_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CloseListener_Signal_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CloseListener_Signal_Params.encodedSize = codec.kStructHeaderSize + 0;

  CloseListener_Signal_Params.decode = function(decoder) {
    var packed;
    var val = new CloseListener_Signal_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CloseListener_Signal_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CloseListener_Signal_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kCloseListener_Signal_Name = 0;

  function CloseListenerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CloseListener,
                                                   handleOrPtrInfo);
  }

  function CloseListenerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CloseListener, associatedInterfacePtrInfo);
  }

  CloseListenerAssociatedPtr.prototype =
      Object.create(CloseListenerPtr.prototype);
  CloseListenerAssociatedPtr.prototype.constructor =
      CloseListenerAssociatedPtr;

  function CloseListenerProxy(receiver) {
    this.receiver_ = receiver;
  }
  CloseListenerPtr.prototype.signal = function() {
    return CloseListenerProxy.prototype.signal
        .apply(this.ptr.getProxy(), arguments);
  };

  CloseListenerProxy.prototype.signal = function() {
    var params_ = new CloseListener_Signal_Params();
    var builder = new codec.MessageV0Builder(
        kCloseListener_Signal_Name,
        codec.align(CloseListener_Signal_Params.encodedSize));
    builder.encodeStruct(CloseListener_Signal_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CloseListenerStub(delegate) {
    this.delegate_ = delegate;
  }
  CloseListenerStub.prototype.signal = function() {
    return this.delegate_ && this.delegate_.signal && this.delegate_.signal();
  }

  CloseListenerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCloseListener_Signal_Name:
      var params = reader.decodeStruct(CloseListener_Signal_Params);
      this.signal();
      return true;
    default:
      return false;
    }
  };

  CloseListenerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCloseListenerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCloseListener_Signal_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CloseListener_Signal_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCloseListenerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CloseListener = {
    name: 'blink.mojom.CloseListener',
    kVersion: 0,
    ptrClass: CloseListenerPtr,
    proxyClass: CloseListenerProxy,
    stubClass: CloseListenerStub,
    validateRequest: validateCloseListenerRequest,
    validateResponse: null,
  };
  CloseListenerStub.prototype.validator = validateCloseListenerRequest;
  CloseListenerProxy.prototype.validator = null;
  exports.CloseListener = CloseListener;
  exports.CloseListenerPtr = CloseListenerPtr;
  exports.CloseListenerAssociatedPtr = CloseListenerAssociatedPtr;
})();