// third_party/blink/public/mojom/conversions/conversions.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/conversions/conversions.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var data_host$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/data_host.mojom', '../../../../../components/attribution_reporting/data_host.mojom.js');
  }
  var registration_eligibility$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/registration_eligibility.mojom', '../../../../../components/attribution_reporting/registration_eligibility.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var attribution$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/attribution.mojom', '../../../../../services/network/public/mojom/attribution.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function Impression(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Impression.prototype.initDefaults_ = function() {
    this.attributionSrcToken = null;
    this.isEmptyAttributionSrcTag = false;
  };
  Impression.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Impression.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Impression.attributionSrcToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.AttributionSrcToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Impression.encodedSize = codec.kStructHeaderSize + 16;

  Impression.decode = function(decoder) {
    var packed;
    var val = new Impression();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.attributionSrcToken =
        decoder.decodeStructPointer(tokens$.AttributionSrcToken);
    packed = decoder.readUint8();
    val.isEmptyAttributionSrcTag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Impression.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Impression.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.AttributionSrcToken, val.attributionSrcToken);
    packed = 0;
    packed |= (val.isEmptyAttributionSrcTag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AttributionHost_RegisterDataHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AttributionHost_RegisterDataHost_Params.prototype.initDefaults_ = function() {
    this.dataHost = new bindings.InterfaceRequest();
    this.registrationEligibility = 0;
    this.isForBackgroundRequests = false;
    this.reportingOrigins = null;
  };
  AttributionHost_RegisterDataHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AttributionHost_RegisterDataHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionHost_RegisterDataHost_Params.dataHost
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionHost_RegisterDataHost_Params.registrationEligibility
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, registration_eligibility$.RegistrationEligibility);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AttributionHost_RegisterDataHost_Params.reportingOrigins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AttributionHost_RegisterDataHost_Params.encodedSize = codec.kStructHeaderSize + 24;

  AttributionHost_RegisterDataHost_Params.decode = function(decoder) {
    var packed;
    var val = new AttributionHost_RegisterDataHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dataHost =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.registrationEligibility =
        decoder.decodeStruct(new codec.Enum(registration_eligibility$.RegistrationEligibility));
    packed = decoder.readUint8();
    val.isForBackgroundRequests = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.reportingOrigins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  AttributionHost_RegisterDataHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AttributionHost_RegisterDataHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.dataHost);
    encoder.encodeStruct(codec.Int32, val.registrationEligibility);
    packed = 0;
    packed |= (val.isForBackgroundRequests & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.reportingOrigins);
  };
  function AttributionHost_RegisterNavigationDataHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AttributionHost_RegisterNavigationDataHost_Params.prototype.initDefaults_ = function() {
    this.dataHost = new bindings.InterfaceRequest();
    this.attributionSrcToken = null;
  };
  AttributionHost_RegisterNavigationDataHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AttributionHost_RegisterNavigationDataHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionHost_RegisterNavigationDataHost_Params.dataHost
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionHost_RegisterNavigationDataHost_Params.attributionSrcToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, tokens$.AttributionSrcToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AttributionHost_RegisterNavigationDataHost_Params.encodedSize = codec.kStructHeaderSize + 16;

  AttributionHost_RegisterNavigationDataHost_Params.decode = function(decoder) {
    var packed;
    var val = new AttributionHost_RegisterNavigationDataHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dataHost =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.attributionSrcToken =
        decoder.decodeStructPointer(tokens$.AttributionSrcToken);
    return val;
  };

  AttributionHost_RegisterNavigationDataHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AttributionHost_RegisterNavigationDataHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.dataHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(tokens$.AttributionSrcToken, val.attributionSrcToken);
  };
  function AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.prototype.initDefaults_ = function() {
    this.attributionSrcToken = null;
    this.expectedRegistrations = 0;
  };
  AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.attributionSrcToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.AttributionSrcToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.encodedSize = codec.kStructHeaderSize + 16;

  AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.decode = function(decoder) {
    var packed;
    var val = new AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.attributionSrcToken =
        decoder.decodeStructPointer(tokens$.AttributionSrcToken);
    val.expectedRegistrations =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.AttributionSrcToken, val.attributionSrcToken);
    encoder.encodeStruct(codec.Uint32, val.expectedRegistrations);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kAttributionHost_RegisterDataHost_Name = 0;
  var kAttributionHost_RegisterNavigationDataHost_Name = 1;
  var kAttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Name = 2;

  function AttributionHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AttributionHost,
                                                   handleOrPtrInfo);
  }

  function AttributionHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AttributionHost, associatedInterfacePtrInfo);
  }

  AttributionHostAssociatedPtr.prototype =
      Object.create(AttributionHostPtr.prototype);
  AttributionHostAssociatedPtr.prototype.constructor =
      AttributionHostAssociatedPtr;

  function AttributionHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  AttributionHostPtr.prototype.registerDataHost = function() {
    return AttributionHostProxy.prototype.registerDataHost
        .apply(this.ptr.getProxy(), arguments);
  };

  AttributionHostProxy.prototype.registerDataHost = function(dataHost, registrationEligibility, isForBackgroundRequests, reportingOrigins) {
    var params_ = new AttributionHost_RegisterDataHost_Params();
    params_.dataHost = dataHost;
    params_.registrationEligibility = registrationEligibility;
    params_.isForBackgroundRequests = isForBackgroundRequests;
    params_.reportingOrigins = reportingOrigins;
    var builder = new codec.MessageV0Builder(
        kAttributionHost_RegisterDataHost_Name,
        codec.align(AttributionHost_RegisterDataHost_Params.encodedSize));
    builder.encodeStruct(AttributionHost_RegisterDataHost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AttributionHostPtr.prototype.registerNavigationDataHost = function() {
    return AttributionHostProxy.prototype.registerNavigationDataHost
        .apply(this.ptr.getProxy(), arguments);
  };

  AttributionHostProxy.prototype.registerNavigationDataHost = function(dataHost, attributionSrcToken) {
    var params_ = new AttributionHost_RegisterNavigationDataHost_Params();
    params_.dataHost = dataHost;
    params_.attributionSrcToken = attributionSrcToken;
    var builder = new codec.MessageV0Builder(
        kAttributionHost_RegisterNavigationDataHost_Name,
        codec.align(AttributionHost_RegisterNavigationDataHost_Params.encodedSize));
    builder.encodeStruct(AttributionHost_RegisterNavigationDataHost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AttributionHostPtr.prototype.notifyNavigationWithBackgroundRegistrationsWillStart = function() {
    return AttributionHostProxy.prototype.notifyNavigationWithBackgroundRegistrationsWillStart
        .apply(this.ptr.getProxy(), arguments);
  };

  AttributionHostProxy.prototype.notifyNavigationWithBackgroundRegistrationsWillStart = function(attributionSrcToken, expectedRegistrations) {
    var params_ = new AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params();
    params_.attributionSrcToken = attributionSrcToken;
    params_.expectedRegistrations = expectedRegistrations;
    var builder = new codec.MessageV0Builder(
        kAttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Name,
        codec.align(AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params.encodedSize));
    builder.encodeStruct(AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AttributionHostStub(delegate) {
    this.delegate_ = delegate;
  }
  AttributionHostStub.prototype.registerDataHost = function(dataHost, registrationEligibility, isForBackgroundRequests, reportingOrigins) {
    return this.delegate_ && this.delegate_.registerDataHost && this.delegate_.registerDataHost(dataHost, registrationEligibility, isForBackgroundRequests, reportingOrigins);
  }
  AttributionHostStub.prototype.registerNavigationDataHost = function(dataHost, attributionSrcToken) {
    return this.delegate_ && this.delegate_.registerNavigationDataHost && this.delegate_.registerNavigationDataHost(dataHost, attributionSrcToken);
  }
  AttributionHostStub.prototype.notifyNavigationWithBackgroundRegistrationsWillStart = function(attributionSrcToken, expectedRegistrations) {
    return this.delegate_ && this.delegate_.notifyNavigationWithBackgroundRegistrationsWillStart && this.delegate_.notifyNavigationWithBackgroundRegistrationsWillStart(attributionSrcToken, expectedRegistrations);
  }

  AttributionHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAttributionHost_RegisterDataHost_Name:
      var params = reader.decodeStruct(AttributionHost_RegisterDataHost_Params);
      this.registerDataHost(params.dataHost, params.registrationEligibility, params.isForBackgroundRequests, params.reportingOrigins);
      return true;
    case kAttributionHost_RegisterNavigationDataHost_Name:
      var params = reader.decodeStruct(AttributionHost_RegisterNavigationDataHost_Params);
      this.registerNavigationDataHost(params.dataHost, params.attributionSrcToken);
      return true;
    case kAttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Name:
      var params = reader.decodeStruct(AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params);
      this.notifyNavigationWithBackgroundRegistrationsWillStart(params.attributionSrcToken, params.expectedRegistrations);
      return true;
    default:
      return false;
    }
  };

  AttributionHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAttributionHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAttributionHost_RegisterDataHost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AttributionHost_RegisterDataHost_Params;
      break;
      case kAttributionHost_RegisterNavigationDataHost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AttributionHost_RegisterNavigationDataHost_Params;
      break;
      case kAttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAttributionHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AttributionHost = {
    name: 'blink.mojom.AttributionHost',
    kVersion: 0,
    ptrClass: AttributionHostPtr,
    proxyClass: AttributionHostProxy,
    stubClass: AttributionHostStub,
    validateRequest: validateAttributionHostRequest,
    validateResponse: null,
  };
  AttributionHostStub.prototype.validator = validateAttributionHostRequest;
  AttributionHostProxy.prototype.validator = null;
  exports.Impression = Impression;
  exports.AttributionHost = AttributionHost;
  exports.AttributionHostPtr = AttributionHostPtr;
  exports.AttributionHostAssociatedPtr = AttributionHostAssociatedPtr;
})();