// third_party/blink/public/mojom/devtools/devtools_agent.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  ReadOnlyBuffer as mojoBase_mojom_ReadOnlyBuffer,
  ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec
} from '../../../../../mojo/public/mojom/base/read_only_buffer.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Point as gfx_mojom_Point,
  PointSpec as gfx_mojom_PointSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DevToolsExecutionContextTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DevToolsExecutionContextType = {
  
  kDedicatedWorker: 0,
  kWorklet: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevToolsAgentPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DevToolsAgent', scope);
  }
}

/** @interface */
export class DevToolsAgentInterface {
  
  /**
   * @param { !Object } host
   * @param { !Object } session
   * @param { !DevToolsSessionPendingReceiver } ioSession
   * @param { ?DevToolsSessionState } reattachSessionState
   * @param { !string } scriptToEvaluateOnLoad
   * @param { !boolean } clientExpectsBinaryResponses
   * @param { !boolean } clientIsTrusted
   * @param { !string } sessionId
   * @param { !boolean } sessionWaitsForDebugger
   */

  attachDevToolsSession(host, session, ioSession, reattachSessionState, scriptToEvaluateOnLoad, clientExpectsBinaryResponses, clientIsTrusted, sessionId, sessionWaitsForDebugger) {}
  
  /**
   * @param { !gfx_mojom_Point } point
   */

  inspectElement(point) {}
  
  /**
   * @param { !boolean } report
   * @param { !boolean } waitForDebugger
   * @return {!Promise}
   */

  reportChildTargets(report, waitForDebugger) {}
}

/**
 * @implements { DevToolsAgentInterface }
 */
export class DevToolsAgentRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevToolsAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevToolsAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevToolsAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } host
   * @param { !Object } session
   * @param { !DevToolsSessionPendingReceiver } ioSession
   * @param { ?DevToolsSessionState } reattachSessionState
   * @param { !string } scriptToEvaluateOnLoad
   * @param { !boolean } clientExpectsBinaryResponses
   * @param { !boolean } clientIsTrusted
   * @param { !string } sessionId
   * @param { !boolean } sessionWaitsForDebugger
   */

  attachDevToolsSession(
      host,
      session,
      ioSession,
      reattachSessionState,
      scriptToEvaluateOnLoad,
      clientExpectsBinaryResponses,
      clientIsTrusted,
      sessionId,
      sessionWaitsForDebugger) {
    this.proxy.sendMessage(
        0,
        DevToolsAgent_AttachDevToolsSession_ParamsSpec.$,
        null,
        [
          host,
          session,
          ioSession,
          reattachSessionState,
          scriptToEvaluateOnLoad,
          clientExpectsBinaryResponses,
          clientIsTrusted,
          sessionId,
          sessionWaitsForDebugger
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Point } point
   */

  inspectElement(
      point) {
    this.proxy.sendMessage(
        1,
        DevToolsAgent_InspectElement_ParamsSpec.$,
        null,
        [
          point
        ],
        false);
  }

  
  /**
   * @param { !boolean } report
   * @param { !boolean } waitForDebugger
   * @return {!Promise}
   */

  reportChildTargets(
      report,
      waitForDebugger) {
    return this.proxy.sendMessage(
        2,
        DevToolsAgent_ReportChildTargets_ParamsSpec.$,
        DevToolsAgent_ReportChildTargets_ResponseParamsSpec.$,
        [
          report,
          waitForDebugger
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevToolsAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevToolsAgentReceiver {
  /**
   * @param {!DevToolsAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevToolsAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevToolsAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevToolsAgent_AttachDevToolsSession_ParamsSpec.$,
        null,
        impl.attachDevToolsSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DevToolsAgent_InspectElement_ParamsSpec.$,
        null,
        impl.inspectElement.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DevToolsAgent_ReportChildTargets_ParamsSpec.$,
        DevToolsAgent_ReportChildTargets_ResponseParamsSpec.$,
        impl.reportChildTargets.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevToolsAgent {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevToolsAgentRemote}
   */
  static getRemote() {
    let remote = new DevToolsAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevToolsAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevToolsAgentCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevToolsAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.attachDevToolsSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevToolsAgent_AttachDevToolsSession_ParamsSpec.$,
        null,
        this.attachDevToolsSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.inspectElement =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DevToolsAgent_InspectElement_ParamsSpec.$,
        null,
        this.inspectElement.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportChildTargets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DevToolsAgent_ReportChildTargets_ParamsSpec.$,
        DevToolsAgent_ReportChildTargets_ResponseParamsSpec.$,
        this.reportChildTargets.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevToolsAgentHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DevToolsAgentHost', scope);
  }
}

/** @interface */
export class DevToolsAgentHostInterface {
  
  /**
   * @param { !DevToolsAgentRemote } workerDevtoolsAgent
   * @param { !DevToolsAgentHostPendingReceiver } workerDevtoolsAgentHost
   * @param { !url_mojom_Url } url
   * @param { !string } name
   * @param { !mojoBase_mojom_UnguessableToken } devtoolsWorkerToken
   * @param { !boolean } waitingForDebugger
   * @param { !DevToolsExecutionContextType } contextType
   */

  childTargetCreated(workerDevtoolsAgent, workerDevtoolsAgentHost, url, name, devtoolsWorkerToken, waitingForDebugger, contextType) {}
  
  /**
   */

  mainThreadDebuggerPaused() {}
  
  /**
   */

  mainThreadDebuggerResumed() {}
  
  /**
   */

  bringToForeground() {}
}

/**
 * @implements { DevToolsAgentHostInterface }
 */
export class DevToolsAgentHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevToolsAgentHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevToolsAgentHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevToolsAgentHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DevToolsAgentRemote } workerDevtoolsAgent
   * @param { !DevToolsAgentHostPendingReceiver } workerDevtoolsAgentHost
   * @param { !url_mojom_Url } url
   * @param { !string } name
   * @param { !mojoBase_mojom_UnguessableToken } devtoolsWorkerToken
   * @param { !boolean } waitingForDebugger
   * @param { !DevToolsExecutionContextType } contextType
   */

  childTargetCreated(
      workerDevtoolsAgent,
      workerDevtoolsAgentHost,
      url,
      name,
      devtoolsWorkerToken,
      waitingForDebugger,
      contextType) {
    this.proxy.sendMessage(
        0,
        DevToolsAgentHost_ChildTargetCreated_ParamsSpec.$,
        null,
        [
          workerDevtoolsAgent,
          workerDevtoolsAgentHost,
          url,
          name,
          devtoolsWorkerToken,
          waitingForDebugger,
          contextType
        ],
        false);
  }

  
  /**
   */

  mainThreadDebuggerPaused() {
    this.proxy.sendMessage(
        1,
        DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  mainThreadDebuggerResumed() {
    this.proxy.sendMessage(
        2,
        DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  bringToForeground() {
    this.proxy.sendMessage(
        3,
        DevToolsAgentHost_BringToForeground_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevToolsAgentHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevToolsAgentHostReceiver {
  /**
   * @param {!DevToolsAgentHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevToolsAgentHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevToolsAgentHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsAgentHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevToolsAgentHost_ChildTargetCreated_ParamsSpec.$,
        null,
        impl.childTargetCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec.$,
        null,
        impl.mainThreadDebuggerPaused.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec.$,
        null,
        impl.mainThreadDebuggerResumed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        DevToolsAgentHost_BringToForeground_ParamsSpec.$,
        null,
        impl.bringToForeground.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevToolsAgentHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsAgentHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevToolsAgentHostRemote}
   */
  static getRemote() {
    let remote = new DevToolsAgentHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevToolsAgentHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevToolsAgentHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevToolsAgentHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsAgentHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.childTargetCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevToolsAgentHost_ChildTargetCreated_ParamsSpec.$,
        null,
        this.childTargetCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mainThreadDebuggerPaused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec.$,
        null,
        this.mainThreadDebuggerPaused.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mainThreadDebuggerResumed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec.$,
        null,
        this.mainThreadDebuggerResumed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bringToForeground =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        DevToolsAgentHost_BringToForeground_ParamsSpec.$,
        null,
        this.bringToForeground.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevToolsSessionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DevToolsSession', scope);
  }
}

/** @interface */
export class DevToolsSessionInterface {
  
  /**
   * @param { !number } callId
   * @param { !string } method
   * @param { !mojoBase_mojom_ReadOnlyBuffer } message
   */

  dispatchProtocolCommand(callId, method, message) {}
  
  /**
   */

  unpauseAndTerminate() {}
}

/**
 * @implements { DevToolsSessionInterface }
 */
export class DevToolsSessionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevToolsSessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevToolsSessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevToolsSessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } callId
   * @param { !string } method
   * @param { !mojoBase_mojom_ReadOnlyBuffer } message
   */

  dispatchProtocolCommand(
      callId,
      method,
      message) {
    this.proxy.sendMessage(
        0,
        DevToolsSession_DispatchProtocolCommand_ParamsSpec.$,
        null,
        [
          callId,
          method,
          message
        ],
        false);
  }

  
  /**
   */

  unpauseAndTerminate() {
    this.proxy.sendMessage(
        1,
        DevToolsSession_UnpauseAndTerminate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevToolsSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevToolsSessionReceiver {
  /**
   * @param {!DevToolsSessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevToolsSessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevToolsSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevToolsSession_DispatchProtocolCommand_ParamsSpec.$,
        null,
        impl.dispatchProtocolCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DevToolsSession_UnpauseAndTerminate_ParamsSpec.$,
        null,
        impl.unpauseAndTerminate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevToolsSession {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsSession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevToolsSessionRemote}
   */
  static getRemote() {
    let remote = new DevToolsSessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevToolsSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevToolsSessionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevToolsSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchProtocolCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevToolsSession_DispatchProtocolCommand_ParamsSpec.$,
        null,
        this.dispatchProtocolCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unpauseAndTerminate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DevToolsSession_UnpauseAndTerminate_ParamsSpec.$,
        null,
        this.unpauseAndTerminate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevToolsSessionHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DevToolsSessionHost', scope);
  }
}

/** @interface */
export class DevToolsSessionHostInterface {
  
  /**
   * @param { !DevToolsMessage } message
   * @param { !number } callId
   * @param { ?DevToolsSessionState } updates
   */

  dispatchProtocolResponse(message, callId, updates) {}
  
  /**
   * @param { !DevToolsMessage } message
   * @param { ?DevToolsSessionState } updates
   */

  dispatchProtocolNotification(message, updates) {}
}

/**
 * @implements { DevToolsSessionHostInterface }
 */
export class DevToolsSessionHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevToolsSessionHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevToolsSessionHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevToolsSessionHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DevToolsMessage } message
   * @param { !number } callId
   * @param { ?DevToolsSessionState } updates
   */

  dispatchProtocolResponse(
      message,
      callId,
      updates) {
    this.proxy.sendMessage(
        0,
        DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec.$,
        null,
        [
          message,
          callId,
          updates
        ],
        false);
  }

  
  /**
   * @param { !DevToolsMessage } message
   * @param { ?DevToolsSessionState } updates
   */

  dispatchProtocolNotification(
      message,
      updates) {
    this.proxy.sendMessage(
        1,
        DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec.$,
        null,
        [
          message,
          updates
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevToolsSessionHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevToolsSessionHostReceiver {
  /**
   * @param {!DevToolsSessionHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevToolsSessionHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevToolsSessionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsSessionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec.$,
        null,
        impl.dispatchProtocolResponse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec.$,
        null,
        impl.dispatchProtocolNotification.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevToolsSessionHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsSessionHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevToolsSessionHostRemote}
   */
  static getRemote() {
    let remote = new DevToolsSessionHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevToolsSessionHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevToolsSessionHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevToolsSessionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsSessionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchProtocolResponse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec.$,
        null,
        this.dispatchProtocolResponse.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchProtocolNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec.$,
        null,
        this.dispatchProtocolNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsMessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsSessionStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsAgent_AttachDevToolsSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsAgent_InspectElement_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsAgent_ReportChildTargets_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsAgent_ReportChildTargets_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsAgentHost_ChildTargetCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsAgentHost_BringToForeground_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsSession_DispatchProtocolCommand_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsSession_UnpauseAndTerminate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DevToolsMessageSpec.$,
    'DevToolsMessage',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DevToolsMessage {
  constructor() {
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    DevToolsSessionStateSpec.$,
    'DevToolsSessionState',
    [
      mojo.internal.StructField(
        'entries', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(mojo.internal.Uint8, false), true),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevToolsSessionState {
  constructor() {
    /** @type { !Object<!string, ?Array<!number>> } */
    this.entries;
  }
}



mojo.internal.Struct(
    DevToolsAgent_AttachDevToolsSession_ParamsSpec.$,
    'DevToolsAgent_AttachDevToolsSession_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(DevToolsSessionHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'session', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(DevToolsSessionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ioSession', 12,
        0,
        mojo.internal.InterfaceRequest(DevToolsSessionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reattachSessionState', 16,
        0,
        DevToolsSessionStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptToEvaluateOnLoad', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientExpectsBinaryResponses', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientIsTrusted', 32,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionWaitsForDebugger', 32,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class DevToolsAgent_AttachDevToolsSession_Params {
  constructor() {
    /** @type { !Object } */
    this.host;
    /** @type { !Object } */
    this.session;
    /** @type { !DevToolsSessionPendingReceiver } */
    this.ioSession;
    /** @type { (DevToolsSessionState|undefined) } */
    this.reattachSessionState;
    /** @type { !string } */
    this.scriptToEvaluateOnLoad;
    /** @type { !boolean } */
    this.clientExpectsBinaryResponses;
    /** @type { !boolean } */
    this.clientIsTrusted;
    /** @type { !string } */
    this.sessionId;
    /** @type { !boolean } */
    this.sessionWaitsForDebugger;
  }
}



mojo.internal.Struct(
    DevToolsAgent_InspectElement_ParamsSpec.$,
    'DevToolsAgent_InspectElement_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevToolsAgent_InspectElement_Params {
  constructor() {
    /** @type { !gfx_mojom_Point } */
    this.point;
  }
}



mojo.internal.Struct(
    DevToolsAgent_ReportChildTargets_ParamsSpec.$,
    'DevToolsAgent_ReportChildTargets_Params',
    [
      mojo.internal.StructField(
        'report', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'waitForDebugger', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevToolsAgent_ReportChildTargets_Params {
  constructor() {
    /** @type { !boolean } */
    this.report;
    /** @type { !boolean } */
    this.waitForDebugger;
  }
}



mojo.internal.Struct(
    DevToolsAgent_ReportChildTargets_ResponseParamsSpec.$,
    'DevToolsAgent_ReportChildTargets_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DevToolsAgent_ReportChildTargets_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    DevToolsAgentHost_ChildTargetCreated_ParamsSpec.$,
    'DevToolsAgentHost_ChildTargetCreated_Params',
    [
      mojo.internal.StructField(
        'workerDevtoolsAgent', 0,
        0,
        mojo.internal.InterfaceProxy(DevToolsAgentRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workerDevtoolsAgentHost', 8,
        0,
        mojo.internal.InterfaceRequest(DevToolsAgentHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsWorkerToken', 32,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'waitingForDebugger', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contextType', 40,
        0,
        DevToolsExecutionContextTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class DevToolsAgentHost_ChildTargetCreated_Params {
  constructor() {
    /** @type { !DevToolsAgentRemote } */
    this.workerDevtoolsAgent;
    /** @type { !DevToolsAgentHostPendingReceiver } */
    this.workerDevtoolsAgentHost;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.name;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.devtoolsWorkerToken;
    /** @type { !boolean } */
    this.waitingForDebugger;
    /** @type { !DevToolsExecutionContextType } */
    this.contextType;
  }
}



mojo.internal.Struct(
    DevToolsAgentHost_MainThreadDebuggerPaused_ParamsSpec.$,
    'DevToolsAgentHost_MainThreadDebuggerPaused_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DevToolsAgentHost_MainThreadDebuggerPaused_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DevToolsAgentHost_MainThreadDebuggerResumed_ParamsSpec.$,
    'DevToolsAgentHost_MainThreadDebuggerResumed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DevToolsAgentHost_MainThreadDebuggerResumed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DevToolsAgentHost_BringToForeground_ParamsSpec.$,
    'DevToolsAgentHost_BringToForeground_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DevToolsAgentHost_BringToForeground_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DevToolsSession_DispatchProtocolCommand_ParamsSpec.$,
    'DevToolsSession_DispatchProtocolCommand_Params',
    [
      mojo.internal.StructField(
        'callId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'method', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DevToolsSession_DispatchProtocolCommand_Params {
  constructor() {
    /** @type { !number } */
    this.callId;
    /** @type { !string } */
    this.method;
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.message;
  }
}



mojo.internal.Struct(
    DevToolsSession_UnpauseAndTerminate_ParamsSpec.$,
    'DevToolsSession_UnpauseAndTerminate_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DevToolsSession_UnpauseAndTerminate_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DevToolsSessionHost_DispatchProtocolResponse_ParamsSpec.$,
    'DevToolsSessionHost_DispatchProtocolResponse_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        DevToolsMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'callId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updates', 16,
        0,
        DevToolsSessionStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DevToolsSessionHost_DispatchProtocolResponse_Params {
  constructor() {
    /** @type { !DevToolsMessage } */
    this.message;
    /** @type { !number } */
    this.callId;
    /** @type { (DevToolsSessionState|undefined) } */
    this.updates;
  }
}



mojo.internal.Struct(
    DevToolsSessionHost_DispatchProtocolNotification_ParamsSpec.$,
    'DevToolsSessionHost_DispatchProtocolNotification_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        DevToolsMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updates', 8,
        0,
        DevToolsSessionStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DevToolsSessionHost_DispatchProtocolNotification_Params {
  constructor() {
    /** @type { !DevToolsMessage } */
    this.message;
    /** @type { (DevToolsSessionState|undefined) } */
    this.updates;
  }
}

