// third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }



  function FileSystemAccessDataTransferToken_GetInternalId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDataTransferToken_GetInternalId_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessDataTransferToken_GetInternalId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDataTransferToken_GetInternalId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDataTransferToken_GetInternalId_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessDataTransferToken_GetInternalId_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDataTransferToken_GetInternalId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessDataTransferToken_GetInternalId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDataTransferToken_GetInternalId_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessDataTransferToken_GetInternalId_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.prototype.initDefaults_ = function() {
    this.id = null;
  };
  FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDataTransferToken_GetInternalId_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.id);
  };
  function FileSystemAccessDataTransferToken_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessDataTransferToken_Clone_Params.prototype.initDefaults_ = function() {
    this.tokenClone = new bindings.InterfaceRequest();
  };
  FileSystemAccessDataTransferToken_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessDataTransferToken_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessDataTransferToken_Clone_Params.tokenClone
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessDataTransferToken_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessDataTransferToken_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessDataTransferToken_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tokenClone =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessDataTransferToken_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessDataTransferToken_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.tokenClone);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kFileSystemAccessDataTransferToken_GetInternalId_Name = 0;
  var kFileSystemAccessDataTransferToken_Clone_Name = 1;

  function FileSystemAccessDataTransferTokenPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessDataTransferToken,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessDataTransferTokenAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessDataTransferToken, associatedInterfacePtrInfo);
  }

  FileSystemAccessDataTransferTokenAssociatedPtr.prototype =
      Object.create(FileSystemAccessDataTransferTokenPtr.prototype);
  FileSystemAccessDataTransferTokenAssociatedPtr.prototype.constructor =
      FileSystemAccessDataTransferTokenAssociatedPtr;

  function FileSystemAccessDataTransferTokenProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessDataTransferTokenPtr.prototype.getInternalId = function() {
    return FileSystemAccessDataTransferTokenProxy.prototype.getInternalId
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDataTransferTokenProxy.prototype.getInternalId = function() {
    var params_ = new FileSystemAccessDataTransferToken_GetInternalId_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessDataTransferToken_GetInternalId_Name,
          codec.align(FileSystemAccessDataTransferToken_GetInternalId_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessDataTransferToken_GetInternalId_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessDataTransferToken_GetInternalId_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessDataTransferTokenPtr.prototype.clone = function() {
    return FileSystemAccessDataTransferTokenProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessDataTransferTokenProxy.prototype.clone = function(tokenClone) {
    var params_ = new FileSystemAccessDataTransferToken_Clone_Params();
    params_.tokenClone = tokenClone;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessDataTransferToken_Clone_Name,
        codec.align(FileSystemAccessDataTransferToken_Clone_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessDataTransferToken_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FileSystemAccessDataTransferTokenStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessDataTransferTokenStub.prototype.getInternalId = function() {
    return this.delegate_ && this.delegate_.getInternalId && this.delegate_.getInternalId();
  }
  FileSystemAccessDataTransferTokenStub.prototype.clone = function(tokenClone) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(tokenClone);
  }

  FileSystemAccessDataTransferTokenStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessDataTransferToken_Clone_Name:
      var params = reader.decodeStruct(FileSystemAccessDataTransferToken_Clone_Params);
      this.clone(params.tokenClone);
      return true;
    default:
      return false;
    }
  };

  FileSystemAccessDataTransferTokenStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessDataTransferToken_GetInternalId_Name:
      var params = reader.decodeStruct(FileSystemAccessDataTransferToken_GetInternalId_Params);
      this.getInternalId().then(function(response) {
        var responseParams =
            new FileSystemAccessDataTransferToken_GetInternalId_ResponseParams();
        responseParams.id = response.id;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessDataTransferToken_GetInternalId_Name,
            codec.align(FileSystemAccessDataTransferToken_GetInternalId_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessDataTransferToken_GetInternalId_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessDataTransferTokenRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessDataTransferToken_GetInternalId_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessDataTransferToken_GetInternalId_Params;
      break;
      case kFileSystemAccessDataTransferToken_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessDataTransferToken_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessDataTransferTokenResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessDataTransferToken_GetInternalId_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessDataTransferToken_GetInternalId_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessDataTransferToken = {
    name: 'blink.mojom.FileSystemAccessDataTransferToken',
    kVersion: 0,
    ptrClass: FileSystemAccessDataTransferTokenPtr,
    proxyClass: FileSystemAccessDataTransferTokenProxy,
    stubClass: FileSystemAccessDataTransferTokenStub,
    validateRequest: validateFileSystemAccessDataTransferTokenRequest,
    validateResponse: validateFileSystemAccessDataTransferTokenResponse,
  };
  FileSystemAccessDataTransferTokenStub.prototype.validator = validateFileSystemAccessDataTransferTokenRequest;
  FileSystemAccessDataTransferTokenProxy.prototype.validator = validateFileSystemAccessDataTransferTokenResponse;
  exports.FileSystemAccessDataTransferToken = FileSystemAccessDataTransferToken;
  exports.FileSystemAccessDataTransferTokenPtr = FileSystemAccessDataTransferTokenPtr;
  exports.FileSystemAccessDataTransferTokenAssociatedPtr = FileSystemAccessDataTransferTokenAssociatedPtr;
})();