// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.FileSystemAccessPermissionMode');
goog.require('blink.mojom.PermissionStatus');
goog.require('blink.mojom.FileSystemAccessFileHandle');
goog.require('blink.mojom.FileSystemAccessTransferToken');
goog.require('blink.mojom.FileSystemAccessCloudIdentifier');
goog.require('blink.mojom.FileSystemAccessError');






goog.provide('blink.mojom.FileSystemAccessDirectoryEntriesListener');
goog.provide('blink.mojom.FileSystemAccessDirectoryEntriesListenerReceiver');
goog.provide('blink.mojom.FileSystemAccessDirectoryEntriesListenerCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessDirectoryEntriesListenerInterface');
goog.provide('blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote');
goog.provide('blink.mojom.FileSystemAccessDirectoryEntriesListenerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryEntriesListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessDirectoryEntriesListener.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessDirectoryEntriesListenerInterface = class {
  
  /**
   * @param { !blink.mojom.FileSystemAccessError } result
   * @param { !Array<!blink.mojom.FileSystemAccessEntry> } entries
   * @param { !boolean } hasMoreEntries
   */

  didReadDirectory(result, entries, hasMoreEntries) {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessDirectoryEntriesListenerInterface }
 */
blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessDirectoryEntriesListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessDirectoryEntriesListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessDirectoryEntriesListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessError } result
   * @param { !Array<!blink.mojom.FileSystemAccessEntry> } entries
   * @param { !boolean } hasMoreEntries
   */

  didReadDirectory(
      result,
      entries,
      hasMoreEntries) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec.$,
        null,
        [
          result,
          entries,
          hasMoreEntries
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessDirectoryEntriesListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessDirectoryEntriesListenerReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessDirectoryEntriesListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec.$,
        null,
        impl.didReadDirectory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessDirectoryEntriesListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessDirectoryEntriesListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessDirectoryEntriesListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessDirectoryEntriesListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReadDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec.$,
        null,
        this.didReadDirectory.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessDirectoryHandle');
goog.provide('blink.mojom.FileSystemAccessDirectoryHandleReceiver');
goog.provide('blink.mojom.FileSystemAccessDirectoryHandleCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessDirectoryHandleInterface');
goog.provide('blink.mojom.FileSystemAccessDirectoryHandleRemote');
goog.provide('blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessDirectoryHandle.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessDirectoryHandleInterface = class {
  
  /**
   * @param { !blink.mojom.FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  getPermissionStatus(mode) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  requestPermission(mode) {}
  
  /**
   * @param { !string } basename
   * @param { !boolean } create
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        file: ?blink.mojom.FileSystemAccessFileHandleRemote,
   *  }>}
   */

  getFile(basename, create) {}
  
  /**
   * @param { !string } basename
   * @param { !boolean } create
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory(basename, create) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote } listener
   */

  getEntries(listener) {}
  
  /**
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  rename(newEntryName) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } destinationDirectory
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  move(destinationDirectory, newEntryName) {}
  
  /**
   * @param { !boolean } recurse
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  remove(recurse) {}
  
  /**
   * @param { !string } basename
   * @param { !boolean } recurse
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  removeEntry(basename, recurse) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } possibleChild
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        path: ?Array<!string>,
   *  }>}
   */

  resolve(possibleChild) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } token
   */

  transfer(token) {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        id: !string,
   *  }>}
   */

  getUniqueId() {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        cloudIdentifiers: !Array<!blink.mojom.FileSystemAccessCloudIdentifier>,
   *  }>}
   */

  getCloudIdentifiers() {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessDirectoryHandleInterface }
 */
blink.mojom.FileSystemAccessDirectoryHandleRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  getPermissionStatus(
      mode) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  requestPermission(
      mode) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !string } basename
   * @param { !boolean } create
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        file: ?blink.mojom.FileSystemAccessFileHandleRemote,
   *  }>}
   */

  getFile(
      basename,
      create) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec.$,
        [
          basename,
          create
        ],
        false);
  }

  
  /**
   * @param { !string } basename
   * @param { !boolean } create
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory(
      basename,
      create) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec.$,
        [
          basename,
          create
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote } listener
   */

  getEntries(
      listener) {
    this.proxy.sendMessage(
        4,
        blink.mojom.FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }

  
  /**
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  rename(
      newEntryName) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.FileSystemAccessDirectoryHandle_Rename_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec.$,
        [
          newEntryName
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } destinationDirectory
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  move(
      destinationDirectory,
      newEntryName) {
    return this.proxy.sendMessage(
        6,
        blink.mojom.FileSystemAccessDirectoryHandle_Move_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec.$,
        [
          destinationDirectory,
          newEntryName
        ],
        false);
  }

  
  /**
   * @param { !boolean } recurse
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  remove(
      recurse) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.FileSystemAccessDirectoryHandle_Remove_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec.$,
        [
          recurse
        ],
        false);
  }

  
  /**
   * @param { !string } basename
   * @param { !boolean } recurse
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
   *  }>}
   */

  removeEntry(
      basename,
      recurse) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec.$,
        [
          basename,
          recurse
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } possibleChild
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        path: ?Array<!string>,
   *  }>}
   */

  resolve(
      possibleChild) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec.$,
        [
          possibleChild
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } token
   */

  transfer(
      token) {
    this.proxy.sendMessage(
        10,
        blink.mojom.FileSystemAccessDirectoryHandle_Transfer_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        id: !string,
   *  }>}
   */

  getUniqueId() {
    return this.proxy.sendMessage(
        11,
        blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        cloudIdentifiers: !Array<!blink.mojom.FileSystemAccessCloudIdentifier>,
   *  }>}
   */

  getCloudIdentifiers() {
    return this.proxy.sendMessage(
        12,
        blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessDirectoryHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandleReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessDirectoryHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessDirectoryHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessDirectoryHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessDirectoryHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec.$,
        impl.getPermissionStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec.$,
        impl.requestPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec.$,
        impl.getFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec.$,
        impl.getDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec.$,
        null,
        impl.getEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FileSystemAccessDirectoryHandle_Rename_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec.$,
        impl.rename.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FileSystemAccessDirectoryHandle_Move_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec.$,
        impl.move.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FileSystemAccessDirectoryHandle_Remove_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec.$,
        impl.remove.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec.$,
        impl.removeEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec.$,
        impl.resolve.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.FileSystemAccessDirectoryHandle_Transfer_ParamsSpec.$,
        null,
        impl.transfer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec.$,
        impl.getUniqueId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        impl.getCloudIdentifiers.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessDirectoryHandle = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessDirectoryHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessDirectoryHandleRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessDirectoryHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessDirectoryHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandleCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessDirectoryHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessDirectoryHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPermissionStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec.$,
        this.getPermissionStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec.$,
        this.requestPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec.$,
        this.getFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec.$,
        this.getDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec.$,
        null,
        this.getEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rename =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FileSystemAccessDirectoryHandle_Rename_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec.$,
        this.rename.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.move =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FileSystemAccessDirectoryHandle_Move_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec.$,
        this.move.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.remove =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FileSystemAccessDirectoryHandle_Remove_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec.$,
        this.remove.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec.$,
        this.removeEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec.$,
        this.resolve.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transfer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.FileSystemAccessDirectoryHandle_Transfer_ParamsSpec.$,
        null,
        this.transfer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUniqueId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec.$,
        this.getUniqueId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCloudIdentifiers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec.$,
        blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        this.getCloudIdentifiers.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessEntrySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Rename_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Rename_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Move_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Move_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Remove_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Remove_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Transfer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_Transfer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessHandleSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FileSystemAccessHandleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessEntrySpec.$,
    'FileSystemAccessEntry',
    [
      mojo.internal.StructField(
        'entryHandle', 0,
        0,
        blink.mojom.FileSystemAccessHandleSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.FileSystemAccessEntry');

/** @record */
blink.mojom.FileSystemAccessEntry = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessHandle } */
    this.entryHandle;
    /** @export { !string } */
    this.name;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryEntriesListener_DidReadDirectory_ParamsSpec.$,
    'FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entries', 8,
        0,
        mojo.internal.Array(blink.mojom.FileSystemAccessEntrySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasMoreEntries', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryEntriesListener_DidReadDirectory_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !Array<!blink.mojom.FileSystemAccessEntry> } */
    this.entries;
    /** @export { !boolean } */
    this.hasMoreEntries;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetPermissionStatus_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.FileSystemAccessPermissionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessPermissionMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetPermissionStatus_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_RequestPermission_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.FileSystemAccessPermissionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessPermissionMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_RequestPermission_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetFile_Params',
    [
      mojo.internal.StructField(
        'basename', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'create', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetFile_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetFile_Params = class {
  constructor() {
    /** @export { !string } */
    this.basename;
    /** @export { !boolean } */
    this.create;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetFile_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'file', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessFileHandleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetFile_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessFileHandleRemote|undefined) } */
    this.file;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetDirectory_Params',
    [
      mojo.internal.StructField(
        'basename', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'create', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_Params = class {
  constructor() {
    /** @export { !string } */
    this.basename;
    /** @export { !boolean } */
    this.create;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDirectoryHandleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetDirectory_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetEntries_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetEntries_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetEntries_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetEntries_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessDirectoryEntriesListenerRemote } */
    this.listener;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Rename_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Rename_Params',
    [
      mojo.internal.StructField(
        'newEntryName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Rename_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Rename_Params = class {
  constructor() {
    /** @export { !string } */
    this.newEntryName;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Rename_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Rename_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Rename_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Rename_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Move_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Move_Params',
    [
      mojo.internal.StructField(
        'destinationDirectory', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newEntryName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Move_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Move_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.destinationDirectory;
    /** @export { !string } */
    this.newEntryName;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Move_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Move_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Move_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Move_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Remove_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Remove_Params',
    [
      mojo.internal.StructField(
        'recurse', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Remove_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Remove_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.recurse;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Remove_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Remove_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Remove_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Remove_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_RemoveEntry_Params',
    [
      mojo.internal.StructField(
        'basename', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recurse', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_Params = class {
  constructor() {
    /** @export { !string } */
    this.basename;
    /** @export { !boolean } */
    this.recurse;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_RemoveEntry_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Resolve_Params',
    [
      mojo.internal.StructField(
        'possibleChild', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Resolve_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Resolve_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.possibleChild;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Resolve_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Resolve_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (Array<!string>|undefined) } */
    this.path;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_Transfer_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_Transfer_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessTransferTokenPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_Transfer_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_Transfer_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetUniqueId_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetUniqueId_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
    'FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cloudIdentifiers', 8,
        0,
        mojo.internal.Array(blink.mojom.FileSystemAccessCloudIdentifierSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessDirectoryHandle_GetCloudIdentifiers_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !Array<!blink.mojom.FileSystemAccessCloudIdentifier> } */
    this.cloudIdentifiers;
  }
};

goog.provide('blink.mojom.FileSystemAccessHandle');


mojo.internal.Union(
    blink.mojom.FileSystemAccessHandleSpec.$, 'FileSystemAccessHandle',
    {
      'file': {
        'ordinal': 0,
        'type': mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessFileHandleRemote),
      },
      'directory': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDirectoryHandleRemote),
      },
    });

/**
 * @typedef { {
 *   file: (!blink.mojom.FileSystemAccessFileHandleRemote|undefined),
 *   directory: (!blink.mojom.FileSystemAccessDirectoryHandleRemote|undefined),
 * } }
 */
blink.mojom.FileSystemAccessHandle;
