// third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  FileError as mojoBase_mojom_FileError,
  FileErrorSpec as mojoBase_mojom_FileErrorSpec
} from '../../../../../mojo/public/mojom/base/file_error.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessFileDelegateHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessFileDelegateHost', scope);
  }
}

/** @interface */
export class FileSystemAccessFileDelegateHostInterface {
  
  /**
   * @param { !bigint } offset
   * @param { !number } bytesToRead
   * @return {!Promise<{
        data: ?mojoBase_mojom_BigBuffer,
        error: !mojoBase_mojom_FileError,
        bytesRead: !number,
   *  }>}
   */

  read(offset, bytesToRead) {}
  
  /**
   * @param { !bigint } offset
   * @param { !MojoHandle } data
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        bytesWritten: !number,
   *  }>}
   */

  write(offset, data) {}
  
  /**
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        length: !bigint,
   *  }>}
   */

  getLength() {}
  
  /**
   * @param { !bigint } length
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  setLength(length) {}
}

/**
 * @implements { FileSystemAccessFileDelegateHostInterface }
 */
export class FileSystemAccessFileDelegateHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessFileDelegateHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessFileDelegateHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessFileDelegateHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } offset
   * @param { !number } bytesToRead
   * @return {!Promise<{
        data: ?mojoBase_mojom_BigBuffer,
        error: !mojoBase_mojom_FileError,
        bytesRead: !number,
   *  }>}
   */

  read(
      offset,
      bytesToRead) {
    return this.proxy.sendMessage(
        0,
        FileSystemAccessFileDelegateHost_Read_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec.$,
        [
          offset,
          bytesToRead
        ],
        false);
  }

  
  /**
   * @param { !bigint } offset
   * @param { !MojoHandle } data
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        bytesWritten: !number,
   *  }>}
   */

  write(
      offset,
      data) {
    return this.proxy.sendMessage(
        1,
        FileSystemAccessFileDelegateHost_Write_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec.$,
        [
          offset,
          data
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
        length: !bigint,
   *  }>}
   */

  getLength() {
    return this.proxy.sendMessage(
        2,
        FileSystemAccessFileDelegateHost_GetLength_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } length
   * @return {!Promise<{
        error: !mojoBase_mojom_FileError,
   *  }>}
   */

  setLength(
      length) {
    return this.proxy.sendMessage(
        3,
        FileSystemAccessFileDelegateHost_SetLength_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec.$,
        [
          length
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessFileDelegateHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessFileDelegateHostReceiver {
  /**
   * @param {!FileSystemAccessFileDelegateHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessFileDelegateHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessFileDelegateHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessFileDelegateHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessFileDelegateHost_Read_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessFileDelegateHost_Write_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec.$,
        impl.write.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessFileDelegateHost_GetLength_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec.$,
        impl.getLength.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessFileDelegateHost_SetLength_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec.$,
        impl.setLength.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessFileDelegateHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessFileDelegateHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessFileDelegateHostRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessFileDelegateHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessFileDelegateHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessFileDelegateHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessFileDelegateHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessFileDelegateHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessFileDelegateHost_Read_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessFileDelegateHost_Write_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec.$,
        this.write.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getLength =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessFileDelegateHost_GetLength_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec.$,
        this.getLength.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLength =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessFileDelegateHost_SetLength_ParamsSpec.$,
        FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec.$,
        this.setLength.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileDelegateHost_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileDelegateHost_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileDelegateHost_GetLength_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileDelegateHost_SetLength_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileSystemAccessFileDelegateHost_Read_ParamsSpec.$,
    'FileSystemAccessFileDelegateHost_Read_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bytesToRead', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileDelegateHost_Read_Params {
  constructor() {
    /** @type { !bigint } */
    this.offset;
    /** @type { !number } */
    this.bytesToRead;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec.$,
    'FileSystemAccessFileDelegateHost_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bytesRead', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemAccessFileDelegateHost_Read_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_BigBuffer|undefined) } */
    this.data;
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { !number } */
    this.bytesRead;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileDelegateHost_Write_ParamsSpec.$,
    'FileSystemAccessFileDelegateHost_Write_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileDelegateHost_Write_Params {
  constructor() {
    /** @type { !bigint } */
    this.offset;
    /** @type { !MojoHandle } */
    this.data;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec.$,
    'FileSystemAccessFileDelegateHost_Write_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bytesWritten', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileDelegateHost_Write_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { !number } */
    this.bytesWritten;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileDelegateHost_GetLength_ParamsSpec.$,
    'FileSystemAccessFileDelegateHost_GetLength_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessFileDelegateHost_GetLength_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec.$,
    'FileSystemAccessFileDelegateHost_GetLength_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileDelegateHost_GetLength_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
    /** @type { !bigint } */
    this.length;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileDelegateHost_SetLength_ParamsSpec.$,
    'FileSystemAccessFileDelegateHost_SetLength_Params',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileDelegateHost_SetLength_Params {
  constructor() {
    /** @type { !bigint } */
    this.length;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec.$,
    'FileSystemAccessFileDelegateHost_SetLength_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase_mojom_FileErrorSpec.$,
        -16,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileDelegateHost_SetLength_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FileError } */
    this.error;
  }
}

