// third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessFileModificationHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessFileModificationHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FileSystemAccessFileModificationHostInterface }
 */
blink.mojom.FileSystemAccessFileModificationHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessFileModificationHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessFileModificationHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessFileModificationHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } capacityDelta
   * @return {!Promise<{
        grantedCapacityDelta: !bigint,
   *  }>}
   */

  requestCapacityChange(
      capacityDelta) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParamsSpec.$,
        [
          capacityDelta
        ],
        false);
  }

  
  /**
   */

  onContentsModified() {
    this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessFileModificationHost_OnContentsModified_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessFileModificationHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessFileModificationHostReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessFileModificationHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessFileModificationHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessFileModificationHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessFileModificationHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParamsSpec.$,
        impl.requestCapacityChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessFileModificationHost_OnContentsModified_ParamsSpec.$,
        null,
        impl.onContentsModified.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessFileModificationHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessFileModificationHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessFileModificationHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessFileModificationHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessFileModificationHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessFileModificationHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessFileModificationHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessFileModificationHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCapacityChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParamsSpec.$,
        this.requestCapacityChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onContentsModified =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessFileModificationHost_OnContentsModified_ParamsSpec.$,
        null,
        this.onContentsModified.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileModificationHost_OnContentsModified_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ParamsSpec.$,
    'FileSystemAccessFileModificationHost_RequestCapacityChange_Params',
    [
      mojo.internal.StructField(
        'capacityDelta', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.capacityDelta;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParamsSpec.$,
    'FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams',
    [
      mojo.internal.StructField(
        'grantedCapacityDelta', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams = class {
  constructor() {
    /** @export { !bigint } */
    this.grantedCapacityDelta;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileModificationHost_OnContentsModified_ParamsSpec.$,
    'FileSystemAccessFileModificationHost_OnContentsModified_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FileSystemAccessFileModificationHost_OnContentsModified_Params = class {
  constructor() {
  }
};

