// third_party/blink/public/mojom/frame/find_in_page.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/find_in_page.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var StopFindAction = {};
  StopFindAction.kStopFindActionClearSelection = 0;
  StopFindAction.kStopFindActionKeepSelection = 1;
  StopFindAction.kStopFindActionActivateSelection = 2;
  StopFindAction.MIN_VALUE = 0;
  StopFindAction.MAX_VALUE = 2;

  StopFindAction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  StopFindAction.toKnownEnumValue = function(value) {
    return value;
  };

  StopFindAction.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FindMatchUpdateType = {};
  FindMatchUpdateType.kFinalUpdate = 0;
  FindMatchUpdateType.kMoreUpdatesComing = 1;
  FindMatchUpdateType.MIN_VALUE = 0;
  FindMatchUpdateType.MAX_VALUE = 1;

  FindMatchUpdateType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  FindMatchUpdateType.toKnownEnumValue = function(value) {
    return value;
  };

  FindMatchUpdateType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FindOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FindOptions.prototype.initDefaults_ = function() {
    this.forward = true;
    this.matchCase = false;
    this.newSession = true;
    this.findMatch = true;
    this.force = false;
    this.runSynchronouslyForTesting = false;
  };
  FindOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FindOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  FindOptions.encodedSize = codec.kStructHeaderSize + 8;

  FindOptions.decode = function(decoder) {
    var packed;
    var val = new FindOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.forward = (packed >> 0) & 1 ? true : false;
    val.matchCase = (packed >> 1) & 1 ? true : false;
    val.newSession = (packed >> 2) & 1 ? true : false;
    val.findMatch = (packed >> 3) & 1 ? true : false;
    val.force = (packed >> 4) & 1 ? true : false;
    val.runSynchronouslyForTesting = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FindOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FindOptions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.forward & 1) << 0
    packed |= (val.matchCase & 1) << 1
    packed |= (val.newSession & 1) << 2
    packed |= (val.findMatch & 1) << 3
    packed |= (val.force & 1) << 4
    packed |= (val.runSynchronouslyForTesting & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FindInPage_Find_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FindInPage_Find_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.searchText = null;
    this.options = null;
  };
  FindInPage_Find_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FindInPage_Find_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FindInPage_Find_Params.searchText
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FindInPage_Find_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, FindOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FindInPage_Find_Params.encodedSize = codec.kStructHeaderSize + 24;

  FindInPage_Find_Params.decode = function(decoder) {
    var packed;
    var val = new FindInPage_Find_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.searchText =
        decoder.decodeStruct(codec.String);
    val.options =
        decoder.decodeStructPointer(FindOptions);
    return val;
  };

  FindInPage_Find_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FindInPage_Find_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.searchText);
    encoder.encodeStructPointer(FindOptions, val.options);
  };
  function FindInPage_StopFinding_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FindInPage_StopFinding_Params.prototype.initDefaults_ = function() {
    this.action = 0;
  };
  FindInPage_StopFinding_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FindInPage_StopFinding_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FindInPage_StopFinding_Params.action
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, StopFindAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FindInPage_StopFinding_Params.encodedSize = codec.kStructHeaderSize + 8;

  FindInPage_StopFinding_Params.decode = function(decoder) {
    var packed;
    var val = new FindInPage_StopFinding_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeStruct(new codec.Enum(StopFindAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FindInPage_StopFinding_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FindInPage_StopFinding_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.action);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FindInPage_ClearActiveFindMatch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FindInPage_ClearActiveFindMatch_Params.prototype.initDefaults_ = function() {
  };
  FindInPage_ClearActiveFindMatch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FindInPage_ClearActiveFindMatch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FindInPage_ClearActiveFindMatch_Params.encodedSize = codec.kStructHeaderSize + 0;

  FindInPage_ClearActiveFindMatch_Params.decode = function(decoder) {
    var packed;
    var val = new FindInPage_ClearActiveFindMatch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FindInPage_ClearActiveFindMatch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FindInPage_ClearActiveFindMatch_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FindInPage_SetClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FindInPage_SetClient_Params.prototype.initDefaults_ = function() {
    this.client = new FindInPageClientPtr();
  };
  FindInPage_SetClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FindInPage_SetClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FindInPage_SetClient_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FindInPage_SetClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  FindInPage_SetClient_Params.decode = function(decoder) {
    var packed;
    var val = new FindInPage_SetClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(FindInPageClientPtr));
    return val;
  };

  FindInPage_SetClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FindInPage_SetClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(FindInPageClientPtr), val.client);
  };
  function FindInPageClient_SetNumberOfMatches_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FindInPageClient_SetNumberOfMatches_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.numberOfMatches = 0;
    this.updateType = 0;
  };
  FindInPageClient_SetNumberOfMatches_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FindInPageClient_SetNumberOfMatches_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FindInPageClient_SetNumberOfMatches_Params.updateType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, FindMatchUpdateType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FindInPageClient_SetNumberOfMatches_Params.encodedSize = codec.kStructHeaderSize + 16;

  FindInPageClient_SetNumberOfMatches_Params.decode = function(decoder) {
    var packed;
    var val = new FindInPageClient_SetNumberOfMatches_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    val.numberOfMatches =
        decoder.decodeStruct(codec.Uint32);
    val.updateType =
        decoder.decodeStruct(new codec.Enum(FindMatchUpdateType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FindInPageClient_SetNumberOfMatches_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FindInPageClient_SetNumberOfMatches_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.encodeStruct(codec.Uint32, val.numberOfMatches);
    encoder.encodeStruct(codec.Int32, val.updateType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FindInPageClient_SetActiveMatch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FindInPageClient_SetActiveMatch_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.activeMatchOrdinal = 0;
    this.activeMatchRect = null;
    this.updateType = 0;
  };
  FindInPageClient_SetActiveMatch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FindInPageClient_SetActiveMatch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FindInPageClient_SetActiveMatch_Params.activeMatchRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FindInPageClient_SetActiveMatch_Params.updateType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, FindMatchUpdateType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FindInPageClient_SetActiveMatch_Params.encodedSize = codec.kStructHeaderSize + 24;

  FindInPageClient_SetActiveMatch_Params.decode = function(decoder) {
    var packed;
    var val = new FindInPageClient_SetActiveMatch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    val.activeMatchOrdinal =
        decoder.decodeStruct(codec.Int32);
    val.activeMatchRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.updateType =
        decoder.decodeStruct(new codec.Enum(FindMatchUpdateType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FindInPageClient_SetActiveMatch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FindInPageClient_SetActiveMatch_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.encodeStruct(codec.Int32, val.activeMatchOrdinal);
    encoder.encodeStructPointer(geometry$.Rect, val.activeMatchRect);
    encoder.encodeStruct(codec.Int32, val.updateType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kFindInPage_Find_Name = 0;
  var kFindInPage_StopFinding_Name = 1;
  var kFindInPage_ClearActiveFindMatch_Name = 2;
  var kFindInPage_SetClient_Name = 3;

  function FindInPagePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FindInPage,
                                                   handleOrPtrInfo);
  }

  function FindInPageAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FindInPage, associatedInterfacePtrInfo);
  }

  FindInPageAssociatedPtr.prototype =
      Object.create(FindInPagePtr.prototype);
  FindInPageAssociatedPtr.prototype.constructor =
      FindInPageAssociatedPtr;

  function FindInPageProxy(receiver) {
    this.receiver_ = receiver;
  }
  FindInPagePtr.prototype.find = function() {
    return FindInPageProxy.prototype.find
        .apply(this.ptr.getProxy(), arguments);
  };

  FindInPageProxy.prototype.find = function(requestId, searchText, options) {
    var params_ = new FindInPage_Find_Params();
    params_.requestId = requestId;
    params_.searchText = searchText;
    params_.options = options;
    var builder = new codec.MessageV0Builder(
        kFindInPage_Find_Name,
        codec.align(FindInPage_Find_Params.encodedSize));
    builder.encodeStruct(FindInPage_Find_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FindInPagePtr.prototype.stopFinding = function() {
    return FindInPageProxy.prototype.stopFinding
        .apply(this.ptr.getProxy(), arguments);
  };

  FindInPageProxy.prototype.stopFinding = function(action) {
    var params_ = new FindInPage_StopFinding_Params();
    params_.action = action;
    var builder = new codec.MessageV0Builder(
        kFindInPage_StopFinding_Name,
        codec.align(FindInPage_StopFinding_Params.encodedSize));
    builder.encodeStruct(FindInPage_StopFinding_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FindInPagePtr.prototype.clearActiveFindMatch = function() {
    return FindInPageProxy.prototype.clearActiveFindMatch
        .apply(this.ptr.getProxy(), arguments);
  };

  FindInPageProxy.prototype.clearActiveFindMatch = function() {
    var params_ = new FindInPage_ClearActiveFindMatch_Params();
    var builder = new codec.MessageV0Builder(
        kFindInPage_ClearActiveFindMatch_Name,
        codec.align(FindInPage_ClearActiveFindMatch_Params.encodedSize));
    builder.encodeStruct(FindInPage_ClearActiveFindMatch_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FindInPagePtr.prototype.setClient = function() {
    return FindInPageProxy.prototype.setClient
        .apply(this.ptr.getProxy(), arguments);
  };

  FindInPageProxy.prototype.setClient = function(client) {
    var params_ = new FindInPage_SetClient_Params();
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kFindInPage_SetClient_Name,
        codec.align(FindInPage_SetClient_Params.encodedSize));
    builder.encodeStruct(FindInPage_SetClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FindInPageStub(delegate) {
    this.delegate_ = delegate;
  }
  FindInPageStub.prototype.find = function(requestId, searchText, options) {
    return this.delegate_ && this.delegate_.find && this.delegate_.find(requestId, searchText, options);
  }
  FindInPageStub.prototype.stopFinding = function(action) {
    return this.delegate_ && this.delegate_.stopFinding && this.delegate_.stopFinding(action);
  }
  FindInPageStub.prototype.clearActiveFindMatch = function() {
    return this.delegate_ && this.delegate_.clearActiveFindMatch && this.delegate_.clearActiveFindMatch();
  }
  FindInPageStub.prototype.setClient = function(client) {
    return this.delegate_ && this.delegate_.setClient && this.delegate_.setClient(client);
  }

  FindInPageStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFindInPage_Find_Name:
      var params = reader.decodeStruct(FindInPage_Find_Params);
      this.find(params.requestId, params.searchText, params.options);
      return true;
    case kFindInPage_StopFinding_Name:
      var params = reader.decodeStruct(FindInPage_StopFinding_Params);
      this.stopFinding(params.action);
      return true;
    case kFindInPage_ClearActiveFindMatch_Name:
      var params = reader.decodeStruct(FindInPage_ClearActiveFindMatch_Params);
      this.clearActiveFindMatch();
      return true;
    case kFindInPage_SetClient_Name:
      var params = reader.decodeStruct(FindInPage_SetClient_Params);
      this.setClient(params.client);
      return true;
    default:
      return false;
    }
  };

  FindInPageStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFindInPageRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFindInPage_Find_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FindInPage_Find_Params;
      break;
      case kFindInPage_StopFinding_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FindInPage_StopFinding_Params;
      break;
      case kFindInPage_ClearActiveFindMatch_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FindInPage_ClearActiveFindMatch_Params;
      break;
      case kFindInPage_SetClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FindInPage_SetClient_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFindInPageResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FindInPage = {
    name: 'blink.mojom.FindInPage',
    kVersion: 0,
    ptrClass: FindInPagePtr,
    proxyClass: FindInPageProxy,
    stubClass: FindInPageStub,
    validateRequest: validateFindInPageRequest,
    validateResponse: null,
  };
  FindInPageStub.prototype.validator = validateFindInPageRequest;
  FindInPageProxy.prototype.validator = null;
  var kFindInPageClient_SetNumberOfMatches_Name = 0;
  var kFindInPageClient_SetActiveMatch_Name = 1;

  function FindInPageClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FindInPageClient,
                                                   handleOrPtrInfo);
  }

  function FindInPageClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FindInPageClient, associatedInterfacePtrInfo);
  }

  FindInPageClientAssociatedPtr.prototype =
      Object.create(FindInPageClientPtr.prototype);
  FindInPageClientAssociatedPtr.prototype.constructor =
      FindInPageClientAssociatedPtr;

  function FindInPageClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  FindInPageClientPtr.prototype.setNumberOfMatches = function() {
    return FindInPageClientProxy.prototype.setNumberOfMatches
        .apply(this.ptr.getProxy(), arguments);
  };

  FindInPageClientProxy.prototype.setNumberOfMatches = function(requestId, numberOfMatches, updateType) {
    var params_ = new FindInPageClient_SetNumberOfMatches_Params();
    params_.requestId = requestId;
    params_.numberOfMatches = numberOfMatches;
    params_.updateType = updateType;
    var builder = new codec.MessageV0Builder(
        kFindInPageClient_SetNumberOfMatches_Name,
        codec.align(FindInPageClient_SetNumberOfMatches_Params.encodedSize));
    builder.encodeStruct(FindInPageClient_SetNumberOfMatches_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FindInPageClientPtr.prototype.setActiveMatch = function() {
    return FindInPageClientProxy.prototype.setActiveMatch
        .apply(this.ptr.getProxy(), arguments);
  };

  FindInPageClientProxy.prototype.setActiveMatch = function(requestId, activeMatchRect, activeMatchOrdinal, updateType) {
    var params_ = new FindInPageClient_SetActiveMatch_Params();
    params_.requestId = requestId;
    params_.activeMatchRect = activeMatchRect;
    params_.activeMatchOrdinal = activeMatchOrdinal;
    params_.updateType = updateType;
    var builder = new codec.MessageV0Builder(
        kFindInPageClient_SetActiveMatch_Name,
        codec.align(FindInPageClient_SetActiveMatch_Params.encodedSize));
    builder.encodeStruct(FindInPageClient_SetActiveMatch_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FindInPageClientStub(delegate) {
    this.delegate_ = delegate;
  }
  FindInPageClientStub.prototype.setNumberOfMatches = function(requestId, numberOfMatches, updateType) {
    return this.delegate_ && this.delegate_.setNumberOfMatches && this.delegate_.setNumberOfMatches(requestId, numberOfMatches, updateType);
  }
  FindInPageClientStub.prototype.setActiveMatch = function(requestId, activeMatchRect, activeMatchOrdinal, updateType) {
    return this.delegate_ && this.delegate_.setActiveMatch && this.delegate_.setActiveMatch(requestId, activeMatchRect, activeMatchOrdinal, updateType);
  }

  FindInPageClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFindInPageClient_SetNumberOfMatches_Name:
      var params = reader.decodeStruct(FindInPageClient_SetNumberOfMatches_Params);
      this.setNumberOfMatches(params.requestId, params.numberOfMatches, params.updateType);
      return true;
    case kFindInPageClient_SetActiveMatch_Name:
      var params = reader.decodeStruct(FindInPageClient_SetActiveMatch_Params);
      this.setActiveMatch(params.requestId, params.activeMatchRect, params.activeMatchOrdinal, params.updateType);
      return true;
    default:
      return false;
    }
  };

  FindInPageClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFindInPageClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFindInPageClient_SetNumberOfMatches_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FindInPageClient_SetNumberOfMatches_Params;
      break;
      case kFindInPageClient_SetActiveMatch_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FindInPageClient_SetActiveMatch_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFindInPageClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FindInPageClient = {
    name: 'blink.mojom.FindInPageClient',
    kVersion: 0,
    ptrClass: FindInPageClientPtr,
    proxyClass: FindInPageClientProxy,
    stubClass: FindInPageClientStub,
    validateRequest: validateFindInPageClientRequest,
    validateResponse: null,
  };
  FindInPageClientStub.prototype.validator = validateFindInPageClientRequest;
  FindInPageClientProxy.prototype.validator = null;
  exports.StopFindAction = StopFindAction;
  exports.FindMatchUpdateType = FindMatchUpdateType;
  exports.FindOptions = FindOptions;
  exports.FindInPage = FindInPage;
  exports.FindInPagePtr = FindInPagePtr;
  exports.FindInPageAssociatedPtr = FindInPageAssociatedPtr;
  exports.FindInPageClient = FindInPageClient;
  exports.FindInPageClientPtr = FindInPageClientPtr;
  exports.FindInPageClientAssociatedPtr = FindInPageClientAssociatedPtr;
})();