// third_party/blink/public/mojom/geolocation/geolocation_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.PermissionStatus');
goog.require('device.mojom.Geolocation');






goog.provide('blink.mojom.GeolocationService');
goog.provide('blink.mojom.GeolocationServiceReceiver');
goog.provide('blink.mojom.GeolocationServiceCallbackRouter');
goog.provide('blink.mojom.GeolocationServiceInterface');
goog.provide('blink.mojom.GeolocationServiceRemote');
goog.provide('blink.mojom.GeolocationServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.GeolocationServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.GeolocationService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.GeolocationServiceInterface = class {
  
  /**
   * @param { !device.mojom.GeolocationPendingReceiver } receiver
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  createGeolocation(receiver, userGesture) {}
};

/**
 * @export
 * @implements { blink.mojom.GeolocationServiceInterface }
 */
blink.mojom.GeolocationServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.GeolocationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.GeolocationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.GeolocationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.GeolocationPendingReceiver } receiver
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink.mojom.PermissionStatus,
   *  }>}
   */

  createGeolocation(
      receiver,
      userGesture) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.GeolocationService_CreateGeolocation_ParamsSpec.$,
        blink.mojom.GeolocationService_CreateGeolocation_ResponseParamsSpec.$,
        [
          receiver,
          userGesture
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GeolocationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.GeolocationServiceReceiver = class {
  /**
   * @param {!blink.mojom.GeolocationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.GeolocationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.GeolocationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.GeolocationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.GeolocationService_CreateGeolocation_ParamsSpec.$,
        blink.mojom.GeolocationService_CreateGeolocation_ResponseParamsSpec.$,
        impl.createGeolocation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.GeolocationService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.GeolocationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.GeolocationServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.GeolocationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the GeolocationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.GeolocationServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.GeolocationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.GeolocationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createGeolocation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.GeolocationService_CreateGeolocation_ParamsSpec.$,
        blink.mojom.GeolocationService_CreateGeolocation_ResponseParamsSpec.$,
        this.createGeolocation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.GeolocationService_CreateGeolocation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GeolocationService_CreateGeolocation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.GeolocationService_CreateGeolocation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GeolocationService_CreateGeolocation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.GeolocationService_CreateGeolocation_ParamsSpec.$,
    'GeolocationService_CreateGeolocation_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(device.mojom.GeolocationPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.GeolocationService_CreateGeolocation_Params');

/** @record */
blink.mojom.GeolocationService_CreateGeolocation_Params = class {
  constructor() {
    /** @export { !device.mojom.GeolocationPendingReceiver } */
    this.receiver;
    /** @export { !boolean } */
    this.userGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.GeolocationService_CreateGeolocation_ResponseParamsSpec.$,
    'GeolocationService_CreateGeolocation_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.PermissionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.GeolocationService_CreateGeolocation_ResponseParams');

/** @record */
blink.mojom.GeolocationService_CreateGeolocation_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PermissionStatus } */
    this.status;
  }
};

