// third_party/blink/public/mojom/idle/idle_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const IdleManagerErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const IdleManagerError = {
  
  kSuccess: 0,
  kPermissionDisabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IdleMonitorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IdleMonitor', scope);
  }
}

/** @interface */
export class IdleMonitorInterface {
  
  /**
   * @param { !IdleState } state
   * @param { !boolean } isOverriddenByDevtools
   */

  update(state, isOverriddenByDevtools) {}
}

/**
 * @implements { IdleMonitorInterface }
 */
export class IdleMonitorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IdleMonitorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IdleMonitorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IdleMonitorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !IdleState } state
   * @param { !boolean } isOverriddenByDevtools
   */

  update(
      state,
      isOverriddenByDevtools) {
    this.proxy.sendMessage(
        0,
        IdleMonitor_Update_ParamsSpec.$,
        null,
        [
          state,
          isOverriddenByDevtools
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IdleMonitor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IdleMonitorReceiver {
  /**
   * @param {!IdleMonitorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IdleMonitorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IdleMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IdleMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IdleMonitor_Update_ParamsSpec.$,
        null,
        impl.update.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IdleMonitor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IdleMonitor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IdleMonitorRemote}
   */
  static getRemote() {
    let remote = new IdleMonitorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IdleMonitor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IdleMonitorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IdleMonitorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IdleMonitorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.update =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IdleMonitor_Update_ParamsSpec.$,
        null,
        this.update.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class IdleManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.IdleManager', scope);
  }
}

/** @interface */
export class IdleManagerInterface {
  
  /**
   * @param { !IdleMonitorRemote } monitor
   * @return {!Promise<{
        error: !IdleManagerError,
        state: ?IdleState,
   *  }>}
   */

  addMonitor(monitor) {}
}

/**
 * @implements { IdleManagerInterface }
 */
export class IdleManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!IdleManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          IdleManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!IdleManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !IdleMonitorRemote } monitor
   * @return {!Promise<{
        error: !IdleManagerError,
        state: ?IdleState,
   *  }>}
   */

  addMonitor(
      monitor) {
    return this.proxy.sendMessage(
        0,
        IdleManager_AddMonitor_ParamsSpec.$,
        IdleManager_AddMonitor_ResponseParamsSpec.$,
        [
          monitor
        ],
        false);
  }
}

/**
 * An object which receives request messages for the IdleManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class IdleManagerReceiver {
  /**
   * @param {!IdleManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!IdleManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        IdleManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IdleManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        IdleManager_AddMonitor_ParamsSpec.$,
        IdleManager_AddMonitor_ResponseParamsSpec.$,
        impl.addMonitor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class IdleManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.IdleManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!IdleManagerRemote}
   */
  static getRemote() {
    let remote = new IdleManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the IdleManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class IdleManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      IdleManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!IdleManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMonitor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        IdleManager_AddMonitor_ParamsSpec.$,
        IdleManager_AddMonitor_ResponseParamsSpec.$,
        this.addMonitor.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdleStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdleMonitor_Update_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdleManager_AddMonitor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdleManager_AddMonitor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    IdleStateSpec.$,
    'IdleState',
    [
      mojo.internal.StructField(
        'idleTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'screenLocked', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IdleState {
  constructor() {
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.idleTime;
    /** @type { !boolean } */
    this.screenLocked;
  }
}



mojo.internal.Struct(
    IdleMonitor_Update_ParamsSpec.$,
    'IdleMonitor_Update_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        IdleStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isOverriddenByDevtools', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IdleMonitor_Update_Params {
  constructor() {
    /** @type { !IdleState } */
    this.state;
    /** @type { !boolean } */
    this.isOverriddenByDevtools;
  }
}



mojo.internal.Struct(
    IdleManager_AddMonitor_ParamsSpec.$,
    'IdleManager_AddMonitor_Params',
    [
      mojo.internal.StructField(
        'monitor', 0,
        0,
        mojo.internal.InterfaceProxy(IdleMonitorRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class IdleManager_AddMonitor_Params {
  constructor() {
    /** @type { !IdleMonitorRemote } */
    this.monitor;
  }
}



mojo.internal.Struct(
    IdleManager_AddMonitor_ResponseParamsSpec.$,
    'IdleManager_AddMonitor_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        IdleManagerErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'state', 8,
        0,
        IdleStateSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class IdleManager_AddMonitor_ResponseParams {
  constructor() {
    /** @type { !IdleManagerError } */
    this.error;
    /** @type { (IdleState|undefined) } */
    this.state;
  }
}

