// third_party/blink/public/mojom/input/pointer_lock_context.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/input/pointer_lock_context.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var pointer_lock_result$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/input/pointer_lock_result.mojom', 'pointer_lock_result.mojom.js');
  }



  function PointerLockContext_RequestMouseLockChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PointerLockContext_RequestMouseLockChange_Params.prototype.initDefaults_ = function() {
    this.unadjustedMovement = false;
  };
  PointerLockContext_RequestMouseLockChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PointerLockContext_RequestMouseLockChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PointerLockContext_RequestMouseLockChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  PointerLockContext_RequestMouseLockChange_Params.decode = function(decoder) {
    var packed;
    var val = new PointerLockContext_RequestMouseLockChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.unadjustedMovement = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PointerLockContext_RequestMouseLockChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PointerLockContext_RequestMouseLockChange_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.unadjustedMovement & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PointerLockContext_RequestMouseLockChange_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PointerLockContext_RequestMouseLockChange_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  PointerLockContext_RequestMouseLockChange_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PointerLockContext_RequestMouseLockChange_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PointerLockContext_RequestMouseLockChange_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, pointer_lock_result$.PointerLockResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PointerLockContext_RequestMouseLockChange_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PointerLockContext_RequestMouseLockChange_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PointerLockContext_RequestMouseLockChange_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(pointer_lock_result$.PointerLockResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PointerLockContext_RequestMouseLockChange_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PointerLockContext_RequestMouseLockChange_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kPointerLockContext_RequestMouseLockChange_Name = 0;

  function PointerLockContextPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PointerLockContext,
                                                   handleOrPtrInfo);
  }

  function PointerLockContextAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PointerLockContext, associatedInterfacePtrInfo);
  }

  PointerLockContextAssociatedPtr.prototype =
      Object.create(PointerLockContextPtr.prototype);
  PointerLockContextAssociatedPtr.prototype.constructor =
      PointerLockContextAssociatedPtr;

  function PointerLockContextProxy(receiver) {
    this.receiver_ = receiver;
  }
  PointerLockContextPtr.prototype.requestMouseLockChange = function() {
    return PointerLockContextProxy.prototype.requestMouseLockChange
        .apply(this.ptr.getProxy(), arguments);
  };

  PointerLockContextProxy.prototype.requestMouseLockChange = function(unadjustedMovement) {
    var params_ = new PointerLockContext_RequestMouseLockChange_Params();
    params_.unadjustedMovement = unadjustedMovement;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPointerLockContext_RequestMouseLockChange_Name,
          codec.align(PointerLockContext_RequestMouseLockChange_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PointerLockContext_RequestMouseLockChange_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PointerLockContext_RequestMouseLockChange_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function PointerLockContextStub(delegate) {
    this.delegate_ = delegate;
  }
  PointerLockContextStub.prototype.requestMouseLockChange = function(unadjustedMovement) {
    return this.delegate_ && this.delegate_.requestMouseLockChange && this.delegate_.requestMouseLockChange(unadjustedMovement);
  }

  PointerLockContextStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  PointerLockContextStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPointerLockContext_RequestMouseLockChange_Name:
      var params = reader.decodeStruct(PointerLockContext_RequestMouseLockChange_Params);
      this.requestMouseLockChange(params.unadjustedMovement).then(function(response) {
        var responseParams =
            new PointerLockContext_RequestMouseLockChange_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kPointerLockContext_RequestMouseLockChange_Name,
            codec.align(PointerLockContext_RequestMouseLockChange_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PointerLockContext_RequestMouseLockChange_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePointerLockContextRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPointerLockContext_RequestMouseLockChange_Name:
        if (message.expectsResponse())
          paramsClass = PointerLockContext_RequestMouseLockChange_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePointerLockContextResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPointerLockContext_RequestMouseLockChange_Name:
        if (message.isResponse())
          paramsClass = PointerLockContext_RequestMouseLockChange_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PointerLockContext = {
    name: 'blink.mojom.PointerLockContext',
    kVersion: 0,
    ptrClass: PointerLockContextPtr,
    proxyClass: PointerLockContextProxy,
    stubClass: PointerLockContextStub,
    validateRequest: validatePointerLockContextRequest,
    validateResponse: validatePointerLockContextResponse,
  };
  PointerLockContextStub.prototype.validator = validatePointerLockContextRequest;
  PointerLockContextProxy.prototype.validator = validatePointerLockContextResponse;
  exports.PointerLockContext = PointerLockContext;
  exports.PointerLockContextPtr = PointerLockContextPtr;
  exports.PointerLockContextAssociatedPtr = PointerLockContextAssociatedPtr;
})();