// third_party/blink/public/mojom/input/touch_event.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/input/touch_event.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var TouchState = {};
  TouchState.kStateUndefined = 0;
  TouchState.kStateReleased = 1;
  TouchState.kStatePressed = 2;
  TouchState.kStateMoved = 3;
  TouchState.kStateStationary = 4;
  TouchState.kStateCancelled = 5;
  TouchState.MIN_VALUE = 0;
  TouchState.MAX_VALUE = 5;

  TouchState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  TouchState.toKnownEnumValue = function(value) {
    return value;
  };

  TouchState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function TouchEventConsumers(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TouchEventConsumers.prototype.initDefaults_ = function() {
    this.hasTouchEventHandlers = false;
    this.hasHitTestableScrollbar = false;
  };
  TouchEventConsumers.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TouchEventConsumers.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  TouchEventConsumers.encodedSize = codec.kStructHeaderSize + 8;

  TouchEventConsumers.decode = function(decoder) {
    var packed;
    var val = new TouchEventConsumers();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasTouchEventHandlers = (packed >> 0) & 1 ? true : false;
    val.hasHitTestableScrollbar = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TouchEventConsumers.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TouchEventConsumers.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasTouchEventHandlers & 1) << 0
    packed |= (val.hasHitTestableScrollbar & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.TouchState = TouchState;
  exports.TouchEventConsumers = TouchEventConsumers;
})();