// third_party/blink/public/mojom/loader/content_security_notifier.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ContentSecurityNotifierPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ContentSecurityNotifier', scope);
  }
}

/** @interface */
export class ContentSecurityNotifierInterface {
  
  /**
   */

  notifyContentWithCertificateErrorsRan() {}
  
  /**
   */

  notifyContentWithCertificateErrorsDisplayed() {}
  
  /**
   * @param { !url_mojom_Url } origin
   * @param { !url_mojom_Url } insecureUrl
   */

  notifyInsecureContentRan(origin, insecureUrl) {}
}

/**
 * @implements { ContentSecurityNotifierInterface }
 */
export class ContentSecurityNotifierRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ContentSecurityNotifierPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ContentSecurityNotifierPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ContentSecurityNotifierPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  notifyContentWithCertificateErrorsRan() {
    this.proxy.sendMessage(
        0,
        ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  notifyContentWithCertificateErrorsDisplayed() {
    this.proxy.sendMessage(
        1,
        ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } origin
   * @param { !url_mojom_Url } insecureUrl
   */

  notifyInsecureContentRan(
      origin,
      insecureUrl) {
    this.proxy.sendMessage(
        2,
        ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec.$,
        null,
        [
          origin,
          insecureUrl
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ContentSecurityNotifier
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContentSecurityNotifierReceiver {
  /**
   * @param {!ContentSecurityNotifierInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ContentSecurityNotifierRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ContentSecurityNotifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContentSecurityNotifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec.$,
        null,
        impl.notifyContentWithCertificateErrorsRan.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec.$,
        null,
        impl.notifyContentWithCertificateErrorsDisplayed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec.$,
        null,
        impl.notifyInsecureContentRan.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ContentSecurityNotifier {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ContentSecurityNotifier";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ContentSecurityNotifierRemote}
   */
  static getRemote() {
    let remote = new ContentSecurityNotifierRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ContentSecurityNotifier
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContentSecurityNotifierCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ContentSecurityNotifierRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContentSecurityNotifierRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyContentWithCertificateErrorsRan =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec.$,
        null,
        this.notifyContentWithCertificateErrorsRan.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyContentWithCertificateErrorsDisplayed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec.$,
        null,
        this.notifyContentWithCertificateErrorsDisplayed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyInsecureContentRan =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec.$,
        null,
        this.notifyInsecureContentRan.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_ParamsSpec.$,
    'ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ContentSecurityNotifier_NotifyContentWithCertificateErrorsRan_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_ParamsSpec.$,
    'ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ContentSecurityNotifier_NotifyContentWithCertificateErrorsDisplayed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ContentSecurityNotifier_NotifyInsecureContentRan_ParamsSpec.$,
    'ContentSecurityNotifier_NotifyInsecureContentRan_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'insecureUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentSecurityNotifier_NotifyInsecureContentRan_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.origin;
    /** @type { !url_mojom_Url } */
    this.insecureUrl;
  }
}

