// third_party/blink/public/mojom/loader/resource_load_info.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ByteCount as mojoBase_mojom_ByteCount,
  ByteCountSpec as mojoBase_mojom_ByteCountSpec
} from '../../../../../mojo/public/mojom/base/byte_count.mojom.m.js';

import {
  RequestDestination as network_mojom_RequestDestination,
  RequestDestinationSpec as network_mojom_RequestDestinationSpec
} from '../../../../../services/network/public/mojom/fetch_api.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from '../../../../../services/network/public/mojom/ip_endpoint.mojom.m.js';

import {
  LoadTimingInfo as network_mojom_LoadTimingInfo,
  LoadTimingInfoSpec as network_mojom_LoadTimingInfoSpec
} from '../../../../../services/network/public/mojom/load_timing_info.mojom.m.js';

import {
  ProxyChain as network_mojom_ProxyChain,
  ProxyChainSpec as network_mojom_ProxyChainSpec
} from '../../../../../services/network/public/mojom/network_param.mojom.m.js';

import {
  RequestPriority as network_mojom_RequestPriority,
  RequestPrioritySpec as network_mojom_RequestPrioritySpec
} from '../../../../../services/network/public/mojom/request_priority.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ResourceTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ResourceType = {
  
  kMainFrame: 0,
  kSubFrame: 1,
  kStylesheet: 2,
  kScript: 3,
  kImage: 4,
  kFontResource: 5,
  kSubResource: 6,
  kObject: 7,
  kMedia: 8,
  kWorker: 9,
  kSharedWorker: 10,
  kPrefetch: 11,
  kFavicon: 12,
  kXhr: 13,
  kPing: 14,
  kServiceWorker: 15,
  kCspReport: 16,
  kPluginResource: 17,
  kNavigationPreloadMainFrame: 19,
  kNavigationPreloadSubFrame: 20,
  kJson: 21,
  MIN_VALUE: 0,
  MAX_VALUE: 21,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CommonNetworkInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RedirectInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResourceLoadInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CommonNetworkInfoSpec.$,
    'CommonNetworkInfo',
    [
      mojo.internal.StructField(
        'networkAccessed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alwaysAccessNetwork', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteEndpoint', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CommonNetworkInfo {
  constructor() {
    /** @type { !boolean } */
    this.networkAccessed;
    /** @type { !boolean } */
    this.alwaysAccessNetwork;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.remoteEndpoint;
  }
}



mojo.internal.Struct(
    RedirectInfoSpec.$,
    'RedirectInfo',
    [
      mojo.internal.StructField(
        'originOfNewUrl', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkInfo', 8,
        0,
        CommonNetworkInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RedirectInfo {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.originOfNewUrl;
    /** @type { !CommonNetworkInfo } */
    this.networkInfo;
  }
}



mojo.internal.Struct(
    ResourceLoadInfoSpec.$,
    'ResourceLoadInfo',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'finalUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrer', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'method', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestDestination', 40,
        0,
        network_mojom_RequestDestinationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestPriority', 44,
        0,
        network_mojom_RequestPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mimeType', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasCached', 56,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkInfo', 64,
        0,
        CommonNetworkInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netError', 60,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyChain', 72,
        0,
        network_mojom_ProxyChainSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loadTimingInfo', 80,
        0,
        network_mojom_LoadTimingInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rawBodyBytes', 88,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'totalReceivedBytes', 96,
        0,
        mojoBase_mojom_ByteCountSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redirectInfoChain', 104,
        0,
        mojo.internal.Array(RedirectInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httpStatusCode', 112,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 128],]);



/**
 * @record
 */
export class ResourceLoadInfo {
  constructor() {
    /** @type { !bigint } */
    this.requestId;
    /** @type { !url_mojom_Url } */
    this.finalUrl;
    /** @type { !url_mojom_Url } */
    this.referrer;
    /** @type { !url_mojom_Url } */
    this.originalUrl;
    /** @type { !string } */
    this.method;
    /** @type { !network_mojom_RequestDestination } */
    this.requestDestination;
    /** @type { !network_mojom_RequestPriority } */
    this.requestPriority;
    /** @type { !string } */
    this.mimeType;
    /** @type { !boolean } */
    this.wasCached;
    /** @type { !CommonNetworkInfo } */
    this.networkInfo;
    /** @type { !number } */
    this.netError;
    /** @type { !network_mojom_ProxyChain } */
    this.proxyChain;
    /** @type { !network_mojom_LoadTimingInfo } */
    this.loadTimingInfo;
    /** @type { !mojoBase_mojom_ByteCount } */
    this.rawBodyBytes;
    /** @type { !mojoBase_mojom_ByteCount } */
    this.totalReceivedBytes;
    /** @type { !Array<!RedirectInfo> } */
    this.redirectInfoChain;
    /** @type { !number } */
    this.httpStatusCode;
  }
}

