// third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AudioOutputStreamProviderRemote as media_mojom_AudioOutputStreamProviderRemote,
  AudioOutputStreamProviderPendingReceiver as media_mojom_AudioOutputStreamProviderPendingReceiver
} from '../../../../../media/mojo/mojom/audio_output_stream.mojom.m.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from '../../../../../media/mojo/mojom/audio_parameters.mojom.m.js';

import {
  OutputDeviceStatus as media_mojom_OutputDeviceStatus,
  OutputDeviceStatusSpec as media_mojom_OutputDeviceStatusSpec
} from '../../../../../media/mojo/mojom/media_types.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererAudioOutputStreamFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RendererAudioOutputStreamFactory', scope);
  }
}

/** @interface */
export class RendererAudioOutputStreamFactoryInterface {
  
  /**
   * @param { !media_mojom_AudioOutputStreamProviderPendingReceiver } streamProviderReceiver
   * @param { ?mojoBase_mojom_UnguessableToken } sessionId
   * @param { !string } deviceId
   * @return {!Promise<{
        state: !media_mojom_OutputDeviceStatus,
        outputParams: !media_mojom_AudioParameters,
        matchedDeviceId: !string,
   *  }>}
   */

  requestDeviceAuthorization(streamProviderReceiver, sessionId, deviceId) {}
}

/**
 * @implements { RendererAudioOutputStreamFactoryInterface }
 */
export class RendererAudioOutputStreamFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererAudioOutputStreamFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererAudioOutputStreamFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererAudioOutputStreamFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioOutputStreamProviderPendingReceiver } streamProviderReceiver
   * @param { ?mojoBase_mojom_UnguessableToken } sessionId
   * @param { !string } deviceId
   * @return {!Promise<{
        state: !media_mojom_OutputDeviceStatus,
        outputParams: !media_mojom_AudioParameters,
        matchedDeviceId: !string,
   *  }>}
   */

  requestDeviceAuthorization(
      streamProviderReceiver,
      sessionId,
      deviceId) {
    return this.proxy.sendMessage(
        0,
        RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ParamsSpec.$,
        RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParamsSpec.$,
        [
          streamProviderReceiver,
          sessionId,
          deviceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RendererAudioOutputStreamFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererAudioOutputStreamFactoryReceiver {
  /**
   * @param {!RendererAudioOutputStreamFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererAudioOutputStreamFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererAudioOutputStreamFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererAudioOutputStreamFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ParamsSpec.$,
        RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParamsSpec.$,
        impl.requestDeviceAuthorization.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RendererAudioOutputStreamFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RendererAudioOutputStreamFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererAudioOutputStreamFactoryRemote}
   */
  static getRemote() {
    let remote = new RendererAudioOutputStreamFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RendererAudioOutputStreamFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererAudioOutputStreamFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererAudioOutputStreamFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererAudioOutputStreamFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestDeviceAuthorization =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ParamsSpec.$,
        RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParamsSpec.$,
        this.requestDeviceAuthorization.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ParamsSpec.$,
    'RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params',
    [
      mojo.internal.StructField(
        'streamProviderReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_AudioOutputStreamProviderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params {
  constructor() {
    /** @type { !media_mojom_AudioOutputStreamProviderPendingReceiver } */
    this.streamProviderReceiver;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.sessionId;
    /** @type { !string } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParamsSpec.$,
    'RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        media_mojom_OutputDeviceStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputParams', 8,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchedDeviceId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams {
  constructor() {
    /** @type { !media_mojom_OutputDeviceStatus } */
    this.state;
    /** @type { !media_mojom_AudioParameters } */
    this.outputParams;
    /** @type { !string } */
    this.matchedDeviceId;
  }
}

