// third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }



  function NavigationApiHistoryEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NavigationApiHistoryEntry.prototype.initDefaults_ = function() {
    this.key = null;
    this.id = null;
    this.url = null;
    this.itemSequenceNumber = 0;
    this.documentSequenceNumber = 0;
    this.state = null;
  };
  NavigationApiHistoryEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NavigationApiHistoryEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationApiHistoryEntry.key
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationApiHistoryEntry.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationApiHistoryEntry.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate NavigationApiHistoryEntry.state
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NavigationApiHistoryEntry.encodedSize = codec.kStructHeaderSize + 48;

  NavigationApiHistoryEntry.decode = function(decoder) {
    var packed;
    var val = new NavigationApiHistoryEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStructPointer(string16$.String16);
    val.id =
        decoder.decodeStructPointer(string16$.String16);
    val.url =
        decoder.decodeStructPointer(string16$.String16);
    val.itemSequenceNumber =
        decoder.decodeStruct(codec.Int64);
    val.documentSequenceNumber =
        decoder.decodeStruct(codec.Int64);
    val.state =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  NavigationApiHistoryEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NavigationApiHistoryEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.key);
    encoder.encodeStructPointer(string16$.String16, val.id);
    encoder.encodeStructPointer(string16$.String16, val.url);
    encoder.encodeStruct(codec.Int64, val.itemSequenceNumber);
    encoder.encodeStruct(codec.Int64, val.documentSequenceNumber);
    encoder.encodeStructPointer(string16$.String16, val.state);
  };
  function NavigationApiHistoryEntryArrays(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NavigationApiHistoryEntryArrays.prototype.initDefaults_ = function() {
    this.backEntries = null;
    this.forwardEntries = null;
    this.previousEntry = null;
  };
  NavigationApiHistoryEntryArrays.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NavigationApiHistoryEntryArrays.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationApiHistoryEntryArrays.backEntries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(NavigationApiHistoryEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationApiHistoryEntryArrays.forwardEntries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(NavigationApiHistoryEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationApiHistoryEntryArrays.previousEntry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, NavigationApiHistoryEntry, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NavigationApiHistoryEntryArrays.encodedSize = codec.kStructHeaderSize + 24;

  NavigationApiHistoryEntryArrays.decode = function(decoder) {
    var packed;
    var val = new NavigationApiHistoryEntryArrays();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.backEntries =
        decoder.decodeArrayPointer(new codec.PointerTo(NavigationApiHistoryEntry));
    val.forwardEntries =
        decoder.decodeArrayPointer(new codec.PointerTo(NavigationApiHistoryEntry));
    val.previousEntry =
        decoder.decodeStructPointer(NavigationApiHistoryEntry);
    return val;
  };

  NavigationApiHistoryEntryArrays.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NavigationApiHistoryEntryArrays.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(NavigationApiHistoryEntry), val.backEntries);
    encoder.encodeArrayPointer(new codec.PointerTo(NavigationApiHistoryEntry), val.forwardEntries);
    encoder.encodeStructPointer(NavigationApiHistoryEntry, val.previousEntry);
  };
  exports.NavigationApiHistoryEntry = NavigationApiHistoryEntry;
  exports.NavigationApiHistoryEntryArrays = NavigationApiHistoryEntryArrays;
})();