// third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.OriginTrialStateHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.OriginTrialStateHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.OriginTrialStateHostInterface }
 */
blink.mojom.OriginTrialStateHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.OriginTrialStateHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.OriginTrialStateHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.OriginTrialStateHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object<!blink.mojom.RuntimeFeature, !blink.mojom.OriginTrialFeatureState> } originTrialFeatures
   */

  applyFeatureDiffForOriginTrial(
      originTrialFeatures) {
    this.proxy.sendMessage(
        0,
        blink.mojom.OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec.$,
        null,
        [
          originTrialFeatures
        ],
        false);
  }

  
  /**
   * @param { !string } token
   * @param { !Array<!url.mojom.Origin> } scriptOrigins
   */

  enablePersistentTrial(
      token,
      scriptOrigins) {
    this.proxy.sendMessage(
        1,
        blink.mojom.OriginTrialStateHost_EnablePersistentTrial_ParamsSpec.$,
        null,
        [
          token,
          scriptOrigins
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OriginTrialStateHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.OriginTrialStateHostReceiver = class {
  /**
   * @param {!blink.mojom.OriginTrialStateHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.OriginTrialStateHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.OriginTrialStateHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.OriginTrialStateHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec.$,
        null,
        impl.applyFeatureDiffForOriginTrial.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.OriginTrialStateHost_EnablePersistentTrial_ParamsSpec.$,
        null,
        impl.enablePersistentTrial.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.OriginTrialStateHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.OriginTrialStateHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.OriginTrialStateHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.OriginTrialStateHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the OriginTrialStateHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.OriginTrialStateHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.OriginTrialStateHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.OriginTrialStateHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.applyFeatureDiffForOriginTrial =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec.$,
        null,
        this.applyFeatureDiffForOriginTrial.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enablePersistentTrial =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.OriginTrialStateHost_EnablePersistentTrial_ParamsSpec.$,
        null,
        this.enablePersistentTrial.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.OriginTrialFeatureStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.OriginTrialStateHost_EnablePersistentTrial_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.OriginTrialFeatureStateSpec.$,
    'OriginTrialFeatureState',
    [
      mojo.internal.StructField(
        'isEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tokens', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.OriginTrialFeatureState = class {
  constructor() {
    /** @export { !boolean } */
    this.isEnabled;
    /** @export { !Array<!string> } */
    this.tokens;
  }
};



mojo.internal.Struct(
    blink.mojom.OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_ParamsSpec.$,
    'OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params',
    [
      mojo.internal.StructField(
        'originTrialFeatures', 0,
        0,
        mojo.internal.Map(blink.mojom.RuntimeFeatureSpec.$, blink.mojom.OriginTrialFeatureStateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params = class {
  constructor() {
    /** @export { !Object<!blink.mojom.RuntimeFeature, !blink.mojom.OriginTrialFeatureState> } */
    this.originTrialFeatures;
  }
};



mojo.internal.Struct(
    blink.mojom.OriginTrialStateHost_EnablePersistentTrial_ParamsSpec.$,
    'OriginTrialStateHost_EnablePersistentTrial_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptOrigins', 8,
        0,
        mojo.internal.Array(url.mojom.OriginSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.OriginTrialStateHost_EnablePersistentTrial_Params = class {
  constructor() {
    /** @export { !string } */
    this.token;
    /** @export { !Array<!url.mojom.Origin> } */
    this.scriptOrigins;
  }
};

